/* Instance of Event server */!!

inherit(EventLib, #Event, #(descriptor  /* my descriptor from Open... */
), 2, nil)!!

now(class(Event))!!

now(Event)!!

/* PUBLIC */
Def descriptor(self)
{ 
  ^descriptor
}
!!
/* PUBLIC -- gingerbread for pcall */
Def evtClearEvent(self | rc)
{
  if pcallLock(self)
    rc := pcall(procs[#EVTCLEAREVENT], descriptor);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtDeleteAllEvents(self | rc)
{
  if pcallLock(self)
    rc := pcall(procs[#EVTDELETEALLEVENTS]);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtDeleteEvent(self | rc)
{
  if pcallLock(self)
    rc := pcall(procs[#EVTDELETEEVENT], descriptor);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtGetActiveEvent(self | rc name)
{
  name := new(String, 100);
  if pcallLock(self)
    rc := pcall(procs[#EVTGETACTIVEEVENT], descriptor, name, 100);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
/* don't want to display any errors received */
  if (rc <> 0)
  then
    ^"" ;
  else
    ^ removeNulls(name);
  endif ;  
}

!!

/* PUBLIC -- gingerbread for pcall */
Def evtGetEnd(self | rc value)
{
  value := new(String, 100);
  if pcallLock(self)
    rc := pcall(procs[#EVTGETEND], descriptor, value, 100);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^"" ;
  else
    ^ removeNulls(value);
  endif ;  
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtGetEndFunction(self | rc func) {
  func := new( Struct, 4 ) ;
  if pcallLock(self)
    rc := pcall(procs[#EVTGETENDFUNCTION], descriptor, func);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(func, 0)
  endif ;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def evtGetMask(self | rc value)
{
  value := new(String, 100);
  if pcallLock(self)
    rc := pcall(procs[#EVTGETMASK], descriptor, value, 100);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^"" ;
  else
    ^ removeNulls(value);
  endif ;  
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtGetNextEvent(self | rc name)
{
  name := new(String, 100);
  if pcallLock(self)
    rc := pcall(procs[#EVTGETNEXTEVENT], descriptor, name, 100);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^"" ;
  else
    ^ removeNulls(name);
  endif ;  
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtGetNotCondition(self | rc value)
{
  value := new( Struct, 4 ) ;
  if pcallLock(self)
    rc := pcall(procs[#EVTGETNOTCONDITION], descriptor, value);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value, 0)
  endif ;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtGetStart(self | rc value)
{
  value := new(String, 100);
  if pcallLock(self)
    rc := pcall(procs[#EVTGETSTART], descriptor, value, 100);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^"" ;
  else
    ^ removeNulls(value);
  endif ;  
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtGetStartAndMask(self | rc value)
{
  value := new(String, 100);
  if pcallLock(self)
    rc := pcall(procs[#EVTGETSTARTANDMASK], descriptor, value, 100);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^"" ;
  else
    ^ removeNulls(value);
  endif ;  
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtNumDefinedEvents(self | rc num)
{
  num := new( Struct, 4 ) ;
  if pcallLock(self)
    rc := pcall(procs[#EVTNUMDEFINEDEVENTS], descriptor, num);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(num, 0)
  endif ;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtRestoreEvents(self, fileName | rc)
{
  if pcallLock(self)
    rc := pcall(procs[#EVTRESTOREEVENTS], asciiz(fileName));
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtSaveAsEvents(self, fileName | rc)
{
  if pcallLock(self)
    rc := pcall(procs[#EVTSAVEASEVENTS], asciiz(fileName));
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtSetActiveEvent(self, eventName | rc)
{
  if( not(eventName) )
    ^0;    /* don't set NIL to server */
  endif;
  if pcallLock(self)
    rc := pcall(procs[#EVTSETACTIVEEVENT], descriptor, asciiz(eventName));
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtSetActiveField(self, fieldName | rc)
{ 
  if pcallLock(self)
    rc := pcall(procs[#EVTSETACTIVEFIELD], descriptor, asciiz(fieldName));
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtSetEnd(self, valueStr | rc)
{ 
  if pcallLock(self)
    rc := pcall(procs[#EVTSETEND], descriptor, asciiz(valueStr));
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  if( handleSetEventError(self,rc) = 1 )
    if pcallLock(self)
      rc := pcall(procs[#EVTSETEND], descriptor, asciiz(valueStr));
      pcallUNLock(self);
    endif;
    displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  endif;
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtSetEndFunction(self, func | rc) {
  if pcallLock(self)
    rc := pcall(procs[#EVTSETENDFUNCTION], descriptor, func);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def evtSetMask(self, valueStr | rc)
{
  if pcallLock(self)
    rc := pcall(procs[#EVTSETMASK], descriptor, asciiz(valueStr));
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  if( handleSetEventError(self,rc) = 1 )
    if pcallLock(self)
      rc := pcall(procs[#EVTSETMASK], descriptor, asciiz(valueStr));
      pcallUNLock(self);
    endif;
    displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  endif;
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtSetNotCondition(self, value | rc)
{
  if pcallLock(self)
    rc := pcall(procs[#EVTSETNOTCONDITION], descriptor, value);
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  if( handleSetEventError(self,rc) = 1 )
    if pcallLock(self)
      rc := pcall(procs[#EVTSETNOTCONDITION], descriptor, value);
      pcallUNLock(self);
    endif;
    displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  endif;
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtSetStart(self, valueStr | rc tmp)
{
  if pcallLock(self)
    rc := pcall(procs[#EVTSETSTART], descriptor, asciiz(valueStr));
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  if( handleSetEventError(self,rc) = 1 )
    if pcallLock(self)
      rc := pcall(procs[#EVTSETSTART], descriptor, asciiz(valueStr));
      pcallUNLock(self);
    endif;
    displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  endif;
  ^rc;
}!!

/* PUBLIC -- gingerbread for pcall */
Def evtSetStartAndMask(self, valueStr | rc)
{
  if pcallLock(self)
    rc := pcall(procs[#EVTSETSTARTANDMASK], descriptor, asciiz(valueStr));
    pcallUNLock(self);
  else
    rc := ERR_PCALL_RECURSION;
  endif;
  if( handleSetEventError(self,rc) = 1 )
    if pcallLock(self)
      rc := pcall(procs[#EVTSETSTARTANDMASK], descriptor, asciiz(valueStr));
      pcallUNLock(self);
    endif;
    displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  endif;
  ^rc;
}!!

/* PRIVATE
   handle putting up an error box to turn off tracing
   or emulation if user really wants to modify an event
   that is in use by trigger.
 */
Def handleSetEventError(self,rc | response results) {
  results := 0;
  if( rc = (MODULE_EVENT+17) )  /* TRACING ON error */
    response := errMessageBox(ErrorTextLibClass$Inst, 
                 "Do you want to turn off tracing?",
                 getErrorText(ErrorTextLibClass$Inst, rc),
                 MB_YESNO bitOr MB_ICONQUESTION, HE_DLGM_EVENT_1);
                    
    if( response = IDYES )
      trcTracingSet(TraceLibClass$Inst,0);
      results := 1;
    endif;
  else
    if( rc = (MODULE_EVENT+18) )  /* EMULATING error */
      response := errMessageBox(ErrorTextLibClass$Inst, 
                 "Do you want to halt?",
                 getErrorText(ErrorTextLibClass$Inst, rc),
                 MB_YESNO bitOr MB_ICONQUESTION, HE_DLGM_EVENT_2);
      if( response = IDYES )
        halt(HLBreakLibClass$Inst);
        results := 1;
      endif;
    else
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  endif;
  ^results;
} !!

/* PRIVATE */
Def init(self)
{
  /* init state vars */
}
!!

/* PRIVATE to TriggerLib */
Def setDescriptor(self, d)
{
  descriptor := d ;
}!!

/* PRIVATE to TriggerLib */
Def setProcs(self, p)
{
  procs := p ;
}
!!
