/* A trigger *instance* with its own descriptor (returned by triggerOpen(TriggerLib, nameString) ) */!!

inherit(TriggerLib, #Trigger, #(descriptor  /* my descriptor from Open... */
triggerFileName

), 2, nil)!!

setClassVars(Trigger, #())!!

now(class(Trigger))!!

now(Trigger)!!

/* 11/15/1995 15:38 */
/* PUBLIC -- gingerbread for pcall */
Def trigExtEventGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGEXTEVENTGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PRIVATE */
Def init(self)
{
  /* init state vars */
  triggerFileName := "" ;
/*  descriptor := nil ; */
}
!!

/* PRIVATE
   handle putting up an error box to turn off tracing
   or emulation if user really wants to modify an event
   that is in use by trigger.
 */
Def handleSetTriggerError(self,rc | results) {
  results := 0; 
  if( (rc bitAnd E_COMPONENT_MASK) <> MODULE_TRIGGER )
    displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    ^results;
  endif;
  if( (rc bitAnd E_ERROR_NUMBER_MASK) = 10 )  /* TRACING ON error */
    if (errMessageBox(ErrorTextLibClass$Inst, "MP/SLD", 
       "Do you want to turn off tracing?", 
       MB_YESNO bitOr MB_ICONQUESTION, HE_DLGM_TRIGGER_1) = IDYES) then
      trcTracingSet(TraceLibClass$Inst,0);
      results := 1;
    endif;
  else
    displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  endif;

  ^results;
}

!!

Def aREAD_ME(self)
{ 
/*
This is an example of how to implement an Actor-style interface to an
imported DLL.  All instances of this class share the dll interface.

Each instance of this class has its own descriptor and local, memoized, 
state (see seqLevelSet() as an example).

Look in the aREAD_ME in class "TriggerLib" for more information.
*/
}!!

/* PUBLIC */
Def descriptor(self)
{ 
  ^descriptor
}
!!

/* PUBLIC */
Def name(self)
{ 
  ^triggerFileName
}
!!

/* PUBLIC -- gingerbread for pcall */
Def prim_trigFillActionGet(self, valueRef | rc )
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGFILLACTIONGET], descriptor, valueRef);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def prim_trigTraceConfigureGet(self, valueRef | rc) { 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGTRACECONFIGUREGET], descriptor, valueRef);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def prim_trigTraceModeGet(self, valueRef | rc) { 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGTRACEMODEGET], descriptor, valueRef);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc;
}
!!

/* PRIVATE to TriggerLib */
Def setDescriptor(self, d)
{
  descriptor := d ;
}
!!

/* PRIVATE to TriggerLib */
Def setFileName(self, name)
{
  triggerFileName := name ;
}
!!

/* PRIVATE to TriggerLib */
Def setProcs(self, p)
{
  procs := p ;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigActionClear(self, action | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGACTIONCLEAR], descriptor, action);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGACTIONCLEAR], descriptor, action);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigActionGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGACTIONGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigActionSet(self, action | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGACTIONSET], descriptor, action);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGACTIONSET], descriptor, action);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc;
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigCounterFunctionGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGCOUNTERFUNCTIONGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigCounterFunctionSet(self, enum | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGCOUNTERFUNCTIONSET], descriptor, enum);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGCOUNTERFUNCTIONSET], descriptor, enum);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!
/* PUBLIC -- gingerbread for pcall */
Def trigCounterValueGet(self, counter | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGCOUNTERVALUEGET], descriptor, counter, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^longAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigCounterValueSet(self, counter, value | rc) /* U16 counter, U32 value */
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGCOUNTERVALUESET], descriptor, counter, value);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGCOUNTERVALUESET], descriptor, counter, value);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigEventClear(self | rc) {
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGEVENTCLEAR], descriptor);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGEVENTCLEAR], descriptor);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigEventEnableGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGEVENTENABLEGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigEventEnableSet(self, enable | rc) /* BOOLEAN enable */
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGEVENTENABLESET], descriptor, enable);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGEVENTENABLESET], descriptor, enable);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigEventNameGet(self | rc name) 
{
  name := new(String, MAX_EVENT_NAME);
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGEVENTNAMEGET], descriptor, name, MAX_EVENT_NAME);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^"" ;
  else
    ^ removeNulls(name);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigEventNameSet(self, stringName | rc) { 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGEVENTNAMESET], descriptor, asciiz(stringName));
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGEVENTNAMESET], descriptor, asciiz(stringName));
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigEventServerGet(self | rc serverId)
{ 
  serverId := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGEVENTSERVERGET], descriptor, serverId);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(serverId,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigEventSet(self, event | rc)
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGEVENTSET], descriptor, event);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGEVENTSET], descriptor, event);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigExtGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGEXTGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigExtSet(self, enableExt | rc) /* BOOLEAN enableExt */
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGEXTSET], descriptor, enableExt);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGEXTSET], descriptor, enableExt);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigFillActionGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGFILLACTIONGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigFillActionSet(self, enableBreak | rc) /* BOOLEAN enableBreak */ 
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGFILLACTIONSET], descriptor, enableBreak);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGFILLACTIONSET], descriptor, enableBreak);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigQualifierGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGQUALIFIERGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigQualifierSet(self, action | rc) { 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGQUALIFIERSET], descriptor, action);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGQUALIFIERSET], descriptor, action);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigSeqLevelSet(self, seqLevel | rc) /* U16 seqLevel */ 
{ 
  if pcallLock(self)
    rc := pcall(procs[#TRIGSEQLEVELSET], descriptor, seqLevel);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGSEQLEVELSET], descriptor, seqLevel);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigTraceConfigureGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGTRACECONFIGUREGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigTraceConfigureSet(self, numBuffers | rc ) { /* U16 numBuffers */
  if pcallLock(self)
    rc := pcall(procs[#TRIGTRACECONFIGURESET], descriptor, numBuffers);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGTRACECONFIGURESET], descriptor, numBuffers);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigTraceModeGet(self | rc value)
{ 
  value := new( Struct, 4 ) ;
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGTRACEMODEGET], descriptor, value);
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  if (rc <> 0)
    ^0 ;
  else
    ^wordAt(value,0);
  endif ;  
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigTraceModeSet(self, mode | rc) /* TRACE_MODE mode */
{ 
  if pcallLock(self)
    rc := pcall(procs[#TRIGTRACEMODESET], descriptor, mode);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGTRACEMODESET], descriptor, mode);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigTriggerClear(self | rc) { 
  if pcallLock(self)
    rc := pcall(procs[#TRIGTRIGGERCLEAR], descriptor);
    pcallUNLock(self);
    if( handleSetTriggerError(self,rc) = 1 )
      if pcallLock(self)
        rc := pcall(procs[#TRIGTRIGGERCLEAR], descriptor);
        pcallUNLock(self);
      endif;
      displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
    endif;
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigTriggerClose(self | rc ) 
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGTRIGGERCLOSE], descriptor) ;
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc; 
}
!!

/* PUBLIC -- gingerbread for pcall */
Def trigTriggerSaveAs(self, nameString | rc) 
{ 
  if pcallLock(self)
  then
    rc := pcall(procs[#TRIGTRIGGERSAVEAS], descriptor, asciiz(nameString) );
    pcallUNLock(self);
  else 
    rc := ERR_PCALL_RECURSION ;
  endif ;

  displayError(ErrorTextLibClass$Inst,rc,FORCE_POPUP);
  ^rc;
}
!!
