/* class comment */!!

inherit(Window, #WatchPresenter, nil, 2, nil)!!

now(class(WatchPresenter))!!

/* 7/30/1997 16:26 */ 
Def openWithPosAndState(self, sizeRect, showVal | newHWnd )
{ 
   /* the Peripheral presenter in order to comply with Actor limitations
      must fake a windows object in Actor.  This object would be used to
      open, close, show a window.  The new(PeriphPresenter) call actually
      causes a CreateWindow call.  I do not want this window but I do 
      need this object to launch a peripheral window of my own.  Therefore,
      I destroy the created window using the handle myself and take over
      the object by brute force using a new WindowObject method SetHWnd().
      Not very nice but I have ulterior motives.
    */
  if not(exists(self))
      if not(TheWatchpointPresenter := new(WatchPresenter, nil, nil,
            "WatchPoint",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheWatchpointPresenter));
      if ((newHWnd := openWatchpointWindow(WatchLibClass$Inst,
            sizeRect, WS_OVERLAPPEDWINDOW)) <> nil) then
         setHWnd(TheWatchpointPresenter,newHWnd);
         show(TheWatchpointPresenter,showVal);
      else
         ^nil;
      endif;
   endif;
   ^TheWatchpointPresenter; 
   
}    !!

/* 7/30/1997 16:24 */ 
Def open(self)
{
   /* the Peripheral presenter in order to comply with Actor limitations
      must fake a windows object in Actor.  This object would be used to
      open, close, show a window.  The new(PeriphPresenter) call actually
      causes a CreateWindow call.  I do not want this window but I do 
      need this object to launch a peripheral window of my own.  Therefore,
      I destroy the created window using the handle myself and take over
      the object by brute force using a new WindowObject method SetHWnd().
      Not very nice but I have ulterior motives.
    */
   if not(exists(self))
      if not(TheWatchpointPresenter:=new(WatchPresenter,nil,nil,
            "WatchPoint",nil)) then
         ^nil;
      endif;
      Call DestroyWindow(handle(TheWatchpointPresenter));
      setHWnd(TheWatchpointPresenter,openWatchpointWindow(WatchLibClass$Inst,
            nil, nil));
      show(TheWatchpointPresenter,SW_SHOW);
   endif;
   ^TheWatchpointPresenter;

}     !!

/* 7/30/1997 16:22 */ 
Def exists(self | handle)
{
   if TheWatchpointPresenter
      handle := existsWatchpointWindow(WatchLibClass$Inst);
      if handle 
         setHWnd(TheWatchpointPresenter,handle)
      else
         TheWatchpointPresenter := nil;
      endif;
   endif;
   ^TheWatchpointPresenter;
}!!

now(WatchPresenter)!!

/* 7/30/1997 16:30 */ 
Def saveWindowPos(self keyName| isIconic layout windRect)
{
  if (hWnd = 0)
    ^clearLayoutEntry(Window, asString(keyName));
  endif;    
  /* Save Layout for Peripheral window:
  ** if the window is an icon - use the previous saved layout
  **    if there is no previous saved lay out set to 0 for default size
  ** else
  **    Get the current window  position to save.
  */

  /* IsIconic returns nonzero if self is minimized */
  if (Call IsIconic(hWnd) = 0) then
    isIconic := 0;
    /* get the location of the current window position */
    Call GetWindowRect(hWnd, windRect := new(Rect));
    if (width(windRect)=0 cand height(windRect)=0)
       isIconic := 2;
    endif;
  else
    /* force the nonzero return to be 1 */
    isIconic := 1;
    if not(windRect := getPos(PreLauncher, asString(keyName))) then
      windRect := init(new(Rect),0,0,0,0);
    endif;      
  endif; 

  if (windRect) then   
    layout := new(String, 18);
    if (isIconic = 2)
       layout := " ";
    else
       layout := asString(left(windRect)) + "," + asString(top(windRect)) +
            "," + asString(right(windRect)) + "," +
            asString(bottom(windRect)) + "," + asString(isIconic);
    endif;
    saveProfileEntry(TheProfileInfoObj, "DefaultLayout", keyName, layout);
  endif;  
  ^GOOD;
}   !!

/* 7/30/1997 16:29 */ 
Def close(self)
{ 
   if (exists(class(self)))
      closeWatchpointWindow(WatchLibClass$Inst);
      TheWatchpointPresenter := nil;
   endif;
   ^GOOD;
}!!