/***************************************************************************
**
**    $Header:   S:/tbird/mt2_amd/fwsetup/abicore.h_v   1.1   20 May 1998 10:29:18   Eric  $
**
**    $Log:   S:/tbird/mt2_amd/fwsetup/abicore.h_v  $
** 
**    Rev 1.1   20 May 1998 10:29:18   Eric
** 
**    Rev 1.0   06 May 1998 17:18:48   Eric
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : abicore.h
**
** Description: 
**
** Modification:
**
** Programmer: john 1997.1.10 for TW ABI
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _ABICORE_
#define _ABICORE_

#include "stdafx.h"
#include "serialcm.h"
#include "simulate.h"
#include "abitype.h"    


/********************** for class CBaseAbi *******************************/
class CBaseAbi : public CObject
{ 
//DESTRUCT                        
public:
    virtual ~CBaseAbi() {};          
//operator
protected:
    STATUS DefFunc() { ASSERT(FALSE);return ICE_OK; };
//virtual abi functions
public:
    virtual STATUS emuChecksum(ADDR addr, U32 len, U16 *n,RET_ADDR* retAddr) = 0;//0x2
    virtual STATUS emuCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findAddr1, RET_ADDR *findAddr2) = 0;//0x5
    virtual STATUS emuCopy(ADDR addr1, U32 len, ADDR addr2,RET_ADDR* addrRet1,
                           RET_ADDR* addrRet2) = 0;//0x6
    virtual STATUS emuFill(ADDR addr, U32 len, U16 patternLen, U8 *buff,
                           RET_ADDR* retAddr) = 0;//0x9
    virtual STATUS emuGetAllReg(U32 *cpuReg) = 0;//0xc
    virtual STATUS emuGetCpuStatus(U32 *cpuStatus) = 0;//0x3d
    virtual STATUS emuGetID(U8 *ID_Info) = 0;// 0x1
    
    virtual STATUS emuGetMemN(ADDR addr, U16 len ,U8 *buff,RET_ADDR* retAddr) = 0;// 0x21
    virtual STATUS emuGetReg(REG_MODE regMode, S16 regId,U32 *content) = 0;//0x16
    virtual STATUS emuSetReg(REG_MODE regMode, S16 regId, U32 content) = 0;
    virtual STATUS emuGetVerify(U16 *verifyFlag) = 0;//0x1a
    virtual STATUS emuGo(U16 mode,ADDR fromAddr,ADDR tillAddr) = 0;//0x1c
    virtual STATUS emuReset(ADDR addr) = 0;//0x22
    virtual STATUS emuSearch(ADDR addr, U32 len, U8 *buff, U16 patternLen,U8 caseFlag,RET_ADDR* retAddr)=0;//0x23
    virtual STATUS emuSetBp(ADDR addr) = 0;//0x53
    virtual STATUS emuGetBp(ADDR , ADDR , ADDR* ) = 0;//0x67
    virtual STATUS emuSetID(U16 idFlag) = 0;//0x2a
    
    virtual STATUS emuSetMemN(ADDR addr, U8 *buff, U16 patternLen,RET_ADDR* retAddr) = 0;//0x2b
    virtual STATUS emuSetVerify(U16 verifyFlag) = 0;//0x35
    virtual STATUS emuTest(ADDR addr1, U32 len,RET_ADDR* retAddr) = 0;//0x39
    virtual STATUS emuGetFWSupport(U16 * wCpuNum,U16* wCpuType) = 0;//0x52
    virtual STATUS emuClrBp(ADDR addr) = 0;//0x54
        
    
//following routine is appending on defferent cpu
    virtual STATUS emuGetMap(ADDR,ADDR,MAP_INFO *) { return DefFunc(); };//0x12
    virtual STATUS emuSetMap(ADDR , ADDR , U16 ) { return DefFunc(); };//0x2c
    virtual STATUS emuAbort() { return DefFunc(); };// 0x3e
    virtual STATUS emuGetControl(U16* ) { return DefFunc(); };//0xf
    virtual STATUS emuInput(U16, U16, U16, U8*) { return DefFunc(); };//0x1e
    virtual STATUS emuOutput (U16 , U8 *, U16 , U16) { return DefFunc(); };//0x20
    virtual STATUS emuSetControl(U16) { return DefFunc(); };//0x25
    virtual STATUS emuStepOne() { return DefFunc(); };//0x38
    virtual STATUS emuStepOver() { return DefFunc(); };//0x57
    virtual STATUS emuStepOne(U8,U16,ADDR*){ return DefFunc(); };
    virtual STATUS emuStepOver(U8,U16,ADDR*){ return DefFunc(); };
    virtual STATUS emuEreaseFlash(U32,RET_ADDR*) { return DefFunc(); };//0x59
    virtual STATUS emuProgFlash(U8,U8,U16,U8*) { return DefFunc(); };//0x5a
    virtual STATUS emuSwitchFlash() { return DefFunc(); };//0x5b
    virtual STATUS emuFillFlashBland(ADDR , ADDR, U8,RET_ADDR*) { return DefFunc(); };//0x5c
    virtual STATUS emuFwInit() { return DefFunc(); };//0x56
    virtual STATUS emuSetDecodeRam(ADDR , U8 ,U8*, RET_ADDR*) { return DefFunc(); };//0x5d
    virtual STATUS emuDiagnosticFunction(DIAG_ID) { return DefFunc(); };
    //trace
    virtual STATUS emuClrEvent(U16) { return DefFunc(); };//0x03
    virtual STATUS emuClrAllEvent(){ return DefFunc(); };//0x60
    virtual STATUS emuGetTrigger(U8 *,
                     U8 *, TRIGGER_LEVEL*,
                     U8 *, TRIGGER_LEVEL*,
                     TRIGGER_LOGIC* ){ return DefFunc(); };//0x3f
    virtual STATUS emuGetEvent(U8 *, U8 *,BUS_EVENT *, BUS_EVENT *){ return DefFunc(); };//0x11                 
    virtual STATUS emuGetTraceDepth(U16 ,BUFFER_DEPTH *){ return DefFunc(); };//0x10
    virtual STATUS emuListTraceBuff(U32 , 
                            U32 , QUALIFY_INFO *,
                            U8 *,TRACE_INFO *,
                            U8 *){ return DefFunc(); };//0x1f
    virtual STATUS emuSetEvent(U16 , BUS_EVENT *){ return DefFunc(); };//0x7
    virtual STATUS emuSetExtEvent(U16 ){ return DefFunc(); };//0x3a
    //virtual   STATUS emuSetAllEvent(BUS_EVENT*,EXEC_EVENT*,U16*){ return DefFunc(); };
    virtual STATUS emuSetTimerReg(U16) { return DefFunc(); };
    virtual STATUS emuSetTrigLogic(TRIGGER_LOGIC* ){ return DefFunc(); };//0x33
    virtual STATUS EmuStepRange(U16, ADDR*,ADDR* ){ return DefFunc(); };//0x37/////////////////
    virtual STATUS emuSetQualify(QUALIFY*){ return DefFunc(); };//0x61
    virtual STATUS emuClearQualify(){ return DefFunc(); };//0x62
    virtual STATUS emuSetTrigLevel(int , TRIGGER_LEVEL*){ return DefFunc(); };//0x63
    virtual STATUS emuSetTriggerStatus(U8 ){ return DefFunc(); };//0x64
    virtual STATUS emuSetTraceStatus (U8 ){ return DefFunc(); };//0x65
    virtual STATUS emuInitBank(BANKINIT*){ return DefFunc(); }//0x66 ///////////////////
    virtual STATUS emuConfig(BYTE [8], BYTE [8]){ return DefFunc(); };
    virtual STATUS emuGetConfig(BYTE[8]){ return DefFunc(); };
    virtual STATUS emuSetPort(U16){ return DefFunc(); };
    virtual STATUS emuCycle(U8,WORD,ADDR*,U8*,TRACE_INFO*)
        { return DefFunc(); };                            
    virtual STATUS emuGetHWMode(U8*){ return DefFunc(); };  
    virtual STATUS emuSelectBaud(BYTE){ return DefFunc(); };    
    virtual STATUS emuTestCom(BYTE* ,BYTE& ){ return DefFunc(); };  
    virtual STATUS emuSetMemMode(BYTE) { return DefFunc(); };
    virtual STATUS emuGetMemMode(BYTE&) { return DefFunc(); }; 
    virtual STATUS emuGetUesData(BYTE,BYTE&,BYTE*) { return DefFunc(); };
    virtual STATUS emuProgram(BYTE,BYTE) { return DefFunc(); };
    virtual STATUS emuSendProgData(WORD,BYTE ,BYTE* ){ return DefFunc(); };
    virtual STATUS emuClrTrig(U16) { return DefFunc(); };
    virtual STATUS emuGetAllTrig(TRIGGER *){ return DefFunc(); };
    virtual STATUS emuGetControl(U8,U8*){ return DefFunc(); };   
    virtual STATUS emuGetEvent(BUS_EVENT*,U16 *){ return DefFunc(); };
    virtual STATUS emuGetReady(U16 *){ return DefFunc(); };
    virtual STATUS emuGetSync(U16 *) { return DefFunc(); };
    virtual STATUS emuGetTraceInfo(U16 *, U32 *, U32 *, U16 *,U32*,U8*) { return DefFunc(); };
    virtual STATUS emuSetAllEvent(BUS_EVENT *, U16) {return DefFunc(); };
    virtual STATUS emuSetControl(U8,U8) {return DefFunc(); };
    virtual STATUS emuSetSync(U16) {return DefFunc(); };
    virtual STATUS emuSetTimerCounter(U16 , U32 , U32) {return DefFunc(); };
    virtual STATUS emuSetTraceBreak(U16) {return DefFunc(); };
    virtual STATUS emuSetTrig(U16,TRIGGER*){return DefFunc(); };
    virtual STATUS emuSetReady(U16){return DefFunc(); };
    virtual STATUS emuSetTrigOut(U16) {return DefFunc(); };
    virtual STATUS emuTraceAction(U16 ) {return DefFunc(); };
    virtual STATUS emuReadFlash(U8 *) {return DefFunc(); };
    virtual STATUS emuWriteFlash(U8 *){return DefFunc(); };
    virtual STATUS emuSPASetRange(U8 ,U8,ADDR,ADDR){return DefFunc(); };
    virtual STATUS emuSPAClearRange(U8 ){return DefFunc(); };
    virtual STATUS emuSPASetBkpt(U8 ,ADDR ){return DefFunc(); };
    virtual STATUS emuSPAOpen(){return DefFunc(); };
    virtual STATUS emuSPAClose(){return DefFunc(); };
    virtual STATUS emuSPAGetMAInfo(U32 *,U8 *,SPA_MA_INFO_NODE *,BOOL *){return DefFunc(); };
    virtual STATUS emuSPAGetTAInfo(U32 *,U8 *,U16 *,BOOL *){return DefFunc(); };
    virtual STATUS emuSPAGetCCInfo(ADDR ,U16,U16*,U8 *,BOOL* ){return DefFunc(); };
    virtual STATUS emuStepRange(ADDR, ADDR){return DefFunc(); };
    virtual STATUS emuSendAddr(DWORD, DWORD){return DefFunc(); };
    virtual STATUS emuDownLoadMPFW(CFile*,void (*fp)(int)){fp; return DefFunc(); };
    virtual STATUS emuNeedDownload() {return DefFunc(); };
    virtual STATUS EmuSetTrcOffOnFull(U16) {return DefFunc(); };
    virtual STATUS emuGetFROM(U8*) {return DefFunc(); };
    virtual STATUS emuSetFROM(U8*) {return DefFunc(); };
    //virtual STATUS emuDiagnosticMP(U32,DIAGNORESULT*,unsigned long) {return DefFunc(); };
    virtual STATUS emuDiagnosticMP(U32, U32 *, U8 *) {return DefFunc(); };
    
 };

/********************** for class CSimulatorAbi *******************************/
class CSimulatorAbi : public CBaseAbi
{      
//member
protected:                                  
    CSimulateMem *pMemSim;
    CSimulateCpu *pCpuSim;
//constructor & destructor
protected:
    CSimulatorAbi() {
        pMemSim = NULL;    
        pCpuSim = NULL;
    };
    virtual ~CSimulatorAbi() {
    };
//virtual simulator abi functions
public: 
    virtual STATUS emuChecksum(ADDR addr, U32 len, U16 *n,RET_ADDR* retAddr);//0x2
    virtual STATUS emuCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findAddr1, RET_ADDR *findAddr2);//0x5
    virtual STATUS emuCopy(ADDR addr1, U32 len, ADDR addr2,RET_ADDR* addrRet1,
                           RET_ADDR* addrRet2);//0x6
    virtual STATUS emuFill(ADDR addr, U32 len, U16 patternLen, U8 *buff,
                           RET_ADDR* retAddr);//0x9
    virtual STATUS emuGetAllReg(U32 *cpuReg);//0xc
    virtual STATUS emuGetCpuStatus(U32 *cpuStatus);//0x3d
    virtual STATUS emuGetID(U8 *ID_Info);// 0x1
    virtual STATUS emuGetMemN(ADDR addr, U16 len ,U8 *buff,RET_ADDR* retAddr);// 0x21
    virtual STATUS emuGetReg(REG_MODE regMode, S16 regId,U32 *content);//0x16
    virtual STATUS emuSetReg(REG_MODE regMode, S16 regId, U32 content);
    virtual STATUS emuGetVerify(U16 *verifyFlag);//0x1a
    virtual STATUS emuGo(U16 mode,ADDR fromAddr,ADDR tillAddr);//0x1c
    virtual STATUS emuReset(ADDR addr);//0x22
    virtual STATUS emuSearch(ADDR addr, U32 len, U8 *buff, U16 patternLen,U8 caseFlag,RET_ADDR* retAddr);//0x23
    virtual STATUS emuSetBp(ADDR addr);//0x53
    virtual STATUS emuGetBp(ADDR addr1, ADDR addr2, ADDR* bpAddr);//0x67
    virtual STATUS emuSetID(U16 idFlag);//0x2a
    virtual STATUS emuSetMemN(ADDR addr, U8 *buff, U16 patternLen,RET_ADDR* retAddr);//0x2b
    virtual STATUS emuSetVerify(U16 verifyFlag);//0x35
    virtual STATUS emuTest(ADDR addr1, U32 len,RET_ADDR* retAddr);//0x39
    virtual STATUS emuGetFWSupport(U16 * wCpuNum,U16* wCpuType);//0x52
    virtual STATUS emuClrBp(ADDR addr);//0x54 
        
};

/********************** for class CTWAbi *******************************/
class  CTWAbi : public CBaseAbi
{   
//member
protected:    
    CAbiPipe m_Pipe;
    CBaseAgree* m_pAgree;
    enum { END_CODE = 0 };
//operator 
public:
    void ConnectTo(CBaseAgree* pAgree) {
        m_pAgree = pAgree;
        pAgree->SetPipe((CBasePipe*)(&m_Pipe));
    };  

protected:     
    STATUS Start(unsigned long nBackTime = BASE_TIME) {
        STATUS tmpStatus;
        m_pAgree->nBackTime = nBackTime;
        if (FALSE == m_pAgree->Do()) return ICE_ERROR_COM;
        m_Pipe.Reflash(FALSE);
        tmpStatus =  (STATUS)(m_Pipe.GetStatus());
        return tmpStatus;
    };

//abi core virtual functions(for simulator)
public:
//construct
    CTWAbi() {    
        m_pAgree = NULL;
    };      
    virtual ~CTWAbi() { };  
//virtual real abi function
public:                     
    virtual STATUS emuChecksum(ADDR addr, U32 len, U16 *n,RET_ADDR* retAddr);//0x2
    virtual STATUS emuCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findAddr1, RET_ADDR *findAddr2);//0x5
    virtual STATUS emuCopy(ADDR addr1, U32 len, ADDR addr2,RET_ADDR* addrRet1,
                           RET_ADDR* addrRet2);//0x6
    virtual STATUS emuFill(ADDR addr, U32 len, U16 patternLen, U8 *buff,
                           RET_ADDR* retAddr);//0x9
    virtual STATUS emuGetAllReg(U32 *cpuReg);//0xc
    virtual STATUS emuGetCpuStatus(U32 *cpuStatus);//0x3d
    virtual STATUS emuGetID(U8 *ID_Info);// 0x1
    virtual STATUS emuGetMemN(ADDR addr, U16 len ,U8 *buff,RET_ADDR* retAddr);// 0x21
    virtual STATUS emuGetReg(REG_MODE regMode, S16 regId,U32 *content);//0x16
    virtual STATUS emuGetVerify(U16 *verifyFlag);//0x1a
    virtual STATUS emuGo(U16 mode,ADDR fromAddr,ADDR tillAddr);//0x1c
    virtual STATUS emuReset(ADDR addr);//0x22
    virtual STATUS emuSearch(ADDR addr, U32 len, U8 *buff, U16 patternLen,U8 caseFlag,RET_ADDR* retAddr);//0x23
    virtual STATUS emuSetBp(ADDR addr);//0x53
    virtual STATUS emuGetBp(ADDR addr1, ADDR addr2, ADDR* bpAdr);//0x67
    virtual STATUS emuSetID(U16 idFlag);//0x2a
    virtual STATUS emuSetMap(ADDR addr1, ADDR addr2, U16 attrib);//0x2c
    virtual STATUS emuSetMemN(ADDR addr, U8 *buff, U16 patternLen,RET_ADDR* retAddr);//0x2b
    virtual STATUS emuSetVerify(U16 verifyFlag);//0x35
    virtual STATUS emuTest(ADDR addr1, U32 len,RET_ADDR* retAddr);//0x39
    virtual STATUS emuGetFWSupport(U16 * wCpuNum,U16* wCpuType);//0x52
    virtual STATUS emuClrBp(ADDR addr);//0x54   
    virtual STATUS emuSetReg(REG_MODE regMode, S16 regId, U32 content);
    //trace
    virtual STATUS emuClrEvent(U16 evId);//0x03
    virtual STATUS emuClrAllEvent();//0x60
    virtual STATUS emuGetTrigger(U8 *byTrigStatus,
                     U8 *byLv1Status, TRIGGER_LEVEL* pLv1,
                     U8 *byLv2Status, TRIGGER_LEVEL* pLv2,
                     TRIGGER_LOGIC* pTrigLogic);//0x3f
    virtual STATUS emuGetEvent(U8 *byControl, U8 *byEv3,BUS_EVENT *pEv1, BUS_EVENT *pEv2);//0x11                 
    virtual STATUS emuGetTraceDepth(U16 bufID,BUFFER_DEPTH *traceDepth);//0x10
    virtual STATUS emuListTraceBuff(U32 startFrame, 
                            U32 endFrame, QUALIFY_INFO *qualifyInfo,
                            U8 *frameLen,TRACE_INFO *traceInfo,
                            U8 *readEnd);//0x1f
    virtual STATUS emuSetEvent(U16 evId, BUS_EVENT *busEventData);//0x7
    virtual STATUS emuSetExtEvent(U16 evData);//0x3a
    virtual STATUS emuSetTrigLogic(TRIGGER_LOGIC* trigLogicData);//0x33
    virtual STATUS emuSetQualify(QUALIFY* qualifyData);//0x61
    virtual STATUS emuClearQualify();//0x62
    virtual STATUS emuSetTrigLevel(int levelId, TRIGGER_LEVEL* trigLevelData);//0x63
    virtual STATUS emuSetTriggerStatus(U8 triggerFlag);//0x64
    virtual STATUS emuSetTraceStatus (U8 tracerFlag);//0x65
    //others
    virtual STATUS emuGetMap(ADDR,ADDR,MAP_INFO *mapData);//0x12
    virtual STATUS emuAbort() ;// 0x3e
    virtual STATUS emuGetControl(U16 *signals) ;//0xf
    virtual STATUS emuInput(U16 port, U16 len, U16 size, U8 *buff) ;//0x1e
    virtual STATUS emuOutput (U16 port, U8 *buff , U16 len, U16 size) ;//0x20
    virtual STATUS emuSetControl(U16 signals) ;//0x25
    virtual STATUS emuStepOne() ;//0x38
    virtual STATUS emuStepOver() ;//0x57
    virtual STATUS emuEreaseFlash(U32 bankNo,RET_ADDR* addr) ;//0x59
    virtual STATUS emuProgFlash(U8 dataLen, U8 bOptionBankLowOrHigh,U16 startAddr, U8 *dataContent) ;//0x5a
    virtual STATUS emuSwitchFlash() ;//0x5b
    virtual STATUS emuFillFlashBland(ADDR addr1, ADDR addr2, U8 blankValue,RET_ADDR* retAddr) ;//0x5c
    virtual STATUS emuFwInit() ;//0x56                           
    
 }; 
 
//globle value
//extern CBaseAbi* pAbi; 
///////////////////////////////////////////
#endif ////////////////
