
/***************************************************************************
**
**    $Header:   S:/tbird/mt2_amd/fwsetup/abiextfn.h_v   1.1   20 May 1998 10:29:24   Eric  $
**
**    $Log:   S:/tbird/mt2_amd/fwsetup/abiextfn.h_v  $
** 
**    Rev 1.1   20 May 1998 10:29:24   Eric
** 
**    Rev 1.0   06 May 1998 17:18:46   Eric
** Initial revision.
** 
****************************************************************************/
/***************************************************************************
**
** File name : abiextfn.h
**
** Description: john 1997.1 for TW ABI
**
** Modification:
**
** Programmer: 
**
**    Copyright (C) 1996 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/
#ifndef _ABIEXTFN_
#define _ABIEXTFN_

#include "stdafx.h"   
#include "abitype.h"
#include "abicore.h"

#ifdef __cplusplus
extern "C" {
#endif  // __cplusplus
BOOL WINAPI InitABIDLL();
BOOL WINAPI NewABIDLL(ABI_INIT_OPTION nOption);
BOOL WINAPI ExitABIDLL();

CBaseAbi* WINAPI GetAbi();
CBaseSerialAgree* WINAPI GetCom();
void WINAPI GetSerialBaudRateStr(CString& str);
void WINAPI GetSerialPortNumStr(CString& str);

//////////////////////////////////////////////////////////////////////////////
STATUS WINAPI emuAbort();
STATUS WINAPI emuChecksum(ADDR addr, U32 len, U16 *n,RET_ADDR* retAddr);
STATUS WINAPI emuClrEvent(U16 evId);
STATUS WINAPI emuClrAllEvent();
STATUS WINAPI emuCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findAddr1, RET_ADDR *findAddr2);
STATUS WINAPI emuCopy(ADDR addr1, U32 len, ADDR addr2,RET_ADDR* addrRet1,RET_ADDR* addrRet2);
STATUS WINAPI emuFill(ADDR addr, U32 len, U16 patternLen, U8 *buff,RET_ADDR* retAddr);
STATUS WINAPI emuGetAllReg(U32 *cpuReg);
STATUS WINAPI emuGetTrigger(U8 *byTrigStatus,
                     U8 *byLv1Status, TRIGGER_LEVEL* pLv1,
                     U8 *byLv2Status, TRIGGER_LEVEL* pLv2,
                     TRIGGER_LOGIC* pTrigLogic);
STATUS WINAPI emuGetControl(U8 signals,U8* value);
STATUS WINAPI emuGetCpuStatus(U32 *cpuStatus);
STATUS WINAPI emuGetEvent(BUS_EVENT* event_record,U16 *ext_record);
STATUS WINAPI emuGetID(U8 *ID_Info);
STATUS WINAPI emuGetMap(ADDR,ADDR,MAP_INFO *mapData);
STATUS WINAPI emuGetMemN(ADDR addr, U16 len ,U8 *buff,RET_ADDR* retAddr);
STATUS WINAPI emuGetReg(REG_MODE regMode, S16 regId,U32 *content);
STATUS WINAPI emuGetTraceDepth(U16 bufID,BUFFER_DEPTH *traceDepth);
STATUS WINAPI emuGetVerify(U16 *verifyFlag);
STATUS WINAPI emuGo(U16 mode,ADDR fromAddr,ADDR tillAddr);
STATUS WINAPI emuInput(U16 port, U16 len, U16 size, U8 *buff);
STATUS WINAPI emuListTraceBuff(S32 startFrame, 
			            U32 dwFrameNum, QUALIFY_INFO *qualifyInfo,
			          	U8 *frameLen,TRACE_INFO *traceInfo,
						U8 *readEnd);
STATUS WINAPI emuOutput (U16 port, U8 *buff , U16 len, U16 size);
STATUS WINAPI emuReset(ADDR addr);
STATUS WINAPI emuSearch(ADDR addr, U32 len, U8 *buff, U16 patternLen,U8 caseFlag,
				 RET_ADDR* retAddr);
STATUS WINAPI emuSetBp(ADDR addr);
STATUS WINAPI emuSetControl(U8 id,U8 value);
STATUS WINAPI emuSetEvent(U16 evId, BUS_EVENT *busEventData);
STATUS WINAPI emuSetExtEvent(U16 evData);
STATUS WINAPI emuSetID(U16 idFlag);
STATUS WINAPI emuSetMap(ADDR addr1, ADDR addr2, U16 attrib);
STATUS WINAPI emuSetMemN(ADDR addr, U8 *buff, U16 patternLen,RET_ADDR* retAddr);
STATUS WINAPI emuSetTrigLogic(TRIGGER_LOGIC* trigLogicData);
STATUS WINAPI emuSetTrig(U16 levelNo,TRIGGER* tmpTrig);
STATUS WINAPI emuSetVerify(U16 verifyFlag);
STATUS WINAPI emuTest(ADDR addr1, U32 len,RET_ADDR* retAddr);
STATUS WINAPI emuGetFWSupport(U16 * wCpuNum,U16* wCpuType);
STATUS WINAPI emuClrBp(ADDR addr);
STATUS WINAPI emuStepOne();
STATUS WINAPI emuStepOver();
STATUS WINAPI emuEreaseFlash(U32 bankNo,RET_ADDR* addr);
STATUS WINAPI emuProgFlash(U8 dataLen, U8 bOptionBankLowOrHigh,U16 startAddr, U8 *dataContent); 
STATUS WINAPI emuSwitchFlash ();
STATUS WINAPI emuFillFlashBland ( ADDR addr1, ADDR addr2, U8 blankValue,RET_ADDR* retAddr);
STATUS WINAPI emuFwInit();
STATUS WINAPI emuSetQualify(QUALIFY* qualifyData);
STATUS WINAPI emuClearQualify();
STATUS WINAPI emuSetTrigLevel(int levelId, TRIGGER_LEVEL* trigLevelData);
STATUS WINAPI emuSetTriggerStatus(U8 triggerFlag);
STATUS WINAPI emuSetTraceStatus (U8 tracerFlag);
STATUS WINAPI emuInitBank(BANKINIT* bankInit);
STATUS WINAPI emuGetBp(ADDR addr1, ADDR addr2, ADDR* bpAddr);
STATUS WINAPI emuSetReg(REG_MODE regMode, S16 regId,U32 content);
STATUS WINAPI emuSelectBaud(BYTE bBaud);
STATUS WINAPI emuTestCom(BYTE* pChar,BYTE& bRetLen);
STATUS WINAPI emuSetMemMode(BYTE bMode);
STATUS WINAPI emuGetMemMode(BYTE& bMode);
STATUS WINAPI emuGetUesData(BYTE bType,BYTE& bLen,BYTE* pBuff);
STATUS WINAPI emuProgram(BYTE bType,BYTE bUes);
STATUS WINAPI emuSendProgData(WORD wAddr,BYTE bLen,BYTE* pBuff);
STATUS WINAPI emuClrTrig(U16 evId);
STATUS WINAPI emuGetAllTrig(TRIGGER *trig_record);
STATUS WINAPI emuGetReady(U16 *readyFlag);               
STATUS WINAPI emuGetSync(U16 *sync); 
STATUS WINAPI emuGetTraceInfo(U16 *lastBuff, U32 *curCNT0, U32 *curCNT1, U16 *bufNO,U32* timer,U8* timerMSB);
STATUS WINAPI emuSetAllEvent(BUS_EVENT *event_record, U16 ext_record);
STATUS WINAPI emuSetReady(U16 readyFlag);
STATUS WINAPI emuSetSync(U16 syncFlag);
STATUS WINAPI emuSetTimerCounter(U16 tcFlag, U32 tcData0, U32 tcData1);
STATUS WINAPI emuSetTimerReg(U16 settings);
STATUS WINAPI emuSetTraceBreak(U16 breakFull);
STATUS WINAPI emuConfig(BYTE uconfigset[8], BYTE uconfigGet[8]);
STATUS WINAPI emuGetConfig(BYTE uconfigGet[8]);
STATUS WINAPI emuSetPort(U16 portNum);
STATUS WINAPI emuSetTrigOut(U16 trigOut);
STATUS WINAPI emuTraceAction(U16 traceAct);

STATUS WINAPI emuReadFlash(U8 *data);
STATUS WINAPI emuWriteFlash(U8 *data);
STATUS WINAPI emuSPASetRange(U8 type,U8 id,ADDR start,ADDR end); 
STATUS WINAPI emuSPAClearRange(U8 type);
STATUS WINAPI emuSPASetBkpt(U8 enable,ADDR addr);
STATUS WINAPI emuSPAOpen();
STATUS WINAPI emuSPAClose();
STATUS WINAPI emuSPAGetMAInfo(U32 *totalTime,U8 *totalTimeMSB,SPA_MA_INFO_NODE *info,BOOL *flagHalt);
STATUS WINAPI emuSPAGetTAInfo(U32 *timeStamp,U8 *timeStampMSB,U16 *info,BOOL *flagHalt);
STATUS WINAPI emuSPAGetCCInfo(ADDR start,U16 len,U16* retLen,U8 *buf,BOOL* flagHalt);
STATUS WINAPI emuStepRange(ADDR addr1, ADDR addr2) ;
STATUS WINAPI emuGetHWMode(U8* mode) ;
STATUS WINAPI emuSendAddr(DWORD dwAddr, DWORD dwLen);
STATUS WINAPI emuDownLoadMPFW(CFile* fileFW,void (*fp)(int) = NULL); 
STATUS WINAPI emuNeedDownload();
STATUS WINAPI emuSetTrcOffOnFull(U16 trcOffOnFull);
STATUS WINAPI emuGetFROM(U8 data[32]); 
STATUS WINAPI emuSetFROM(U8 data[32]);               
//STATUS WINAPI emuDiagnosticMP(U32 diagID,DIAGNORESULT* retVal,unsigned long nBackTimer);
STATUS WINAPI emuDiagnosticMP(U32 diagID,U32 *retData,U8 *retID);
//only for diagnostic 97.6
STATUS WINAPI emuGetDiagnosticMeterTimer(BYTE& bTimer);
STATUS WINAPI emuSetDiagnosticIsStop(BOOL isStop); 
STATUS WINAPI emuReshakeHandle(); 

#ifdef __cplusplus
}
#endif

#endif
