/***************************************************************************
**
**    $Header:   S:/tbird/mt2_amd/fwsetup/abifunc.cpv   1.1   20 May 1998 10:29:32   Eric  $
**                             
**    $Log:   S:/tbird/mt2_amd/fwsetup/abifunc.cpv  $
** 
**    Rev 1.1   20 May 1998 10:29:32   Eric
** 
**    Rev 1.0   06 May 1998 17:18:48   Eric
** Initial revision.
** 
****************************************************************************/
/***************************************************************************
**
** File name : ABIFUNC.CPP
** Author:john chow
** Description:
**    Descript the ABI for TW ABI
**
**    Finished date: 97.1
**    modifed date:
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#include "stdafx.h" 

#include "abicore.h"
#include "abitype.h"
#include "simulate.h"
#include "abiextfn.h" 
#include "abifnmp.h"

extern CBaseAbi* pAbi;

#ifdef __cplusplus
extern "C" {
#endif	// __cplusplus
 
STATUS WINAPI emuAbort()                         
{ 
    return pAbi->emuAbort();
 }         
 
STATUS WINAPI emuChecksum(ADDR addr, U32 len, U16 *n,RET_ADDR* retAddr)
{ 
    return pAbi->emuChecksum(addr,len,n,retAddr);
 }         

STATUS WINAPI emuClrEvent(U16 evId)
{ 
    return pAbi->emuClrEvent(evId);
 }         

STATUS WINAPI emuClrAllEvent()
{ 
    return pAbi->emuClrAllEvent();
 }         

STATUS WINAPI emuCompare(ADDR addr1, U32 len, ADDR addr2, RET_ADDR *findAddr1, RET_ADDR *findAddr2)
{ 
    return pAbi->emuCompare(addr1,len,addr2,findAddr1,findAddr2);
 }         

STATUS WINAPI emuCopy(ADDR addr1, U32 len, ADDR addr2,RET_ADDR* addrRet1,RET_ADDR* addrRet2)
{ 
    return pAbi->emuCopy(addr1,len,addr2,addrRet1,addrRet2);
 }         

STATUS WINAPI emuFill(ADDR addr, U32 len, U16 patternLen, U8 *buff,RET_ADDR* retAddr)
{ 
    return pAbi->emuFill(addr,len,patternLen,buff,retAddr);
 }         

STATUS WINAPI emuGetAllReg(U32 *cpuReg)
{ 
    return pAbi->emuGetAllReg(cpuReg);
 }         

STATUS WINAPI emuGetTrigger(U8 *byTrigStatus,
                     U8 *byLv1Status, TRIGGER_LEVEL* pLv1,
                     U8 *byLv2Status, TRIGGER_LEVEL* pLv2,
                     TRIGGER_LOGIC* pTrigLogic)
{ 
    return pAbi->emuGetTrigger(byTrigStatus,
                     byLv1Status,pLv1,
                     byLv2Status,pLv2,
                     pTrigLogic);
}         
                     
STATUS WINAPI emuGetCpuStatus(U32 *cpuStatus)
{ 
    return pAbi->emuGetCpuStatus(cpuStatus);
 }         

STATUS WINAPI emuGetID(U8 *ID_Info)
{ 
    return pAbi->emuGetID(ID_Info);
}         

STATUS WINAPI emuGetMap(ADDR addrStart,ADDR addrEnd,MAP_INFO *mapData)
{ 
    return pAbi->emuGetMap(addrStart,addrEnd,mapData);
 }         

STATUS WINAPI emuGetMemN(ADDR addr, U16 len ,U8 *buff,RET_ADDR* retAddr)
{ 
    return pAbi->emuGetMemN(addr,len,buff,retAddr);
 }         

STATUS WINAPI emuGetReg(REG_MODE regMode, S16 regId,U32 *content)
{ 
    return pAbi->emuGetReg(regMode,regId,content);
 }         

STATUS WINAPI emuSetReg(REG_MODE regMode, S16 regId,U32 content)
{ 
    return pAbi->emuSetReg(regMode,regId,content);
 }         

STATUS WINAPI emuGetTraceDepth(U16 bufID,BUFFER_DEPTH *traceDepth)
{ 
    return pAbi->emuGetTraceDepth(bufID,traceDepth);
 }         

STATUS WINAPI emuGetVerify(U16 *verifyFlag)
{ 
    return pAbi->emuGetVerify(verifyFlag);
 }         

STATUS WINAPI emuGo(U16 mode,ADDR fromAddr,ADDR tillAddr)
{ 
    return pAbi->emuGo(mode,fromAddr,tillAddr);
 }         

STATUS WINAPI emuInput(U16 port, U16 len, U16 size, U8 *buff)
{ 
    return pAbi->emuInput(port,len,size,buff);
 }         

STATUS WINAPI emuListTraceBuff(S32 startFrame, 
                        U32 endFrame, QUALIFY_INFO *qualifyInfo,
                        U8 *frameLen,TRACE_INFO *traceInfo,
                        U8 *readEnd)
{ 
    return pAbi->emuListTraceBuff((U32)startFrame, 
                        endFrame,qualifyInfo,
                        frameLen,traceInfo,
                        readEnd);
 }         
                        
STATUS WINAPI emuOutput(U16 port, U8 *buff , U16 len, U16 size)
{ 
    return pAbi->emuOutput(port,buff,len,size);
 }         

STATUS WINAPI emuReset(ADDR addr)
{ 
    return pAbi->emuReset(addr);
 }         

STATUS WINAPI emuSearch(ADDR addr, U32 len, U8 *buff, U16 patternLen,U8 caseFlag,
                 RET_ADDR* retAddr)
{ 
    return pAbi->emuSearch(addr,len,buff,patternLen,caseFlag,retAddr);
 }         
                 
STATUS WINAPI emuSetBp(ADDR addr)
{ 
    return pAbi->emuSetBp(addr);
 }         

STATUS WINAPI emuSetEvent(U16 evId, BUS_EVENT *busEventData)
{ 
    return pAbi->emuSetEvent(evId,busEventData);
 }         

STATUS WINAPI emuSetExtEvent(U16 evData)
{ 
    return pAbi->emuSetExtEvent(evData);
 }         

STATUS WINAPI emuSetID(U16 idFlag)
{ 
    return pAbi->emuSetID(idFlag);
 }         

STATUS WINAPI emuSetMap(ADDR addr1, ADDR addr2, U16 attrib)
{ 
    return pAbi->emuSetMap(addr1,addr2,attrib);
 }         

STATUS WINAPI emuSetMemN(ADDR addr, U8 *buff, U16 patternLen,RET_ADDR* retAddr)
{ 
    return pAbi->emuSetMemN(addr,buff,patternLen,retAddr);
 }         

STATUS WINAPI emuSetTrigLogic(TRIGGER_LOGIC* trigLogicData)
{ 
    return pAbi->emuSetTrigLogic(trigLogicData);
 }         

STATUS WINAPI emuSetVerify(U16 verifyFlag)
{ 
    return pAbi->emuSetVerify(verifyFlag);
 }         

STATUS WINAPI emuTest(ADDR addr1, U32 len,RET_ADDR* retAddr)
{ 
    return pAbi->emuTest(addr1,len,retAddr);
 }         

STATUS WINAPI emuGetFWSupport(U16* wCpuNum,U16* wCpuType)
{ 
    return pAbi->emuGetFWSupport(wCpuNum,wCpuType);
 }         

STATUS WINAPI emuClrBp(ADDR addr)
{ 
    return pAbi->emuClrBp(addr);
 }         

STATUS WINAPI emuStepOne()
{ 
    return pAbi->emuStepOne();
 }         

STATUS WINAPI emuStepOver()
{ 
    return pAbi->emuStepOver();
 }         

STATUS WINAPI emuEreaseFlash(U32 bankNo,RET_ADDR* addr)
{ 
    return pAbi->emuEreaseFlash(bankNo,addr);
 }         

STATUS WINAPI emuProgFlash(U8 dataLen, U8 bOptionBankLowOrHigh,U16 startAddr, U8 *dataContent)
{ 
    return pAbi->emuProgFlash(dataLen,bOptionBankLowOrHigh,startAddr,dataContent);
 }         

STATUS WINAPI emuSwitchFlash()
{ 
    return pAbi->emuSwitchFlash();
 }         

STATUS WINAPI emuFillFlashBland(ADDR addr1,ADDR addr2, U8 blankValue,RET_ADDR* retAddr)
{ 
    return pAbi->emuFillFlashBland(addr1,addr2,blankValue,retAddr);
 }         

STATUS WINAPI emuFwInit()
{ 
    return pAbi->emuFwInit();
 }         

STATUS WINAPI emuSetQualify(QUALIFY* qualifyData)
{ 
    return pAbi->emuSetQualify(qualifyData);
 }         

STATUS WINAPI emuClearQualify()
{ 
    return pAbi->emuClearQualify();
 }         

STATUS WINAPI emuSetTrigLevel(int levelId, TRIGGER_LEVEL* trigLevelData)
{ 
    return pAbi->emuSetTrigLevel(levelId,trigLevelData);
 }         

STATUS WINAPI emuSetTriggerStatus(U8 triggerFlag)
{ 
    return pAbi->emuSetTriggerStatus(triggerFlag);
 }         

STATUS WINAPI emuSetTraceStatus (U8 tracerFlag)
{ 
    return pAbi->emuSetTraceStatus (tracerFlag);
 }         

STATUS WINAPI emuInitBank(BANKINIT* bankInit)
{ 
    return pAbi->emuInitBank(bankInit);
 }         

STATUS WINAPI emuGetBp(ADDR addr1, ADDR addr2, ADDR* bpAddr)
{ 
    return pAbi->emuGetBp(addr1,addr2,bpAddr);
 }
          
STATUS WINAPI emuSelectBaud(BYTE bBaud)
{                                             
    return pAbi->emuSelectBaud(bBaud);
 }                                 
 
STATUS WINAPI emuTestCom(BYTE* pChar,BYTE& bRetLen)
{                                     
    return pAbi->emuTestCom(pChar,bRetLen);
 }

STATUS WINAPI emuSetMemMode(BYTE bMode)
{                                     
    return pAbi->emuSetMemMode(bMode);
 }

STATUS WINAPI emuGetMemMode(BYTE& bMode)
{                                     
    return pAbi->emuGetMemMode(bMode);
 }
 
STATUS WINAPI emuGetUesData(BYTE bType,BYTE& bLen,BYTE* pBuff) {
    return pAbi->emuGetUesData(bType,bLen,pBuff);
}

STATUS WINAPI emuProgram(BYTE bType,BYTE bUes) {
    return pAbi->emuProgram(bType,bUes);
}

STATUS WINAPI emuSendProgData(WORD wAddr,BYTE bLen,BYTE* pBuff) {
    return pAbi->emuSendProgData(wAddr,bLen,pBuff);
}

STATUS WINAPI emuClrTrig(U16 evId) { 
    return pAbi->emuClrTrig(evId);
}      

STATUS WINAPI emuGetAllTrig(TRIGGER *trig_record) {
	return pAbi->emuGetAllTrig(trig_record);
}                                          

STATUS WINAPI emuGetControl(U8 signals,U8* value) {
	return pAbi->emuGetControl(signals,value);
}                                                           

STATUS WINAPI emuGetEvent(BUS_EVENT* event_record,U16 *ext_record) {
	return pAbi->emuGetEvent(event_record,ext_record);
 }

STATUS WINAPI emuGetReady(U16 *readyFlag) {  
	return pAbi->emuGetReady(readyFlag);
 }                

STATUS WINAPI emuGetSync(U16 *sync) {
	return pAbi->emuGetSync(sync);
 }                            

STATUS WINAPI emuGetTraceInfo(U16 *lastBuff, U32 *curCNT0, U32 *curCNT1, U16 *bufNO,U32* timer,U8* timerMSB) {
	return pAbi->emuGetTraceInfo(lastBuff,curCNT0,curCNT1,bufNO,timer,timerMSB);
 }      

STATUS WINAPI emuSetAllEvent(BUS_EVENT *event_record, U16 ext_record) {
	return pAbi->emuSetAllEvent(event_record,ext_record);
 }                                                  

STATUS WINAPI emuSetControl(U8 id,U8 value) {
	return pAbi->emuSetControl(id,value);
 }                                     

STATUS WINAPI emuSetReady(U16 readyFlag) {
	return pAbi->emuSetReady(readyFlag);	
 }                                 
 
STATUS WINAPI emuSetSync(U16 syncFlag) {
	return pAbi->emuSetSync(syncFlag);
} 

STATUS WINAPI emuSetTimerCounter(U16 tcFlag, U32 tcData0, U32 tcData1) {
	return pAbi->emuSetTimerCounter(tcFlag,tcData0,tcData1);
 }
 
STATUS WINAPI emuSetTimerReg(U16 settings) {
	return pAbi->emuSetTimerReg(settings);
 } 
 
STATUS WINAPI emuSetTraceBreak(U16 breakFull) {
	return pAbi->emuSetTraceBreak(breakFull);
}                                     

STATUS WINAPI emuSetTrig(U16 levelNo,TRIGGER* tmpTrig) {
	return pAbi->emuSetTrig(levelNo,tmpTrig);
}                

STATUS WINAPI emuConfig(BYTE uconfigset[8], BYTE uconfigGet[8]) {
	return pAbi->emuConfig(uconfigset,uconfigGet);
}

STATUS WINAPI emuGetConfig(BYTE uconfigset[8]) {
	return pAbi->emuGetConfig(uconfigset);
 }                            
 
STATUS WINAPI emuSetPort(U16 portNum) {
	return pAbi->emuSetPort(portNum);
} 

STATUS WINAPI emuSetTrigOut(U16 trigOut) {
	return pAbi->emuSetTrigOut(trigOut);
 }                             
 
STATUS WINAPI emuTraceAction(U16 traceAct) {   
	return pAbi->emuTraceAction(traceAct);
}                                   

STATUS WINAPI emuReadFlash(U8 *data) {       
	return pAbi->emuReadFlash(data);
 }
 
STATUS WINAPI emuWriteFlash(U8 *data) {  
	return pAbi->emuWriteFlash(data);
 }            
 
STATUS WINAPI emuGetHWMode(U8* mode) {
	return pAbi->emuGetHWMode(mode);
} 
 
STATUS WINAPI emuSPASetRange(U8 type,U8 id,ADDR start,ADDR end){
	return pAbi->emuSPASetRange(type,id,start,end);
 }
 
STATUS WINAPI emuSPAClearRange(U8 type) {
	return pAbi->emuSPAClearRange(type);
 }
 
STATUS WINAPI emuSPASetBkpt(U8 enable,ADDR addr) {
	return pAbi->emuSPASetBkpt(enable,addr);
 }
 
STATUS WINAPI emuSPAOpen() {
	return pAbi->emuSPAOpen();
 }
 
STATUS WINAPI emuSPAClose() {
	return pAbi->emuSPAClose();
 }

STATUS WINAPI emuSPAGetMAInfo(U32 *totalTime,U8 *totalTimeMSB,SPA_MA_INFO_NODE *info,BOOL *flagHalt) {
	return pAbi->emuSPAGetMAInfo(totalTime,totalTimeMSB,info,flagHalt);
 }
 
STATUS WINAPI emuSPAGetTAInfo(U32 *timeStamp,U8 *timeStampMSB,U16*info,BOOL*flagHalt) {
	return pAbi->emuSPAGetTAInfo(timeStamp,timeStampMSB,info,flagHalt);
 }
 
STATUS WINAPI emuSPAGetCCInfo(ADDR start,U16 len,U16* retLen,U8 *buf,BOOL* flagHalt) {
	return pAbi->emuSPAGetCCInfo(start,len,retLen,buf,flagHalt);
 }
 
STATUS WINAPI emuStepRange(ADDR addr1, ADDR addr2) {
	return pAbi->emuStepRange(addr1, addr2);
 }                                     
 
STATUS WINAPI emuSendAddr(DWORD dwAddr, DWORD dwLen) {
	return pAbi->emuSendAddr(dwAddr, dwLen);
}                                                   

STATUS WINAPI emuDownLoadMPFW(CFile* fileFW,void (*fp)(int)) {
        return pAbi->emuDownLoadMPFW(fileFW,fp);
}
STATUS WINAPI emuNeedDownload() { 
	return pAbi->emuNeedDownload();
}
STATUS WINAPI emuSetTrcOffOnFull(U16 trcOffOnFull) {
	return pAbi->EmuSetTrcOffOnFull(trcOffOnFull);
}

STATUS WINAPI emuGetFROM(U8 data[32]) {
	return pAbi->emuGetFROM(data);
}                                      
STATUS WINAPI emuSetFROM(U8 data[32]) {
	return pAbi->emuSetFROM(data);
}
//STATUS WINAPI emuDiagnosticMP(U32 diagID,DIAGNORESULT* retVal,unsigned long nBackTimer) {
//        return pAbi->emuDiagnosticMP(diagID,retVal,nBackTimer);
//}
STATUS WINAPI emuDiagnosticMP(U32 diagID,U32 *retData,U8 *retID) {
        return pAbi->emuDiagnosticMP(diagID,retData,retID);
}

#ifdef __cplusplus
}
#endif	// __cplusplus
 
