/***************************************************************************
**
**    $Header:   S:/tbird/mt2_amd/fwsetup/abitype.h_v   1.1   20 May 1998 10:29:34   Eric  $
**
**    $Log:   S:/tbird/mt2_amd/fwsetup/abitype.h_v  $
** 
**    Rev 1.1   20 May 1998 10:29:34   Eric
** 
**    Rev 1.0   06 May 1998 17:18:48   Eric
** Initial revision.
** 
****************************************************************************/
/***************************************************************************
**
** File name : abitype.h
**
** Description: JOHN 1997.1 FOR TW ABI
**
**
**
**
** Programmer: 
**
**    Copyright (C) 1997 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _ABITYPE_
#define _ABITYPE_
#include "abibase.h"
//only for init abidll using
    typedef enum {
    	MAKE_SIMULATOR_ABI,
    	MAKE_REAL_196_ABI,
        MAKE_REAL_MP_ABI,
        MAKE_REAL_MP_ABI_DIAGNOSTIC,
        MAKE_REAL_MP_ABI_FIRSTTIME
    } ABI_INIT_OPTION;

    typedef struct{
		U32 addr;
		U16 addrType;
	}ADDR;
	
	typedef struct{
		U32 addr;  
		U16 addrType;
		U32 data;
	}RET_ADDR; 
	
   //address type (for pos)
	typedef enum {
        MEM_UNDEFINED   = 0,   //for error or other using
        MEM_16MB = 1,             //24 bits linear address space
        MEM_REGISTER = 5,         //MP REGISTER FILE SPACE
        MEM_SFR = 7             //MP SFR SPACE
	}ADDR_TYPE;


//defined for filter , qualify
	typedef struct {
		U8 filterFlag;
		U8 addrType;
		U8 dataType;

		U32 addrValue1;//MAX 24 BIT
		U32 addrValue2;//MAX 24 BIT
		U16 dataValue1;//MAX 16 BIT
		U16 dataValue2;
		U16 statusValue;
	} QUALIFY_INFO;
//NEW STRUCT
	typedef enum { 
		UNDEFINE_ADDR, SINGLE_ADDR, RANGE_ADDR, MASK_ADDR , RANGE_MASK
	} ADDR_SPEC;
	typedef enum { 
		UNDEFINE_DATA = 0, SINGLE_DATA = 1, MASK_DATA = 3 
	} DATA_SPEC;
	
	typedef U32 EP_ADDR;
	typedef U32 EP_DATA;
	
	typedef struct {
		U32 statusLow;
		U32 statusHigh;
		U8  TraceBitLow;
		U8  TraceBitHigh;
	}EP_STATUS;
    
    typedef struct {
		U16 count;
		U32 totalStamp;
		U8 totalStampMSB;
	} SPA_MA_INFO_NODE;
	
	#define SPA_TA_TIME_NO	9
	typedef struct {
		U16 count[SPA_TA_TIME_NO];
		U32 tmpStamp;
		U32 totalStamp;
		U8 totalStampMSB;
		U32 longest;
		U8 longestMSB;
		U32 shortest; 
		U8 shortestMSB;
	} SPA_TA_INFO_NODE;

	
//defined for trace info.
	typedef struct tracerec{
		S32 frameNo;	// frame number is not content of F/W trace data
		U32 addr;
		U32 data;
		U8  tbit;	// external trace bit
		U16 stat;   // eric page 1 chen
		U32 tport;	// trace port data
		U32 tstamp;	// byte 0-3 of time stamp
		U8  tstampMSB;	// byte 4 of time stamp
		U8  evtMatch;
		U8  seqLevel; 
	}TRACE_INFO;

//for trigger
	typedef struct {
		U16 physet;		// used for trace on the fly. If physet is TRUE , it will set
						// trigger to HW. otherwise , it is just dummy operation.
		U16 ev[11]; /* bus event : 1 ~ 8 ; ext-in : 9, cnt0 ~1 : 10, 11; 0: null */
		U16 act[11]; 
		/* bit :		     0	     1		2	3		4		5
		"LV0",   "LV1",   "BRK",  "TC0 RST", "TC1 RST", "TC0 START",
		     6			7		8	    9		10
		"TC1 START", "TC0 STOP","TC1 STOP", "TOFF", "TSTART",
		   11		12		13
		"TSTOP", "TRIG OUTT", "HIZ"
		*/
		U16 mode;  /* backward : 0 ; forward : 1 ; center : 2; delay : 3 */
		U16 delay;
	} TRIGGER;


//defined for event
	typedef struct {
		U16 physet;		// used for trace on the fly. If physet is TRUE , it will set
					// event to HW. otherwise , it is just dummy operation.
		ADDR_SPEC addrSpec;
		EP_ADDR addrLow;
		EP_ADDR addrHigh;
		EP_ADDR addrRangeMask;
		DATA_SPEC dataSpec;
		EP_DATA dataLow;
		EP_DATA dataHigh;
		EP_STATUS status;
	}BUS_EVENT;


//defined for map settings
	typedef enum {
		MAP_ERW = 0x0,	// external read/write(TARGET)
		MAP_ORW = 0x1,	// overlay read/write
		MAP_ER = 0x2,		// external read only(reserved)
		MAP_OR = 0x3,		// overlay read only
		MAP_GUARD=0x4		// guard
	} MAP_ATTR;



	typedef struct {
		ADDR addr1; 
	    ADDR addr2; 
	   	U16  attr;
	}MAP_INFO;

//defined for trace
	typedef struct {
	    S32 startFrame;
	    S32 endFrame;
	}BUFFER_DEPTH;

//defined for go command
	typedef enum {
	    NORMAL_RUN = 0,FREE_RUN,FLY_RUN,MONITOR_RUN,TEST_RUN,
	    SPA_MA_RUN, SPA_TA_RUN, SPA_CC_RUN,  // special running mode for SPA
	}RUN_MODE;
//defined for diagnostic    
typedef struct {
	U32    nResult;
	U32	   nErrAddr;
	U8	   bExpectData;
	U8	   bActualData;
} DIAGNORESULT;

/* define the F/W command ID for Pic  */
typedef enum {  
   COMMAND_START,          /* 0  -- 0x0  */
   GET_ID,                 /* 1  -- 0x1  */ // special command, must place 1st.
   CHECKSUM,               /* 2  -- 0x2  */
   CLR_EVENT,              /* 3  -- 0x3  */
   CLR_TRIG,               /* 4  -- 0x4  */
   COMPARE,                /* 5  -- 0x5  */
   COPY,                   /* 6  -- 0x6  */
   FUNCTION_TEST,          /* 7  -- 0x7  */
   ESC_COMMAND,            /* 8  -- 0x8  */
   FILL_COMMAND,           /* 9  -- 0x9  */
   GET_ALL_CO_REG,         /* 10 -- 0xa  */
   GET_ALL_INTERNAL_REG,   /* 11 -- 0xb  */
   GET_ALL_REG,            /* 12 -- 0xc  */
   GET_CO_COVERAGE,        /* 13 -- 0xd  */
   GET_CO_REG,             /* 14 -- 0xe  */
   GET_CONTROL,            /* 15 -- 0xf  */
   GET_DEPTH,              /* 16 -- 0x10 */
   GET_EVENT,              /* 17 -- 0x11 */
   GET_MAP,                /* 18 -- 0x12 */
   GET_MAP_SIZE,           /* 19 -- 0x13 */
   GET_MODE,               /* 20 -- 0x14 */
   GET_READY,              /* 21 -- 0x15 */
   GET_REG,                /* 22 -- 0x16 */
   GET_SIZE,               /* 23 -- 0x17 */
   GET_STAT,               /* 24 -- 0x18 */
   GET_SYNC,               /* 25 -- 0x19 */
   GET_VERIFY,             /* 26 -- 0x1a */
   GET_WAIT,               /* 27 -- 0x1b */
   GO_COMMAND,             /* 28 -- 0x1c */
   HALT,                   /* 29 -- 0x1d */
   INPUT,                  /* 30 -- 0x1e */
   LIST_TRACE,             /* 31 -- 0x1f */
   OUTPUT,                 /* 32 -- 0x20 */
   READ_MEM_N,             /* 33 -- 0x21 */
   RESET,                  /* 34 -- 0x22 */
   SEARCH,                 /* 35 -- 0x23 */
   SET_TRACE_BUFF,         /* 36 -- 0x24 */
   SET_CONTROL,            /* 37 -- 0x25 */
   SET_CO_COVERAGE,        /* 38 -- 0x26 */
   SET_CO_REG,             /* 39 -- 0x27 */
   SET_EVENT,              /* 40 -- 0x28 */
   SET_EX_BKPT,            /* 41 -- 0x29 */
   SET_ID,                 /* 42 -- 0x2a */
   SET_MEM_N,              /* 43 -- 0x2b */
   SET_MAP,                /* 44 -- 0x2c */
   SET_MODE,               /* 45 -- 0x2d */
   SET_REG,                /* 46 -- 0x2e */
   SET_READY,              /* 47 -- 0x2f */
   SET_SIZE,               /* 48 -- 0x20 */
   SET_SYNC,               /* 49 -- 0x31 */
   SET_TRACE_BREAK,        /* 50 -- 0x32 */
   SET_TRIG,               /* 51 -- 0x33 */
   SET_TIMER_COUNTER,      /* 52 -- 0x34 */
   SET_VERIFY,             /* 53 -- 0x35 */
   SET_WAIT,               /* 54 -- 0x36 */
   STEP,                   /* 55 -- 0x37 */
   STEP_ONE,               /* 56 -- 0x38 */
   TEST,                   /* 57 -- 0x39 */
   SET_EXT_EVENT,          /* 58 -- 0x3a */
   SET_ALL_EVENT,          /* 59 -- 0x3b */
   SET_TIMER_REG,          /* 60 -- 0x3c */
   GET_CPU_STATUS,         /* 61 -- 0x3d */
   ABORT,                  /* 62 -- 0x3e */
   GET_TRIG,               /* 63 -- 0x3f */
   GET_LAST_BUFF,          /* 64 -- 0x40 */
   DIAGNOSTIC,             /* 65 -- 0x41 */
   SET_TRACE_OFF_FULL,     /* 66 -- 0x42 */
   SET_TRIG_OUT_ACT,       /* 67 -- 0x43 */
   TRACE_ACTION,           /* 68 -- 0x44 */
   READ_STAMP,             /* 69 -- 0x45 */
   SPA_SET_RANGE,          /* 70 -- 0x46 */
   SPA_CLEAR_RANGE,        /* 71 -- 0x47 */
   SPA_GET_MA_INFO,        /* 72 -- 0x48 */
   SPA_GET_TA_INFO,        /* 73 -- 0x49 */
   SPA_GET_CC_INFO,        /* 74 -- 0x4A */
   SPA_CLOSE,              /* 75 -- 0x4B */
   SPA_SETBKPT,            /* 76 -- 0x4C */
   SPA_OPEN,               /* 77 -- 0x4D */
   R_FLUSH_ROM,            /* 78 -- 0x4E */
   W_FLUSH_ROM,            /* 79 -- 0x4F */
   CLR_BKPT,               /* 80 -- 0x50 */  //add by Eric 9/30/97
   //Add flashrom command by Eric 3/12/98
   GET_HW_MODE,            /* 81 -- 0x51 */  
   SWITCH_FLASH,           /* 82 -- 0x52 */
   EREASE_FLASH,           /* 83 -- 0x53 */  
   PROG_FLASH,             /* 84 -- 0x54 */
   FILL_FLASH_BLANK,       /* 85 -- 0x55 */
   //EOF flashrom command

   SELECT_BAUD,            /* 86 -- 0x56 not supported   */
   SET_QUALIFY,            /* 87 -- 0x57 not supported   */
   CLEAR_QUALIFY,          /* 88 -- 0x58 not supported       */
   SET_LEVEL,              /* 89 -- 0x59 not supported       */
   SET_TRIGGER_STATUS,     /* 90 -- 0x5A not supported      */
   SET_TRACE_STATUS,       /* 91 -- 0x5B not supported  */
   FW_INIT,                /* 92 -- 0x5C supported      */
   SET_BP,                 /* 93 -- 0x5D supported         */
   CLR_BP,                 /* 94 -- 0x5E supported       */
   SET_PORT,               /* 95 -- 0x5F not supported  */
   STEP_OVER,              /* 96 -- 0x60 supported      */
   CONFIG_CPU ,            /* 97 -- 0x61 not supported   */
   GET_CONFIG,             /* 98 -- 0x62 not supported   */
   GET_FW_SUPPORT,         /* 99 -- 0x63 supported       */
   CLEAR_ALL_EVENT,        /*100 -- 0x64 not supported   */
   GET_BP,                 /*101 -- 0x65 not supported     */

   MAX_COMMAND          /* All new command must add before this command. */

} FW_COMMAND_ID;

/* define the command ID od the Michelle firmware function */
typedef enum {
   DIAG_START,             /* 0  -- 0x0  */
   D_GET_ID,               /* 1  -- 0x1  */ // special command, must place 1st.
   INITIAL_TEST,           /* 2  -- 0x02 */
   MCE_OPEN_SHORT_TEST,    /* 3  -- 0x03 */
   MCE_PULL_HIGH_TEST,     /* 4  -- 0x04 */
   MCE_MAP_TEST,           /* 5  -- 0x05 */
   MCE_MEMORY_TEST,        /* 6  -- 0x06 */
   TEST_BC_RDATA_BUS,      /* 7  -- 0x07 */
   TEST_BC_SDATA_BUS,      /* 8  -- 0x08 */
   TEST_BC_TDATA_BUS,      /* 9  -- 0x09 */
   TEST_BC_UDATA_BUS,      /* 10 -- 0x0A */
   TEST_BC_VDATA_BUS,      /* 11 -- 0x0B */
   TEST_BC_WDATA_BUS,      /* 12 -- 0x0C */
   TEST_BC_RADDR_BUS,      /* 13 -- 0x0D */
   TEST_BC_SADDR_BUS,      /* 14 -- 0x0E */
   TEST_BC_TADDR_BUS,      /* 15 -- 0x0F */
   TEST_BC_UADDR_BUS,      /* 16 -- 0x10 */
   TEST_BC_VADDR_BUS,      /* 17 -- 0x11 */
   TEST_BC_WADDR_BUS,      /* 18 -- 0x12 */
   TEST_TB_RSDATA_BUS,     /* 19 -- 0x13 */
   TEST_TB_TUDATA_BUS,     /* 20 -- 0x14 */
   TEST_TB_TPDATA_BUS,     /* 21 -- 0x15 */
   TEST_TB_VWDATA_BUS,     /* 22 -- 0x16 */
   TEST_TB_TSDATA_BUS,     /* 23 -- 0x17 */
   TEST_TB_EVDATA_BUS,     /* 24 -- 0x18 */
   TEST_TB_RSADDR_BUS,     /* 25 -- 0x19 */
   TEST_TB_TUADDR_BUS,     /* 26 -- 0x1A */
   TEST_TB_TPADDR_BUS,     /* 27 -- 0x1B */
   TEST_TB_VWADDR_BUS,     /* 28 -- 0x1C */
   TEST_TB_TSADDR_BUS,     /* 29 -- 0x1D */
   TEST_TB_EVADDR_BUS,     /* 30 -- 0x1E */
   TEST_SEQ_RAM,           /* 31 -- 0x1F */
   MCE_CONNECT_TEST,       /* 32 -- 0x20 */
   REPEAT_DIAG,            /* All new command must add before this command. */
   END_DIAG                /* All new command must add before this command. */
} DIAG_ID;

static char *diagDisplayMTAT2[] = {
     "Testing RDATA BUS...",
     "Testing SDATA BUS...",
     "Testing TDATA BUS...",
     "Testing UDATA BUS...",
     "Testing VDATA BUS...",
     "Testing WDATA BUS...",
     "Testing RADDR BUS...",
     "Testing SADDR BUS...",
     "Testing TADDR BUS...",
     "Testing UADDR BUS...",
     "Testing VADDR BUS...",
     "Testing WADDR BUS...",
     "Testing RSDATA BUS..",
     "Testing TUDATA BUS..",
     "Testing TPDATA BUS..",
     "Testing VWDATA BUS..",
     "Testing TSDATA BUS..",
     "Testing EVDATA BUS..",
     "Testing RSADDR BUS..",
     "Testing TUADDR BUS..",
     "Testing TPADDR BUS..",
     "Testing VWADDR BUS..",
     "Testing TSADDR BUS..",
     "Testing EVADDR BUS.."
};

/*
typedef struct {
	BOOL bResult;// TRUE -- OK; FALSE WRONG
	WORD  nLoc; //error location    
	BYTE bSend;//byte send to fw
	BYTE bRet; //error byte return from firmware
	WORD nError;      //
	WORD nDetailError; //from CBaseCom
} COMTESTERR;*/

//RESERVED STRUCTURE
//for LEVEL command
    typedef struct {
        FLAG traceFlag;        /* 0 trace unchanged    */
                               /* 1 trace ON           */
                               /* 2 trace OFF          */
        FLAG timerFlag;        /* 0 timer unchanged    */
                               /* 1 timer ON           */
                               /* 2 timer OFF          */
        DWORD dwCond;          /* condition list       */
                            // EV1  AAAAAAAAH
                            // EV2  CCCCCCCCH
                            // EV3  F0F0F0F0H
                            // EV4  FF00FF00H
                            // EV5  FFFF0000H
                            // EV1 OR  EV2 = AAAAAAAAH OR  CCCCCCCCH = EEEEEEEEH
                            // EV2 AND EV3 = CCCCCCCCH AND F0F0F0F0H = C0C0C0C0H

    }  TRIGGER_LEVEL;

//for trigger
	typedef struct {
        FLAG trigFlag;         /* 0 delay count    */
                               /* 1 foreward       */
                               /* 2 backward       */
                               /* 3 center         */
        FLAG runFlag;          /* 0 without run    */
                               /* 1 with run       */
        DWORD delayCount;      /* delay count(trigFlg=0 used) */
        WORD levelCount;
        WORD levelID[4];       /* level ID list*/
                               //LV1:           levelCount =1, levelID[0]=1
                               //LV2:           levelCount =1, levelID[0]=2
                               //LV1_Then_LV2:  levelCount =2, levelID[0]=1, levelID[1] =2
    } TRIGGER_LOGIC;

//defined for filter , qualify
	typedef struct {
		U8 filterFlag;
		U8 addrType;
		U8 dataType;

		U8 addrCount;
		U32 addrValue[10];//18 BIT
		U16 dataValue1;//8 or 16 BIT
		U16 dataValue2;
		U16 statusValue;
	} QUALIFY;
//for bank init
	typedef struct {
		BYTE bSignal;
			//bit 0-1 : 0: max 64k bank size
			//		    1: max 128k bank size
			//		    2: max 256k bank size
			//bit 2-6 : reserved
			//bit 7:    0: signal low to select bank
			//          1: signal high to select bank
		BYTE  bSignalPlaceLow;
			// 0-7 :  P0-P7
			// others : reserved
		BYTE  bSignalPlaceHigh;
			// 0-7 :  P0-P7
			// others : reserved
		BYTE bSignalBitLow;
			//only one bit of this byte can be set to 1,then the
			//correponding bit of P0 to P7(which you select last byte)
			//is used to output the low bit of bank selection signal.
		BYTE bSignalBitHigh; //only valid or 256k bank settings
			//only one bit of this byte can be set to 1,then the
			//correponding bit of P0 to P7(which you select last byte)
			//is used to output the high bit of bank selection signal.
	
	} BANKINIT;

#endif
