
/***************************************************************************
**
** File name : UISERIAL.H 
** Author:john chow
** Description:
**    Descript the function of serial communication for MP
**
**    Finished date: 97.1
**    modifed date:
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _UISERIAL_
#define _UISERIAL_
#include "serialcm.h"

//definition of class CDosSerialAgree 
class CWinSerialAgree : public CBaseSerialAgree
{
//members              
public:
    BOOL SerialInfor[COM_PORT_4+1];
    enum {
        ERR_OPEN = 500,
        ERR_BAUD,
        ERR_INIT,
        ERR_TRYINIT,
        ERR_FWINIT
    }; 
private:
	enum {
		XON_LIMIT = 5,
		XOFF_LIMIT = 2048
	};     
//operation
public:
    virtual BOOL SetSerialOption();
    virtual BOOL SetSerialPortBaud(BYTE,BYTE);
    virtual BOOL CommInit();  
    virtual void IsUnstable();               
    //1996.8 TO TEST THE ABI
    //virtual BOOL CommunicationTest(COMTESTERR* pErr);
    
    
protected:
    int m_nDeviceID;
    COMSTAT m_ComStatus;    
    DCB m_DCB;

    BOOL TryInit();
    
    virtual BOOL SendByte(BYTE);
    virtual BOOL ReceiveByte(BYTE&);
    virtual BOOL SendString(BYTE *,int);
    virtual BOOL ReceiveString(BYTE *,int);
    
    virtual BOOL IsEscape();
    virtual BOOL IsRelink();
    
    virtual void FlushBufferIn();
    virtual void FlushBufferOut();
    
//construct and destruct
public:       
    CWinSerialAgree();
    virtual ~CWinSerialAgree();
        
};

//definition of class CWinSerialAgree_MP
class CWinSerialAgree_MP : public CWinSerialAgree
{                                     
//operator
protected:
	virtual CString GetLinkerStr() { return CString("MICE");}; 
	virtual CString GetLinkerStr_() { return CString(CTWAgree::ACK);}; 
public:
	virtual BOOL CommInit(); 
	virtual BOOL IsRelink() { return FALSE;}; 	
//construct && destruct
        virtual ~CWinSerialAgree_MP() {};
 };

//definition of class CWinSerialAgree_196
class CWinSerialAgree_196 : public CWinSerialAgree
{                                     
//operator
protected:
	virtual CString GetLinkerStr() { return CString("?");}; 
	virtual CString GetLinkerStr_() { return CString("!");}; 
//destruct
	virtual ~CWinSerialAgree_196() {};
 };

//definition of class CDosSerialAgree 
class CWinSerialAgree_MP_Diagnostic : public CWinSerialAgree_MP
{                 
//member
public:                
	unsigned char m_bWaitTime;
    BOOL m_isStop; 
//operator
public:
	virtual BOOL ReceiveResult();	
 };


#endif //uiserial
