/* Class of auto radio buttons used in EventWindow */!!

inherit(Control, #EventButton, #(title /* event template field name */), 2, nil)!!

now(class(EventButton))!!

/* Create and return a new button object in Actor and
  Windows. Parent passes the control id, self, the name of
  the new button.  The style argument is a constant which
  defines what type of button will be created (see the
  Actor manual, in the Guide to the Actor Classes). */
Def new(self, id, par, name, style | theBut)
{ theBut := new(self:Behavior);
  setContID(theBut, id);
  setParent(theBut, par);
  setTitle(theBut, name);
  create(theBut, name, "BUTTON", style bitOr WS_CHILD);
  ^theBut;
}!!

now(EventButton)!!

Def setTitle(self, name)
{ ^title := name
}!!
Def title(self)
{ ^title
}!!
