/* CLASS: High Level Breakpoint/Exec ROOT Library
   Provide high level breakpoints, asm level breakpoints and
   execution control mechanism.

*/!!

inherit(ProvidedLibs, #HLBrkRootLib, nil, 2, nil)!!

now(class(HLBrkRootLib))!!

/* semiPRIVATE -- should only be called via require(HLBrkRootLib)
   Define entry points and load library.  Define any structs required.
*/
Def provide(self, path)
{
  ^initialise( new(self:ancestor), path )
}
!!

now(HLBrkRootLib)!!

/* 5/5/1992 16:11 - PUBLIC
  Return #true if processor emulation status is halted, else return nil.
  NOTES: Caller can retrieve the errorCode by calling lastError(HLBrkRootLibClass$Inst).
*/
Def prim_processorHalted?(self)
{ 
  if pcallLock(self)
  then
    lastError := pcall(procs[#BKPROCESSORMUSTBEHALTED]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;
  if (lastError <> GOOD) then
    ^nil;
  endif;
  ^#true;
}
!!

/* PRIVATE */
Def initServer(self)
{
  if pcallLock(self)
  then
    lastError := pcall(procs[#BKROOTINIT]) ;
    pcallUNLock(self);
  else
    lastError := ERR_PCALL_RECURSION ;
  endif;
  if (lastError <> GOOD)
    displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);
  endif;
  ^lastError;
}!!

/* 3/23/1992 14:21 - PUBLIC
  Get the current state of emulation.
  return an BX_EMULATION_STATE value or nil.  See HLBREAK.H for value defined.
 */
Def prim_getEmulationStatus(self | emStateRef)
{ 
  emStateRef := new(Struct, 2);
  if pcallLock(self)
  then
    lastError := pcall(procs[#BKGETEMULATIONSTATUS], emStateRef);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError <> GOOD) then
    ^nil
  else
    ^byteAt(emStateRef, 0)
  endif;
}
!!

/* 6/23/1992 15:29 - PUBLIC
  Return true if processor emulation status is halted, else nil.
*/
Def processorHaltedAbsolute?(self)
{ 
  if pcallLock(self)
  then
    lastError := pcall(procs[#BKPROCESSORMUSTBEHALTEDABSOLUTE]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;

  if lastError <> GOOD then
    ^nil;
  endif;
  ^#true;
}

!!

/* get run access flag */
Def getRunAccess(self | runAccessRef)
{ 
  runAccessRef := new(Struct, 2);
  if pcallLock(self)
  then
    lastError := pcall(procs[#BKGETRUNACCESS], runAccessRef);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;

  if (lastError <> GOOD) then
    displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
    ^nil;
  endif;
  ^byteAt(runAccessRef, 0);
}
!!

/* Set clear access. */
Def clearRunAccess(self)
{ 
  if pcallLock(self)
  then
    lastError := pcall(procs[#BKCLEARRUNACCESS]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;

  if lastError <> GOOD then
    displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
    ^nil;
  endif;
  ^0;
}
!!

/* Set run access. */
Def setRunAccess(self)
{ 
  if pcallLock(self)
  then
    lastError := pcall(procs[#BKSETRUNACCESS]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION;
  endif;

  if lastError <> GOOD then
    displayError(ErrorTextLibClass$Inst, lastError, CHECK_MODE);
    ^nil;
  endif;
  ^GOOD;
}
!!

/* PRIVATE
   Define all entry points for library as prototypes.
*/
Def addImportProcs(self)
{
  add( self, #BKROOTINIT,                         1, nil ) ;
  add( self, #BKGETEMULATIONSTATUS,               1, #(1) ) ;
  add( self, #BKSETRUNACCESS,                     1, nil ) ;
  add( self, #BKCLEARRUNACCESS,                   1, nil ) ;
  add( self, #BKGETRUNACCESS,                     1, #(1) ) ;
  add( self, #BKPROCESSORMUSTBEHALTED,            1, nil ) ;
  add( self, #BKPROCESSORMUSTBEHALTEDABSOLUTE,    1, nil ) ;
}!!

/* PUBLIC */
Def free(self)
{
  free( self:ancestor );
}
!!

/* 3/23/1992 14:21 - PUBLIC
  Get the current state of emulation.
  return an BX_EMULATION_STATE value or nil.  See HLBREAK.H for value defined.
 */
Def getEmulationStatus(self | result)
{ 
   result := prim_getEmulationStatus( self ) ;

  if (lastError <> GOOD) then
    displayError( ErrorTextLibClass$Inst, lastError, CHECK_MODE);
    ^nil
  else
    ^result
  endif;
}
!!

/* PRIVATE 
   Open and initialize variable server library & load trigger dll
*/
Def initialise(self, path)
{
   setName( self, path ) ;
   addImportProcs( self ) ;

   load( self ) ;  /* raises alert if fails: alert(System, self, #libLoad) */
   initServer( self ) ;
}!!

/* 5/5/1992 16:11 - PUBLIC
  Return true if processor emulation status is halted, else nil.
*/
Def processorHalted?(self)
{ 
  if pcallLock(self)
  then
    lastError := pcall(procs[#BKPROCESSORMUSTBEHALTED]);
    pcallUNLock(self);
  else 
    lastError := ERR_PCALL_RECURSION ;
  endif ;

  if lastError <> GOOD then
    displayError(ErrorTextLibClass$Inst,lastError, CHECK_MODE);
    ^nil;
  endif;
  ^#true;
}
!!
