/***************************************************************************
**
** File name : sub68k.c
**
**
**
** Changing :
**
** A. Date -- 10/22/1992 By Cheerson
**
**    0. Received from Matthew as the initial version.
**    1. Gather and sort externals/includes/local definitions ..etc.
**    2. Program source code alignment, follow the "coding standard".
**
**
**
**    Copyright (C) 1992 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

/***************************************************************************
**

**    Include files
**
***************************************************************************/

#include <conio.h>
#include <time.h>

#ifndef _COMM_
#include "comm.h"
#endif

#ifndef _ABI_DEF_
#include "abidef.h"
#endif

#ifndef _REG68306_DEFINE_
#include "reg68k.h"
#endif

#ifndef _ABI_GLOBAL_
#include "abiglbs.h"
#endif

/**************************************************************************
**
** Local define
**
***************************************************************************/

/**************************************************************************
**
** Name : iceDiagnostic()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceDiagnostic(VOID) {
   return(GOOD);
}
/*
int lp=0;
RETCODE status;

   SaveId(DIAGNOSTIC,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*3);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}
*/
/**************************************************************************
**
** Name : iceDiagnostic()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT DiagnosticFunction(DIAG_ID diagID) {
   return(GOOD);
}
/*
int lp=0;
RETCODE status;

   SaveId(diagID,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*3);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if (status != ICE_OK) {
      switch (diagID) {
         case MCE_MEMORY_TEST :
         case INITIAL_TEST :
            _fmemcpy(&memFailAddress,&inputStream[3],inputStream[2]);
            break;
         case MCE_CONNECT_TEST :
            _fmemcpy(&errorMceConnTest,&inputStream[3],sizeof(ERROR_MCE_CONN_TEST));
      }
   }
   return(status);

}
*/
/**************************************************************************
**
** Name : iceSelfTest()
**
** Function :
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSelfTest(U16 cmdId) {
   return(GOOD);
}
/*
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(FUNCTION_TEST,lp);

   varWidth = sizeof(cmdId);
   SaveVar(cmdId,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME*3);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetTimerReg(U16 regNo) {
   return(GOOD);
}
/*
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_TIMER_REG,lp);

   varWidth = sizeof(regNo);
   SaveVar(regNo,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceSetAccessSize(U16 sizeFlag) {
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_SIZE,lp);

   varWidth = sizeof(sizeFlag);

   sizeFlag >>= 1;   // PV use 1,2,4 and MP use 0,1,2 as BYTE, WORD, LONG
   //if (sizeFlag == 2) sizeFlag = 1; **MICEpack-306 doesn't support dword access

   SaveVar(sizeFlag,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetAccessSize(U16 *sizeFlag) {
RETCODE status;
U16 result;
int lp=0;

   SaveId(GET_SIZE,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) result = inputStream[3]; /* 0, 1, 2 */
   if (result == 0) /* 0 -> 1, 1 -> 2, 2 -> 4 */
      *sizeFlag = 1;
   else
      *sizeFlag = result*2;

   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetStatus(VOID) {
   return(GOOD);
}
/*
RETCODE status;
int lp;

   lp = 0;
   SaveId(GET_STAT,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceSetReady(U16 readyFlag) {
   return(GOOD);
}
/*
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_READY,lp);

   varWidth = sizeof(readyFlag);
   SaveVar(readyFlag,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}
*/

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetReady(U16 *readyFlag) {
   *readyFlag = 0;
   return(GOOD);
}
/*
RETCODE status;
int lp=0;

   SaveId(GET_READY,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) *readyFlag = inputStream[3];
   return(status);
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceSetControl(U16 signals) {
   return(GOOD);
}
/*
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_CONTROL,lp);

   varWidth = sizeof(signals);
   SaveVar(signals,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetControl(U16 *signals) {
   *signals = 0;
   return(GOOD);
}
/*
int lp=0;
RETCODE status;

   SaveId(GET_CONTROL,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) _fmemcpy(signals,&inputStream[3],inputStream[2]);
   return(status);
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetMode(U16 *modeFlag) {
   *modeFlag = 0;
   return(GOOD);
}
/*
int lp;
RETCODE status;

   lp = 0;
   SaveId(GET_MODE,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if ((U16)status == ICE_OK) *modeFlag = inputStream[3];
//   if (status == ICE_OK) _fmemcpy(modeFlag,&inputStream[3],inputStream[2]);
   return(status);
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetSync(U16 syncFlag) {
   return(GOOD);
}
/*
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_SYNC,lp);

   varWidth = sizeof(syncFlag);
   SaveVar(syncFlag,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetSync(U16 *sync) {
   *sync = 0;
   return(GOOD);
}
/*
int lp=0;
RETCODE status;

   SaveId(GET_SYNC,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if (status == ICE_OK) *sync = inputStream[3];
   return(status);
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetVerify(U16 verifyFlag) {
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_VERIFY,lp);

   varWidth = sizeof(verifyFlag);
   SaveVar(verifyFlag,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetVerify(U16 *verifyFlag) {
int lp=0;
RETCODE status;

   SaveId(GET_VERIFY,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if (status == ICE_OK) *verifyFlag = inputStream[3];
   return(status);
}

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetWait(U16 count) {
   return(GOOD);
}
/*
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_WAIT,lp);

   varWidth = sizeof(count);
   SaveVar(count,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*((U16 *)&inputStream[0]));
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceGetWait(U16 *count) {
   *count = 1;
   return(GOOD);
}
/*
int lp=0;
RETCODE status;

   SaveId(GET_WAIT,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if (status == ICE_OK) *count = inputStream[3];
   return(status);
}
*/

/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/
RETCODE EXPORT iceSetID(U16 idFlag) {
   return(GOOD);
}
/*
RETCODE status;
int lp=0;
U16 varWidth;

   SaveId(SET_ID,lp);

   varWidth = sizeof(idFlag);
   SaveVar(idFlag,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   return(*(U16 *)&inputStream[0]);
}
*/
/**************************************************************************
**
** Name :
**
** Function
**
**    Input  :
**
**    Output :
**
** Notes:
**
**************************************************************************/

RETCODE EXPORT iceGetID(U8 *ID_Info) {
int lp=0;
RETCODE status;

   SaveId(GET_ID,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   if (status == ICE_REC_TIME_OUT) return(status);
   status = *((U16 *)&inputStream[0]);
   if (status == ICE_OK) _fmemcpy(ID_Info,&inputStream[3],inputStream[2]);  // kkk
   return(status);
}

RETCODE EXPORT iceEnableSwBkpt(VOID) {
int lp=0;
RETCODE status;

   SaveId(ENABLE_SW_BKPT,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   return(status);
}
RETCODE EXPORT iceDisableSwBkpt(VOID) {
int lp=0;
RETCODE status;

   SaveId(DISABLE_SW_BKPT,lp);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   return(status);
}
RETCODE EXPORT iceSetBkptCode(BKPT_OP_68K code) {
int lp=0;
RETCODE status;
U16   varWidth;

   SaveId(SET_BKPT_CODE,lp);
   varWidth = sizeof(BKPT_OP_68K);
   SaveVar(code,lp,varWidth);

   outputStream[lp++] = 0;

   SendStream(outputStream,lp);
   status = ReceiveStream(inputStream,&inputStreamLen,BASE_TIME);
   return(status);
}
/**************************** End of File **********************************/
