/****************************************************************************
**
**  Name:  ERR.C
**
**  Description:
**      Error message strings for ELF/Dwarf loader.  Entries correspond
**      to error #defines in err.h.
**
**  Status:  CODED
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CLISRV_
#include "clisrv.h"
#endif

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef __LDR__
#include "ldr.h"
#endif

#ifndef __VERSION__
#include "version.h"
#endif

#ifndef __ERR__
#include "err.h"
#endif

#ifndef _HLPENTRY_
#include "hlpentry.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/
/* Note that indiscriminate use of 'char *' type parameters will have
   different effects depending on the memory model used to build this.
   I am assuming Compact model (char * becomes LPSTR).
*/

extern HANDLE cliServerHandle;
extern HANDLE dllServerHandle;
extern BOOL runMode;  /* batch vs. interactive */
extern BOOL reportedLoadAbort; /* synchronize progress handler */
extern U16 ldrwarn;
extern U16 reportOn;
extern U16 reportWarning;

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/
STATIC CHAR infoString[255] = "";  /* status information */

CHAR *infomsg[] = {
   "Load complete.",
   "bytes code loaded.",
   "module(s) loaded."
};

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/
/******************************************************************************
**
**  Warning
**
******************************************************************************/
VOID Warning(RETCODE ret) {

   /* Report ret if ret is a warning and reportWarning flag is TRUE */
   if (!reportWarning && ((ret & E_SEVERITY_MASK) == E_WARNING))
      return;
   /* lets let errtext server determine run mode and report appropriately */
   ErrDisplayError(ret, CHECK_MODE);
   if (ret == ER_LOAD_ABORT) {
      reportedLoadAbort = TRUE;
   }
   /* Put up hourglass for loader to continue */
   SetCursor(LoadCursor(NULL, IDC_WAIT)); 
}  /* Warning */

/******************************************************************************
**
**  Query
**
******************************************************************************/
U16 Query(RETCODE ret) {
   S16 status;

   ErrDisplayErrorEx(ret, CHECK_MODE, MB_OKCANCEL | MB_ICONQUESTION,
       (S16 FAR *)&status);
   /* Put up hourglass for loader to continue */
   SetCursor(LoadCursor(NULL, IDC_WAIT)); 

   if (status == IDOK)
      return (QOK);
   else if (status == IDCANCEL)
      return (QCANCEL);

   /* default action is to abort the load process */
   return (QCANCEL);
}  /* Query */

/******************************************************************************
**
** InfoMsg
**
******************************************************************************/
VOID InfoMsg(CHAR *s) {
   if (!reportOn)
      return;
   if (runMode == BATCH)
      SendMessageToCLI(s);
}  /* InfoMsg */

/******************************************************************************
**
**  SendMessageToCLI
**
******************************************************************************/
S16 SendMessageToCLI(CHAR *s) {
   GLOBALHANDLE hmsgBuf;
   CSERVER_RESULTS FAR *lpmsgBuf;
   U16 msgLength;
   U32 err;
   LOOP_VAR i;

   /*
   ** Send (not Post, we don't want them to get queued) text message to CLI.
   ** Used when running in BATCH mode.
   */
   msgLength = lstrlen(s);
   /* note that global allocation is required */
   /* also, we need to allocate for string buffer here */
   if ((hmsgBuf = GlobalAlloc(GHND, sizeof(CSERVER_RESULTS)+msgLength+1))
         == NULL) {
      /* return proper err code */
      return (-1);
   }
   lpmsgBuf = (CSERVER_RESULTS FAR *)GlobalLock(hmsgBuf);
   lpmsgBuf->target = 0;  /* !!! CLI: not yet def'ed */
   lpmsgBuf->variantCode = CLI_SERVER_RESULTS;  /* !!! CLI: not yet def'ed */
   lpmsgBuf->resultTextLength = msgLength;
   /* we've already allocated for buffer */
   for (i=0; i<msgLength; i++)
      lpmsgBuf->messageText[i] = *s++;
   lpmsgBuf->messageText[i] = '\0'; /* NULL terminate string */
   /* Send resultant message to CLI */
   err = SendMessage(cliServerHandle, CLI_SERVER_RESULTS, hmsgBuf,
	   (DWORD)CLI_SERVER_RESULTS);
   return (err);
}  /* SendMessageToCLI */

/******************************************************************************
**
**  InitInfostring
**
******************************************************************************/
VOID InitInfostring(VOID) {
   /* In case the previous load exited with a partially constructed info
   ** buffer (as with user-abort), we need to clear for each load
   */
   infoString[0] = '\0';
}  /* InitInfostring */

/******************************************************************************
**
**  WarningEx
**
******************************************************************************/
VOID WarningEx(RETCODE ret, LPSTR infoStr) {
   /* Report ret if ret is a warning and reportWarning flag is TRUE */
   if (!reportWarning && ((ret & E_SEVERITY_MASK) == E_WARNING))
      return;
   ErrDisplayString(ret,(LPSTR) infoStr, CHECK_MODE);
   /* Put up hourglass for loader to continue */
   SetCursor(LoadCursor(NULL, IDC_WAIT)); 
}  /* WarningEx */

/*********************************** E O F ***********************************/
