/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the SERVERS.DLL
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcppc/cpu/libmain.c_v  $
** 
**    Rev 1.0   17 Jan 1997 09:12:12   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 11:16:56   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:10:44   gene
** Initial revision.
** 
**    Rev 1.7   30 Jun 1993 10:22:34   steveh
** Changed CPU_NO to NO_CPU
** 
**    Rev 1.6   31 Mar 1993 13:40:16   ernie
** Changed logic around call to InitCpuServer() to display error box
** only if the error is not type ER_CPU_NO_CONFIG_FILE.  In this case,
** the box was displayed in BuildTables(), using ErrDisplayString so
** that the filename can be part of the error message.
** 
**    Rev 1.5   30 Mar 1993 14:36:50   ernie
** Changed name of init call to InitCpuServer(), added .h file
** 
**    Rev 1.4   31 Jul 1992 12:46:44   doug
** init server is now local to this module and not accessible outside.  Use
** local prototype (cheat since no .h file!).
** 
**    Rev 1.3   31 Jul 1992 11:35:08   mindy
** Each server needs to initialize itself in libMain
** 
**    Rev 1.2   14 May 1992 14:48:02   nghia
** Added ErrInitDLL() to initialize ErrorText interface.
** 
**    Rev 1.1   08 Apr 1992 10:46:58   nghia
** No change.
** 
**    Rev 1.0   28 Feb 1992 11:55:46   nghia
** Initial revision.
** 
**  $Header:   S:/tbird/arcppc/cpu/libmain.c_v   1.0   17 Jan 1997 09:12:12   kevin  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _CPUCLI_
#include "cpucli.h"
#endif

#ifndef _CPUERR_
#include "cpuerr.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif


/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
/* Handle of the DLL instance */
HANDLE hLib;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the SERVERS.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
    RETCODE err;
    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    /* initialize successfully */
    hLib = hInstance;
    ErrInitDLL(MODULE_CPU, "cpu.dll");
    err = InitCpuServer();
    if ((err != GOOD) && (err != ER_NO_CPU_CONFIG_FILE))
         /* ER_CPU_NO_CONFIG_FILE error is displayed earlier. */
       ErrDisplayError(err, FORCE_POPUP);
    return(err==GOOD);
}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**	Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
void FAR PASCAL WEP(int nParam) {

   switch(nParam) {
      case WEP_SYSTEMEXIT:
         /* System shutdown in progress. Respond accordingly */
         break;
      case WEP_FREE_DLL:
         /* The DLL use count is 0 */
         break;
      default:
         /* Undefined value - ignore */
         break;
   }
   return(TRUE);
}
#endif

/******************************** E O F ***********************************/
