/***************************************************************************
**
**    Name:    daddef.h
**
**
**    $Header:   S:/tbird/arcppc/dasm/asmdef.h_v   1.0   11 Mar 1997 14:21:42   cjchen  $
*/

#define _DAD_DEFINE_


                        /********************
                        **                 **
                        **  Includes       **
                        **                 **
                        ********************/
/*
typedef unsigned char  U8;
typedef signed   char  S8;
typedef unsigned short U16;
typedef signed   short S16;
typedef unsigned long  U32;
typedef signed   long  S32;
typedef signed   int   LOOP_VAR;
*/
                        /**********************
                        **                   **
                        **  Definitions      **
                        **                   **
                        **********************/
#define rA              1 /* GRP, 5 bits */
#define frA             2 /* FPR, 5 bits */
#define crbA            3 /* specify a bit in the CR, 5 bits */
#define crfD            4 /* specify one of the CR or FPSCR, 3 bits */
#define UVA1            5 /* 1 bits for L */
#define UVA4            6 /* 4 bits for IMM, SR */
#define UVA5            7 /* 5 bits for BI, BO, MB, ME, NB, SH, TO */
#define UVA6            8 /* 6 bits for sh, mb, me */
#define UVA8            9 /* 8 bits for CRM, FM */
#define UVA10          10 /* 10 bits for SPR, TBR */
#define SVA14          11 /* 14 bits for BD, ds */
#define UVA16          12 /* 16 bits for UIMM */
#define SVA16          13 /* 16 bits for d, SIMM */
#define SVA24          14 /* 24 bits for LI */

#define B5             40 /* 5 bits for operand position */
#define RB5            41 /* 5 bits for change position after */
#define ZR             42 /* 5 bits with zero */
#define crfDZZ         43 /* 5 bits for crfD and 2 zeros */
#define crfDZL         44 /* 5 bits for crfD, zero and L */
#define ZSR            45 /* 5 bits for zero and SR */
#define ZUB8Z          46 /* 10 bits for zero, CRM(or FM) and zero */
#define UB10           47 /* 10 bits for spr( or tbr) */
#define UB4Z           48 /* 5 bits for IMM and zero */
#define SB24           49 /* 24 bits for LI */
#define SB16           50 /* 16 bits for d, SIMM */
#define UB16           51 /* 16 bits for UIMM */
#define SB14           52 /* 14 bits for BD, ds */
#define UB6sh          53 /* 6 bits for sh */
#define UB6            54 /* 6 bits for mb (or me) */
#define RZUB8Z         55 /* 10 bits for CMR */
#define RUB10          56 /* 10 bits for spr */


#define OE_BIT         21
#define RC_BIT         31
#define AA_BIT         30
#define LK_BIT         31

#define VEA       0  /*00*/
#define UISA      1  /*01*/
#define OEA       2  /*10*/
#define UISA_OEA  3  /*11*/

#define MAX_MNEMONIC_SIZE  11

typedef struct Operator{
  U8 Mnemonic[MAX_MNEMONIC_SIZE+1];
  U8 ArchLevel,SuperLevel;
  U8 Operand[5][30]; 
  S32 OperandValue[5];
  U16 OpType;
  U8 CpuType;
  U32 ObjCode;
}OPERATOR;
 
typedef struct operand {
   U8 OperandType[5];
}OPERANDTYPE;

typedef struct operandpos {
   U8 OperandPos[5]; 
}OPERANDPOS;

typedef struct Inst {
   U8 Mnemonic[MAX_MNEMONIC_SIZE+1],OpCode;
   U16 Xo;
   U8 OperandType;
   U8 OperandPos;
   U8 OE,RC,AA,LK;
   U8 ArchLevel,SuperLevel,CPU;
}INSTRUCTION;


