/***************************************************************************
**
**    Name:    daddef.h
**
**    Description:
**        Internal definitions for the DAD server.
**
**    $Log:   S:/tbird/arcppc/dasm/daddef.h_v  $
** 
**    Rev 1.1   18 Jul 1997 17:57:26   cjchen
** 
**    Rev 1.0   11 Mar 1997 14:21:42   cjchen
** Initial revision.
** 
**    Rev 1.0   04 Mar 1997 09:36:38   cjchen
** Initial revision.
** 
**    Rev 1.0   27 Feb 1997 09:08:10   cjchen
** Initial revision.
** 
**    Rev 1.4   21 Jun 1996 17:00:50   gene
** 
**    Rev 1.3   13 Jun 1996 14:37:20   gene
** 
**    Rev 1.2   06 Jun 1996 15:33:34   gene
** 
**    Rev 1.1   06 Jun 1996 15:28:08   gene
** remove checkdasminst prototype
** 
**    Rev 1.0   03 Jun 1996 11:20:16   gene
** Initial revision.
** 
**    Rev 1.1   12 Mar 1996 10:23:54   gene
** changed to large model and modified operator structure
** 
**    Rev 1.0   07 Sep 1995 10:16:42   gene
** Initial revision.
** 
**    Rev 1.14   22 Jul 1993 10:15:30   ernie
** (For Mindy):  Added support for dequeuer backup
** 
**    Rev 1.13   15 Jul 1993 16:57:18   ernie
** Made constants unsigned
** 
**    Rev 1.12   13 Jul 1993 19:25:28   doug
** Errors consolidated in errtext/mkerrors.h
** 
**    Rev 1.11   13 Jul 1993 09:26:54   ernie
** Added prototype for new function GetDasmInstNoAlloc()
** 
**    Rev 1.10   09 Jun 1993 09:00:10   ernie
** Added call member to DASM_INFO and prototype for IsTransfer()
** 
**    Rev 1.9   06 Jan 1993 17:38:14   marilyn
** Added define for MAX_INST_PER_BUFFER of 250.
** 
**    Rev 1.8   05 Jan 1993 15:57:32   courtney
** Removed MemAlloc and related macros, for consistency with other servers.
** 
**    Rev 1.7   16 Dec 1992 15:35:18   mindy
** moved dq to fw
** 
**    Rev 1.6   16 Oct 1992 15:12:36   john
** increased asm/dasm table to handle dc.w for asm
** 
**    Rev 1.5   15 Oct 1992 10:35:48   john
** bumped max number of insts because some were added to 68030.tbl
** 
**    Rev 1.4   14 Oct 1992 15:09:56   john
** increased buffer size
** 
**    Rev 1.3   13 Oct 1992 11:26:42   ernie
** Changed def of DqInsts to get rid of warning
** 
**    Rev 1.2   19 Aug 1992 09:17:44   marilyn
** Added error codes
** 
**    Rev 1.1   05 Aug 1992 10:38:32   marilyn
** Added another error message.
** 
**    Rev 1.0   31 Jul 1992 14:43:24   marilyn
** Initial revision.
** 
**    Rev 1.9   17 Jul 1992 09:37:02   marilyn
** Added prototypes.
** 
**    Rev 1.8   10 Jul 1992 17:20:54   marilyn
** Added additonal prototypes.
** 
**    Rev 1.7   23 Jun 1992 16:31:36   marilyn
** Added prototypes.
**
**    $Header:   S:/tbird/arcppc/dasm/daddef.h_v   1.1   18 Jul 1997 17:57:26   cjchen  $
*/

#define _DAD_DEFINE_


                        /********************
                        **                 **
                        **  Includes       **
                        **                 **
                        ********************/

#ifndef __STRING_H_
#include <string.h>
#endif

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _BASETYPE_
#include "basetype.h"
#endif

#ifndef _DAD_SERVER_
#include "dasm.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#ifndef _DQ306_
#include "dq306.h"
#endif


                        /**********************
                        **                   **
                        **  Definitions      **
                        **                   **
                        **********************/
// new definition for 603e
#define SP              0
#define sh              1
#define rD              2
#define rA              3
#define rB              4
#define ZR              5
#define NB	        6
#define crfDZZ          7
#define crfSZZ          8
#define crfDZL          9
#define frD             10
#define frA             11
#define frB             12
#define frC             13
#define ZSR             14
#define crbD            15
#define crbA            16
#define crbB            17
#define SIMM            18
#define UIMM            19
#define LI              20
#define rS              21
#define BO              22
#define BI              23
#define BD              24
#define Dis             25
#define Ds              26
#define ME              27
#define MB	        28
#define me              29
#define mb              30
#define TO              31
#define spr             32
#define CRM             33
#define tbr             34
#define FM              35
#define IMM             36
#define SH              37
#define RS              38
#define fRS             39

#define I         1
#define B         2
#define SC        3
#define D         4
#define DS        5
#define X         6
#define XFX       7
#define XFL       8
#define XS        9
#define XO        10
#define A         11
#define M         12
#define MD        13
#define MDS       14
#define XL        15

#define VEA       0  /*00*/
#define UISA      1  /*01*/
#define OEA       2  /*10*/
#define UISA_OEA  3  /*11*/

#define MAX_MNEMONIC_SIZE  11
// end of new definition

#define UNSIZED         0
#define TB              1
#define TW              2
#define TL              4
#define TQ              8
#define TS              16
#define TD              32
#define TX              64
#define TP              128
#define TWL             6
#define TBW             3
#define TBWL            7
#define TBWLSDXP        247
#define TWLQ            14
#define LINE            0x10

#define MAX_MNEMONIC_SIZE  11
#define MAX_CODE_LENGTH    11
#define MAX_NUM_INST       275
#define MAX_NUM_CO_INST    123
#define MAX_INST_PER_LINE  6     /* bytes */
#define MAX_LINE_LENGTH    256u   /* bytes */
#define MAX_INST_PER_BUFFER 250u  /* max insts per 64KB buffer */
#define MAX_LINE_PER_INST  3
#define MAX_OPSTRING       256
#define MAX_OPERAND        30

#define FULL_EXTENSION  0x0100
#define BRIEF_EXTENSION 0x0000

/*
typedef struct operator {
   U8       mnemonic[MAX_MNEMONIC_SIZE+1], !! content operand size
            opStringStorage[MAX_OPSTRING], !! content symbol
            FAR *opString,
            operandStorage[MAX_OPERAND],
            FAR *operand,
            size[2],
            eaType,
            ea1Type,
            ea2Type,
            eaPos,
            cpuType,
            opLength;
   BOOLEAN  symbol;
   U16      objCode[MAX_CODE_LENGTH];
} OPERATOR;


typedef struct ea {
   U16    AdrMode;
   U16    AdrReg; !! high nibble : start register no.
}EA;              !!  low nibble :   end register no.

typedef struct instruction {
   U8     Mnemonic[MAX_MNEMONIC_SIZE+1],
          OpSize,
          OpType,
          EaType,
          EaPos,
          CpuType,

          readCycle,  !! Add three field for data alignment. allen 3.14.94
          writeCycle,
          instCycle;
}INSTRUCTION;
*/
// new code for 603e
typedef struct Operator{
  U8 Mnemonic[MAX_MNEMONIC_SIZE+1];
  U8 ArchLevel,SuperLevel;
  U8 Operand1[30],Operand2[30],Operand3[30];
  U8 Operand4[30],Operand5[30];
  S32 OperandValue[5];
  U16 OpType;
  U8 CpuType;
  U32 ObjCode;
  U32 targetAddr;
}OPERATOR;
 
typedef struct operand {
   U8 Operand1,Operand2,Operand3;
   U8 Operand4,Operand5;
}OPERANDTYPE;

typedef struct Inst {
   U8 Mnemonic[MAX_MNEMONIC_SIZE+1],OpCode;
   U16 Xo;
   BOOLEAN Transfer,Conditional,KnowAddr;
   U8 ArchLevel,SuperLevel;
   U8 Formate;
   U16 Index;
}INSTRUCTION;

typedef struct ds_form{
   U8  Mnemonic[MAX_MNEMONIC_SIZE+1];
   U16 OpType;
   U8  CpuType;
} DS_FORM,XFX_FORM;

typedef struct a_form{
   U8  Mnemonic[MAX_MNEMONIC_SIZE+1],RC;
   U16 OpType;
   U8  CpuType;
}A_FORM,XFL_FORM,MDS_FORM,MD_FORM,M_FORM,SC_FORM,XS_FORM;

typedef struct i_form{
   U8  Mnemonic[MAX_MNEMONIC_SIZE+1], AA_LK;
   U16 OpType;
   U8  CpuType;
}I_FORM;

typedef struct xl_form{
   U8  Mnemonic[MAX_MNEMONIC_SIZE+1];
   U8  LK;
   U16 OpType;
   U8  CpuType;
}XL_FORM;

typedef struct b_form{
   U8  Mnemonic[MAX_MNEMONIC_SIZE+1];
   U8  AA_LK;
   U16 OpType;
   U8  CpuType;
}B_FORM;

typedef struct d_form{
   U8  Mnemonic[MAX_MNEMONIC_SIZE+1];
   U8  LVal;
   U16 OpType;
   U8  CpuType;
} D_FORM;

typedef struct x_form{
   U8  Mnemonic[MAX_MNEMONIC_SIZE+1];
   U8  LVal;
   U8  RC;
   U16 OpType;
   U8  CpuType;
}X_FORM;

typedef struct xo_form{
   U8  Mnemonic[MAX_MNEMONIC_SIZE+1];
   U16 OE_RC;
   U16 OpType;
   U8  CpuType;
}XO_FORM;
// new code , end

typedef enum{
   NORMAL_INST,
   MODIFY_SR,
   BRANCH,
   TRAP,
   ILLEGAL,
   RETURN,
   TRANSFER_INST,
   SW_INT, // find wwwrr seq. cycles
   HW_INT  // fine wAwwrr seq. cycles
}INST_TYPE;

typedef struct {
   BOOLEAN transfer;                        /* control transfer instruction */
   BOOLEAN conditional;                 /* conditional transfer instruction */
   BOOLEAN returnType;                      /* return type with pc on stack */
   BOOLEAN knowAddr;                          /* exact target address known */
   U32 target    ;                    /* Target address of control transfer */
   BOOLEAN flushableInst;    /* instruction will cause an instruction flush */
   BOOLEAN bkptInst;            /* Is instruction a breakpoint instruction? */
   BOOLEAN call;                              /* instruction is a call type */

   INST_TYPE instType;
   U8 bytesUsed,      // instruction length         /* Number of bytes used */
      readCycle,      // Add three field for data alignment. allen 3.14.94
      writeCycle,
      instCycle;
} DASM_INFO;


                      /********************
                      **                 **
                      **   Macros        **
                      **                 **
                      ********************/

#define ctoi(c)  ( ((U8)(c) > 0x39) ?  ((U8)((c) - 'a') + 10) : ((U8)((c) - '0')) )  /* Char to Dec */
#define htoc(i)  ((U8)((i) + '0'))  /* Hex to Char, only 0 - 7 */

#define MY_ATOL(value, string) \
   {    CHAR FAR * ptr; \
        U16 temp; \
        value = 0; \
        ptr = string; \
        while (*ptr) { \
           temp = ((U16)*ptr) - 0x30; \
           if ((temp > 9) || (temp < 0)) { \
              value = -2; \
              break; \
           } else { \
              value = (value * 10) + temp; \
           } \
           ++ ptr; \
        } \
   }


                    /**************************
                    **                       **
                    **   Prototypes          **
                    **                       **
                    **************************/


RETCODE TraceBufInst(U32 addrOffset, BOOLEAN DadSymbol,
                  U8 *inst, DASM_INFO FAR *dasmInfo,ADDR_SPACE addrSpace);

RETCODE IsCallOrRTS(DESCRIPTOR StartAddr, DESCRIPTOR calledAddr,
                    CALL_TYPE FAR *type);

RETCODE GetDasmInst(DESCRIPTOR startAddr, U16 numInst, LPSTR *buffer, 
                    BOOLEAN DasmSymbol);

RETCODE GetDasmInstNoAlloc(DESCRIPTOR startAddr, LPSTR buffer, 
                    BOOLEAN DasmSymbol);

RETCODE GetDasmInstByLine(DESCRIPTOR startAddr, U16 FAR *lines, LPSTR *buffer,
                    BOOLEAN DasmSymbol);

S8      FindString(U8 Count, U8 **Source, U8 FAR *Search);

RETCODE FreeDasmCache(VOID);

RETCODE AsmInst(OPERATOR FAR *OpSet, LPSTR inInst, LPSTR *outInst,
                LPWORD numBytes, DESCRIPTOR startAddr);

RETCODE DqInsts(DQ_STATE FAR *dqState, S32 numInst,LPSTR buffer);

//RETCODE GetBits(U16 Value, U8 BitStart,U8 Length);

RETCODE DummyGetAsmLine(LPSTR buffer);

RETCODE InitOpSet(OPERATOR FAR *opSet,BOOLEAN symbols);

RETCODE SendCliMessage(HANDLE cliHandle, LPSTR msgPtr);

VOID GetStartEndFrame(S32 FAR *starting, S32 FAR *ending);
/*********************************** E O F ***********************************/
