/****************************************************************************
**
**  Name:  libmain.c
**
**  Description:
**     Contains the main entry/exit point of the ENLIB.DLL
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcppc/enlib/libmain.c_v  $
** 
**    Rev 1.0   17 Jan 1997 09:13:12   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 11:21:38   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:18:32   gene
** Initial revision.
** 
**    Rev 1.2   14 May 1992 11:56:26   mindy
** added call to register dasm with error server
** 
**    Rev 1.1   06 Nov 1991 11:31:10   doug
** prototype must match declaration in windows.h since _export was added
** to EXPORT.
** 
**    Rev 1.0   06 Nov 1991 11:17:00   doug
** Initial revision.
** 
**  $Header:   S:/tbird/arcppc/enlib/libmain.c_v   1.0   17 Jan 1997 09:13:12   kevin  $
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

/* Define symbol to exclude the WEP routine */
#define _BORLANDC_
                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

/* Handle of the DLL instance */
HANDLE hLib;

                        /****************************
                         *                          *
                         *    EXTERNAL VARIABLES    *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/

                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

/**************************************************************************
**
** LibMain
**
** Description: Main entry point of the ENLIB.DLL
**
**	Parameters:
**    input:
**       hInstance:     Handle of the library instance
**       wDataSeg:      Value of Data Segment register
**       cbHeapSize:    Heap Size of the heap defined in the DEF
**       lpszCmdLine:   Command Line information (rarely used)
**
**    output:
**
***************************************************************************/
#pragma argsused
int FAR PASCAL LibMain(HANDLE hInstance, WORD wDataSeg, WORD cbHeapSize,
    LPSTR lpszCmdLine) {
    /* the LIBENTRY initializes the local heap by calling LocalInit() and
       then calls LibMain.  The LocalInit() locks the data segment of the
       library when initialize; therefore LibMain needs to unlock */
    if (cbHeapSize != 0) /* the DLL Data segment is MOVEABLE */
       UnlockData(0);

    /* initialize successfully */
    hLib = hInstance;
    ErrInitDLL(MODULE_ENLIB,"enlib.dll");
    return(TRUE);
}

#ifndef _BORLANDC_
/**************************************************************************
**
** WEP {Windows Exit Procedure}
**
** Description: DLL exit procedure to perform cleanup for the DLL before it
**              is unloaded. - not to be used with BC++ compiler.
**
**	Parameters:
**    input:
**       nParam:     Message to indicate whether all of Windows is shutting
**                   down or just the DLL itself.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
void FAR PASCAL WEP(int nParam) {

   switch(nParam) {
      case WEP_SYSTEMEXIT:
         /* System shutdown in progress. Respond accordingly */
         break;
      case WEP_FREE_DLL:
         /* The DLL use count is 0 */
         break;
      default:
         /* Undefined value - ignore */
         break;
   }
   return(TRUE);
}
#endif

/******************************** E O F ***********************************/
