/****************************************************************************
**
**  Name:  mkerrors.h
**
**  Description:
**     This is the ONLY file to change in order to add or change error
**     definitions in PowerViews.  This file is the source for several
**     other files, which are automatically produced by mkerrors.exe.
**     The generated files are:
**       actor\res\errcodea.h : error code defines in Actor format
**       inc\errcodec.h : error code defines in C format
**       errtext\errerr.h : error code offsets in the errtext.rc file
**       errtext\errtext.rc : string resources (error text)
**       errtext\errhelp.map : help [MAP] codes for the pwrviews.hpj file
**       errtext\mkerrors.new : the next version of THIS header file
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcppc/errtext/mkerrors.h_v  $
** 
**    Rev 1.6   05 Jan 1998 14:54:54   kevin
** modified "invalid code" message
** 
**    Rev 1.5   05 Nov 1997 12:15:20   kevin
** changed contents of some error code.
** 
**    Rev 1.4   26 Sep 1997 15:31:38   kevin
** 
**    Rev 1.3   28 Aug 1997 17:23:06   cjchen
** 
**    Rev 1.2   28 Aug 1997 10:17:50   cjchen
** 
**    Rev 1.1   07 Aug 1997 17:38:20   cjchen
** 
**    Rev 1.0   15 Jan 1997 15:51:50   kevin
** Initial revision.
** 
**    Rev 1.0   15 Jan 1997 15:19:44   kevin
** Initial revision.
** 
**    Rev 1.2   17 Oct 1996 17:57:38   gene
** modify TARGET_RESET and NO_VCC error message
** 
**    Rev 1.1   26 Jul 1996 08:31:08   gene
** modify ER_RESET_OCCURED error code for TARGET_RESET
** 
**    Rev 1.0   03 Jun 1996 11:23:06   gene
** Initial revision.
** 
**    Rev 1.6   30 Nov 1995 16:33:36   kevin
** back to version 1.4
** 
**    Rev 1.4   23 Nov 1995 10:39:32   kevin
** replaced some messages
** 
**    Rev 1.3   20 Nov 1995 10:17:10   kevin
** added ROM and NONE violation break msg
** 
**    Rev 1.2   16 Nov 1995 14:39:58   kevin
** added No emm memory msg
** 
**    Rev 1.1   18 Oct 1995 10:10:52   kevin
** modified INPUT_OVERRUN
** 
**    Rev 1.0   07 Sep 1995 10:22:54   gene
** Initial revision.
** 
**    Rev 1.52   05 May 1994 11:02:54   ernie
** Added 2 new firmware errors
** 
**    Rev 1.51   23 Apr 1994 07:51:44   ernie
** Added ER_RESET_STUCK.
** 
**    Rev 1.50   21 Apr 1994 11:43:10   nghia
** Revised Peripheral error to report CFG file name.
** 
**    Rev 1.49   07 Apr 1994 10:27:12   nghia
** Fixed incorrect message for checking register index.
** WhiteSmith tool (HC16) violates the IEEE695 ATN9 record format.
** 
**    Rev 1.48   06 Apr 1994 11:02:20   tom
** Corrected spelling and capitalization errors; not vital for 2.2.
** 
**    Rev 1.47   30 Mar 1994 18:32:34   STEVE
** HE_TARGET_FLOAT didn't match error -> help translation.
** 
**    Rev 1.46   30 Mar 1994 16:13:58   ernie
** Added 386 errors and a new trace firmware error.
** 
**    Rev 1.45   30 Mar 1994 15:49:34   tom
** Fixed some misspellings.
** 
**    Rev 1.44   25 Mar 1994 11:34:14   marilyn
** Put back 2 adress errors removed unused peri errors.
** 
**    Rev 1.43   24 Mar 1994 09:27:14   ernie
** Added ER_SAVECS_MBAR_INVALID
** 
**    Rev 1.42   23 Mar 1994 16:37:02   tom
** Added error for incompatible PV/network versions.
** 
**    Rev 1.41   21 Mar 1994 11:39:14   marilyn
** Added just one more address error.
** 
**    Rev 1.40   17 Mar 1994 17:48:24   marilyn
** Take some out and put some in.
** 
**    Rev 1.39   17 Mar 1994 14:20:58   marilyn
** Added some more address errors, removed several old unused ones.
** 
**    Rev 1.37   11 Mar 1994 11:03:32   marilyn
** Added ER_PRC_OPER_INCOMPAT error.
** 
**    Rev 1.36   10 Mar 1994 15:34:54   marilyn
** Removed duplicate address error.
** 
**    Rev 1.35   03 Mar 1994 10:56:48   john
** Added pod version error code
** 
**    Rev 1.34   01 Mar 1994 14:06:18   tom
** Inability to get host info should be a warning, not fatal error.
** 
**    Rev 1.33   01 Mar 1994 10:56:50   marilyn
** Added some more address errors.
** 
**    Rev 1.32   01 Mar 1994 10:51:54   marilyn
** Added new errors for updated address server.
** 
**    Rev 1.31   01 Mar 1994 09:32:16   tom
** Added OS/2 LAN Server error code.
** 
**    Rev 1.30   14 Jan 1994 17:30:54   tom
** Multiple memory window changes.
** 
**    Rev 1.29   03 Jan 1994 14:31:12   mindy
** needed to change warning level on ipipe error
** 
**    Rev 1.28   23 Dec 1993 11:17:40   mindy
** added ipipe error in fw
** 
**    Rev 1.27   20 Dec 1993 16:46:34   tom
** Added network error messages.
** 
**    Rev 1.26   19 Nov 1993 11:44:46   tom
** PPR 9114: corrected error text.
** 
**    Rev 1.25   17 Nov 1993 15:40:52   ron
** clarified invalid base error message
** 
**    Rev 1.24   06 Oct 1993 16:36:26   tom
** 8802, 8929: display memory verify info with memory verify error
** 
**    Rev 1.23   30 Sep 1993 13:21:26   tom
** Updated user abort message text.
**
**    Rev 1.22   28 Sep 1993 15:35:30   ron
** peripheral presenter errors
**
**    Rev 1.21   23 Sep 1993 10:52:46   nghia
** Added 2 new errors: ER_UNKNOWN_FWREF_TYPE and ER_NO_LINEBLK_IN_MODULE.
** Revised some error message to report more information.
**
**    Rev 1.20   23 Aug 1993 10:00:44   nghia
** Removed INTERNAL_ERROR for ER_LINE_EXPT, since data module does not have
** any line number block which makes this error occurs very frequent.
**
**    Rev 1.19   13 Aug 1993 15:37:40   nghia
** Removed INTERNAL_ERROR for CompilerUsed not defined. Common error.
**
**    Rev 1.18   10 Aug 1993 16:56:28   ron
** make "Address addition overflowed" a regular error.
**
**    Rev 1.17   10 Aug 1993 14:34:14   ron
** changed ER_SYM_SYM_NOT_SHARP to a non-internal error (it comes up all the
** time if someone doesn't start a symbol with a #).
**
**    Rev 1.16   05 Aug 1993 17:01:12   nghia
** Added ER_SRC_MODULE_HAS_NO_ADDR_RANGE to support data module warning.
** Revised message for ER_SYM_NO_MODULES_LOADED (has nothing to do with line
** number sorted).
**
**    Rev 1.15   04 Aug 1993 14:41:08   ron
** changed ER_SRC_FIND_ADDRESS to E_FATAL (*should* not happen any more).
**
**    Rev 1.14   30 Jul 1993 15:15:56   nghia
** Remove INTERNAL_ERROR for 2 errors in Source window that might happen without
** any serious consequences.
**
**    Rev 1.13   30 Jul 1993 13:55:44   ron
** Nghia found an error (ER_BAD_REG_INDEX) with a stupid error message.  Now say
** Loader register index is invalid.
**
**    Rev 1.12   29 Jul 1993 08:21:56   ron
** Courtney says: "No symbols are loaded." (ER_SYMBOL_NOT_A_MODULE) should
** not be an INTERNAL error.  Removed internal flag.
**
**    Rev 1.11   28 Jul 1993 19:43:02   courtney
** Added text for ER_CANNOT_ADD_ASM_MOD.
**
**    Rev 1.10   28 Jul 1993 16:13:36   ron
** fiddled with INTERNAL flags based on comments from John, Nghia, and
** Courtney.  Also changed error text based on notes from Nghia and Courtney.
**
**    Rev 1.9   28 Jul 1993 15:22:22   nghia
** Revised ER_SYMBASE to E_FATAL instead of internal error.
** Revised LOADFILE_HAD_INCOMPATIBLE_TOOLCHAIN message for continue loading.
**
**    Rev 1.8   28 Jul 1993 14:44:28   ron
** toggle internal flag on two more errors (sheesh).
**
**    Rev 1.7   28 Jul 1993 13:38:04   ron
** removed INTERNAL flag from 5 more errors
**
**    Rev 1.6   28 Jul 1993 11:28:30   john
** Changed error text for system clock dialog.
** Changed error text for HighWaterMark warning.
**
**    Rev 1.5   28 Jul 1993 07:55:14   ron
** pprs 8687,8674: remove INTERNAL flag from ER_SYM_TYPE and
** ER_TABLE_SMALLER_THAN_INDEX
**
**    Rev 1.4   27 Jul 1993 22:26:38   nghia
** Revised error message for INCOMPATIBLE_TOOLCHAIN.
**
**    Rev 1.3   27 Jul 1993 21:16:10   marilyn
** Revised ER_STK_FILL_STACK_AREA error to be more like an informational message
** which the user can cancel the operation on.
**
**    Rev 1.2   27 Jul 1993 20:20:06   nghia
** Revised error messages:
** - Failed to initialize stack area for HighWaterMark.
** - Stack Area too large/small -> stack area specified is out of range, adjust
**   size.
** - Added new error message ER_LOADFILE_HAD_INCOMPATIBLE_TOOLCHAIN.
**
**    Rev 1.1   27 Jul 1993 09:49:38   ron
** ppr8654: C++ duplicate name shouldn't be internal error
**
**    Rev 1.0   27 Jul 1993 09:01:50   ron
** Initial revision.
**
**  $Header:   S:/tbird/arcppc/errtext/mkerrors.h_v   1.6   05 Jan 1998 14:54:54   kevin  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _MKERRORS_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _VRTXERRS_
#include "vrtxerrs.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
  /* Must match flash\public\error.h */
#define WW_ (0x004FL + 0x0037L + 100 + 0x40000000L)
#define ER_VRTX_BASE (0x004FL + 100 + 0x40000000L)

/*
 * Here are all the error codes for all the error types in PowerViews
 * The corresponding error text is in errtext\errtext.rc.
 * 
 * ONLY MAKE CHANGES BELOW THIS LINE (in mkerrors.h)
 */
{
   "ERR_ASSIGN_VEC0",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 419L ),
   "HER_ASSIGN_VEC0",
   "HER_ASSIGN_VEC0",
   LOCKED
},
{
   "ERR_ASSIGN_VEC23",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 418L ),
   "HER_ASSIGN_VEC23",
   "HER_ASSIGN_VEC23",
   LOCKED
},
{
   "ERR_BAD",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 361L ),
   "HER_BAD",
   "HER_BAD",
   LOCKED
},
{
   "ERR_BAD_BASE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 350L ),
   "HER_BAD_BASE",
   "HER_BAD_BASE",
   LOCKED
},
{
   "ERR_BAD_DATA_PORT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 402L ),
   "HER_BAD_DATA_PORT",
   "HER_BAD_DATA_PORT",
   LOCKED
},
{
   "ERR_BAD_DEV_INFO",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 375L ),
   "HER_BAD_DEV_INFO",
   "HER_BAD_DEV_INFO",
   LOCKED
},
{
   "ERR_BAD_MEMORY",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 399L ),
   "HER_BAD_MEMORY",
   "HER_BAD_MEMORY",
   LOCKED
},
{
   "ERR_BAD_PROBE_DATA",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 379L ),
   "HER_BAD_PROBE_DATA",
   "HER_BAD_PROBE_DATA",
   LOCKED
},
{
   "ERR_BAD_REFRESH_MEM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 411L ),
   "HER_BAD_REFRESH_MEM",
   "HER_BAD_REFRESH_MEM",
   LOCKED
},
{
   "ERR_BAD_SD_DATA",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 388L ),
   "HER_BAD_SD_DATA",
   "HER_BAD_SD_DATA",
   LOCKED
},
{
   "ERR_BAD_TEST",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 374L ),
   "HER_BAD_TEST",
   "HER_BAD_TEST",
   LOCKED
},
{
   "ERR_BAD_TIMER1",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 410L ),
   "HER_BAD_TIMER1",
   "HER_BAD_TIMER1",
   LOCKED
},
{
   "ERR_BAD_TRACE_DATA",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 387L ),
   "HER_BAD_TRACE_DATA",
   "HER_BAD_TRACE_DATA",
   LOCKED
},
{
   "ERR_BAD_TRIG_TYPE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 394L ),
   "HER_BAD_TRIG_TYPE",
   "HER_BAD_TRIG_TYPE",
   LOCKED
},
{
   "ERR_CP_BOOT_EPROM_CHKSM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 403L ),
   "HER_CP_BOOT_EPROM_CHKSM",
   "HER_CP_BOOT_EPROM_CHKSM",
   LOCKED
},
{
   "ERR_CP_FLASH_PROM_CHKSM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 404L ),
   "HER_CP_FLASH_PROM_CHKSM",
   "HER_CP_FLASH_PROM_CHKSM",
   LOCKED
},
{
   "ERR_CP_MEM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 415L ),
   "HER_CP_MEM",
   "HER_CP_MEM",
   LOCKED
},
{
   "ERR_EMPTY_SYM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 365L ),
   "HER_EMPTY_SYM",
   "HER_EMPTY_SYM",
   LOCKED
},
{
   "ERR_FILL_ALWAYS_ON",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 391L ),
   "HER_FILL_ALWAYS_ON",
   "HER_FILL_ALWAYS_ON",
   LOCKED
},
{
   "ERR_INT_NOT_ON",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 413L ),
   "HER_INT_NOT_ON",
   "HER_INT_NOT_ON",
   LOCKED
},
{
   "ERR_INT_ON",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 414L ),
   "HER_INT_ON",
   "HER_INT_ON",
   LOCKED
},
{
   "ERR_INVALID_BOARD_TYPE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 396L ),
   "HER_INVALID_BOARD_TYPE",
   "HER_INVALID_BOARD_TYPE",
   LOCKED
},
{
   "ERR_INVALID_CHAR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 353L ),
   "HER_INVALID_CHAR",
   "HER_INVALID_CHAR",
   LOCKED
},
{
   "ERR_INVALID_CMD",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 376L ),
   "HER_INVALID_CMD",
   "HER_INVALID_CMD",
   LOCKED
},
{
   "ERR_INVALID_LOOPING",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 373L ),
   "HER_INVALID_LOOPING",
   "HER_INVALID_LOOPING",
   LOCKED
},
{
   "ERR_INVALID_MASK",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 351L ),
   "HER_INVALID_MASK",
   "HER_INVALID_MASK",
   LOCKED
},
{
   "ERR_INVALID_NUM_TRCBUF",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 385L ),
   "HER_INVALID_NUM_TRCBUF",
   "HER_INVALID_NUM_TRCBUF",
   LOCKED
},
{
   "ERR_INVALID_PORT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 371L ),
   "HER_INVALID_PORT",
   "HER_INVALID_PORT",
   LOCKED
},
{
   "ERR_INVALID_PROBE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 377L ),
   "HER_INVALID_PROBE",
   "HER_INVALID_PROBE",
   LOCKED
},
{
   "ERR_INVALID_SIZE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 384L ),
   "HER_INVALID_SIZE",
   "HER_INVALID_SIZE",
   LOCKED
},
{
   "ERR_IN_CP_PORT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 400L ),
   "HER_IN_CP_PORT",
   "HER_IN_CP_PORT",
   LOCKED
},
{
   "ERR_MISSING_QUOTE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 352L ),
   "HER_MISSING_QUOTE",
   "HER_MISSING_QUOTE",
   LOCKED
},
{
   "ERR_NOT_DONE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 395L ),
   "HER_NOT_DONE",
   "HER_NOT_DONE",
   LOCKED
},
{
   "ERR_NOT_TRIG",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 393L ),
   "HER_NOT_TRIG",
   "HER_NOT_TRIG",
   LOCKED
},
{
   "ERR_NO_SOCKET",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 397L ),
   "HER_NO_SOCKET",
   "HER_NO_SOCKET",
   LOCKED
},
{
   "ERR_NO_TIMER2_INT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 412L ),
   "HER_NO_TIMER2_INT",
   "HER_NO_TIMER2_INT",
   LOCKED
},
{
   "ERR_NUMBER_EXCEEDS_SIZE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 368L ),
   "HER_NUMBER_EXCEEDS_SIZE",
   "HER_NUMBER_EXCEEDS_SIZE",
   LOCKED
},
{
   "ERR_ONLY_ONE_RANGE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 366L ),
   "HER_ONLY_ONE_RANGE",
   "HER_ONLY_ONE_RANGE",
   LOCKED
},
{
   "ERR_OUT_CP_PORT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 401L ),
   "HER_OUT_CP_PORT",
   "HER_OUT_CP_PORT",
   LOCKED
},
{
   "ERR_PARSER_STACK_OVERFLOW",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 363L ),
   "HER_PARSER_STACK_OVERFLOW",
   "HER_PARSER_STACK_OVERFLOW",
   LOCKED
},
{
   "ERR_PARSER_SYNTAX",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 354L ),
   "HER_PARSER_SYNTAX",
   "HER_PARSER_SYNTAX",
   LOCKED
},
{
   "ERR_PORT_ALIGN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 370L ),
   "HER_PORT_ALIGN",
   "HER_PORT_ALIGN",
   LOCKED
},
{
   "ERR_PORT_BOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 369L ),
   "HER_PORT_BOUND",
   "HER_PORT_BOUND",
   LOCKED
},
{
   "ERR_POS_STK_ERROR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 359L ),
   "HER_POS_STK_ERROR",
   "HER_POS_STK_ERROR",
   LOCKED
},
{
   "ERR_PROBE_RX_TIMEOUT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 378L ),
   "HER_PROBE_RX_TIMEOUT",
   "HER_PROBE_RX_TIMEOUT",
   LOCKED
},
{
   "ERR_PROGRAM_IS_RUNNING",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 362L ),
   "HER_PROGRAM_IS_RUNNING",
   "HER_PROGRAM_IS_RUNNING",
   LOCKED
},
{
   "ERR_PROGRAM_NOT_RUNNING",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 360L ),
   "HER_PROGRAM_NOT_RUNNING",
   "HER_PROGRAM_NOT_RUNNING",
   LOCKED
},
{
   "ERR_RESET_TMAN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 386L ),
   "HER_RESET_TMAN",
   "HER_RESET_TMAN",
   LOCKED
},
{
   "ERR_SET_SOCKET",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 398L ),
   "HER_SET_SOCKET",
   "HER_SET_SOCKET",
   LOCKED
},
{
   "ERR_SET_TRACE_ACTION",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 383L ),
   "HER_SET_TRACE_ACTION",
   "HER_SET_TRACE_ACTION",
   LOCKED
},
{
   "ERR_STACK_OVERFLOW",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 357L ),
   "HER_STACK_OVERFLOW",
   "HER_STACK_OVERFLOW",
   LOCKED
},
{
   "ERR_STACK_UNDERFLOW",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 356L ),
   "HER_STACK_UNDERFLOW",
   "HER_STACK_UNDERFLOW",
   LOCKED
},
{
   "ERR_SYM_REDEFINED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 364L ),
   "HER_SYM_REDEFINED",
   "HER_SYM_REDEFINED",
   LOCKED
},
{
   "ERR_TIMER2_INT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 417L ),
   "HER_TIMER2_INT",
   "HER_TIMER2_INT",
   LOCKED
},
{
   "ERR_TOO_MANY_DATA_ITEMS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 367L ),
   "HER_TOO_MANY_DATA_ITEMS",
   "HER_TOO_MANY_DATA_ITEMS",
   LOCKED
},
{
   "ERR_TRCBUF_FILL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 392L ),
   "HER_TRCBUF_FILL",
   "HER_TRCBUF_FILL",
   LOCKED
},
{
   "ERR_TRCBUF_NOT_FILL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 381L ),
   "HER_TRCBUF_NOT_FILL",
   "HER_TRCBUF_NOT_FILL",
   LOCKED
},
{
   "ERR_TRCBUF_NOT_INC",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 382L ),
   "HER_TRCBUF_NOT_INC",
   "HER_TRCBUF_NOT_INC",
   LOCKED
},
{
   "ERR_TRIC_WR_DATA",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 380L ),
   "HER_TRIC_WR_DATA",
   "HER_TRIC_WR_DATA",
   LOCKED
},
{
   "ERR_TRIG_POS_CYCLE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 389L ),
   "HER_TRIG_POS_CYCLE",
   "HER_TRIG_POS_CYCLE",
   LOCKED
},
{
   "ERR_TRIG_POS_SBUFF",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 390L ),
   "HER_TRIG_POS_SBUFF",
   "HER_TRIG_POS_SBUFF",
   LOCKED
},
{
   "ERR_UART_BAD_DATA",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 408L ),
   "HER_UART_BAD_DATA",
   "HER_UART_BAD_DATA",
   LOCKED
},
{
   "ERR_UART_BAD_LS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 406L ),
   "HER_UART_BAD_LS",
   "HER_UART_BAD_LS",
   LOCKED
},
{
   "ERR_UART_INT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 416L ),
   "HER_UART_INT",
   "HER_UART_INT",
   LOCKED
},
{
   "ERR_UART_RCVR_EMPTY",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 407L ),
   "HER_UART_RCVR_EMPTY",
   "HER_UART_RCVR_EMPTY",
   LOCKED
},
{
   "ERR_UART_RCVR_TIMEOUT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 409L ),
   "HER_UART_RCVR_TIMEOUT",
   "HER_UART_RCVR_TIMEOUT",
   LOCKED
},
{
   "ERR_UART_XMIT_NOT_EMPTY",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 405L ),
   "HER_UART_XMIT_NOT_EMPTY",
   "HER_UART_XMIT_NOT_EMPTY",
   LOCKED
},
{
   "ERR_UNLEX_STACK_OVERFLOW",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 355L ),
   "HER_UNLEX_STACK_OVERFLOW",
   "HER_UNLEX_STACK_OVERFLOW",
   LOCKED
},
{
   "ERR_VAR_REDEFINED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 358L ),
   "HER_VAR_REDEFINED",
   "HER_VAR_REDEFINED",
   LOCKED
},
{
   "ER_ABORT_FROM_ESC",
   ( 0L | 501L ),
   "Command aborted.",
   "HE_ABORT_FROM_ESC",
   UNLOCKED
},
{
   "ER_ABORT_SESSION",
   ( E_SEVERE | 0L | 14L ),
   "Session terminated.",
   "HE_ABORT_SESSION",
   LOCKED
},
{
   "ER_ADDRESS_MISSING",
   ( E_WARNING | 0L | 502L ),
   "%s address missing.",
   "HE_ADDRESS_MISSING",
   UNLOCKED
},
{
   "ER_ADDRESS_NOT_FOUND",
   ( E_WARNING | 0L | 503L ),
   "Cannot find address in symbol table.",
   "HE_ADDRESS_NOT_FOUND",
   UNLOCKED
},
{
   "ER_ADDRESS_UPDATED",
   ( E_WARNING | 0L | 504L ),
   "Public symbol updated.",
   "HE_ADDRESS_UPDATED",
   UNLOCKED
},
{
   "ER_ADDR_ODD_ADDRESS",
   ( E_WARNING | 0L | 505L ),
   "Address cannot start on an odd boundary.",
   "HE_ADDR_ODD_ADDRESS",
   UNLOCKED
},
{
   "ER_ADDR_TYPE_NOT_ACCEPTED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 506L ),
   "Invalid address format.",
   "HE_ADDR_TYPE_NOT_ACCEPTED",
   UNLOCKED
},
{
   "ER_ADR_ADDRESS_TOO_LARGE",
   ( E_WARNING | 0L | 507L ),
   "Address is larger than the target processor's maximum address.",
   "HE_ADR_ADDRESS_TOO_LARGE",
   UNLOCKED
},
{
   "ER_ADR_END_ADDR_TOO_SMALL",
   ( E_WARNING | 0L | 510L ),
   "Cannot set end address smaller than start address.",
   "HE_ADR_END_ADDR_TOO_SMALL",
   UNLOCKED
},
{
   "ER_ADR_INVALID_ADDRESS_STR",
   ( E_WARNING | 0L | 511L ),
   "Invalid address text string.",
   "HE_ADR_INVALID_ADDRESS_STR",
   UNLOCKED
},
{
   "ER_ADR_INVALID_DESCRIPTOR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 512L ),
   "Address descriptor is zero/null.",
   "HE_ADR_INVALID_DESCRIPTOR",
   UNLOCKED
},
{
   "ER_ADR_INVALID_PTR_SIZE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 513L ),
   "Invalid pointer size when fetching pointer's address.",
   "HE_ADR_INVALID_PTR_SIZE",
   UNLOCKED
},
{
   "ER_ADR_NOT_MOTOROLA_USAGE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 515L ),
   "Address operation is not compatible with a Motorola processor.",
   "HE_ADR_NOT_MOTOROLA_USAGE",
   UNLOCKED
},
{
   "ER_ADR_NOT_RANGE_TYPE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 516L ),
   "Address is not a range.",
   "HE_ADR_NOT_RANGE_TYPE",
   UNLOCKED
},
{
   "ER_ADR_RESULT_OVERFLOW",
   ( E_WARNING | 0L | 517L ),
   "Address addition overflowed.",
   "HE_ADR_RESULT_OVERFLOW",
   UNLOCKED
},
{
   "ER_ADR_RESULT_UNDERFLOW",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 518L ),
   "Address subtraction underflowed.",
   "HE_ADR_RESULT_UNDERFLOW",
   UNLOCKED
},
{
   "ER_ANO_TEXT_PARSE_FIELD",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 521L ),
   "Malformed text field encountered during annotated text parsing.",
   "HE_ANO_TEXT_PARSE_FIELD",
   UNLOCKED
},
{
   "ER_ANO_TEXT_PARSE_SPECIAL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 522L ),
   "Malformed special field encountered during annotated text parsing.",
   "HE_ANO_TEXT_PARSE_SPECIAL",
   UNLOCKED
},
{
   "ER_ARGS_NEED_SYM",
   ( INTERNAL_ERROR_ON | 0L | 523L ),
   "ER_ARGS_NEED_SYM.",
   "HE_ARGS_NEED_SYM",
   UNLOCKED
},
{
   "ER_ARRAY_INDEX_TOO_LARGE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 524L ),
   "Attempt to get a structure or union element larger than the structure or union.",
   "HE_ARRAY_INDEX_TOO_LARGE",
   UNLOCKED
},
{
   "ER_ATN_EXPT",
   ( E_WARNING | 0L | 525L ),
   "Expected ATN record type.",
   "HE_ATN_EXPT",
   UNLOCKED
},
{
   "ER_ATN_NOT_HANDLED",
   ( E_WARNING | 0L | 526L ),
   "Unrecognized miscellaneous record skipped.",
   "HE_ATN_NOT_HANDLED",
   UNLOCKED
},
{
   "ER_ATTR_NOT_HANDLED",
   ( E_WARNING | 0L | 527L ),
   "Attribute type not supported: ",
   "HE_ATTR_NOT_HANDLED",
   UNLOCKED
},
{
   "ER_BADGET",
   ( 0L | 528L ),
   "Cannot read file.",
   "HE_BADGET",
   UNLOCKED
},
{
   "ER_BADID",
   ( E_WARNING | 0L | 529L ),
   "Invalid or unsupported ID.",
   "HE_BADID",
   UNLOCKED
},
{
   "ER_BADMODULE",
   ( 0L | 530L ),
   "Invalid module id.",
   "HE_BADMODULE",
   UNLOCKED
},
{
   "ER_BAD_ATI_RECORD_IN_FILE",
   ( E_WARNING | 0L | 531L ),
   "Bad ATI record in loadfile.",
   "HE_BAD_ATI_RECORD_IN_FILE",
   UNLOCKED
},
{
   "ER_BAD_CMD_TYPE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 259L ),
   "ER_BAD_CMD_TYPE.",
   "HE_BAD_CMD_TYPE",
   LOCKED
},
{
   "ER_BAD_COMM_STATE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 261L ),
   "Unrecognized data arriving.",
   "HE_BAD_COMM_STATE",
   LOCKED
},
{
   "ER_BAD_COUNTER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 532L ),
   "Invalid counter.",
   "HE_BAD_COUNTER",
   UNLOCKED
},
{
   "ER_BAD_EVENT",
   ( E_WARNING | 0L | 533L ),
   "Invalid trigger event index.",
   "HE_BAD_EVENT",
   UNLOCKED
},
{
   "ER_BAD_FIELD_NUMBER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 534L ),
   "Field number greater than maximum.",
   "HE_BAD_FIELD_NUMBER",
   UNLOCKED
},
{
   "ER_BAD_FILE",
   ( E_WARNING | 0L | 535L ),
   "Corrupted file.",
   "HE_BAD_FILE",
   UNLOCKED
},
{
   "ER_BAD_FREE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 536L ),
   "Cannot free memory.",
   "HE_BAD_FREE",
   UNLOCKED
},
{
   "ER_BAD_HDR",
   ( E_WARNING | 0L | 537L ),
   "Invalid 695 file header.",
   "HE_BAD_HDR",
   UNLOCKED
},
{
   "ER_BAD_LNUM_BLOCK_IN_FILE",
   ( E_WARNING | 0L | 538L ),
   "Invalid line number block in file.",
   "HE_BAD_LNUM_BLOCK_IN_FILE",
   UNLOCKED
},
{
   "ER_BAD_NEST",
   ( E_WARNING | 0L | 539L ),
   "Nested block is not a procedure.",
   "HE_BAD_NEST",
   UNLOCKED
},
{
   "ER_BAD_PART",
   ( E_WARNING | 0L | 540L ),
   "Invalid part of file.",
   "HE_BAD_PART",
   UNLOCKED
},
{
   "ER_BAD_REG_INDEX",
   ( E_WARNING | 0L | 541L ),
   "Loadfile contains invalid register index.",
   "HE_BAD_REG_INDEX",
   UNLOCKED
},
{
   "ER_BAD_SECREC",
   ( E_WARNING | 0L | 542L ),
   "Invalid section record.",
   "HE_BAD_SECREC",
   UNLOCKED
},
{
   "ER_BAD_SEEK",
   ( E_WARNING | 0L | 543L ),
   "Cannot seek load file.",
   "HE_BAD_SEEK",
   UNLOCKED
},
{
   "ER_BAD_UNREGISTER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 544L ),
   "Cannot unregister the code buffers.",
   "HE_BAD_UNREGISTER",
   UNLOCKED
},
{
   "ER_BAUDRATE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 545L ),
   "Unsupported baud rate.",
   "HE_BAUDRATE",
   UNLOCKED
},
{
   "ER_BBFUNCTION_EXPT",
   ( E_WARNING | 0L | 546L ),
   "Expected begin-block function record.",
   "HE_BBFUNCTION_EXPT",
   UNLOCKED
},
{
   "ER_BDM_PACKET_OVERFLOW",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 298L ),
   "BDM packet overflow.",
   "HE_BDM_PACKET_OVERFLOW",
   LOCKED
},
{
   "ER_BDM_RESULT_OVERFLOW",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 299L ),
   "Not used.",
   "HE_BDM_RESULT_OVERFLOW",
   LOCKED
},
{
   "ER_BKPT_CANT_ADD",
   ( INTERNAL_ERROR_ON | E_FATAL | 0L | 547L ),
   "Cannot add breakpoint to list.",
   "HE_BKPT_CANT_ADD",
   UNLOCKED
},
{
   "ER_BKPT_CANT_REGISTER",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 548L ),
   "Cannot register events for Breakpoint.",
   "HE_BKPT_CANT_REGISTER",
   UNLOCKED
},
{
   "ER_BKPT_MEM_FAIL",
   ( E_FATAL | 0L | 549L ),
   "No memory available to store breakpoints.",
   "HE_BKPT_MEM_FAIL",
   UNLOCKED
},
{
   "ER_BKPT_NONE_AVAILABLE",
   ( E_WARNING | 0L | 550L ),
   "No breakpoint available.",
   "HE_BKPT_NONE_AVAILABLE",
   UNLOCKED
},
{
   "ER_BKPT_NONE_SELECTED",
   ( E_WARNING | 0L | 551L ),
   "No breakpoint selected: %s.",
   "HE_BKPT_NONE_SELECTED",
   UNLOCKED
},
{
   "ER_BKPT_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 307L ),
   "The breakpoint id is not in list.",
   "HE_BKPT_NOT_FOUND",
   LOCKED
},
{
   "ER_BKPT_NO_WINDOW",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 552L ),
   "Cannot open window for Breakpoint.",
   "HE_BKPT_NO_WINDOW",
   UNLOCKED
},
{
   "ER_BK_EMULATOR_MUST_BE_HALTED",
   ( E_WARNING | 0L | 553L ),
   "The emulator must be halted before performing this operation.",
   "HE_BK_EMULATOR_MUST_BE_HALTED",
   UNLOCKED
},
{
   "ER_BLOCK_ALREADY_MAPPED",
   ( E_WARNING | 0L | 554L ),
   "Address range already mapped.",
   "HE_BLOCK_ALREADY_MAPPED",
   UNLOCKED
},
{
   "ER_BLOCK_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 555L ),
   "Map block not found.",
   "HE_BLOCK_NOT_FOUND",
   UNLOCKED
},
{
   "ER_BLOCK_OUT_OF_RANGE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 556L ),
   "Map block out of range.",
   "HE_BLOCK_OUT_OF_RANGE",
   UNLOCKED
},
{
   "ER_BLOCK_TOO_LARGE",
   ( E_WARNING | 0L | 557L ),
   "Map block too large.",
   "HE_BLOCK_TOO_LARGE",
   UNLOCKED
},
{
   "ER_BLOCK_UNMAPPABLE",
   ( E_WARNING | 0L | 558L ),
   "Map block cannot be mapped.",
   "HE_BLOCK_UNMAPPABLE",
   UNLOCKED
},
{
   "ER_BREAK",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 295L ),
   "Packet terminated normally.",
   "HE_BREAK",
   LOCKED
},
{
   "ER_BUF",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 186L ),
   "The buffer is full.",
   "HE_BUF",
   LOCKED
},
{
   "ER_BUS_ERROR",
   ( E_WARNING | 0L | 300L ),
   "Bus error occurred during memory cycle.",
   "HE_BUS_ERROR",
   LOCKED
},
{
   "ER_BUS_TIMEOUT",
   ( E_WARNING | 0L | 302L ),
   "Unterminated memory cycle; internal termination failed.  Reset processor to recover.",
   "HE_BUS_TIMEOUT",
   LOCKED
},
{
   "ER_BX_ALREADY_HAS_BKPT",
   ( E_WARNING | 0L | 559L ),
   "Breakpoint already set at: ",
   "HE_BX_ALREADY_HAS_BKPT",
   UNLOCKED
},
{
   "ER_BX_ASMGRANULARITY_INVALID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 560L ),
   "Asm granularity is not allowed in source step.",
   "HE_BX_ASMGRANULARITY_INVALID",
   UNLOCKED
},
{
   "ER_BX_BKPT_LESSTHAN_FUNC",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 561L ),
   "The breakpoint address is less than the function start address.",
   "HE_BX_BKPT_LESSTHAN_FUNC",
   UNLOCKED
},
{
   "ER_BX_EMU_IS_HALTED",
   ( E_INFORMATIVE | 0L | 562L ),
   "The emulator is halted.",
   "HE_BX_EMU_IS_HALTED",
   UNLOCKED
},
{
   "ER_BX_ID_TOO_BIG",
   ( E_WARNING | 0L | 563L ),
   "Exceeded the maximum breakpoint ID value.",
   "HE_BX_ID_TOO_BIG",
   UNLOCKED
},
{
   "ER_BX_INACTIVE_BKPT",
   ( E_WARNING | 0L | 564L ),
   "No breakpoint matches the specified ID.",
   "HE_BX_INACTIVE_BKPT",
   UNLOCKED
},
{
   "ER_BX_INVALID_CALLBACK",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 565L ),
   "Invalid event callback value.",
   "HE_BX_INVALID_CALLBACK",
   UNLOCKED
},
{
   "ER_BX_INVALID_COUNT",
   ( E_WARNING | 0L | 566L ),
   "Step count cannot be zero.",
   "HE_BX_INVALID_COUNT",
   UNLOCKED
},
{
   "ER_BX_INVALID_DESCRIPTOR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 567L ),
   "Invalid breakpoint descriptor.",
   "HE_BX_INVALID_DESCRIPTOR",
   UNLOCKED
},
{
   "ER_BX_LOOP_COMPLETE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 568L ),
   "End of loop reached.",
   "HE_BX_LOOP_COMPLETE",
   UNLOCKED
},
{
   "ER_BX_NOT_ON_INST_BOUNDARY",
   ( E_WARNING | 0L | 569L ),
   "Breakpoint address not on an instruction boundary; breakpoint not set.",
   "HE_BX_NOT_ON_INST_BOUNDARY",
   UNLOCKED
},
{
   "ER_BX_NO_BKPT_AVAILABLE",
   ( E_WARNING | 0L | 570L ),
   "All available breakpoints are assigned.",
   "HE_BX_NO_BKPT_AVAILABLE",
   UNLOCKED
},
{
   "ER_BX_NO_BKPT_MATCH_ADDR",
   ( E_WARNING | 0L | 571L ),
   "No breakpoint matches the specified address.",
   "HE_BX_NO_BKPT_MATCH_ADDR",
   UNLOCKED
},
{
   "ER_BX_NO_CALL_RETURN",
   ( E_WARNING | 0L | 572L ),
   "Current function has no call or return instructions.",
   "HE_BX_NO_CALL_RETURN",
   UNLOCKED
},
{
   "ER_BX_SEND_MESSAGE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 573L ),
   "SendMessage error.",
   "HE_BX_SEND_MESSAGE",
   UNLOCKED
},
{
   "ER_BYADDRTABLE_EMPTY",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 574L ),
   "Line numbers cannot be loaded; invalid load state.",
   "HE_BYADDRTABLE_EMPTY",
   UNLOCKED
},
{
   "ER_BYTESIZE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 575L ),
   "Invalid character length.",
   "HE_BYTESIZE",
   UNLOCKED
},
{
   "ER_CANNOT_ADD_ASM_MOD",
   ( INTERNAL_ERROR_ON | 0L | 576L ),
   "Cannot add assembly module to symbol table: ",
   "HE_CANNOT_ADD_ASM_MOD",
   UNLOCKED
},
{
   "ER_CANNOT_ADD_FUNC",
   ( E_WARNING | 0L | 577L ),
   "Cannot add function symbol to symbol table; local symbols will be lost: ",
   "HE_CANNOT_ADD_FUNC",
   UNLOCKED
},
{
   "ER_CANNOT_ADD_MOD",
   ( E_WARNING | 0L | 578L ),
   "Cannot add module to symbol table: ",
   "HE_CANNOT_ADD_MOD",
   UNLOCKED
},
{
   "ER_CANNOT_ADD_PUBLIC",
   ( E_WARNING | 0L | 579L ),
   "Cannot add public symbol to symbol table: ",
   "HE_CANNOT_ADD_PUBLIC",
   UNLOCKED
},
{
   "ER_CANNOT_ADD_SYM",
   ( E_WARNING | 0L | 580L ),
   "Cannot add symbol to symbol table: ",
   "HE_CANNOT_ADD_SYM",
   UNLOCKED
},
{
   "ER_CANNOT_FIND_PFILE",
   ( E_WARNING | 0L | 581L ),
   "Cannot find initialization file.",
   "HE_CANNOT_FIND_PFILE",
   UNLOCKED
},
{
   "ER_CANNOT_FIND_WDIR",
   ( E_WARNING | 0L | 582L ),
   "Cannot find Windows directory.",
   "HE_CANNOT_FIND_WDIR",
   UNLOCKED
},
{
   "ER_CANNOT_GET_TOOL_NAME",
   ( E_WARNING | 0L | 583L ),
   "Cannot get compiler defined in initialization file.",
   "HE_CANNOT_GET_TOOL_NAME",
   UNLOCKED
},
{
   "ER_CANNOT_OPEN",
   ( E_WARNING | 0L | 584L ),
   "Cannot open load file.",
   "HE_CANNOT_OPEN",
   UNLOCKED
},
{
   "ER_CANNOT_WRITE_TO_FILE",
   ( E_WARNING | 0L | 585L ),
   "Cannot write to initialization file.",
   "HE_CANNOT_WRITE_TO_FILE",
   UNLOCKED
},
{
   "ER_CANT_CLOSE_FILE",
   ( E_WARNING | 0L | 586L ),
   "Cannot close file.",
   "HE_CANT_CLOSE_FILE",
   UNLOCKED
},
{
   "ER_CANT_CONV_TEXT",
   ( E_WARNING | 0L | 587L ),
   "Cannot convert text to a value.",
   "HE_CANT_CONV_TEXT",
   UNLOCKED
},
{
   "ER_CANT_DISPLAY_BUF",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 588L ),
   "Cannot display empty text buffer.  Reposition the ScrollBox to correct the problem.",
   "HE_CANT_DISPLAY_BUF",
   UNLOCKED
},
{
   "ER_CANT_DO_COMMAND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 589L ),
   "Cannot do command: %s.",
   "HE_CANT_DO_COMMAND",
   UNLOCKED
},
{
   "ER_CANT_GET_SIZE",
   ( E_WARNING | 0L | 590L ),
   "Cannot get total bytes in file.",
   "HE_CANT_GET_SIZE",
   UNLOCKED
},
{
   "ER_CANT_GET_STACK_DIR",
   ( INTERNAL_ERROR_ON | E_FATAL | 0L | 591L ),
   "Cannot get stack grow direction.  Close the Stack Window to reset.",
   "HE_CANT_GET_STACK_DIR",
   UNLOCKED
},
{
   "ER_CANT_INIT_PROBE",
   ( E_SEVERE | 0L | 17L ),
   "Cannot initialize probe.",
   "HE_CANT_INIT_PROBE",
   LOCKED
},
{
   "ER_CANT_LOAD_BITMAP",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 592L ),
   "Cannot load bitmap.",
   "HE_CANT_LOAD_BITMAP",
   UNLOCKED
},
{
   "ER_CANT_OPEN_FILE",
   ( E_WARNING | 0L | 593L ),
   "Cannot open file.",
   "HE_CANT_OPEN_FILE",
   UNLOCKED
},
{
   "ER_CANT_OPEN_SOURCE_FILE",
   ( E_WARNING | 0L | 594L ),
   "Unable to open source file %s",
   "HE_CANT_OPEN_SOURCE_FILE",
   UNLOCKED
},
{
   "ER_CANT_OPEN_TEMPLATE_FILE",
   ( E_WARNING | 0L | 595L ),
   "Cannot open configuration file.",
   "HE_CANT_OPEN_TEMPLATE_FILE",
   UNLOCKED
},
{
   "ER_CANT_OPEN_UNIX_FILE",
   ( E_WARNING | 0L | 596L ),
   "Unable to open UNIX source file.",
   "HE_CANT_OPEN_UNIX_FILE",
   UNLOCKED
},
{
   "ER_CANT_REOPEN_FILE",
   ( E_WARNING | 0L | 597L ),
   "Cannot reopen file.",
   "HE_CANT_REOPEN_FILE",
   UNLOCKED
},
{
   "ER_CANT_REOPEN_MIXED",
   ( E_WARNING | 0L | 598L ),
   "Cannot reopen mixed data source.",
   "HE_CANT_REOPEN_MIXED",
   UNLOCKED
},
{
   "ER_CANT_SCROLL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 599L ),
   "Cannot scroll down.",
   "HE_CANT_SCROLL",
   UNLOCKED
},
{
   "ER_CANT_START_TASK",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 254L ),
   "Failed attempt to create the task.",
   "HE_CANT_START_TASK",
   LOCKED
},
{
   "ER_CAUSE_STATUS",
   ( E_WARNING | 0L | 424L ),
   "BKPT pin was asserted spuriously.",
   "HE_CAUSE_STATUS",
   LOCKED
},
{
   "ER_CLIULIB_BAD_DRIVES_BAT_LINE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 600L ),
   "Incorrectly formed line in nfs/drives.bat file.",
   "HE_CLIULIB_BAD_DRIVES_BAT_LINE",
   UNLOCKED
},
{
   "ER_CLIULIB_CLI_OPEN_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 601L ),
   "File open failed.",
   "HE_CLIULIB_CLI_OPEN_FAILED",
   UNLOCKED
},
{
   "ER_CLIULIB_DIRECTORY_ATTACH_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 602L ),
   "Unable to attach to directory.",
   "HE_CLIULIB_DIRECTORY_ATTACH_FAILED",
   UNLOCKED
},
{
   "ER_CLIULIB_DRIVES_BAT_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 603L ),
   "PC-NFS nfs/drives.bat not found.",
   "HE_CLIULIB_DRIVES_BAT_NOT_FOUND",
   UNLOCKED
},
{
   "ER_CLIULIB_DRIVES_BAT_OPEN_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 604L ),
   "Unable to open nfs/drives.bat file.",
   "HE_CLIULIB_DRIVES_BAT_OPEN_FAILED",
   UNLOCKED
},
{
   "ER_CLIULIB_DRIVES_BAT_READ_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 605L ),
   "Unable to read nfs/drives.bat file.",
   "HE_CLIULIB_DRIVES_BAT_READ_FAILED",
   UNLOCKED
},
{
   "ER_CLIULIB_DRIVE_ATTACH_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 606L ),
   "Unable to attach to PC-NFS drive.",
   "HE_CLIULIB_DRIVE_ATTACH_FAILED",
   UNLOCKED
},
{
   "ER_CLIULIB_ILLEGAL_DRIVE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 607L ),
   "Illegal drive letter.",
   "HE_CLIULIB_ILLEGAL_DRIVE",
   UNLOCKED
},
{
   "ER_CLIULIB_INVALID_INI_NUMBER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 608L ),
   "MICEPACK.INI - %s had an invalid number.",
   "HE_CLIULIB_INVALID_INI_NUMBER",
   UNLOCKED
},
{
   "ER_CLIULIB_PCNFS_NOT_INSTALLED",
   ( E_WARNING | 0L | 609L ),
   "PC-NFS is not installed.",
   "HE_CLIULIB_PCNFS_NOT_INSTALLED",
   UNLOCKED
},
{
   "ER_CLIULIB_PFILE_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 610L ),
   "MICEPACK.INI file not found.",
   "HE_CLIULIB_PFILE_NOT_FOUND",
   UNLOCKED
},
{
   "ER_CLIULIB_PPATH_NOT_AVAIL",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 611L ),
   "Path to MICEPACK.INI file is not available.",
   "HE_CLIULIB_PPATH_NOT_AVAIL",
   UNLOCKED
},
{
   "ER_CLIULIB_UNABLE_TO_READ_PFILE",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 612L ),
   "Unable to read MICEPACK.INI file.",
   "HE_CLIULIB_UNABLE_TO_READ_PFILE",
   UNLOCKED
},
{
   "ER_CLIULIB_UNABLE_TO_WRITE_PFILE",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 613L ),
   "Unable to write MICEPACK.INI file.",
   "HE_CLIULIB_UNABLE_TO_WRITE_PFILE",
   UNLOCKED
},
{
   "ER_CLIULIB_UNIX_DIR_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 614L ),
   "UNIX path name not found.",
   "HE_CLIULIB_UNIX_DIR_NOT_FOUND",
   UNLOCKED
},
{
   "ER_CLIULIB_UNIX_FILE_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 615L ),
   "UNIX file not found.",
   "HE_CLIULIB_UNIX_FILE_NOT_FOUND",
   UNLOCKED
},
{
   "ER_CLIULIB_WDIR_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 616L ),
   "WINDOWS directory not found.",
   "HE_CLIULIB_WDIR_NOT_FOUND",
   UNLOCKED
},
{
   "ER_CLI_ALREADY_RUNNING",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 617L ),
   "Shell server is already running.",
   "HE_CLI_ALREADY_RUNNING",
   UNLOCKED
},
{
   "ER_CLI_BAD_DEC",
   ( E_WARNING | 0L | 618L ),
   "Invalid decimal constant.",
   "HE_CLI_BAD_DEC",
   UNLOCKED
},
{
   "ER_CLI_BAD_HEX",
   ( E_WARNING | 0L | 619L ),
   "Invalid hexadecimal constant.",
   "HE_CLI_BAD_HEX",
   UNLOCKED
},
{
   "ER_CLI_BAD_OCT",
   ( E_WARNING | 0L | 620L ),
   "Invalid octal constant.",
   "HE_CLI_BAD_OCT",
   UNLOCKED
},
{
   "ER_CLI_BAD_SERVER_COMMAND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 621L ),
   "Invalid server command name (%s:%s).",
   "HE_CLI_BAD_SERVER_COMMAND",
   UNLOCKED
},
{
   "ER_CLI_COMMAND_NAME",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 622L ),
   "Command name not found.",
   "HE_CLI_COMMAND_NAME",
   UNLOCKED
},
{
   "ER_CLI_COMMAND_SIZE",
   ( E_WARNING | 0L | 623L ),
   "Command too long: %s.",
   "HE_CLI_COMMAND_SIZE",
   UNLOCKED
},
{
   "ER_CLI_DOING_COMMAND",
   ( E_INFORMATIVE | 0L | 624L ),
   "A command is being executed; hit escape to terminate command.",
   "HE_CLI_DOING_COMMAND",
   UNLOCKED
},
{
   "ER_CLI_DUPLICATE_KEY",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 625L ),
   "Duplicated command: %s.",
   "HE_CLI_DUPLICATE_KEY",
   UNLOCKED
},
{
   "ER_CLI_DUPLICATE_SERVER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 626L ),
   "Duplicated server: %s.",
   "HE_CLI_DUPLICATE_SERVER",
   UNLOCKED
},
{
   "ER_CLI_ENTRY_POINT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 627L ),
   "Entry point not found.",
   "HE_CLI_ENTRY_POINT",
   UNLOCKED
},
{
   "ER_CLI_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 628L ),
   "Shell registration failed.",
   "HE_CLI_FAILED",
   UNLOCKED
},
{
   "ER_CLI_FILE_ACCESS",
   ( E_WARNING | 0L | 629L ),
   "File error: %s failure on %s: access denied.",
   "HE_CLI_FILE_ACCESS",
   UNLOCKED
},
{
   "ER_CLI_FILE_ARG",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 630L ),
   "File error: %s failure on %s: argument error.",
   "HE_CLI_FILE_ARG",
   UNLOCKED
},
{
   "ER_CLI_FILE_CODE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 631L ),
   "File error: %s failure on %s: invalid access code.",
   "HE_CLI_FILE_CODE",
   UNLOCKED
},
{
   "ER_CLI_FILE_DEVICE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 632L ),
   "File error: %s failure on %s: not same device.",
   "HE_CLI_FILE_DEVICE",
   UNLOCKED
},
{
   "ER_CLI_FILE_HANDLE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 633L ),
   "File error: %s failure on %s: invalid handle.",
   "HE_CLI_FILE_HANDLE",
   UNLOCKED
},
{
   "ER_CLI_FILE_NOT_FOUND",
   ( E_WARNING | 0L | 634L ),
   "File error: %s failure on %s: file not found.",
   "HE_CLI_FILE_NOT_FOUND",
   UNLOCKED
},
{
   "ER_CLI_FILE_NUMBER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 635L ),
   "File error: %s failure on %s: error number %s.",
   "HE_CLI_FILE_NUMBER",
   UNLOCKED
},
{
   "ER_CLI_FILE_OPEN_ERR",
   ( E_WARNING | 0L | 636L ),
   "Error opening file: %s.",
   "HE_CLI_FILE_OPEN_ERR",
   UNLOCKED
},
{
   "ER_CLI_FILE_PATH",
   ( E_WARNING | 0L | 637L ),
   "File error: %s failure on %s: path not found.",
   "HE_CLI_FILE_PATH",
   UNLOCKED
},
{
   "ER_CLI_FILE_TOO_MANY",
   ( E_WARNING | 0L | 638L ),
   "File error: %s failure on %s: too many files open.",
   "HE_CLI_FILE_TOO_MANY",
   UNLOCKED
},
{
   "ER_CLI_HISTORY_SIZE",
   ( E_WARNING | 0L | 639L ),
   "History size must be between 0 and 100.",
   "HE_CLI_HISTORY_SIZE",
   UNLOCKED
},
{
   "ER_CLI_INPUT_STACK_OVERFLOW",
   ( E_WARNING | 0L | 640L ),
   "Include file or alias definition nesting limit exceeded.",
   "HE_CLI_INPUT_STACK_OVERFLOW",
   UNLOCKED
},
{
   "ER_CLI_INTERNAL",
   ( INTERNAL_ERROR_ON | E_FATAL | 0L | 641L ),
   "Shell library: %s (%s).",
   "HE_CLI_INTERNAL",
   UNLOCKED
},
{
   "ER_CLI_INTERNAL_ERROR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 642L ),
   "Shell internal error: %s.",
   "HE_CLI_INTERNAL_ERROR",
   UNLOCKED
},
{
   "ER_CLI_LINE_COUNT",
   ( E_WARNING | 0L | 643L ),
   "Statement list too large: %s.",
   "HE_CLI_LINE_COUNT",
   UNLOCKED
},
{
   "ER_CLI_MALFORMED_VARIABLE",
   ( E_WARNING | 0L | 644L ),
   "Invalid variable: %s.",
   "HE_CLI_MALFORMED_VARIABLE",
   UNLOCKED
},
{
   "ER_CLI_NO_HELP",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 645L ),
   "Help text empty.",
   "HE_CLI_NO_HELP",
   UNLOCKED
},
{
   "ER_CLI_NO_SERVER_NAME",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 646L ),
   "Server name not found.",
   "HE_CLI_NO_SERVER_NAME",
   UNLOCKED
},
{
   "ER_CLI_SERVER_REG",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 647L ),
   "Server registration error.",
   "HE_CLI_SERVER_REG",
   UNLOCKED
},
{
   "ER_CLI_SYNTAX",
   ( E_WARNING | 0L | 648L ),
   "Syntax error.",
   "HE_CLI_SYNTAX",
   UNLOCKED
},
{
   "ER_CLI_UNDECL_VAR",
   ( E_WARNING | 0L | 649L ),
   "Undeclared variable: $%s.",
   "HE_CLI_UNDECL_VAR",
   UNLOCKED
},
{
   "ER_CLI_UNREGISTERED_COMMAND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 650L ),
   "Command not registered with server: %s.",
   "HE_CLI_UNREGISTERED_COMMAND",
   UNLOCKED
},
{
   "ER_CLI_UNREGISTERED_SERVER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 651L ),
   "Server not registered with Shell: %s.",
   "HE_CLI_UNREGISTERED_SERVER",
   UNLOCKED
},
{
   "ER_CLI_UNTERM_COMMENT",
   ( E_WARNING | 0L | 652L ),
   "Unterminated comment.",
   "HE_CLI_UNTERM_COMMENT",
   UNLOCKED
},
{
   "ER_CLI_UNTERM_STRING",
   ( E_WARNING | 0L | 653L ),
   "Unterminated string.",
   "HE_CLI_UNTERM_STRING",
   UNLOCKED
},
{
   "ER_CLI_USER_ABORT",
   ( E_WARNING | 0L | 654L ),
   "Command aborted by user.",
   "HE_CLI_USER_ABORT",
   UNLOCKED
},
{
   "ER_CLOSE_SYM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 655L ),
   "Cannot close symbol-load context.",
   "HE_CLOSE_SYM",
   UNLOCKED
},
{
   "ER_CMD_ABORT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 283L ),
   "The command was aborted.",
   "HE_CMD_ABORT",
   LOCKED
},
{
   "ER_CODEBUF_SIZE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 656L ),
   "Code byte count too large.",
   "HE_CODEBUF_SIZE",
   UNLOCKED
},
{
   "ER_CODE_OVF",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 256L ),
   "The attempt to download code will overflow the buffer.",
   "HE_CODE_OVF",
   LOCKED
},
{
   "ER_CODE_STREAM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 657L ),
   "Error loading code.",
   "HE_CODE_STREAM",
   UNLOCKED
},
{
   "ER_COM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 212L ),
   "The component is undefined.",
   "HE_COM",
   LOCKED
},
{
   "ER_COMM_PACKET_TIMEOUT",
   ( E_SEVERE | 0L | 15L ),
   "Communication timeout sending to box.",
   "HE_COMM_PACKET_TIMEOUT",
   LOCKED
},
{
   "ER_COMM_RETRY_EXHAUSTED",
   ( E_WARNING | 0L | 16L ),
   "Excessive errors in communication from host to box.",
   "HE_COMM_RETRY_EXHAUSTED",
   LOCKED
},
{
   "ER_COMM_STATE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 658L ),
   "Cannot get comm state.",
   "HE_COMM_STATE",
   UNLOCKED
},
{
   "ER_COM_BADTIMER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 659L ),
   "Cannot deallocate timer for read timeout.",
   "HE_COM_BADTIMER",
   UNLOCKED
},
{
   "ER_COM_CONFIG",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 9L ),
   "Cannot configure the comm port with the default parameters.",
   "HE_COM_CONFIG",
   LOCKED
},
{
   "ER_COM_FRAME",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 660L ),
   "Serial port framing error.",
   "HE_COM_FRAME",
   UNLOCKED
},
{
   "ER_COM_HWRCV",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 661L ),
   "Hardware receive queue overrun.",
   "HE_COM_HWRCV",
   UNLOCKED
},
{
   "ER_COM_INREAD",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 662L ),
   "Already in read operation.",
   "HE_COM_INREAD",
   UNLOCKED
},
{
   "ER_COM_NOREAD_CALLBACK",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 663L ),
   "Cannot create callback for read timeout.",
   "HE_COM_NOREAD_CALLBACK",
   UNLOCKED
},
{
   "ER_COM_NOREAD_TIMEOUT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 664L ),
   "Cannot install timeout for read.",
   "HE_COM_NOREAD_TIMEOUT",
   UNLOCKED
},
{
   "ER_COM_OPEN",
   ( E_SEVERE | 0L | 7L ),
   "Cannot open the connection.",
   "HE_COM_OPEN",
   LOCKED
},
{
   "ER_COM_RCVOVER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 665L ),
   "Receive queue overflow.",
   "HE_COM_RCVOVER",
   UNLOCKED
},
{
   "ER_COM_READNOTALL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 666L ),
   "No error but not all data received.",
   "HE_COM_READNOTALL",
   UNLOCKED
},
{
   "ER_COM_READTIMEOUT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 667L ),
   "Timeout on read operation.",
   "HE_COM_READTIMEOUT",
   UNLOCKED
},
{
   "ER_COM_TIMEDOUT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 668L ),
   "DSR timeout.",
   "HE_COM_TIMEDOUT",
   UNLOCKED
},
{
   "ER_COM_TXFULL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 669L ),
   "Transmit queue overflowed.",
   "HE_COM_TXFULL",
   UNLOCKED
},
{
   "ER_CONFIG_FILE_FORMAT",
   ( E_WARNING | 0L | 670L ),
   "Loader configuration file corrupted.",
   "HE_CONFIG_FILE_FORMAT",
   UNLOCKED
},
{
   "ER_COPY_ABORT",
   ( E_WARNING | 0L | 442L ),
   "Memory copy aborted.",
   "HE_COPY_ABORT",
   LOCKED
},
{
   "ER_CPP_DUPLICATE",
   ( E_WARNING | 0L | 671L ),
   "C++ duplicate name detected.",
   "HE_CPP_DUPLICATE",
   UNLOCKED
},
{
   "ER_CPP_NOT_SUPPORTED",
   ( E_WARNING | 0L | 672L ),
   "C++ type not handled: mangled names may result.",
   "HE_CPP_NOT_SUPPORTED",
   UNLOCKED
},
{
   "ER_CPU_CANT_BE_ODD",
   ( E_WARNING | 0L | 673L ),
   "Register cannot be set to an odd value.",
   "HE_CPU_CANT_BE_ODD",
   UNLOCKED
},
{
   "ER_CPU_CONFIG_FILE_FORMAT",
   ( E_FATAL | 0L | 674L ),
   "Processor configuration file format error.",
   "HE_CPU_CONFIG_FILE_FORMAT",
   UNLOCKED
},
{
   "ER_CPU_PROC_EM",
   ( E_INFORMATIVE | 0L | 675L ),
   "The target processor is emulating.  Pre-emulation values shown.",
   "HE_CPU_PROC_EM",
   UNLOCKED
},
{
   "ER_CVT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 211L ),
   "The component vector table is missing.",
   "HE_CVT",
   LOCKED
},
{
   "ER_DAD_ASM_ERROR",
   ( E_WARNING | 0L | 676L ),
   "Assembly syntax error.",
   "HE_DAD_ASM_ERROR",
   UNLOCKED
},
{
   "ER_DAD_AT_TOP_OF_MEMORY",
   ( E_WARNING | 0L | 677L ),
   "Dasm at top of memory.",
   "HE_DAD_AT_TOP_OF_MEMORY",
   UNLOCKED
},
{
   "ER_DAD_BAD_MASKED_INST_FORMAT",
   ( E_WARNING | 0L | 678L ),
   "Masked instruction format wrong.",
   "HE_DAD_BAD_MASKED_INST_FORMAT",
   UNLOCKED
},
{
   "ER_DAD_BAD_NUM_PARM",
   ( E_WARNING | 0L | 679L ),
   "Invalid number of parameters.",
   "HE_DAD_BAD_NUM_PARM",
   UNLOCKED
},
{
   "ER_DAD_BOGUS_ADDRESS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 680L ),
   "Invalid address descriptor.",
   "HE_DAD_BOGUS_ADDRESS",
   UNLOCKED
},
{
   "ER_DAD_DISPLACEMENT_INVALID",
   ( E_WARNING | 0L | 681L ),
   "Invalid displacement.",
   "HE_DAD_DISPLACEMENT_INVALID",
   UNLOCKED
},
{
   "ER_DAD_EA_INVALID",
   ( E_WARNING | 0L | 682L ),
   "Invalid effective address.",
   "HE_DAD_EA_INVALID",
   UNLOCKED
},
{
   "ER_DAD_IMMED_FIELD_INCORRECT",
   ( E_WARNING | 0L | 683L ),
   "Immediate value incorrectly given.",
   "HE_DAD_IMMED_FIELD_INCORRECT",
   UNLOCKED
},
{
   "ER_DAD_INCORRECT_DISP",
   ( E_WARNING | 0L | 684L ),
   "Bad displacement.",
   "HE_DAD_INCORRECT_DISP",
   UNLOCKED
},
{
   "ER_DAD_INST_NOT_FOUND",
   ( E_WARNING | 0L | 685L ),
   "Instruction mnemonic missing or invalid.",
   "HE_DAD_INST_NOT_FOUND",
   UNLOCKED
},
{
   "ER_DAD_INST_SIZE_UNDETERMINED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 686L ),
   "Missing size for given instruction.",
   "HE_DAD_INST_SIZE_UNDETERMINED",
   UNLOCKED
},
{
   "ER_DAD_INVALID_ID_DESCRIPTOR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 687L ),
   "The caller id descriptor is invalid.",
   "HE_DAD_INVALID_ID_DESCRIPTOR",
   UNLOCKED
},
{
   "ER_DAD_INVALID_INDEX_REG",
   ( E_WARNING | 0L | 688L ),
   "Illegal index register.",
   "HE_DAD_INVALID_INDEX_REG",
   UNLOCKED
},
{
   "ER_DAD_INVALID_INST_ADDR",
   ( E_WARNING | 0L | 689L ),
   "Instruction mnemonic missing or invalid.",
   "HE_DAD_INVALID_INST_ADDR",
   UNLOCKED
},
{
   "ER_DAD_INVALID_MODE_FOR_INST",
   ( E_WARNING | 0L | 690L ),
   "Invalid mode for instruction.",
   "HE_DAD_INVALID_MODE_FOR_INST",
   UNLOCKED
},
{
   "ER_DAD_INVALID_NUM_OPERANDS",
   ( E_WARNING | 0L | 691L ),
   "Incorrect number of operands for instruction.",
   "HE_DAD_INVALID_NUM_OPERANDS",
   UNLOCKED
},
{
   "ER_DAD_INVALID_OPCODE",
   ( E_WARNING | 0L | 692L ),
   "Invalid opcode.",
   "HE_DAD_INVALID_OPCODE",
   UNLOCKED
},
{
   "ER_DAD_INVALID_REGLIST_BIT",
   ( E_WARNING | 0L | 693L ),
   "Illegal bit for pshm/pulm instructions.",
   "HE_DAD_INVALID_REGLIST_BIT",
   UNLOCKED
},
{
   "ER_DAD_NO_FLUSH_FRAMES_FOUND",
   ( E_WARNING | 0L | 694L ),
   "No queue flushes found in trace buffer.  Cannot view instructions.",
   "HE_DAD_NO_FLUSH_FRAMES_FOUND",
   UNLOCKED
},
{
   "ER_DAD_NO_SUCH_INST",
   ( E_WARNING | 0L | 695L ),
   "Invalid instruction.",
   "HE_DAD_NO_SUCH_INST",
   UNLOCKED
},
{
   "ER_DAD_OPERAND_INVALID",
   ( E_WARNING | 0L | 696L ),
   "Invalid operand.",
   "HE_DAD_OPERAND_INVALID",
   UNLOCKED
},
{
   "ER_DAD_REG_INVALID",
   ( E_WARNING | 0L | 697L ),
   "Invalid register.",
   "HE_DAD_REG_INVALID",
   UNLOCKED
},
{
   "ER_DAD_STRING_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 698L ),
   "String not found.",
   "HE_DAD_STRING_NOT_FOUND",
   UNLOCKED
},
{
   "ER_DAD_SYMBOL_USE_BUT_DISABLED",
   ( E_WARNING | 0L | 699L ),
   "Symbol name given but symbols disabled.",
   "HE_DAD_SYMBOL_USE_BUT_DISABLED",
   UNLOCKED
},
{
   "ER_DASM_CANT",
   ( INTERNAL_ERROR_ON | E_FATAL | 0L | 700L ),
   "Cannot disassemble memory.  Close Source Window.",
   "HE_DASM_CANT",
   UNLOCKED
},
{
   "ER_DASM_CANT_SET_BKPT",
   ( E_WARNING | 0L | 701L ),
   "Cannot set break on a non-opcode location.",
   "HE_DASM_CANT_SET_BKPT",
   UNLOCKED
},
{
   "ER_DASM_INVALID_ALIAS",
   ( E_WARNING | 0L | 702L ),
   "Invalid alias path.",
   "HE_DASM_INVALID_ALIAS",
   UNLOCKED
},
{
   "ER_DASM_MEMORY",
   ( E_SEVERE | 0L | 703L ),
   "Unable to read memory.",
   "HE_DASM_MEMORY",
   UNLOCKED
},
{
   "ER_DASM_NO_BKPT",
   ( E_WARNING | 0L | 704L ),
   "No breakpoint to %s.",
   "HE_DASM_NO_BKPT",
   UNLOCKED
},
{
   "ER_DASM_REOPEN",
   ( E_FATAL | 0L | 705L ),
   "Failed to reopen a mixed mode data source.",
   "HE_DASM_REOPEN",
   UNLOCKED
},
{
   "ER_DEFAULT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 706L ),
   "Invalid default parameters.",
   "HE_DEFAULT",
   UNLOCKED
},
{
   "ER_DEFINE_START_FIRST",
   ( E_WARNING | 0L | 707L ),
   "Cannot calculate end offset without a start.",
   "HE_DEFINE_START_FIRST",
   UNLOCKED
},
{
   "ER_DEFSEC_NOT_FOUND",
   ( E_WARNING | 0L | 708L ),
   "Cannot find section defined in initialization file: ",
   "HE_DEFSEC_NOT_FOUND",
   UNLOCKED
},
{
   "ER_DEL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 230L ),
   "Deleted the event flag group or semaphore.",
   "HE_DEL",
   LOCKED
},
{
   "ER_DESCRIPTOR_NOT_VALID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 709L ),
   "The entered module does not match parent module of entered symbol.",
   "HE_DESCRIPTOR_NOT_VALID",
   UNLOCKED
},
{
   "ER_DOFIELD_END",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 710L ),
   "Annotated Text Field: out of text before end.",
   "HE_DOFIELD_END",
   UNLOCKED
},
{
   "ER_DOFIELD_END_TAG",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 711L ),
   "Annotated Text Field: end tag expected.",
   "HE_DOFIELD_END_TAG",
   UNLOCKED
},
{
   "ER_DQ_ABORTED",
   ( E_WARNING | 0L | 434L ),
   "Trace instruction processing aborted.",
   "HE_DQ_ABORTED",
   LOCKED
},
{
   "ER_DQ_NO_FRAMES_AVAILABLE",
   ( E_WARNING | 0L | 435L ),
   "No bus cycles collected in trace buffer.",
   "HE_DQ_NO_FRAMES_AVAILABLE",
   LOCKED
},
{
   "ER_DUPLICATE_GLOBAL_NAME",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 712L ),
   "Duplicate symbol name.",
   "HE_DUPLICATE_GLOBAL_NAME",
   UNLOCKED
},
{
   "ER_EEPROM_ERROR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 249L ),
   "Cannot read or illegal value in eeprom; hardware failure.",
   "HE_EEPROM_ERROR",
   LOCKED
},
{
   "ER_END_NOT_ALLOWED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 713L ),
   "End is not supported for this field.",
   "HE_END_NOT_ALLOWED",
   UNLOCKED
},
{
   "ER_END_OF_BUFFER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 439L ),
   //"End of trace buffer reached.",
   "Can't set breakpoints. Try watchpoints.",
   "HE_END_OF_BUFFER",
   LOCKED
},
{
   "ER_ENL_CLI",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 714L ),
   "Cannot send message.",
   "HE_ENL_CLI",
   UNLOCKED
},
{
   "ER_ERCODE_NOT_FOUND",
   ( INTERNAL_ERROR_ON | 0L | 715L ),
   "Error code not found.",
   "HE_ERCODE_NOT_FOUND",
   UNLOCKED
},
{
   "ER_EXPAND_SIZE_ERROR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 716L ),
   "The descriptor is not valid.",
   "HE_EXPAND_SIZE_ERROR",
   UNLOCKED
},
{
   "ER_FAILED_STRCPY",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 717L ),
   "Failed string copy.",
   "HE_FAILED_STRCPY",
   UNLOCKED
},
{
   "ER_FAST_TERMINATION",
   ( E_WARNING | 0L | 420L ),
   "Fast termination CS is active; cannot map.",
   "HE_FAST_TERMINATION",
   LOCKED
},
{
   "ER_FCK",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 239L ),
   "Invalid image checksum.",
   "HE_FCK",
   LOCKED
},
{
   "ER_FIELD_NAME",
   ( E_WARNING | 0L | 718L ),
   "Invalid field name.",
   "HE_FIELD_NAME",
   UNLOCKED
},
{
   "ER_FIELD_NAME_DUP",
   ( E_WARNING | 0L | 719L ),
   "Field name already defined.",
   "HE_FIELD_NAME_DUP",
   UNLOCKED
},
{
   "ER_FILE_NOT_FOUND",
   ( E_WARNING | 0L | 720L ),
   "File not found %s",
   "HE_FILE_NOT_FOUND",
   UNLOCKED
},
{
   "ER_FILL_ABORT",
   ( E_WARNING | 0L | 312L ),
   "Fill command aborted prior to completion.",
   "HE_FILL_ABORT",
   LOCKED
},
{
   "ER_FIRST_CREATE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 247L ),
   "The first task-create failed.",
   "HE_FIRST_CREATE",
   LOCKED
},
{
   "ER_FLASH_CHKSUM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 276L ),
   "Flash memory checksum failure.",
   "HE_FLASH_CHKSUM",
   LOCKED
},
{
   "ER_FLASH_ERASE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 273L ),
   "Failed to erase flash memory.",
   "HE_FLASH_ERASE",
   LOCKED
},
{
   "ER_FLASH_IMAGE_SIZE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 277L ),
   "RAM image size is greater than the Flash PROM size.",
   "HE_FLASH_IMAGE_SIZE",
   LOCKED
},
{
   "ER_FLASH_SIZE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 275L ),
   "Invalid Flash PROM size specified.",
   "HE_FLASH_SIZE",
   LOCKED
},
{
   "ER_FLASH_VERIFY",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 274L ),
   "Failed to write flash memory.",
   "HE_FLASH_VERIFY",
   LOCKED
},
{
   "ER_FLUSH_IN_QUEUE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 721L ),
   "Cannot flush input queue.",
   "HE_FLUSH_IN_QUEUE",
   UNLOCKED
},
{
   "ER_FLUSH_OUT_QUEUE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 722L ),
   "Cannot flush output queue.",
   "HE_FLUSH_OUT_QUEUE",
   UNLOCKED
},
{
   "ER_FN_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 723L ),
   "Cannot open function to add symbols: ",
   "HE_FN_NOT_FOUND",
   UNLOCKED
},
{
   "ER_FP_NOT_SUPPORTED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 724L ),
   "Floating point not currently supported.",
   "HE_FP_NOT_SUPPORTED",
   UNLOCKED
},
{
   "ER_FRAMING",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 292L ),
   "ER_FRAMING.",
   "HE_FRAMING",
   LOCKED
},
{
   "ER_FSZ",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 238L ),
   "The image is too big to fit in flash memory.",
   "HE_FSZ",
   LOCKED
},
{
   "ER_FW_INTERNAL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 232L ),
   "Internal error.",
   "HE_FW_INTERNAL",
   LOCKED
},
{
   "ER_GO_RETURNED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 248L ),
   "Operating system somehow returned to us.",
   "HE_GO_RETURNED",
   LOCKED
},
{
   "ER_HALT_TIMEOUT",
   ( E_WARNING | 0L | 429L ),
   "Attempted halt failed.",
   "HE_HALT_TIMEOUT",
   LOCKED
},
{
   "ER_HARDWARE",
   ( E_WARNING | 0L | 725L ),
   "Comm port hardware not present.",
   "HE_HARDWARE",
   UNLOCKED
},
{
   "ER_HEAP_BAD_FREE_ADDRESS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 726L ),
   "Attempt to free address not in heap list.",
   "HE_HEAP_BAD_FREE_ADDRESS",
   UNLOCKED
},
{
   "ER_HEAP_BAD_POINTER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 727L ),
   "Cannot find memory pointer in list.",
   "HE_HEAP_BAD_POINTER",
   UNLOCKED
},
{
   "ER_HEAP_CORRUPT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 728L ),
   "Memory has been corrupted; save work and exit program.",
   "HE_HEAP_CORRUPT",
   UNLOCKED
},
{
   "ER_HEAP_OUT_OF_MEMORY",
   ( E_WARNING | 0L | 729L ),
   "Out of memory.",
   "HE_HEAP_OUT_OF_MEMORY",
   UNLOCKED
},
{
   "ER_HEAP_REQUEST_TOO_BIG",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 730L ),
   "Memory allocation request too large (64K max).",
   "HE_HEAP_REQUEST_TOO_BIG",
   UNLOCKED
},
{
   "ER_HEX_ABORT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 279L ),
   "Hex file download aborted.",
   "HE_HEX_ABORT",
   LOCKED
},
{
   "ER_HEX_FORMAT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 280L ),
   "Hex file format error.",
   "HE_HEX_FORMAT",
   LOCKED
},
{
   "ER_ICP",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 196L ),
   "Invalid config parameter encountered during INIT.",
   "HE_ICP",
   LOCKED
},
{
   "ER_ID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 228L ),
   "Invalid event flag group or semaphore ID.",
   "HE_ID",
   LOCKED
},
{
   "ER_IEEE_FLOAT",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 731L ),
   "Unimplemented IEEE float display function.",
   "HE_IEEE_FLOAT",
   UNLOCKED
},
{
   "ER_IIP",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 197L ),
   "Invalid input parameter 0x00 PCREATE/PEXTEND.",
   "HE_IIP",
   LOCKED
},
{
   "ER_ILLEGAL_CMD",
   ( E_WARNING | 0L | 301L ),
   "Probe transmission error.",
   "HE_ILLEGAL_CMD",
   LOCKED
},
{
   "ER_ILLEGAL_EVENT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 732L ),
   "Invalid trigger event.",
   "HE_ILLEGAL_EVENT",
   UNLOCKED
},
{
   "ER_ILLEGAL_SIGNAL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 431L ),
   "Invalid signal.",
   "HE_ILLEGAL_SIGNAL",
   LOCKED
},
{
   "ER_ILLEGAL_WHILE_EMON",
   ( E_WARNING | 0L | 309L ),
   "Operation not allowed while emulating.",
   "HE_ILLEGAL_WHILE_EMON",
   LOCKED
},
{
   "ER_INCOMPATIBLE_CPU",
   ( E_WARNING | 0L | 733L ),
   "Incompatible load file processor type: ",
   "HE_INCOMPATIBLE_CPU",
   UNLOCKED
},
{
   "ER_INDEX_ALREADY_EXISTS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 734L ),
   "Cannot create base index.",
   "HE_INDEX_ALREADY_EXISTS",
   UNLOCKED
},
{
   "ER_INDEX_NOT_IN_TABLE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 735L ),
   "Base index not in table.",
   "HE_INDEX_NOT_IN_TABLE",
   UNLOCKED
},
{
   "ER_INDEX_OUT_OF_BOUNDS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 736L ),
   "Base index too large.",
   "HE_INDEX_OUT_OF_BOUNDS",
   UNLOCKED
},
{
   "ER_INI",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 194L ),
   "Fatal initialization error.",
   "HE_INI",
   LOCKED
},
{
   "ER_INPUT_OVERRUN",
   ( E_WARNING | 0L | 303L ),
   "Problems of mapping boundary, mapping resolution, or memory spaces.",
   "HE_INPUT_OVERRUN",
   LOCKED
},
{
   "ER_INPUT_SEMA",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 10L ),
   "Already inside input routine.",
   "HE_INPUT_SEMA",
   LOCKED
},
{
   "ER_INTERNAL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 737L ),
   "MICEpack/SLD internal error: %s (%s).",
   "HE_INTERNAL",
   UNLOCKED
},
{
   "ER_INTERNAL_ERROR",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 738L ),
   "MICEpack/SLD internal error: %s (%s).",
   "HE_INTERNAL_ERROR",
   UNLOCKED
},
{
   "ER_INTERNAL_LINE_UP",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 739L ),
   "Frames do not line up.",
   "HE_INTERNAL_LINE_UP",
   UNLOCKED
},
{
   "ER_INTERNAL_TERMINATION",
   ( E_WARNING | 0L | 441L ),
   "Unterminated memory access; internal termination used.",
   "HE_INTERNAL_TERMINATION",
   LOCKED
},
{
   "ER_INT_TOO_BIG",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 740L ),
   "Value truncated to 16 bits.",
   "HE_INT_TOO_BIG",
   UNLOCKED
},
{
   "ER_INVALID_ACCESS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 426L ),
   "Invalid access size.",
   "HE_INVALID_ACCESS",
   LOCKED
},
{
   "ER_INVALID_ACTION",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 741L ),
   "Invalid action parameter.",
   "HE_INVALID_ACTION",
   UNLOCKED
},
{
   "ER_INVALID_ADDRESS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 742L ),
   "Invalid symbol address.",
   "HE_INVALID_ADDRESS",
   UNLOCKED
},
{
   "ER_INVALID_ADDRESS_TYPE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 743L ),
   "Line number end address is less than or equal to the start address.",
   "HE_INVALID_ADDRESS_TYPE",
   UNLOCKED
},
{
   "ER_INVALID_ALIAS_PATH",
   ( E_WARNING | 0L | 744L ),
   "Source path is invalid.",
   "HE_INVALID_ALIAS_PATH",
   UNLOCKED
},
{
   "ER_INVALID_ARG",
   ( E_WARNING | 0L | 745L ),
   "Invalid command line arguments.",
   "HE_INVALID_ARG",
   UNLOCKED
},
{
   "ER_INVALID_BKPT_INFO",
   ( E_WARNING | 0L | 746L ),
   "Invalid breakpoint specified.",
   "HE_INVALID_BKPT_INFO",
   UNLOCKED
},
{
   "ER_INVALID_BUFFER",
   ( E_WARNING | 0L | 437L ),
   //"Invalid trace buffer.",
   "Memory Access Error (%s).",
   "HE_INVALID_BUFFER",
   LOCKED
},
{
   "ER_INVALID_DATA_OBJECT",
   ( INTERNAL_ERROR_ON | E_FATAL | 0L | 747L ),
   "Invalid data object.  Close Source Window to reset.",
   "HE_INVALID_DATA_OBJECT",
   UNLOCKED
},
{
   "ER_INVALID_DIGIT",
   ( E_WARNING | 0L | 748L ),
   "Invalid number.",
   "HE_INVALID_DIGIT",
   UNLOCKED
},
{
   "ER_INVALID_DISP_FORMAT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 749L ),
   "Invalid display format used.",
   "HE_INVALID_DISP_FORMAT",
   UNLOCKED
},
{
   "ER_INVALID_EVENT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 750L ),
   "Invalid event name.",
   "HE_INVALID_EVENT",
   UNLOCKED
},
{
   "ER_INVALID_EVENT_NAME",
   ( E_WARNING | 0L | 751L ),
   "Invalid event name.",
   "HE_INVALID_EVENT_NAME",
   UNLOCKED
},
{
   "ER_INVALID_FIELD",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 752L ),
   "Invalid template field name.",
   "HE_INVALID_FIELD",
   UNLOCKED
},
{
   "ER_INVALID_FIELD_NUM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 753L ),
   "Invalid template field number.",
   "HE_INVALID_FIELD_NUM",
   UNLOCKED
},
{
   "ER_INVALID_FRAME",
   ( E_WARNING | 0L | 754L ),
   "Invalid frame number.",
   "HE_INVALID_FRAME",
   UNLOCKED
},
{
   "ER_INVALID_IDN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 755L ),
   "Invalid identifier format.",
   "HE_INVALID_IDN",
   UNLOCKED
},
{
   "ER_INVALID_INPUT",
   ( E_WARNING | 0L | 756L ),
   "Invalid input value.",
   "HE_INVALID_INPUT",
   UNLOCKED
},
{
   "ER_INVALID_LANGUAGE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 757L ),
   "Invalid language name in data object.",
   "HE_INVALID_LANGUAGE",
   UNLOCKED
},
{
   "ER_INVALID_LENGTH",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 287L ),
   "The length exceeds the maximum.",
   "HE_INVALID_LENGTH",
   LOCKED
},
{
   "ER_INVALID_MAP_BLOCK",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 428L ),
   "Invalid map block number.",
   "HE_INVALID_MAP_BLOCK",
   LOCKED
},
{
   "ER_INVALID_MODE",
   ( E_WARNING | 0L | 758L ),
   "Invalid tracing mode.",
   "HE_INVALID_MODE",
   UNLOCKED
},
{
   "ER_INVALID_MODULE_NAME",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 759L ),
   "Invalid module file name.",
   "HE_INVALID_MODULE_NAME",
   UNLOCKED
},
{
   "ER_INVALID_MODULE_SYMBOL",
   ( E_WARNING | 0L | 760L ),
   "Invalid module symbol to select function.  Select the module first.",
   "HE_INVALID_MODULE_SYMBOL",
   UNLOCKED
},
{
   "ER_INVALID_PROBE_SPACE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 286L ),
   "The probe space is not valid.",
   "HE_INVALID_PROBE_SPACE",
   LOCKED
},
{
   "ER_INVALID_PRODUCT_IN_DEMO",
   ( INTERNAL_ERROR_ON | E_FATAL | 0L | 761L ),
   "Invalid Product= under [Demonstration].  Use PS or PP followed by 330, 331, 332, F333, 334, 340, 360, 16Y1, 16Z1, or 16Z2 (e.g. PS332, PPF333, PP16Z2, etc.).",
   "HE_INVALID_PRODUCT_IN_DEMO",
   UNLOCKED
},
{
   "ER_INVALID_RANGE_SPEC",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 762L ),
   "Invalid address/data range specified",
   "HE_INVALID_RANGE_SPEC",
   UNLOCKED
},
{
   "ER_INVALID_REGID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 763L ),
   "Invalid register ID.",
   "HE_INVALID_REGID",
   UNLOCKED
},
{
   "ER_INVALID_SECTION_NAME",
   ( E_WARNING | 0L | 764L ),
   "Invalid section name.",
   "HE_INVALID_SECTION_NAME",
   UNLOCKED
},
{
   "ER_INVALID_SIGID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 765L ),
   "Invalid signal ID.",
   "HE_INVALID_SIGID",
   UNLOCKED
},
{
   "ER_INVALID_SPACE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 427L ),
   "Invalid memory space.",
   "HE_INVALID_SPACE",
   LOCKED
},
{
   "ER_INVALID_SYM_DESCRIPTOR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 766L ),
   "Invalid symbol descriptor.",
   "HE_INVALID_SYM_DESCRIPTOR",
   UNLOCKED
},
{
   "ER_INVALID_TIMER",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 242L ),
   "Attempted to use an unavailable timer.",
   "HE_INVALID_TIMER",
   LOCKED
},
{
   "ER_INV_TASK_NUM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 255L ),
   "The requested task number is out of range.",
   "HE_INV_TASK_NUM",
   LOCKED
},
{
   "ER_IN_PROGRESS",
   ( E_WARNING | 0L | 767L ),
   "Loading is in progress, cannot perform the requested operation.",
   "HE_IN_PROGRESS",
   UNLOCKED
},
{
   "ER_ISC",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 188L ),
   "Invalid system call attempted.",
   "HE_ISC",
   LOCKED
},
{
   "ER_KEY_TOKEN_NOT_FOUND",
   ( E_WARNING | 0L | 768L ),
   "Token keyword not found.",
   "HE_KEY_TOKEN_NOT_FOUND",
   UNLOCKED
},
{
   "ER_LAD",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 235L ),
   "Invalid address entered.",
   "HE_LAD",
   LOCKED
},
{
   "ER_LDR_ABORT",
   ( E_WARNING | 0L | 769L ),
   "User abort requested.",
   "HE_LDR_ABORT",
   UNLOCKED
},
{
   "ER_LINENUMS_ALREADY_LOADED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 770L ),
   "Line numbers have already been loaded.",
   "HE_LINENUMS_ALREADY_LOADED",
   UNLOCKED
},
{
   "ER_LINENUMS_NOT_SORTED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 771L ),
   "A code address was requested, a variable address was found.",
   "HE_LINENUMS_NOT_SORTED",
   UNLOCKED
},
{
   "ER_LINENUM_BAD_STATE",
   ( E_WARNING | 0L | 772L ),
   "Cannot add linenumber symbols.",
   "HE_LINENUM_BAD_STATE",
   UNLOCKED
},
{
   "ER_LINENUM_INDEX_TOO_LARGE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 773L ),
   "Line number index too large.",
   "HE_LINENUM_INDEX_TOO_LARGE",
   UNLOCKED
},
{
   "ER_LINENUM_NOT_FOUND",
   ( E_WARNING | 0L | 774L ),
   "Cannot find line number.",
   "HE_LINENUM_NOT_FOUND",
   UNLOCKED
},
{
   "ER_LINE_EXPT",
   ( E_WARNING | 0L | 775L ),
   "Expected line number block.",
   "HE_LINE_EXPT",
   UNLOCKED
},
{
   "ER_LINE_MISSING",
   ( E_WARNING | 0L | 776L ),
   "Line Number Missing.",
   "HE_LINE_MISSING",
   UNLOCKED
},
{
   "ER_LINE_NOT_ADDED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 777L ),
   "Line number(s) not added to symbol table.",
   "HE_LINE_NOT_ADDED",
   UNLOCKED
},
{
   "ER_LOADFILES_DONT_MATCH",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 778L ),
   "The load filename does not match previous load.",
   "HE_LOADFILES_DONT_MATCH",
   UNLOCKED
},
{
   "ER_LOAD_ABORT",
   ( E_WARNING | 0L | 444L ),
   "Load aborted.",
   "HE_LOAD_ABORT",
   LOCKED
},
{
   "ER_LONG_DEFARG",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 779L ),
   "Long default argument value not processed.",
   "HE_LONG_DEFARG",
   UNLOCKED
},
{
   "ER_MAP_CANNOT_OPEN_FILE",
   ( E_WARNING | 0L | 780L ),
   "Cannot open file.",
   "HE_MAP_CANNOT_OPEN_FILE",
   UNLOCKED
},
{
   "ER_MAP_INVALID_REGNAME",
   ( E_WARNING | 0L | 781L ),
   "Invalid register name.",
   "HE_MAP_INVALID_REGNAME",
   UNLOCKED
},
{
   "ER_MAP_INVALID_VALUE_INPUT",
   ( E_WARNING | 0L | 782L ),
   "Invalid register value.",
   "HE_MAP_INVALID_VALUE_INPUT",
   UNLOCKED
},
{
   "ER_MAP_TOO_MANY_INPUT_LINES",
   ( E_WARNING | 0L | 783L ),
   "Too many input lines.",
   "HE_MAP_TOO_MANY_INPUT_LINES",
   UNLOCKED
},
{
   "ER_MAP_UNKNOWN_TYPE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 784L ),
   "Unknown type.",
   "HE_MAP_UNKNOWN_TYPE",
   UNLOCKED
},
{
   "ER_MAP_VALUE_MISSING",
   ( E_WARNING | 0L | 785L ),
   "Chip select value not found.",
   "HE_MAP_VALUE_MISSING",
   UNLOCKED
},
{
   "ER_MAP_VALUE_TOO_BIG",
   ( E_WARNING | 0L | 786L ),
   "Register value too large.",
   "HE_MAP_VALUE_TOO_BIG",
   UNLOCKED
},
{
   "ER_MASK_VALUE_PROBLEM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 787L ),
   "The mask and value fields do not match.",
   "HE_MASK_VALUE_PROBLEM",
   UNLOCKED
},
{
   "ER_MAX_COUNTER_VALUE",
   ( E_WARNING | 0L | 788L ),
   "Counter value too large; setting to maximum value.",
   "HE_MAX_COUNTER_VALUE",
   UNLOCKED
},
{
   "ER_MEM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 182L ),
   "Out of memory in box.",
   "HE_MEM",
   LOCKED
},
{
   "ER_MEMBER_NAME_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 263L ),
   "ER_MEMBER_NAME_NOT_FOUND.",
   "HE_MEMBER_NAME_NOT_FOUND",
   LOCKED
},
{
   "ER_MEMORY_BUFF_LEN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 422L ),
   "Dump or fill request too large.",
   "HE_MEMORY_BUFF_LEN",
   LOCKED
},
{
   "ER_MEMORY_VERIFY",
   ( E_WARNING | 0L | 306L ),
   "Memory verification failed (%s).",
   "HE_MEMORY_VERIFY",
   LOCKED
},
{
   "ER_MEM_BUFF_LEN",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 2L ),
   "Not enough memory to complete read operation.",
   "HE_MEM_BUFF_LEN",
   LOCKED
},
{
   "ER_MEM_DATA_GREATER_THAN_BYTE",
   ( E_WARNING | 0L | 789L ),
   "Data values must be less than 256.",
   "HE_MEM_DATA_GREATER_THAN_BYTE",
   UNLOCKED
},
{
   "ER_MEM_DATA_GREATER_THAN_WORD",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 790L ),
   "Data values must be less than 65536.",
   "HE_MEM_DATA_GREATER_THAN_WORD",
   UNLOCKED
},
{
   "ER_MEM_END_LESS_THAN_START",
   ( E_WARNING | 0L | 791L ),
   "The end address is less than the start address.",
   "HE_MEM_END_LESS_THAN_START",
   UNLOCKED
},
{
   "ER_MEM_FROM_TO",
   ( E_WARNING | 0L | 792L ),
   "From and to addresses out of order.",
   "HE_MEM_FROM_TO",
   UNLOCKED
},
{
   "ER_MEM_INVALID_DESCRIPTOR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 793L ),
   "Invalid session descriptor.",
   "HE_MEM_INVALID_DESCRIPTOR",
   UNLOCKED
},
{
   "ER_MEM_INVALID_SRC_ID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 794L ),
   "Invalid size.",
   "HE_MEM_INVALID_SRC_ID",
   UNLOCKED
},
{
   "ER_MEM_NON_NUM",
   ( E_WARNING | 0L | 795L ),
   "Non-numeric pattern.",
   "HE_MEM_NON_NUM",
   UNLOCKED
},
{
   "ER_MEM_NOT_IMPLEMENTED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 796L ),
   "This function is not yet implemented.",
   "HE_MEM_NOT_IMPLEMENTED",
   UNLOCKED
},
{
   "ER_MEM_NO_FUNC",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 797L ),
   "Function not implemented by Memory Server.",
   "HE_MEM_NO_FUNC",
   UNLOCKED
},
{
   "ER_MEM_PAT_LEN",
   ( E_WARNING | 0L | 798L ),
   "Data pattern too long.",
   "HE_MEM_PAT_LEN",
   UNLOCKED
},
{
   "ER_MIN_COUNTER_VALUE",
   ( E_WARNING | 0L | 799L ),
   "Counter value too small; setting to minimum value.",
   "HE_MIN_COUNTER_VALUE",
   UNLOCKED
},
{
   "ER_MISMATCHED_SHARED_DATA",
   ( E_SEVERE | 0L | 1L ),
   "Firmware not compatible with host software.",
   "HE_MISMATCHED_SHARED_DATA",
   LOCKED
},
{
   "ER_MISSING_SECTION_NAME",
   ( E_WARNING | 0L | 800L ),
   "Missing section name information.",
   "HE_MISSING_SECTION_NAME",
   UNLOCKED
},
{
   "ER_MISSING_TOOLS_SUPPORT",
   ( E_WARNING | 0L | 801L ),
   "Missing compiler information in initialization file.",
   "HE_MISSING_TOOLS_SUPPORT",
   UNLOCKED
},
{
   "ER_MIU",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 184L ),
   "The mailbox is in use.",
   "HE_MIU",
   LOCKED
},
{
   "ER_MODREF",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 802L ),
   "Cannot update module path information.",
   "HE_MODREF",
   UNLOCKED
},
{
   "ER_MODTIME",
   ( E_WARNING | 0L | 803L ),
   "Module time stamp is later than the original load file.",
   "HE_MODTIME",
   UNLOCKED
},
{
   "ER_MODULE_ALREADY_OPEN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 804L ),
   "Cannot open two modules simultaneously for symbol loading.",
   "HE_MODULE_ALREADY_OPEN",
   UNLOCKED
},
{
   "ER_MODULE_NOT_FOUND",
   ( E_WARNING | 0L | 805L ),
   "Cannot find module.",
   "HE_MODULE_NOT_FOUND",
   UNLOCKED
},
{
   "ER_MULTI_BUFS_NEEDED",
   ( E_WARNING | 0L | 806L ),
   "A NEXT action requires multiple trace buffer configuration.",
   "HE_MULTI_BUFS_NEEDED",
   UNLOCKED
},
{
   "ER_MUST_DEFINE_TOOLUSE",
   ( E_WARNING | 0L | 807L ),
   "Must define CompilerUsed information, specify 'CompilerUsed <compiler>' option.",
   "HE_MUST_DEFINE_TOOLUSE",
   UNLOCKED
},
{
   "ER_NAME_NOT_ADDED",
   ( E_WARNING | 0L | 808L ),
   "Cannot add module reference to symbol table. (Warning only.)",
   "HE_NAME_NOT_ADDED",
   UNLOCKED
},
{
   "ER_NAME_TOO_LONG",
   ( E_WARNING | 0L | 809L ),
   "The new event name is too long.",
   "HE_NAME_TOO_LONG",
   UNLOCKED
},
{
   "ER_NCP",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 195L ),
   "No character is present.",
   "HE_NCP",
   LOCKED
},
{
   "ER_NMB",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 183L ),
   "Not a memory block.",
   "HE_NMB",
   LOCKED
},
{
   "ER_NMP",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 190L ),
   "No message present.",
   "HE_NMP",
   LOCKED
},
{
   "ER_NOCB",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 227L ),
   "There are no available control blocks.",
   "HE_NOCB",
   LOCKED
},
{
   "ER_NOCODE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 810L ),
   "Code region not loaded.",
   "HE_NOCODE",
   UNLOCKED
},
{
   "ER_NOP",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 236L ),
   "No process IDs are available.",
   "HE_NOP",
   LOCKED
},
{
   "ER_NOPEN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 811L ),
   "Device not open.",
   "HE_NOPEN",
   UNLOCKED
},
{
   "ER_NOQ",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 423L ),
   "No message queue is available.",
   "HE_NOQ",
   LOCKED
},
{
   "ER_NOREG_UPDATE",
   ( E_WARNING | 0L | 812L ),
   "Cannot update PC, SP while processor running.",
   "HE_NOREG_UPDATE",
   UNLOCKED
},
{
   "ER_NORUNACCESS",
   ( E_WARNING | 0L | 813L ),
   "Cannot load code while processor running.",
   "HE_NORUNACCESS",
   UNLOCKED
},
{
   "ER_NOTYET_IMPL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 814L ),
   "This function is not yet implemented.",
   "HE_NOTYET_IMPL",
   UNLOCKED
},
{
   "ER_NOT_A_VARIABLE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 815L ),
   "Expected a variable type symbol.",
   "HE_NOT_A_VARIABLE",
   UNLOCKED
},
{
   "ER_NOT_CPU",
   ( E_WARNING | 0L | 816L ),
   "Processor type not supported.",
   "HE_NOT_CPU",
   UNLOCKED
},
{
   "ER_NOT_ENOUGH_STORAGE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 817L ),
   "Not enough memory to return string.",
   "HE_NOT_ENOUGH_STORAGE",
   UNLOCKED
},
{
   "ER_NOT_FOUND",
   ( INTERNAL_ERROR_ON | 0L | 818L ),
   "Error not found.",
   "HE_NOT_FOUND",
   UNLOCKED
},
{
   "ER_NOT_IMPLEMENTED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 819L ),
   "A variable address was requested, a code address was found.",
   "HE_NOT_IMPLEMENTED",
   UNLOCKED
},
{
   "ER_NOT_IN_POWERSCOPE",
   ( E_WARNING | 0L | 820L ),
   "Feature not supported in PowerScope.",
   "HE_NOT_IN_POWERSCOPE",
   UNLOCKED
},
{
   "ER_NOT_MEM_CONF",
   ( E_WARNING | 0L | 821L ),
   "Save/restore error: file is not in the correct format. Memory save/restore not supported yet.",
   "HE_NOT_MEM_CONF",
   UNLOCKED
},
{
   "ER_NOT_NOT_ALLOWED",
   ( E_WARNING | 0L | 822L ),
   "The NOT feature is not supported for this field.",
   "HE_NOT_NOT_ALLOWED",
   UNLOCKED
},
{
   "ER_NOT_SUPPORTED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 266L ),
   "ER_NOT_SUPPORTED.",
   "HE_NOT_SUPPORTED",
   LOCKED
},
{
   "ER_NO_ACTIVE_EVENT",
   ( E_WARNING | 0L | 823L ),
   "No active event has been selected.",
   "HE_NO_ACTIVE_EVENT",
   UNLOCKED
},
{
   "ER_NO_ACTIVE_FIELD",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 824L ),
   "No active template field was selected.",
   "HE_NO_ACTIVE_FIELD",
   UNLOCKED
},
{
   "ER_NO_ACTIVE_TEMPLATE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 825L ),
   "No active template was selected.",
   "HE_NO_ACTIVE_TEMPLATE",
   UNLOCKED
},
{
   "ER_NO_CONFIG",
   ( E_WARNING | 0L | 241L ),
   "No system configuration is available.",
   "HE_NO_CONFIG",
   LOCKED
},
{
   "ER_NO_CPU_CONFIG_FILE",
   ( E_FATAL | 0L | 826L ),
   "CPU configuration file missing.",
   "HE_NO_CPU_CONFIG_FILE",
   UNLOCKED
},
{
   "ER_NO_DATA_AVAIL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 253L ),
   "No data is available from the task yet.",
   "HE_NO_DATA_AVAIL",
   LOCKED
},
{
   "ER_NO_EVFILE_ENTRY",
   ( E_WARNING | 0L | 827L ),
   "Cannot open event configuration file",
   "HE_NO_EVFILE_ENTRY",
   UNLOCKED
},
{
   "ER_NO_FILE_GIVEN",
   ( E_WARNING | 0L | 828L ),
   "File name required.",
   "HE_NO_FILE_GIVEN",
   UNLOCKED
},
{
   "ER_NO_FLASH_PROM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 284L ),
   "Flash memory size is unreadable or there are no flash PROMs.",
   "HE_NO_FLASH_PROM",
   LOCKED
},
{
   "ER_NO_FREE_MAP_BLOCKS",
   ( E_WARNING | 0L | 829L ),
   "There are no map blocks available.",
   "HE_NO_FREE_MAP_BLOCKS",
   UNLOCKED
},
{
   "ER_NO_LIBS",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 830L ),
   "Cannot open the required libraries for %s.",
   "HE_NO_LIBS",
   UNLOCKED
},
{
   "ER_NO_LIFETIME_INFO",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 831L ),
   "Symbol has no lifetime information.",
   "HE_NO_LIFETIME_INFO",
   UNLOCKED
},
{
   "ER_NO_LINENUMS_ADDED",
   ( E_WARNING | 0L | 832L ),
   "There are no line numbers for this module.",
   "HE_NO_LINENUMS_ADDED",
   UNLOCKED
},
{
   "ER_NO_MASK_SUPPORTED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 833L ),
   "Mask not supported with decimal format.",
   "HE_NO_MASK_SUPPORTED",
   UNLOCKED
},
{
   "ER_NO_MATCH",
   ( INTERNAL_ERROR_ON | 0L | 834L ),
   "Attempt to match record failed.",
   "HE_NO_MATCH",
   UNLOCKED
},
{
   "ER_NO_MATCHING_VAR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 835L ),
   "ER_NO_MATCHING_VAR",
   "HE_NO_MATCHING_VAR",
   UNLOCKED
},
{
   "ER_NO_MDESC",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 836L ),
   "No module descriptor found; cannot add line numbers.",
   "HE_NO_MDESC",
   UNLOCKED
},
{
   "ER_NO_MEM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 251L ),
   "No memory available.",
   "HE_NO_MEM",
   LOCKED
},
{
   "ER_NO_MEMORY",
   ( E_WARNING | 0L | 837L ),
   "Out of memory during load.",
   "HE_NO_MEMORY",
   UNLOCKED
},
{
   "ER_NO_MEMORY_PRESENT",
   ( E_WARNING | 0L | 838L ),
   "No map ram installed on probe.",
   "HE_NO_MEMORY_PRESENT",
   UNLOCKED
},
{
   "ER_NO_MEM_FOR_INPUT_DATA",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 260L ),
   "ER_NO_MEM_FOR_INPUT_DATA.",
   "HE_NO_MEM_FOR_INPUT_DATA",
   LOCKED
},
{
   "ER_NO_MORE_PG_DIR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 233L ),
   "There are no more page directory entries.",
   "HE_NO_MORE_PG_DIR",
   LOCKED
},
{
   "ER_NO_MORE_SELECTORS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 258L ),
   "No more selectors are available.",
   "HE_NO_MORE_SELECTORS",
   LOCKED
},
{
   "ER_NO_PC",
   ( E_WARNING | 0L | 839L ),
   "No starting PC available.",
   "HE_NO_PC",
   UNLOCKED
},
{
   "ER_NO_PREV_TBL_ENTRY",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 234L ),
   "No previous page table entry encountered.",
   "HE_NO_PREV_TBL_ENTRY",
   LOCKED
},
{
   "ER_NO_SECTION_NAME_DEFINED",
   ( E_WARNING | 0L | 840L ),
   "Tool not defined in initialization file.",
   "HE_NO_SECTION_NAME_DEFINED",
   UNLOCKED
},
{
   "ER_NO_SEMAPHORES_AVAILABLE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 264L ),
   "ER_NO_SEMAPHORES_AVAILABLE.",
   "HE_NO_SEMAPHORES_AVAILABLE",
   LOCKED
},
{
   "ER_NO_STACK_LIMIT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 841L ),
   "No alarm limit set.  Set the alarm limit first.",
   "HE_NO_STACK_LIMIT",
   UNLOCKED
},
{
   "ER_NO_STROBE",
   ( E_WARNING | 0L | 313L ),
   "Execution breakpoint requires active AS or CS.",
   "HE_NO_STROBE",
   LOCKED
},
{
   "ER_NO_SUCH_EVENT",
   ( E_WARNING | 0L | 842L ),
   "Invalid search event name.",
   "HE_NO_SUCH_EVENT",
   UNLOCKED
},
{
   "ER_NO_SYMBOLIC_INFO",
   ( E_WARNING | 0L | 843L ),
   "No symbolic information on the selected region.",
   "HE_NO_SYMBOLIC_INFO",
   UNLOCKED
},
{
   "ER_NO_TASK",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 257L ),
   "The task does not exist.",
   "HE_NO_TASK",
   LOCKED
},
{
   "ER_NO_TASKS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 25L ),
   "No tasks in task table.",
   "HE_NO_TASKS",
   LOCKED
},
{
   "ER_NO_TEMPLATE_FILE_GIVEN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 844L ),
   "Filename required.",
   "HE_NO_TEMPLATE_FILE_GIVEN",
   UNLOCKED
},
{
   "ER_NO_TIMER",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 6L ),
   "Cannot install the timer.",
   "HE_NO_TIMER",
   LOCKED
},
{
   "ER_NO_TIMER_AVAIL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 845L ),
   "No timer available.",
   "HE_NO_TIMER_AVAIL",
   UNLOCKED
},
{
   "ER_NO_TOOLS_SUPPORT_DEFINED",
   ( E_WARNING | 0L | 846L ),
   "No compilers defined in initialization file.",
   "HE_NO_TOOLS_SUPPORT_DEFINED",
   UNLOCKED
},
{
   "ER_NO_TOOLUSE_DEFINED",
   ( E_WARNING | 0L | 847L ),
   "No CompilerUsed defined in MICEPACK.INI file.",
   "HE_NO_TOOLUSE_DEFINED",
   UNLOCKED
},
{
   "ER_NO_TRACE_FRAME",
   ( E_INFORMATIVE | 0L | 848L ),
   //"Frame not found.  Trace search failed.",
   "User abort.",
   "HE_NO_TRACE_FRAME",
   UNLOCKED
},
{
   "ER_NO_TRACE_OPEN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 849L ),
   "Do a trace open first.",
   "HE_NO_TRACE_OPEN",
   UNLOCKED
},
{
   "ER_NO_TRIG_DEFINED",
   ( E_WARNING | 0L | 850L ),
   "No active trigger found.",
   "HE_NO_TRIG_DEFINED",
   UNLOCKED
},
{
   "ER_NO_VALID_ADDRESS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 851L ),
   "Invalid address.",
   "HE_NO_VALID_ADDRESS",
   UNLOCKED
},
{
   "ER_NULL_FUNCTION",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 243L ),
   "The callback function has a null value.",
   "HE_NULL_FUNCTION",
   LOCKED
},
{
   "ER_NUM_BASE_MISMATCH",
   ( E_WARNING | 0L | 852L ),
   "Number does not match base.",
   "HE_NUM_BASE_MISMATCH",
   UNLOCKED
},
{
   "ER_ONLY_FOR_RANGES",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 853L ),
   "This routine only works for range fields.",
   "HE_ONLY_FOR_RANGES",
   UNLOCKED
},
{
   "ER_ONLY_HW_SUPPORT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 854L ),
   "Supports only hardware trace file.",
   "HE_ONLY_HW_SUPPORT",
   UNLOCKED
},
{
   "ER_OPC",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 213L ),
   "The component opcode is undefined.",
   "HE_OPC",
   LOCKED
},
{
   "ER_OPEN",
   ( E_WARNING | 0L | 855L ),
   "Device already open.",
   "HE_OPEN",
   UNLOCKED
},
{
   "ER_OPTIMIZED",
   ( E_WARNING | 0L | 856L ),
   "Optimized code detected: source view and variable access may be incorrect.",
   "HE_OPTIMIZED",
   UNLOCKED
},
{
   "ER_OUT_OF_MEMORY",
   ( INTERNAL_ERROR_ON | 0L | 857L ),
   "Out of memory.",
   "HE_OUT_OF_MEMORY",
   UNLOCKED
},
{
   "ER_OUT_OF_RANGE",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 3L ),
   "Memory address out of range.",
   "HE_OUT_OF_RANGE",
   LOCKED
},
{
   "ER_OVERLAY_HARDWARE",
   ( E_WARNING | 0L | 297L ),
   "Cannot read mapped memory type.",
   "HE_OVERLAY_HARDWARE",
   LOCKED
},
{
   "ER_OVERRUN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 290L ),
   "ER_OVERRUN.",
   "HE_OVERRUN",
   LOCKED
},
{
   "ER_OVF",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 231L ),
   "The event flag is already set or semaphore overflowed.",
   "HE_OVF",
   LOCKED
},
{
   "ER_PACKET_BASE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 296L ),
   "Base of 8751-reported errors.",
   "HE_PACKET_BASE",
   LOCKED
},
{
   "ER_PACKET_FORMAT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 288L ),
   "The header byte is missing.",
   "HE_PACKET_FORMAT",
   LOCKED
},
{
   "ER_PARITY",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 291L ),
   "ER_PARITY.",
   "HE_PARITY",
   LOCKED
},
{
   "ER_PATTERN_MISSING",
   ( E_WARNING | 0L | 858L ),
   "Pattern missing.",
   "HE_PATTERN_MISSING",
   UNLOCKED
},
{
   "ER_PCALL_RECURSE",
   ( INTERNAL_ERROR_ON | 0L | 859L ),
   "Procedure Call Recursion",
   "HE_PCALL_RECURSE",
   UNLOCKED
},
{
   "ER_PID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 193L ),
   "The partition ID is invalid.",
   "HE_PID",
   LOCKED
},
{
   "ER_PND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 229L ),
   "Tasks are pending on the event flag group/semaphore.",
   "HE_PND",
   LOCKED
},
{
   "ER_PROBE_FW_VERSION",
   ( E_WARNING | 0L | 446L ),
   "Probe firmware version incompatible with MICEpack/SLD.",
   "HE_PROBE_FW_VERSION",
   LOCKED
},
{
   "ER_PROBE_TIMEOUT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 293L ),
   "ER_PROBE_TIMEOUT.",
   "HE_PROBE_TIMEOUT",
   LOCKED
},
{
   "ER_PROBE_VERSION_NO_RETRY",
   ( E_SEVERE | 0L | 19L ),
   "PowerScope probe version 1.4 or higher required for internal termination.",
   "HE_PROBE_VERSION_NO_RETRY",
   LOCKED
},
{
   "ER_PROBE_VERSION_NO_XBRKS",
   ( E_SEVERE | 0L | 18L ),
   "PowerScope probe version 1.4 or higher required for ROM breakpoints.",
   "HE_PROBE_VERSION_NO_XBRKS",
   LOCKED
},
{
   "ER_PROC_TYPE_UNKNOWN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 440L ),
   "Unknown processor type.",
   "HE_PROC_TYPE_UNKNOWN",
   LOCKED
},
{
   "ER_PROFILE_WRITE",
   ( INTERNAL_ERROR_ON | 0L | 860L ),
   "Profile Write",
   "HE_PROFILE_WRITE",
   UNLOCKED
},
{
   "ER_PUBLIC_IGNORED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 861L ),
   "Public symbol ignored.",
   "HE_PUBLIC_IGNORED",
   UNLOCKED
},
{
   "ER_QFL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 192L ),
   "The Queue is full.",
   "HE_QFL",
   LOCKED
},
{
   "ER_QID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 191L ),
   "Invalid Queue ID encountered.",
   "HE_QID",
   LOCKED
},
{
   "ER_RCV_CHECKSUM",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 289L ),
   "ER_RCV_CHECKSUM.",
   "HE_RCV_CHECKSUM",
   LOCKED
},
{
   "ER_RDWR_SIZE_EXCEEDED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 285L ),
   "Tried to read or write too many bytes.",
   "HE_RDWR_SIZE_EXCEEDED",
   LOCKED
},
{
   "ER_READING_FILE",
   ( E_WARNING | 0L | 862L ),
   "Cannot read file.",
   "HE_READING_FILE",
   UNLOCKED
},
{
   "ER_REC_NOT_HANDLED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 863L ),
   "Record type not supported.",
   "HE_REC_NOT_HANDLED",
   UNLOCKED
},
{
   "ER_REGISTER_CLASS_UNKNOWN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 864L ),
   "Unknown register class.",
   "HE_REGISTER_CLASS_UNKNOWN",
   UNLOCKED
},
{
   "ER_REGNAME_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 865L ),
   "Register name not found.",
   "HE_REGNAME_NOT_FOUND",
   UNLOCKED
},
{
   "ER_REGTABLE",
   ( E_WARNING | 0L | 866L ),
   "Register translation table contains invalid value.",
   "HE_REGTABLE",
   UNLOCKED
},
{
   "ER_REG_OUT_OF_RANGE",
   ( E_WARNING | 0L | 867L ),
   "Value out of range.",
   "HE_REG_OUT_OF_RANGE",
   UNLOCKED
},
{
   "ER_REMOVE_LIST",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 252L ),
   "Can not remove the entry from the list.",
   "HE_REMOVE_LIST",
   LOCKED
},
{
   "ER_RESET_DCB_STATE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 868L ),
   "Cannot configure comm port to default settings.",
   "HE_RESET_DCB_STATE",
   UNLOCKED
},
{
   "ER_RESET_DURING_BDM",
   ( E_WARNING | 0L | 304L ),
   "Processor reset during BDM exchange.",
   "HE_RESET_DURING_BDM",
   LOCKED
},
{
   "ER_RESET_UNIT_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 245L ),
   "The system could not be reset.",
   "HE_RESET_UNIT_FAILED",
   LOCKED
},
{
   "ER_RESLOAD",
   ( INTERNAL_ERROR_ON | 0L | 869L ),
   "Could not load resource.",
   "HE_RESLOAD",
   UNLOCKED
},
{
   "ER_SCROLL_NEEDS_MEM",
   ( E_WARNING | 0L | 870L ),
   "Scrolling requires accessing memory: %s.",
   "HE_SCROLL_NEEDS_MEM",
   UNLOCKED
},
{
   "ER_SDS_LOGFILE_OPEN",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 22L ),
   "Cannot open shared data logfile.",
   "HE_SDS_LOGFILE_OPEN",
   LOCKED
},
{
   "ER_SDS_TIMEOUT",
   ( INTERNAL_ERROR_ON | 0L | 871L ),
   "Shared data timeout.",
   "HE_SDS_TIMEOUT",
   UNLOCKED
},
{
   "ER_SD_CLOSE",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 5L ),
   "Cannot close the connection.",
   "HE_SD_CLOSE",
   LOCKED
},
{
   "ER_SD_INDEX",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 8L ),
   "Shared data-entry index too big.",
   "HE_SD_INDEX",
   LOCKED
},
{
   "ER_SD_PARTIALMBR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 12L ),
   "Reading partial SDS member.",
   "HE_SD_PARTIALMBR",
   LOCKED
},
{
   "ER_SD_WRITE",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 11L ),
   "Attempt to write too many bytes.",
   "HE_SD_WRITE",
   LOCKED
},
{
   "ER_SEARCH_ABORT",
   ( E_WARNING | 0L | 443L ),
   "Memory search aborted.",
   "HE_SEARCH_ABORT",
   LOCKED
},
{
   "ER_SEARCH_FOUND",
   ( E_INFORMATIVE | 0L | 872L ),
   "Search found at %s.",
   "HE_SEARCH_FOUND",
   UNLOCKED
},
{
   "ER_SEARCH_NOT_FOUND",
   ( E_INFORMATIVE | 0L | 873L ),
   "Search not Found.",
   "HE_SEARCH_NOT_FOUND",
   UNLOCKED
},
{
   "ER_SECTION_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 874L ),
   "Cannot find section index.",
   "HE_SECTION_NOT_FOUND",
   UNLOCKED
},
{
   "ER_SEG_LIMIT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 265L ),
   "ER_SEG_LIMIT.",
   "HE_SEG_LIMIT",
   LOCKED
},
{
   "ER_SEND_MESSAGE_FAILED",
   ( INTERNAL_ERROR_ON | 0L | 875L ),
   "Message Send failed.",
   "HE_SEND_MESSAGE_FAILED",
   UNLOCKED
},
{
   "ER_SHARED_DATA_LIMIT_EXCEEDED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 262L ),
   "ER_SHARED_DATA_LIMIT_EXCEEDED.",
   "HE_SHARED_DATA_LIMIT_EXCEEDED",
   LOCKED
},
{
   "ER_SIGNAL_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 876L ),
   "Signal not found.",
   "HE_SIGNAL_NOT_FOUND",
   UNLOCKED
},
{
   "ER_SIG_NOT_AVAIL_IN_POWERSCOPE",
   ( E_WARNING | 0L | 877L ),
   "Signals are not available in PowerScope.",
   "HE_SIG_NOT_AVAIL_IN_POWERSCOPE",
   UNLOCKED
},
{
   "ER_SIM_UNREADABLE",
   ( E_WARNING | 0L | 430L ),
   "SIM register bank cannot be located.",
   "HE_SIM_UNREADABLE",
   LOCKED
},
{
   "ER_SINGLE_TRACE_BUFFER",
   ( E_WARNING | 0L | 878L ),
   //"Invalid request with only one trace buffer.",
   "Function fail",
   "HE_SINGLE_TRACE_BUFFER",
   UNLOCKED
},
{
   "ER_SKIP_MODULE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 879L ),
   "Symbols for the module not loaded.",
   "HE_SKIP_MODULE",
   UNLOCKED
},
{
   "ER_SLOW_CLOCK",
   ( E_WARNING | 0L | 305L ),
   "Processor clock speed is slower than 131 KHz.",
   "HE_SLOW_CLOCK",
   LOCKED
},
{
   "ER_SOURCE_END",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 880L ),
   "End of source file reached.",
   "HE_SOURCE_END",
   UNLOCKED
},
{
   "ER_SOURCE_NEWER",
   ( E_WARNING | 0L | 881L ),
   "Source module is newer than load file.",
   "HE_SOURCE_NEWER",
   UNLOCKED
},
{
   "ER_SRC_CANT_FIND",
   ( E_WARNING | 0L | 882L ),
   "Cannot find %s.",
   "HE_SRC_CANT_FIND",
   UNLOCKED
},
{
   "ER_SRC_CANT_OPEN_DATA",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 883L ),
   "Cannot open a data object to display.",
   "HE_SRC_CANT_OPEN_DATA",
   UNLOCKED
},
{
   "ER_SRC_CURSOR_MAP",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 884L ),
   "Failed to map current cursor position to the new view.",
   "HE_SRC_CURSOR_MAP",
   UNLOCKED
},
{
   "ER_SRC_END_OF_HISTORY",
   ( E_WARNING | 0L | 885L ),
   "Cannot go forward in file browse history.",
   "HE_SRC_END_OF_HISTORY",
   UNLOCKED
},
{
   "ER_SRC_EVENT_REG",
   ( INTERNAL_ERROR_ON | E_FATAL | 0L | 886L ),
   "Unable to register events for Source Window.",
   "HE_SRC_EVENT_REG",
   UNLOCKED
},
{
   "ER_SRC_FIND_ADDRESS",
   ( E_FATAL | 0L | 887L ),
   "Address is within a source module, but cannot find.  Reload symbols and try again.",
   "HE_SRC_FIND_ADDRESS",
   UNLOCKED
},
{
   "ER_SRC_FUNC_START_INFO",
   ( E_INFORMATIVE | 0L | 888L ),
   "Function %s:  Address starts at: %s.",
   "HE_SRC_FUNC_START_INFO",
   UNLOCKED
},
{
   "ER_SRC_HISTORY_DEPTH",
   ( E_WARNING | 0L | 889L ),
   "History depth must be in the range 5 to 100.",
   "HE_SRC_HISTORY_DEPTH",
   UNLOCKED
},
{
   "ER_SRC_INVALID_ADDRESS",
   ( E_WARNING | 0L | 890L ),
   "Invalid address.",
   "HE_SRC_INVALID_ADDRESS",
   UNLOCKED
},
{
   "ER_SRC_INVALID_INPUT_TAB",
   ( E_WARNING | 0L | 891L ),
   "Invalid tab width.",
   "HE_SRC_INVALID_INPUT_TAB",
   UNLOCKED
},
{
   "ER_SRC_INVALID_LINE",
   ( E_WARNING | 0L | 892L ),
   "Invalid line number.",
   "HE_SRC_INVALID_LINE",
   UNLOCKED
},
{
   "ER_SRC_MEM_NEEDED",
   ( E_WARNING | 0L | 893L ),
   "%s requires accessing memory: %s.",
   "HE_SRC_MEM_NEEDED",
   UNLOCKED
},
{
   "ER_SRC_NO_LOADFILE",
   ( E_WARNING | 0L | 894L ),
   "No module to view since no file is loaded.",
   "HE_SRC_NO_LOADFILE",
   UNLOCKED
},
{
   "ER_SRC_NO_PATHS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 895L ),
   "No paths found. Load a file first.",
   "HE_SRC_NO_PATHS",
   UNLOCKED
},
{
   "ER_SRC_NO_VAR_SEL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 896L ),
   "No variable selected.",
   "HE_SRC_NO_VAR_SEL",
   UNLOCKED
},
{
   "ER_SRC_OPEN_FAIL",
   ( E_WARNING | 0L | 897L ),
   "Failed to open a new view of data source.",
   "HE_SRC_OPEN_FAIL",
   UNLOCKED
},
{
   "ER_SRC_REOPEN_FAIL",
   ( E_WARNING | 0L | 898L ),
   "Failed to reopen a data source.",
   "HE_SRC_REOPEN_FAIL",
   UNLOCKED
},
{
   "ER_SRC_START_OF_HISTORY",
   ( E_WARNING | 0L | 899L ),
   "Cannot back up in file browse history.",
   "HE_SRC_START_OF_HISTORY",
   UNLOCKED
},
{
   "ER_SRC_STEP_COUNT",
   ( E_WARNING | 0L | 900L ),
   "Invalid step count.",
   "HE_SRC_STEP_COUNT",
   UNLOCKED
},
{
   "ER_SRC_TAB_RANGE",
   ( E_WARNING | 0L | 901L ),
   "Tab width is out of range.",
   "HE_SRC_TAB_RANGE",
   UNLOCKED
},
{
   "ER_SRC_VIEW_ALREADY",
   ( E_WARNING | 0L | 902L ),
   "View mode already selected.",
   "HE_SRC_VIEW_ALREADY",
   UNLOCKED
},
{
   "ER_STACK_ALARM_LIM",
   ( E_INFORMATIVE | 0L | 903L ),
   "Stack alarm limit exceeded.",
   "HE_STACK_ALARM_LIM",
   UNLOCKED
},
{
   "ER_STACK_ALARM_RANGE",
   ( E_WARNING | 0L | 904L ),
   "Alarm limit is out of range.",
   "HE_STACK_ALARM_RANGE",
   UNLOCKED
},
{
   "ER_STACK_CRE",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 905L ),
   "Cannot register events for Stack.",
   "HE_STACK_CRE",
   UNLOCKED
},
{
   "ER_STACK_HW_DISABLED",
   ( E_WARNING | 0L | 906L ),
   "Stack high water measurement is disabled.",
   "HE_STACK_HW_DISABLED",
   UNLOCKED
},
{
   "ER_STACK_INVALID_SIZE",
   ( E_WARNING | 0L | 907L ),
   "Invalid stack size specified. Set to 1K.",
   "HE_STACK_INVALID_SIZE",
   UNLOCKED
},
{
   "ER_STACK_NO_CHILD",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 908L ),
   "Cannot create child objects to open the Stack.",
   "HE_STACK_NO_CHILD",
   UNLOCKED
},
{
   "ER_STACK_NO_POINTER",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 909L ),
   "Cannot get stack pointer to open Stack.",
   "HE_STACK_NO_POINTER",
   UNLOCKED
},
{
   "ER_STACK_NO_SESSION",
   ( E_SEVERE | 0L | 910L ),
   "Cannot open a stack session.",
   "HE_STACK_NO_SESSION",
   UNLOCKED
},
{
   "ER_STACK_NO_VAR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 911L ),
   "Cannot add variable to the Variable Window.",
   "HE_STACK_NO_VAR",
   UNLOCKED
},
{
   "ER_STACK_OVERFLOW",
   ( E_INFORMATIVE | 0L | 912L ),
   "Stack overflow.",
   "HE_STACK_OVERFLOW",
   UNLOCKED
},
{
   "ER_STACK_SIZE_0",
   ( E_FATAL | 0L | 913L ),
   "Stack Size is 0.",
   "HE_STACK_SIZE_0",
   UNLOCKED
},
{
   "ER_STACK_SIZE_MISSING",
   ( E_WARNING | 0L | 914L ),
   "Stack size missing.",
   "HE_STACK_SIZE_MISSING",
   UNLOCKED
},
{
   "ER_STACK_TOO_LARGE",
   ( E_WARNING | 0L | 915L ),
   "Requested stack size is too large. Set to 1K.",
   "HE_STACK_TOO_LARGE",
   UNLOCKED
},
{
   "ER_STACK_UNDERFLOW",
   ( E_INFORMATIVE | 0L | 916L ),
   "Stack underflow.",
   "HE_STACK_UNDERFLOW",
   UNLOCKED
},
{
   "ER_STEP_TIMEOUT",
   ( E_WARNING | 0L | 311L ),
   "Timed out waiting for single step.",
   "HE_STEP_TIMEOUT",
   LOCKED
},
{
   "ER_STK_CLI_REG_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 917L ),
   "Stack server registration with Shell failed.",
   "HE_STK_CLI_REG_FAILED",
   UNLOCKED
},
{
   "ER_STK_FILL_STACK_AREA",
   ( E_WARNING | 0L | 918L ),
   "Stack area will be filled with a pattern to enable HighWaterMark.",
   "HE_STK_FILL_STACK_AREA",
   UNLOCKED
},
{
   "ER_STK_FRAME_INVALID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 919L ),
   "Invalid stack frame.",
   "HE_STK_FRAME_INVALID",
   UNLOCKED
},
{
   "ER_STK_FRAME_NOT_OPENED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 920L ),
   "Requested frame not opened.",
   "HE_STK_FRAME_NOT_OPENED",
   UNLOCKED
},
{
   "ER_STK_FRAME_RELEASE_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 921L ),
   "Unable to release previous stack frames.",
   "HE_STK_FRAME_RELEASE_FAILED",
   UNLOCKED
},
{
   "ER_STK_INIT_STK_FAIL",
   ( E_WARNING | 0L | 922L ),
   "Cannot initialize stack area for HighWaterMark.",
   "HE_STK_INIT_STK_FAIL",
   UNLOCKED
},
{
   "ER_STK_INVALID_ALARM_LIMIT",
   ( E_WARNING | 0L | 923L ),
   "Invalid alarm limit.",
   "HE_STK_INVALID_ALARM_LIMIT",
   UNLOCKED
},
{
   "ER_STK_INVALID_DESCRIPTOR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 924L ),
   "Invalid stack descriptor.",
   "HE_STK_INVALID_DESCRIPTOR",
   UNLOCKED
},
{
   "ER_STK_INVALID_HWM",
   ( E_WARNING | 0L | 925L ),
   "Invalid high water mark.",
   "HE_STK_INVALID_HWM",
   UNLOCKED
},
{
   "ER_STK_INVALID_STK_SIZE",
   ( E_WARNING | 0L | 926L ),
   "Invalid stack size.",
   "HE_STK_INVALID_STK_SIZE",
   UNLOCKED
},
{
   "ER_STK_NO_FRAMES",
   ( E_WARNING | 0L | 927L ),
   "No stack frames available.",
   "HE_STK_NO_FRAMES",
   UNLOCKED
},
{
   "ER_STK_RANGE_TOO_LARGE",
   ( E_WARNING | 0L | 928L ),
   "Stack area specified is out of physical range. Stack size will be adjusted from %s bytes to %s bytes.",
   "HE_STK_RANGE_TOO_LARGE",
   UNLOCKED
},
{
   "ER_STK_RANGE_TOO_SMALL",
   ( E_WARNING | 0L | 929L ),
   "Stack area specified is out of physical range. Stack size will be adjusted from %s bytes to %s bytes.",
   "HE_STK_RANGE_TOO_SMALL",
   UNLOCKED
},
{
   "ER_STK_SEND_MESSAGE_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 930L ),
   "Cannot send message to Shell.",
   "HE_STK_SEND_MESSAGE_FAILED",
   UNLOCKED
},
{
   "ER_STK_SESSION_NAME_NOT_FOUND",
   ( E_WARNING | 0L | 931L ),
   "Stack session name not found.",
   "HE_STK_SESSION_NAME_NOT_FOUND",
   UNLOCKED
},
{
   "ER_STK_STK_BASE_INVALID",
   ( E_WARNING | 0L | 932L ),
   "Stack base unknown.",
   "HE_STK_STK_BASE_INVALID",
   UNLOCKED
},
{
   "ER_STORAGE_CLASS_UNKNOWN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 933L ),
   "The variable has an unknown storage class.",
   "HE_STORAGE_CLASS_UNKNOWN",
   UNLOCKED
},
{
   "ER_STRESSED_OUT_SRVR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 934L ),
   "Invalid format: The end length was saved with no starting address.",
   "HE_STRESSED_OUT_SRVR",
   UNLOCKED
},
{
   "ER_STRING_LENGTH_ZERO",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 935L ),
   "This function or feature is not yet implemented.",
   "HE_STRING_LENGTH_ZERO",
   UNLOCKED
},
{
   "ER_SWAT_ABORT",
   ( E_WARNING | 0L | 272L ),
   "SWAT operation aborted to change mode.",
   "HE_SWAT_ABORT",
   LOCKED
},
{
   "ER_SWAT_PA_OVERFLOW",
   ( E_WARNING | 0L | 271L ),
   "SWAT hardware overflowed, information is missing.",
   "HE_SWAT_PA_OVERFLOW",
   LOCKED
},
{
   "ER_SWAT_TIMEOUT",
   ( E_WARNING | 0L | 270L ),
   "SWAT not responding to commands.",
   "HE_SWAT_TIMEOUT",
   LOCKED
},
{
   "ER_SWAT_WRONG_MODE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 269L ),
   "Invalid operation attempted for current mode.",
   "HE_SWAT_WRONG_MODE",
   LOCKED
},
{
   "ER_SYMBASE",
   ( E_FATAL | 0L | 936L ),
   "Cannot set section base in symbol table.",
   "HE_SYMBASE",
   UNLOCKED
},
{
   "ER_SYMBOLS_LOADED",
   ( E_WARNING | 0L | 937L ),
   "Symbols already loaded.",
   "HE_SYMBOLS_LOADED",
   UNLOCKED
},
{
   "ER_SYMBOL_HAS_NO_CHILD",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 938L ),
   "Expected symbol to have a nested function or block.",
   "HE_SYMBOL_HAS_NO_CHILD",
   UNLOCKED
},
{
   "ER_SYMBOL_HAS_NO_LISTS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 939L ),
   "Expected symbol to contain variables, labels, or constants.",
   "HE_SYMBOL_HAS_NO_LISTS",
   UNLOCKED
},
{
   "ER_SYMBOL_NOT_A_FUNCTION",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 940L ),
   "Expected a function type symbol.",
   "HE_SYMBOL_NOT_A_FUNCTION",
   UNLOCKED
},
{
   "ER_SYMBOL_NOT_A_LABEL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 941L ),
   "Symbol is not a label.",
   "HE_SYMBOL_NOT_A_LABEL",
   UNLOCKED
},
{
   "ER_SYMBOL_NOT_A_MODULE",
   ( E_WARNING | 0L | 942L ),
   "No symbols are loaded.",
   "HE_SYMBOL_NOT_A_MODULE",
   UNLOCKED
},
{
   "ER_SYMBOL_NOT_FOUND",
   ( E_WARNING | 0L | 943L ),
   "Cannot find symbol.",
   "HE_SYMBOL_NOT_FOUND",
   UNLOCKED
},
{
   "ER_SYMBOL_STACK_EMPTY",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 944L ),
   "When loading modules, functions, and/or blocks, more closes than opens occurred.",
   "HE_SYMBOL_STACK_EMPTY",
   UNLOCKED
},
{
   "ER_SYM_ALREADY",
   ( E_WARNING | 0L | 945L ),
   "Symbols already loaded, reload?",
   "HE_SYM_ALREADY",
   UNLOCKED
},
{
   "ER_SYM_ALREADY_CLI",
   ( E_WARNING | 0L | 946L ),
   "Symbols already loaded, specify 'reload' option.",
   "HE_SYM_ALREADY_CLI",
   UNLOCKED
},
{
   "ER_SYM_INVALID_CHAR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 947L ),
   "Invalid character.",
   "HE_SYM_INVALID_CHAR",
   UNLOCKED
},
{
   "ER_SYM_INVALID_LN_END_ADDR",
   ( E_WARNING | 0L | 948L ),
   "No symbol information available about source modules.",
   "HE_SYM_INVALID_LN_END_ADDR",
   UNLOCKED
},
{
   "ER_SYM_LOCAL_VAR_ADDRESS",
   ( E_WARNING | 0L | 949L ),
   "Symbol is a local variable, thus it does not have a static address.",
   "HE_SYM_LOCAL_VAR_ADDRESS",
   UNLOCKED
},
{
   "ER_SYM_LOOP_COMPLETE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 950L ),
   "Loop complete.",
   "HE_SYM_LOOP_COMPLETE",
   UNLOCKED
},
{
   "ER_SYM_NOT_CODE_ADDRESS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 951L ),
   "Attempted to put a zero length string into the symbol table.",
   "HE_SYM_NOT_CODE_ADDRESS",
   UNLOCKED
},
{
   "ER_SYM_NOT_DATA_ADDRESS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 952L ),
   "Cannot increase the table size; out of memory.",
   "HE_SYM_NOT_DATA_ADDRESS",
   UNLOCKED
},
{
   "ER_SYM_NOT_UPDATED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 953L ),
   "Cannot update symbol address range.",
   "HE_SYM_NOT_UPDATED",
   UNLOCKED
},
{
   "ER_SYM_NO_CURRENT_CONTEXT",
   ( E_WARNING | 0L | 954L ),
   "The current execution context does not match any known module.",
   "HE_SYM_NO_CURRENT_CONTEXT",
   UNLOCKED
},
{
   "ER_SYM_NO_FUNCTION_MATCH",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 955L ),
   "No function matched.",
   "HE_SYM_NO_FUNCTION_MATCH",
   UNLOCKED
},
{
   "ER_SYM_NO_MODULES_LOADED",
   ( E_FATAL | E_WARNING | 0L | 956L ),
   "No source module(s) loaded.",
   "HE_SYM_NO_MODULES_LOADED",
   UNLOCKED
},
{
   "ER_SYM_OUT_OF_MEMORY",
   ( E_FATAL | 0L | 957L ),
   "Out of memory.",
   "HE_SYM_OUT_OF_MEMORY",
   UNLOCKED
},
{
   "ER_SYM_REG_VAR_NOT_ALLOWED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 958L ),
   "A public variable cannot be a register.",
   "HE_SYM_REG_VAR_NOT_ALLOWED",
   UNLOCKED
},
{
   "ER_SYM_SEND_MESSAGE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 959L ),
   "SendMessage error.",
   "HE_SYM_SEND_MESSAGE",
   UNLOCKED
},
{
   "ER_SYM_STACK_FULL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 960L ),
   "The number of nested functions and/or blocks exceeded internal limit.",
   "HE_SYM_STACK_FULL",
   UNLOCKED
},
{
   "ER_SYM_SYMBOL_NOT_IN_MODULE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 961L ),
   "Cannot sort symbols by address, none loaded into the symbol table.",
   "HE_SYM_SYMBOL_NOT_IN_MODULE",
   UNLOCKED
},
{
   "ER_SYM_SYM_START_NOT_SHARP",
   ( E_WARNING | 0L | 962L ),
   "Invalid symbol address type.",
   "HE_SYM_SYM_START_NOT_SHARP",
   UNLOCKED
},
{
   "ER_SYM_TYPE",
   ( E_WARNING | 0L | 963L ),
   "Cannot create symbol type: %s.",
   "HE_SYM_TYPE",
   UNLOCKED
},
{
   "ER_TABLE_SMALLER_THAN_INDEX",
   ( E_WARNING | 0L | 964L ),
   "Symbol not located in table - base index too large.",
   "HE_TABLE_SMALLER_THAN_INDEX",
   UNLOCKED
},
{
   "ER_TASK_DONE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 250L ),
   "Unable to terminate the requested task.",
   "HE_TASK_DONE",
   LOCKED
},
{
   "ER_TASK_NOT_IN_TABLE",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 24L ),
   "Task not in task table.",
   "HE_TASK_NOT_IN_TABLE",
   LOCKED
},
{
   "ER_TASK_TABLE_FULL",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 26L ),
   "No room for additional tasks in task table.",
   "HE_TASK_TABLE_FULL",
   LOCKED
},
{
   "ER_TCB",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 181L ),
   "No TCBs are available.",
   "HE_TCB",
   LOCKED
},
{
   "ER_TEMPLATE_NAME_TOO_LONG",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 965L ),
   "New template name is too long.",
   "HE_TEMPLATE_NAME_TOO_LONG",
   UNLOCKED
},
{
   "ER_TID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 180L ),
   "Invalid task ID entered.",
   "HE_TID",
   LOCKED
},
{
   "ER_TIMED_OUT",
   ( E_SEVERE | 0L | 4L ),
   "Timed out waiting for hardware to respond.",
   "HE_TIMED_OUT",
   LOCKED
},
{
   "ER_TIMER_NOT_AVAIL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 244L ),
   "The timer is not available for use.",
   "HE_TIMER_NOT_AVAIL",
   LOCKED
},
{
   "ER_TIMESTAMPS_DONT_MATCH",
   ( E_WARNING | 0L | 966L ),
   "The load file time stamp does not match previously loaded file's time stamp.",
   "HE_TIMESTAMPS_DONT_MATCH",
   UNLOCKED
},
{
   "ER_TMO",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 189L ),
   "Timeout encountered.",
   "HE_TMO",
   LOCKED
},
{
   "ER_TOOL_NAME_TOO_LONG",
   ( E_WARNING | 0L | 967L ),
   "Compiler name too long.",
   "HE_TOOL_NAME_TOO_LONG",
   UNLOCKED
},
{
   "ER_TOOMANY_SEC",
   ( E_WARNING | 0L | 968L ),
   "Maximum number of sections reached; the rest will be ignored.",
   "HE_TOOMANY_SEC",
   UNLOCKED
},
{
   "ER_TOO_MANY_EVENTS",
   ( E_WARNING | 0L | 969L ),
   "Cannot create any more events.",
   "HE_TOO_MANY_EVENTS",
   UNLOCKED
},
{
   "ER_TOO_MANY_FIELDS",
   ( E_WARNING | 0L | 970L ),
   "Too many template fields for one line.",
   "HE_TOO_MANY_FIELDS",
   UNLOCKED
},
{
   "ER_TOO_MANY_FRAMES",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 438L ),
   "Too many frames requested.",
   "HE_TOO_MANY_FRAMES",
   LOCKED
},
{
   "ER_TOO_MANY_PAIRS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 971L ),
   "Too many register pairs.",
   "HE_TOO_MANY_PAIRS",
   UNLOCKED
},
{
   "ER_TOO_MANY_SYMBOLS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 972L ),
   "Too many symbols in base.",
   "HE_TOO_MANY_SYMBOLS",
   UNLOCKED
},
{
   "ER_TOO_MANY_TEMPLATES",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 973L ),
   "No more templates can be defined.",
   "HE_TOO_MANY_TEMPLATES",
   UNLOCKED
},
{
   "ER_TOO_MANY_XBRKS",
   ( E_WARNING | 0L | 308L ),
   "The number of hardware breakpoints exceeds capability.",
   "HE_TOO_MANY_XBRKS",
   LOCKED
},
{
   "ER_TRACE_DATA",
   ( E_WARNING | 0L | 974L ),
   "No trace collected in the next trace buffer.",
   "HE_TRACE_DATA",
   UNLOCKED
},
{
   "ER_TRACE_DISABLE_CURS",
   ( E_WARNING | 0L | 975L ),
   "Disabling linked cursor.",
   "HE_TRACE_DISABLE_CURS",
   UNLOCKED
},
{
   "ER_TRACE_TRIG_ON",
   ( E_WARNING | 0L | 976L ),
   "Cannot change trigger while tracing and/or sequencer is enabled.",
   "HE_TRACE_TRIG_ON",
   UNLOCKED
},
{
   "ER_TRACING_ON",
   ( E_WARNING | 0L | 977L ),
   "Cannot change an event used by trigger while trace is on.",
   "HE_TRACING_ON",
   UNLOCKED
},
{
   "ER_TRIGGER_ABORTED",
   ( E_WARNING | 0L | 436L ),
   "Trigger programming aborted.",
   "HE_TRIGGER_ABORTED",
   LOCKED
},
{
   "ER_TRIGGER_USING_EVENT",
   ( E_WARNING | 0L | 978L ),
   "Cannot change an event used by trigger while emulating.",
   "HE_TRIGGER_USING_EVENT",
   UNLOCKED
},
{
   "ER_TYPE_IDXS_DONT_MATCH",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 979L ),
   "Type index does not match.",
   "HE_TYPE_IDXS_DONT_MATCH",
   UNLOCKED
},
{
   "ER_TYPE_TOO_LARGE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 980L ),
   "Symbol type information too large.",
   "HE_TYPE_TOO_LARGE",
   UNLOCKED
},
{
   "ER_UART_INTERNAL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 294L ),
   "ER_UART_INTERNAL.",
   "HE_UART_INTERNAL",
   LOCKED
},
{
   "ER_UNEXPECTED_END",
   ( E_WARNING | 0L | 981L ),
   "Unexpected end-of-file.",
   "HE_UNEXPECTED_END",
   UNLOCKED
},
{
   "ER_UNEXPECTED_TYPE",
   ( E_FATAL | E_WARNING | 0L | 982L ),
   "Unexpected type: %s.",
   "HE_UNEXPECTED_TYPE",
   UNLOCKED
},
{
   "ER_UNK",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 240L ),
   "An unknown extension call was requested.",
   "HE_UNK",
   LOCKED
},
{
   "ER_UNKNOWN",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 983L ),
   "Unidentified error opening comm port.",
   "HE_UNKNOWN",
   UNLOCKED
},
{
   "ER_UNKNOWN_EVENT",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 984L ),
   "Application received unknown event: %s.",
   "HE_UNKNOWN_EVENT",
   UNLOCKED
},
{
   "ER_UNKNOWN_LIST_TYPE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 985L ),
   "Unknown symbol list.",
   "HE_UNKNOWN_LIST_TYPE",
   UNLOCKED
},
{
   "ER_UNKNOWN_LOAD_COMMAND",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 445L ),
   "Unknown load command.",
   "HE_UNKNOWN_LOAD_COMMAND",
   LOCKED
},
{
   "ER_UNKNOWN_XILINX",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 268L ),
   "Invalid Xilinx chip.",
   "HE_UNKNOWN_XILINX",
   LOCKED
},
{
   "ER_UNRECOGNIZED_BLK",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 986L ),
   "Unrecognized block.",
   "HE_UNRECOGNIZED_BLK",
   UNLOCKED
},
{
   "ER_UNRECOGNIZED_SEC",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 987L ),
   "Unrecognized section type.",
   "HE_UNRECOGNIZED_SEC",
   UNLOCKED
},
{
   "ER_UNRECOG_LFILE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 988L ),
   "Unrecognized file format.",
   "HE_UNRECOG_LFILE",
   UNLOCKED
},
{
   "ER_UPD",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 237L ),
   "The specified process ID is unknown.",
   "HE_UPD",
   LOCKED
},
{
   "ER_UPDATE_BLOCK_FAIL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 989L ),
   "Cannot update last symbol block.",
   "HE_UPDATE_BLOCK_FAIL",
   UNLOCKED
},
{
   "ER_USER_ABORT",
   ( E_WARNING | 0L | 990L ),
   "User abort requested.",
   "HE_USER_ABORT",
   UNLOCKED
},
{
   "ER_USE_SET_START",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 991L ),
   "Use set-start routine for range fields.",
   "HE_USE_SET_START",
   UNLOCKED
},
{
   "ER_VAR_CANT_FIND_FUN",
   ( E_WARNING | 0L | 992L ),
   "Cannot find function: %s.",
   "HE_VAR_CANT_FIND_FUN",
   UNLOCKED
},
{
   "ER_VAR_CANT_FIND_MOD",
   ( E_WARNING | 0L | 993L ),
   "Cannot find module: %s.",
   "HE_VAR_CANT_FIND_MOD",
   UNLOCKED
},
{
   "ER_VAR_CANT_FIND_VAR",
   ( E_WARNING | 0L | 994L ),
   "Cannot find variable: %s.",
   "HE_VAR_CANT_FIND_VAR",
   UNLOCKED
},
{
   "ER_VAR_CANT_OPEN_SESSION",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 995L ),
   "Cannot open session with Variable Server.",
   "HE_VAR_CANT_OPEN_SESSION",
   UNLOCKED
},
{
   "ER_VAR_END_PROB",
   ( E_WARNING | 0L | 996L ),
   "Symbols cannot end with #.",
   "HE_VAR_END_PROB",
   UNLOCKED
},
{
   "ER_VAR_HIGHLIGHT",
   ( E_WARNING | 0L | 997L ),
   "Select highlighted text.",
   "HE_VAR_HIGHLIGHT",
   UNLOCKED
},
{
   "ER_VAR_IS_AT_ADDR",
   ( E_INFORMATIVE | 0L | 998L ),
   "Variable: %s is at address %s.",
   "HE_VAR_IS_AT_ADDR",
   UNLOCKED
},
{
   "ER_VAR_NO_DEL_SEL",
   ( E_WARNING | 0L | 999L ),
   "No selected variable to delete.",
   "HE_VAR_NO_DEL_SEL",
   UNLOCKED
},
{
   "ER_VAR_NO_UNDO",
   ( E_WARNING | 0L | 1000L ),
   "No more variables to undo.",
   "HE_VAR_NO_UNDO",
   UNLOCKED
},
{
   "ER_VAR_NO_VIEWS",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1001L ),
   "No more variable views to restore.",
   "HE_VAR_NO_VIEWS",
   UNLOCKED
},
{
   "ER_VAR_UNKNOWN_ADDR",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1002L ),
   "Variable: %s address unknown.",
   "HE_VAR_UNKNOWN_ADDR",
   UNLOCKED
},
{
   "ER_VAR_UNKNOWN_SORT_TYPE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1003L ),
   "Unknown sorting type: %s.",
   "HE_VAR_UNKNOWN_SORT_TYPE",
   UNLOCKED
},
{
   "ER_VPROF_NOT_INSTALLED",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 23L ),
   "Windows profiler not installed.  Add device=vprod.386 to [386enh] section of system.ini.",
   "HE_VPROF_NOT_INSTALLED",
   LOCKED
},
{
   "ER_VRTX_INIT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 246L ),
   "Failed to initialize the operating system.",
   "HE_VRTX_INIT",
   LOCKED
},
{
   "ER_VS_ACCESS_DENIED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1004L ),
   "Access denied to the requested variable.",
   "HE_VS_ACCESS_DENIED",
   UNLOCKED
},
{
   "ER_VS_ADDRESS_ACCESS_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1005L ),
   "Failed to access the address server.",
   "HE_VS_ADDRESS_ACCESS_FAILED",
   UNLOCKED
},
{
   "ER_VS_ANONYMOUS_CLIENT_ACTIVE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1006L ),
   "An anonymous caller is already active.",
   "HE_VS_ANONYMOUS_CLIENT_ACTIVE",
   UNLOCKED
},
{
   "ER_VS_ARRAY_MAPADDR_FAIL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1007L ),
   "Failed to map variable to address.",
   "HE_VS_ARRAY_MAPADDR_FAIL",
   UNLOCKED
},
{
   "ER_VS_BUFNUM_INVALID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1008L ),
   "The requested buffer is invalid.",
   "HE_VS_BUFNUM_INVALID",
   UNLOCKED
},
{
   "ER_VS_CLIENT_DISCREP",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1009L ),
   "The caller is not registered with the Variable Server.",
   "HE_VS_CLIENT_DISCREP",
   UNLOCKED
},
{
   "ER_VS_CLI_REG_FAILED",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1010L ),
   "The Variable Server failed to register with Shell.",
   "HE_VS_CLI_REG_FAILED",
   UNLOCKED
},
{
   "ER_VS_CLI_VAR_NOT_FOUND",
   ( E_WARNING | 0L | 1011L ),
   "The variable was not found in Shell.",
   "HE_VS_CLI_VAR_NOT_FOUND",
   UNLOCKED
},
{
   "ER_VS_CPU_ACCESS_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1012L ),
   "Failed to access the cpu server.",
   "HE_VS_CPU_ACCESS_FAILED",
   UNLOCKED
},
{
   "ER_VS_DOUBLE_EDIT_FAIL",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1013L ),
   "Unable to edit double type values in registers.",
   "HE_VS_DOUBLE_EDIT_FAIL",
   UNLOCKED
},
{
   "ER_VS_EVENT_ACCESS_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1014L ),
   "Failed to access the event server.",
   "HE_VS_EVENT_ACCESS_FAILED",
   UNLOCKED
},
{
   "ER_VS_FUNCNAME_NOT_FOUND",
   ( E_WARNING | 0L | 1015L ),
   "Function name not found.",
   "HE_VS_FUNCNAME_NOT_FOUND",
   UNLOCKED
},
{
   "ER_VS_INVALID_EDITFIELDCHAROFFSET",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1016L ),
   "Invalid edit-field character offset entered.",
   "HE_VS_INVALID_EDITFIELDCHAROFFSET",
   UNLOCKED
},
{
   "ER_VS_LINENUM_INVALID",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1017L ),
   "The requested line is invalid.",
   "HE_VS_LINENUM_INVALID",
   UNLOCKED
},
{
   "ER_VS_LONG_OVERFLOW",
   ( E_WARNING | 0L | 1018L ),
   "Invalid value: signed long int value must be -2147483648 to 2147483647.",
   "HE_VS_LONG_OVERFLOW",
   UNLOCKED
},
{
   "ER_VS_MEMORY_ACCESS_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1019L ),
   "Failed to access the memory server.",
   "HE_VS_MEMORY_ACCESS_FAILED",
   UNLOCKED
},
{
   "ER_VS_MODULENAME_NOT_FOUND",
   ( E_WARNING | 0L | 1020L ),
   "Module name not found.",
   "HE_VS_MODULENAME_NOT_FOUND",
   UNLOCKED
},
{
   "ER_VS_NAME_NOT_VARIABLE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1021L ),
   "This is not a variable.",
   "HE_VS_NAME_NOT_VARIABLE",
   UNLOCKED
},
{
   "ER_VS_NO_SPACE_TABLE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1022L ),
   "The variable table is full.",
   "HE_VS_NO_SPACE_TABLE",
   UNLOCKED
},
{
   "ER_VS_RANGE",
   ( E_FATAL | 0L | 1023L ),
   "Specified line number is out of range.",
   "HE_VS_RANGE",
   UNLOCKED
},
{
   "ER_VS_SEND_MESSAGE_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1024L ),
   "The Variable Server failed to send message to Shell.",
   "HE_VS_SEND_MESSAGE_FAILED",
   UNLOCKED
},
{
   "ER_VS_SHORT_OVERFLOW",
   ( E_WARNING | 0L | 1025L ),
   "Invalid value: signed short int value must be -32768 to 32767.",
   "HE_VS_SHORT_OVERFLOW",
   UNLOCKED
},
{
   "ER_VS_STACK_ACCESS_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1026L ),
   "Failed to access the stack server.",
   "HE_VS_STACK_ACCESS_FAILED",
   UNLOCKED
},
{
   "ER_VS_SYMBOL_ACCESS_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1027L ),
   "Failed to access the symbol table.",
   "HE_VS_SYMBOL_ACCESS_FAILED",
   UNLOCKED
},
{
   "ER_VS_SYSTEM_ACCESS_FAILED",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1028L ),
   "Failed to access the system.",
   "HE_VS_SYSTEM_ACCESS_FAILED",
   UNLOCKED
},
{
   "ER_VS_ULONG_OVERFLOW",
   ( E_WARNING | 0L | 1029L ),
   "Invalid value: unsigned long int value must be 0 to 4294967295.",
   "HE_VS_ULONG_OVERFLOW",
   UNLOCKED
},
{
   "ER_VS_USHORT_OVERFLOW",
   ( E_WARNING | 0L | 1030L ),
   "Invalid value: unsigned short int value must be 0 to 65535.",
   "HE_VS_USHORT_OVERFLOW",
   UNLOCKED
},
{
   "ER_VS_VALU_EDIT_FAIL",
   ( E_WARNING | 0L | 1031L ),
   "The attempt to edit the value has failed.",
   "HE_VS_VALU_EDIT_FAIL",
   UNLOCKED
},
{
   "ER_VS_VARNAME_NOT_FOUND",
   ( E_WARNING | 0L | 1032L ),
   "Variable name not found.",
   "HE_VS_VARNAME_NOT_FOUND",
   UNLOCKED
},
{
   "ER_VS_VAR_NOT_FOUND",
   ( E_WARNING | 0L | 1033L ),
   "Variable not found.",
   "HE_VS_VAR_NOT_FOUND",
   UNLOCKED
},
{
   "ER_WAIT_BDM_TIMEOUT",
   ( E_WARNING | 0L | 421L ),
   "Violated system map.",
   "HE_WAIT_BDM_TIMEOUT",
   LOCKED
},
{
   "ER_WAIT_EMOFF_TIMEOUT",
   ( E_WARNING | 0L | 310L ),
   "Timed out waiting for emulation to stop. Do you want to halt EP nonmaskably",
   "HE_WAIT_EMOFF_TIMEOUT",
   LOCKED
},
{
   "ER_WINDOWS_MEMLOCK",
   ( INTERNAL_ERROR_ON | 0L | 1034L ),
   "Windows Memory Locked.",
   "HE_WINDOWS_MEMLOCK",
   UNLOCKED
},
{
   "ER_WRITING_FILE",
   ( E_WARNING | 0L | 1035L ),
   "Cannot write file.",
   "HE_WRITING_FILE",
   UNLOCKED
},
{
   "ER_WTC",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 187L ),
   "WAITC in progress.",
   "HE_WTC",
   LOCKED
},
{
   "ER_XILINX_BITS_OVERFLOW",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1036L ),
   "Bad bit information for template field.",
   "HE_XILINX_BITS_OVERFLOW",
   UNLOCKED
},
{
   "ER_XILINX_PROGRAMMING",
   ( E_WARNING | 0L | 267L ),
   "Cannot configure the probe hardware.",
   "HE_XILINX_PROGRAMMING",
   LOCKED
},
{
   "ER_ZMW",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 185L ),
   "Zero message.",
   "HE_ZMW",
   LOCKED
},
{
   "ER_DAD_BAD_FW_LINES",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1037L ),
   "First frame is not a timestamp marker.",
   "HE_DAD_BAD_FW_LINES",
   UNLOCKED
},
{
   "ER_MARKER_PEND_TIMEOUT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 447L ),
   "Timeout waiting for dequeuer marking.",
   "HE_MARKER_PEND_TIMEOUT",
   LOCKED
},
{
   "ER_INTERNAL_DQ_LINEUP",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 448L ),
   "Dequeuer cannot find start of bus cycle.",
   "HE_INTERNAL_DQ_LINEUP",
   LOCKED
},
{
   "ER_BAD_FREQUENCY",
   ( E_WARNING | 0L | 1038L ),
   "Invalid clock frequency.  Valid range ( 40MHz <--> .01Hz)",
   "HE_BAD_FREQUENCY",
   UNLOCKED
},
{
   "ER_BAD_TRACE_INFO",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1039L ),
   "Firmware returned invalid trace information.",
   "HE_BAD_TRACE_INFO",
   UNLOCKED
},
{
   "ER_ETHERNET_NOT_SUPPORTED",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1040L ),
   "Ethernet is not yet supported.",
   "HE_ETHERNET_NOT_SUPPORTED",
   UNLOCKED
},
{
   "ER_LOADFILE_HAD_INCOMPATIBLE_TOOLCHAIN",
   ( E_WARNING | 0L | 1041L ),
   "Loadfile compiled using %s tool is incompatible with current Compiler Used: %s.  Continue?",
   "HE_LOADFILE_HAD_INCOMPATIBLE_TOOLCHAIN",
   UNLOCKED
},
{
   "ER_SRC_MODULE_HAS_NO_ADDR_RANGE",
   ( E_WARNING | 0L | 1042L ),
   "Module does not have address range. Unable to view source.",
   "HE_SRC_MODULE_HAS_NO_ADDR_RANGE",
   UNLOCKED
},
{
   "ER_UNKNOWN_FWREF_TYPE",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1043L ),
   "Unknown forward reference type.",
   "HE_UNKNOWN_FWREF_TYPE",
   UNLOCKED
},
{
   "ER_NO_LINEBLK_IN_MODULE",
   ( E_WARNING | 0L | 1044L ),
   "Module %s does not contain line number information.",
   "HE_NO_LINEBLK_IN_MODULE",
   UNLOCKED
}
,{
   "ER_PP_READING_REG",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1045L ),
   "Peripheral Presenter: Error Reading Register %s.",
   "HE_PP_READING_REG",
   UNLOCKED
}
,{
   "ER_PP_READING_GROUP",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1046L ),
   "Peripheral Presenter: Error Reading Group %s.",
   "HE_PP_READING_GROUP",
   UNLOCKED
}
,{
   "ER_PP_READING_FIELD",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1047L ),
   "Peripheral Presenter: Error Reading Field %s.",
   "HE_PP_READING_FIELD",
   UNLOCKED
}
,{
   "ER_PP_OPEN_CFG_FAIL",
   ( E_SEVERE | 0L | 1049L ),
   "Unable to open peripheral configuration file: %s.",
   "HE_PP_OPEN_CFG_FAIL",
   UNLOCKED
}
,{
   "ER_PP_CORRUPT_CFG_FILE",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1050L ),
   "Corrupted peripheral configuration file found - %s.",
   "HE_PP_CORRUPT_CFG_FILE",
   UNLOCKED
}
,{
   "ER_PP_CLOSE_CFG_FAIL",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1051L ),
   "Unable to close peripheral configuration file: %s.",
   "HE_PP_CLOSE_CFG_FAIL",
   UNLOCKED
}
,{
   "ER_PP_CFG_FILE_NOT_FOUND",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1053L ),
   "Peripheral configuration file not found.",
   "HE_PP_CFG_FILE_NOT_FOUND",
   UNLOCKED
}
,{
   "ER_PP_INVALID_VALUE",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1055L ),
   "Attempted to edit register with an invalid value.",
   "HE_PP_INVALID_VALUE",
   UNLOCKED
}
,{
   "ER_PP_UNEXPECTED_END_CFG",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1056L ),
   "Encountered peripheral configuration EOF.",
   "HE_PP_UNEXPECTED_END_CFG",
   UNLOCKED
}
,{
   "ER_PP_INVALID_BASE",
   ( E_SEVERE | 0L | 1057L ),
   "Location of peripheral block is indeterminate.  Use shell command 'write 0x3ff00 0xffff0001 long cpu' (for example)",
   "HE_PP_INVALID_BASE",
   UNLOCKED
}
,{
   "ER_PP_WIN_CREATE_FAIL",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1058L ),
   "Peripheral window creation failed.",
   "HE_PP_WIN_CREATE_FAIL",
   UNLOCKED
}
,{
   "ER_PP_OLD_VERSION",
   ( E_SEVERE | 0L | 1063L ),
   "Peripheral configuration file version is newer than this version of MICEpack/SLD can read.",
   "HE_PP_OLD_VERSION",
   UNLOCKED
},
{
   "ER_NET_PROFILE_MISSING",
   ( E_FATAL | 0L | 1070L ),
   "Unable to access communication type.",
   "HE_NET_PROFILE_MISSING",
// Unable to access communication type information in MICEPACK.INI file.
   UNLOCKED
},
{
   "ER_NET_NOT_NETWORK",
   ( E_FATAL | 0L | 1071L ),
   "Network communication style not selected.",
   "HE_NET_NOT_NETWORK",
// The communication style contained in MICEPACK.INI, application "[Comm]",
// key "type", is not set to "network".
   UNLOCKED
},
{
   "ER_NET_HOST_NAMES_NOT_FOUND",
   ( E_FATAL | 0L | 1072L ),
   "Unable to find network emulator host names.",
   "HE_NET_HOST_NAMES_NOT_FOUND",
// Unable to locate the list of network emulators in MICEPACK.INI.  Refer to
// application "[Network]", key "emulators".
   UNLOCKED
},
{
   "ER_NET_HOST_SELECT_DIALOG",
   ( INTERNAL_ERROR_ON | E_FATAL | 0L | 1073L ),
   "Unable to create host selection dialog.",
   "HE_NET_HOST_SELECT_DIALOG",
// Failure during creation of host selection dialog.
   UNLOCKED
},
{
   "ER_PCNFS_NOT_RUNNING",
   ( E_FATAL | 0L | 1074L ),
   "PC-NFS is not resident.",
   "HE_PCNFS_NOT_RUNNING",
// PC-NFS must be installed and resident for MICEpack/SLD network communications.
// Verify that PC-NFS is properly installed.
   UNLOCKED
},
{
   "ER_PCNFS_RTM_NOT_RESIDENT",
   ( E_FATAL | 0L | 1075L ),
   "PC-NFS RTM is not resident.",
   "HE_PCNFS_RTM_NOT_RESIDENT",
// The PC-NFS Resident Transport Module (RTM) must be installed and resident.
// Verify that PC-NFS is properly installed.
   UNLOCKED
},
{
   "ER_PCNFS_TKDLL_NOT_FOUND",
   ( E_FATAL | 0L | 1076L ),
   "PC-NFS TKLIB.DLL is not accessible.",
   "HE_PCNFS_TKDLL_NOT_FOUND",
// The PC-NFS toolkit library TKLIB.DLL is not accessible.
// Verify that PC-NFS is properly installed.
   UNLOCKED
},
{
   "ER_PCNFS_RNM_NOT_FOUND",
   ( E_FATAL | 0L | 1077L ),
   "PC-NFS RNM.DLL is not accessible.",
   "HE_PCNFS_RNM_NOT_FOUND",
// The PC-NFS Resident Name Service Module (RNM) RNM.DLL is not accessible.
// Verify that PC-NFS is properly installed.
   UNLOCKED
},
{
   "ER_NET_COMM_ENDPOINT",
   ( INTERNAL_ERROR_ON | E_FATAL | 0L | 1078L ),
   "Failed to establish communication endpoint.",
   "ER_NET_COMM_ENDPOINT",
// Unable to establish communication with the emulator due to the inability
// to create a communication endpoint on the host.
   UNLOCKED
},
{
   "ER_NET_EMULATOR_INFO",
   ( INTERNAL_ERROR_ON | E_FATAL | 0L | 1079L ),
   "Unable to access emulator address information.",
   "HE_NET_EMULATOR_INFO",
// Unable to establish communication with the emulator due to the inability
// to access emulator's addressing information.
   UNLOCKED
},
{
   "ER_NET_CONNECT",
   ( E_WARNING | 0L | 1080L ),
   "Unable to establish network connection.",
   "HE_NET_CONNECT",
   UNLOCKED
// Attempt to establish network connection with the emulator failed.
},
{
   "ER_NET_CONNECT_TIMEOUT",
   ( E_WARNING | 0L | 1081L ),
   "Network connection timed out.",
   "HE_NET_CONNECT_TIMEOUT",
   UNLOCKED
// Attempt to establish network connection with the emulator timed out.
},
{
   "ER_NET_HOST_INFO",
   ( E_WARNING | 0L | 1082L ),
   "Unable to access host addressing information.",
   "HE_NET_HOST_INFO",
// Unable to access host's addressing information.
   UNLOCKED
},
{
   "ER_NET_EMULATOR_IN_USE",
   ( E_SEVERE | 0L | 1083L ),
   "The emulator is currently in use.",
   "HE_NET_EMULATOR_IN_USE",
   UNLOCKED
},
{
   "ER_NET_READ",
   ( E_SEVERE | 0L | 1084L ),
   "Network read operation failed.",
   "HE_NET_READ",
// The read operation failed.
   UNLOCKED
},
{
   "ER_NET_WRITE",
   ( E_SEVERE | 0L | 1085L ),
   "Network write operation failed.",
   "HE_NET_WRITE",
// The write operation failed.
   UNLOCKED
},
{
   "ER_NET_CLOSE",
   ( E_SEVERE | 0L | 1086L ),
   "Network close operation failed.",
   "HE_NET_CLOSE",
// The close operation failed.
   UNLOCKED
},
{
   "ER_NET_READ_TIMEOUT",
   ( E_SEVERE | 0L | 1087L ),
   "Network read operation timed out.",
   "HE_NET_READ_TIMEOUT",
   UNLOCKED
// Network read operation timed out.
},
{
   "ER_IPIPE_NOT_FUNC",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 449L ),
   "IPIPE1 pin not functioning correctly.",
   "HE_IPIPE_NOT_FUNC",
   LOCKED
// The IPIPE1 pin must be mapped to alternate signal function
// With the IPIPE1 signal not functioning as IPIPE1 dequeuer can't
// decode the instruction prefetch sequence.
},
{
   "ER_POD_VERSION",
   ( E_WARNING | 0L | 450L ),
   "Invalid pod version.",
   "HE_POD_VERSION",
   LOCKED
// The version number in the pod nvram is too low.
},
{
   "ER_ICE_MODE_TIMEOUT",
   ( E_WARNING | 0L | 451L ),
   "Timeout waiting for processor to enter ice mode.",
   "HE_ICE_MODE_TIMEOUT",
   LOCKED
},
{
   "ER_ICE_CMD_TIMEOUT",
   ( E_WARNING | 0L | 452L ),
   "Timeout waiting for processor to respond to commands.",
   "HE_ICE_CMD_TIMEOUT",
   LOCKED
},
{
   "ER_ICE_BKPT_TIMEOUT",
   ( E_WARNING | 0L | 453L ),
   "Timeout waiting for processor to process breakpoint.",
   "HE_ICE_BKPT_TIMEOUT",
   LOCKED
},
{
   "ER_ILL_MAP_CONTENT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 454L ),
   "Overlay map contains illegal data.",
   "HE_ILL_MAP_CONTENT",
   LOCKED
},
{
   "ER_ILL_MAP_PROTECT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 455L ),
   "Illegal map protection option detected.",
   "HE_ILL_MAP_PROTECT",
   LOCKED
},
{
   "ER_INSUF_MAP_BLOCKS",
   ( E_WARNING | 0L | 456L ),
   "Insufficient overlay memory.",
   "HE_INSUF_MAP_BLOCKS",
   LOCKED
},
{
   "ER_MAP_LIST_CORRUPT",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 457L ),
   "Map block list has been corrupted.",
   "HE_MAP_LIST_CORRUPT",
   LOCKED
},
{
   "ER_TARGET_CONNECT",
   ( E_WARNING | 0L | 458L ),
   "Emulation adapter is not connected properly to target.",
   "HE_TARGET_CONNECT",
   LOCKED
},
{
   "ER_TARGET_FLT",
   ( E_WARNING | 0L | 459L ),
   "Cannot drive target processor FLT# pin to low state.",
   "HE_TARGET_FLT",
   LOCKED
},
{
   "ER_TARGET_VCC",
   ( E_WARNING | 0L | 460L ),
   "Target power is off. Turn on the power and reset emulator immediately.",
   "HE_TARGET_VCC",
   LOCKED
},
{
   "ER_BONDOUT_FLT",
   ( E_WARNING | 0L | 461L ),
   "Cannot drive emulation processor FLT# pin to high state.",
   "HE_BONDOUT_FLT",
   LOCKED
},
{
   "ER_NO_CLOCK",
   ( E_WARNING | 0L | 462L ),
   "No clock input from target.",
   "HE_NO_CLOCK",
   LOCKED
},
{
   "ER_RESET_OCCURRED",
   ( E_WARNING | 0L | 463L ),
   "Target reset during operation.",
   "HE_RESET_OCCURRED",
   LOCKED
},
{
   "ER_HOLD_STUCK",
   ( E_WARNING | 0L | 464L ),
   "HOLD is continuously asserted.",
   "HE_HOLD_STUCK",
   LOCKED
},
{
   "ER_ILLEGAL_386_CMD",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 465L ),
   "Illegal command received by emulation processor.",
   "HE_ILLEGAL_386_CMD",
   LOCKED
},
{
   "ER_READ_ABORT",
   ( E_WARNING | 0L | 466L ),
   "Read operation aborted prior to completion.",
   "HE_READ_ABORT",
   LOCKED
},
{
   "ER_TEST_ABORT",
   ( E_WARNING | 0L | 467L ),
   "Test operation aborted prior to completion.",
   "HE_TEST_ABORT",
   LOCKED
},
{
   "ER_UNKNOWN_TEST_CMD",
   ( E_WARNING | 0L | 468L ),
   "Unknown test command received by emulator.",
   "HE_UNKNOWN_TEST_CMD",
   LOCKED
},
{
   "ER_EVTREC_TRACE",
   ( E_WARNING | 0L | 469L ),
   "Unsupported event recognizer type.",
   "HE_EVTREC_TRACE",
   LOCKED
},
{
   "ER_WAIT_EMON_TIMEOUT",
   ( E_WARNING | 0L | 470L ),
   "Timeout waiting for emulation to start.",
   "HE_WAIT_EMON_TIMEOUT",
   LOCKED
},
{
   "ER_LOAD_SEQUENCE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 471L ),
   "Load packets arrived out of order.",
   "HE_LOAD_SEQUENCE",
   LOCKED
},
{
   "ER_MEM_COUNT_EXCEEDED",
   ( E_WARNING | 0L | 1088L ),
   "Memory window count exceeded.",
   "HE_MEM_COUNT_EXCEEDED",
   UNLOCKED
// The maximum number of supported Memory windows are already open.
},
{
   "ER_CANT_OPEN_MEM_WINDOW",
   ( E_WARNING | 0L | 1089L ),
   "Unable to open Memory window.",
   "HE_CANT_OPEN_MEM_WINDOW",
   UNLOCKED
// Unable to open another Memory window.  Probably indicates system 
// resources exhausted.
},
{
   "ER_OS2_LAN_SERVER_NOT_RUNNING",
   ( E_FATAL | 0L | 1090L ),
   "OS/2 LAN Server is not running.",
   "HE_OS2_LAN_SERVER_NOT_RUNNING",
   UNLOCKED
// OS/2 LAN Server is not running; network initialization failed.
},
{
   "ER_ADR_NOT_INTEL_USAGE",
   ( INTERNAL_ERROR_ON | E_WARNING | 0L | 1091L ),
   "Wrote data to ROM memory.",
   "HE_ADR_NOT_INTEL_USAGE",
   UNLOCKED
// Address operation failed because the operation is not a valid on for
// an Intel processor.
},
{
   "ER_ADR_SPACE_INVALID",
   ( E_WARNING | 0L | 1092L ),
   "Space designator is incompatible with current processor.",
   "HE_ADR_SPACE_INVALID",
   UNLOCKED
// Space designators are processor specific.
// Motorola CPU32 space designators: UD, UP, SD(default), SP, CPU
// Motorola CPU16 space designators: DATA(default), PROGRAM
// Intel space designators: USER(default), SMM, IO
},
{
   "ER_ADR_MODE_INVALID",
   ( E_WARNING | 0L | 1093L ),
   "Address mode does not conform to processor standards.",
   "HE_ADR_MODE_INVALID",
   UNLOCKED
// Address mode is processor specific.
// Motorol modes are none or current.
// Intel modes are current, real, protected16, protected32, virtual86.
},
{
   "ER_ADR_EXCEEDS_ADR_LIMIT",
   ( E_SEVERE | 0L | 1094L ),
   "Address offset exceeds processor's addressing limit.",
   "HE_ADR_EXCEEDS_ADR_LIMIT",
   UNLOCKED
// Address operation failed because the offset exceeds the limitations
// of the current addressing mode.
},
{
   "ER_ADR_EXCEEDS_SEG_LIMIT",
   ( E_SEVERE | 0L | 1095L ),
   "Address offset exceeds processor's segment limit.",
   "HE_ADR_EXCEEDS_SEG_LIMIT",
   UNLOCKED
// Address operation failed because the offset exceeds the limitations
// of the current segment.
},
{
   "ER_ADR_LDT_INVALID",
   ( E_SEVERE | 0L | 1096L ),
   "CPU stopped due to accessing NONE memory.",
   "HE_ADR_LDT_INVALID",
   UNLOCKED
// Address operation failed because the ldt specified does not exist.
},
{
   "ER_ADR_PHYS_TO_LINEAR_NOT_SUPPORTED",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1097L ),
   "Unable to translate physical address to linear address.",
   "HE_ADR_PHYS_TO_LINEAR_NOT_SUPPORTED",
   UNLOCKED
// Address server does not support physical to linear address translation.
},
{
   "ER_ADR_LINEAR_TO_VIRTUAL_INVALID",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1098L ),
   "Unable to translate linear address to virtual address.",
   "HE_ADR_LINEAR_TO_VIRTUAL_INVALID",
   UNLOCKED
// Address server was unable to successfully map the linear address to
// an equivalent virtual address.
},
{
   "ER_ADR_DIFFER_SEGMENTS",
   ( E_WARNING | 0L | 1099L ),
   "Invalid code.",
   "HE_ADR_DIFFER_SEGMENTS",
   UNLOCKED
//Addresses compared do not have the same segment. Comparison has no
//meaning.
},
{
   "ER_ADR_DIFFER_TYPES",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1100L ),
   "Unable to compare addresses of differing types.",
   "HE_ADR_DIFFER_TYPES",
   UNLOCKED
//Addresses compared do not have the same type. Comparison has no
//meaning.
},
{
   "ER_ADR_DIFFER_SPACES",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1101L ),
   "Unable to compare addresses of differing spaces.",
   "HE_ADR_DIFFER_SPACES",
   UNLOCKED
//Addresses compared do not have the same space. Comparison has no meaning.
},
{
   "ER_PRC_OPER_INCOMPAT",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1102L ),
   "Requested operation is incompatible with processor.",
   "HE_PRC_OPER_INCOMPAT",
   UNLOCKED
//A processor specific routine was accessed while operating with the wrong processor family.
},
{
   "ER_ADR_NULL_GDT_DESCRIPTOR",
   ( E_SEVERE | 0L | 1103L ),
   "CPU stopped because of writing data to ROM memory.",
   "HE_ADR_NULL_GDT_DESCRIPTOR",
   UNLOCKED
//Indexing into the GDT resulted in the null descriptor.  An attempt to
// access memory using the null descriptor will always generate an exception.
},
{
   "ER_ADR_DESCTBL_LIMIT_EXCEEDED",
   ( E_SEVERE | 0L | 1104L ),
   "Requested offset in the descriptor table exceeds the physical limits.",
   "HE_ADR_DESCTBL_LIMIT_EXCEEDED",
   UNLOCKED
// Indexing into a descriptor table with the given segment selector
// resulted in an offset exceeding the physical limits of the table.
},
{
   "ER_ADR_SEGMENT_INVALID",
   ( E_SEVERE | 0L | 1105L ),
   "Exception occurred while stepping. Using GO instead of STEP.",
   "HE_ADR_SEGMENT_INVALID",
   UNLOCKED
//The segment is either not valid or no longer present in memory
},
{
   "ER_ADR_SEGMENT_USE_INVALID",
   ( E_SEVERE | 0L | 1106L ),
   "Segment specified is not a valid type for requested use.",
   "HE_ADR_SEGMENT_USE_INVALID",
   UNLOCKED
//The segment specified is probably a system segment and not a valid
// code or data segment
},
{
   "ER_ADR_PAGE_UNAVAILABLE",
   ( INTERNAL_ERROR_ON |E_SEVERE | 0L | 1107L ),
   "The page table entry is not present during page translation.",
   "HE_ADR_PAGE_UNAVAILABLE",
   UNLOCKED
//The present bit in the page table entry is 0 and the page is not
// in memory.
},
{
   "ER_ADR_PMODE_UNAVAILABLE",
   ( INTERNAL_ERROR_ON | E_SEVERE | 0L | 1108L ),
   "The pmode is uninitialized and prevents address translation.",
   "HE_ADR_PMODE_UNAVAILABLE",
   UNLOCKED
//Address translation depends on current processor mode.  The mode is
//uninitialized and the address can not be translated.
},
{
   "ER_ADR_SHELL_NOT_SUPPORTED",
   ( E_SEVERE | 0L | 1109L ),
   "Shell command specified is not supported for the current processor.",
   "HE_ADR_SHELL_NOT_SUPPORTED",
   UNLOCKED
//The shell command is processor specific and is not supported on the
// current processor
},
{
   "ER_NET_INCOMPATIBLE_VERSION",
   ( E_SEVERE | 0L | 1110L ),
   "Network communications option not compatible with host software.",
   "HE_NET_INCOMPATIBLE_VERSION",
   UNLOCKED
// The MICEpack/SLD version number must match the version number of the
// network communications option.
}
,{
   "ER_SAVECS_MBAR_INVALID",
   ( E_WARNING | 0L | 1111L ),
   "MBAR is invalid; no other SIM registers will be processed.",
   "HE_SAVECS_MBAR_INVALID",
   UNLOCKED
}
,{
   "ER_RESET_STUCK",
   ( E_WARNING | 0L | 1112L ),
   "The target is holding RESET asserted; operation cannot be completed.",
   "HE_RESET_STUCK",
   UNLOCKED
}
/* next error code available:  1113 */
