#include "const.h"

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

extern U16 BDMTemp[BDMTempSize];
extern U8 BDMTempB[BDMTempSize*2];
//extern char far TraceBuffer[TraceBufferSize];
extern char far *TraceBuffer;

/*********************************************************/
/* Register Access                                       */
/*********************************************************/
U8 IntRegister(U16 addressOffset, U16 access,
               U16 length, U32 *data, U16 relocatable);
// assess the internal register
//   access --> 0:read/1:write
//   length --> 1:byte/2:word/4:long

U8 OvpRegister(U16 addressOffset, U16 access,
               U16 length, U32 *data, U16 ptrOffset);
// access the Mode Register of UARTs
//   addressOffset --> UMR
//   ptrOffset     --> UCR
//   length        --> always 2

U8 GetReg(U32 *buffer);
//  get A6..A0/D7..D0/SP/SR/PC/VBR
//  return al --> 0:ok/1:fail

U8 SetReg(U32 *buffer);
//  set A6..A0/D7..D0/SP/SR/PC/VBR
//  return al --> 0:ok/1:fail

U8 ReadReg(U16 reg_num,U32 *value);
U8 WriteReg(U16 reg_num,U32 value);
//  read/write a register specified by reg_num
//  return al --> 0:ok/1:fail
#define REG_D0    18  // 0x1000
#define REG_D1    17  // 0x1001
#define REG_D2    16  // 0x1002
#define REG_D3    15  // 0x1003
#define REG_D4    14  // 0x1004
#define REG_D5    13  // 0x1005
#define REG_D6    12  // 0x1006
#define REG_D7    11  // 0x1007
#define REG_A0    10  // 0x1008
#define REG_A1    9   // 0x1009
#define REG_A2    8   // 0x100a
#define REG_A3    7   // 0x100b
#define REG_A4    6   // 0x100c
#define REG_A5    5   // 0x100d
#define REG_A6    4   // 0x100e
#define REG_SP    3   // 0x100f
#define REG_PC    0   // 0x080f
#define REG_SR    2   // 0x080e
#define REG_VBR   20  // 0x0801
#define REG_CSR   21  // 0x2000
#define REG_AABR  22  // 0x2006
#define REG_TDR   23  // 0x2007
#define REG_PBR   24  // 0x2008
#define REG_PBMR  25  // 0x2009
#define REG_ABHR  26  // 0x200c
#define REG_ABLR  27  // 0x200d
#define REG_DBR   28  // 0x200e
#define REG_DBMR  29  // 0x200f
#define REG_CCR   30  // 0x0002
#define REG_ACR0  31  // 0x0004
#define REG_ACR1  32  // 0x0005
#define REG_RAMBAR 33 // 0x0C04
#define REG_MBAR   34 // 0x0C0F

/*********************************************************/
/* Memory Access                                         */
/*********************************************************/
//  epSpace --->  EP space (68306 FC[0..2])
//                            1 ---  UD
//                            2 ---  UP
//                            5 ---  SD
//                            6 ---  SP
//                            7 ---  CPU

U8 SetMaxRetry(U8);
//  return previous value

U8 DumpByteMem(U32 addr,U16 epSpace,U32 Len,U8 *buff);
U8 DumpWordMem(U32 addr,U16 epSpace,U32 Len,U8 *buff);
//  Dump memory from target by byte/word
//  the address and length must be even, if dump in word
//  zero length means 64K
//  return al --> 0:ok/2:access fail
//  the last address is kept in BDMTemp

U8 FillByteMem(U32 addr,U16 epSpace,U32 destLen,U16 srcLen,U8 *buff,U16 Flag);
U8 FillWordMem(U32 addr,U16 epSpace,U32 destLen,U16 srcLen,U8 *buff,U16 Flag);
//  Flag --> 0:verify off/1:verify on
//  return al --> 0:ok/1:verify error/2:access fail
//  the last address is kept in BDMTemp

U8 VerifyMem(U32 addr,U16 epSpace,U32 destLen,U16 srcLen,U8 *buff,U16 size);
//  compare target memory with buffer in size (0:byte/1:word)
//  return al --> 0:Match/1:Not Match/2:access fail
//  the last address is kept in BDMTemp

U8 CompareMem(U32 addr1,U16 epSpace1,U32 Len,U32 addr2,U16 epSpace2,U16 size);
//  compare two memory block of target in size (0:byte/1:word)
//  return al --> 0:Match
//                1:Not Match
//                2:Block 1 Not Ready
//                3:Block 2 Not Ready
//  the last address is kept in BDMTemp

U8 PreCopyMem(U32 addr1,U16 epSpace1,U32 Len,U32 addr2,U16 epSpace2,U16 Flag);
U8 PostCopyMem(U32 addr1,U16 epSpace1,U32 Len,U32 addr2,U16 epSpace2,U16 Flag);
//  copy memory from addr1 to addr2
//  Flag --> 0:verify off/1:verify on
//  return al --> 0:ok
//                1:Verify Failure
//                2:Source Area Not Ready
//                3:Destination Area Not Ready
//  the last address is kept in BDMTemp

U8 SearchMem(U32 addr,U16 epSpace,U32 destLen,U16 srclen,U8 *buff);
//  Search a string from target memory (using size byte always)
//  return al --> 0:ok/1:not found/2:access fail
//  the match or failure address is kept in BDMTemp

U8 Checksum(U32 addr,U16 epSpace,U32 Len, U16 size);
//  calculate the check-sum  of a block memory in size (0:byte/1:word)
//  return ax --> 0:check sum equal to zero
//                1:check sum not zero
//                2:access fail
//  the check sum or failure address is kept in BDMTemp

U8 TestMem(U32 addr,U16 epSpace,U32 Len,U16 size);
//  the address and length must be even, if test in word
//  zero length means 4G
//  size ---> 0:byte/1:word
//  return al --> 0:ok/1:test error/2:access fail
//  the last address is kept in BDMTemp

/*********************************************************/
/* Execution Control                                     */
/*********************************************************/
U8 InitialReset(U32 *buffer);
U8 Reset(U32 *buffer);
//  reset tartget CPU
//  *buffer --> SP/SR/PC/VBR
//  return al --> 0:VCC on/1:VCC off

U8 EPstatus(U32 *buffer);
//  get target CPU status
//  *buffer --> SP/SR/PC/VBR

U8 InstructionStep(U32 *buffer);
//  step one instruction
//  *buffer --> SP/SR/PC/VBR
//  return al --> 0:ok/1:fail

U8 GoEP(VOID);
//  set target CPU free run
//  return al --> 0:ok/1:fail

U8 StopEP(U32 *buffer);
//  stop target CPU
//  return al --> 0:ok/1:fail

U8 SetBreakPoint(U16 Mode,U32 *buff);
U8 SetTriggerLevel(U16 Mode_of_Level_1,U16 Mode_of_Level_2);
// return al --> 0:ok/1:illegal argument/2:BDM access error

#define BP_NONE    0x0000
#define BP_Attrib  0x0000  // buff[0]=Attrib
#define BP_PC      0x0002  // buff[0]=Breakpoint,buff[1]=Mask
#define BP_PCInv   0x0001
#define BP_DLong   0x1000  // buff[0]=Data,buff[1]=Mask
#define BP_DWordL  0x0800  // buff[0]=Data,buff[1]=Mask
#define BP_DWordU  0x0400  // buff[0]=Data,buff[1]=Mask
#define BP_DByteLL 0x0200  // buff[0]=Data,buff[1]=Mask
#define BP_DByteLM 0x0100  // buff[0]=Data,buff[1]=Mask
#define BP_DByteUM 0x0080  // buff[0]=Data,buff[1]=Mask
#define BP_DByteUU 0x0040  // buff[0]=Data,buff[1]=Mask
#define BP_DInv    0x0020
#define BP_SAddr   0x0004  // buff[0]=Breakpoint,buff[1]=Mask
#define BP_RAddr   0x0008  // buff[0]=AddrLow,buff[1]=AddrHigh
#define BP_AddrInv 0x0010

//U8 ClearBreakPoint(U16 Mode);

/*********************************************************/
/* Trace Control                                         */
/*********************************************************/
VOID TraceEnable(U8 BreakFull);
VOID TraceDisable(VOID);
VOID TraceReset(VOID);
U8   TraceStatus(U16 *addr);
U8   TraceBuffTest(VOID);

/*********************************************************/
/* Test only                                             */
/*********************************************************/
void EngTest(void);
void WROM(void);
void TestKermit(void);
void HEXCH(void);
void SetBaud(void);
void FwReset(void);
