;********************************
;*****   BDM Port define    *****
;*****   ( xilinx )         *****
;********************************
XLX           equ
ShiftPort     equ       XLX+0
BdmStatus     equ       XLX+1
BdmCtrl       equ       XLX+2
; set control bit for xlx control port
ShiftInit     equ       00000001B
ShiftStart    equ       00000010B
; read status bit from xlx status port
DSDO          equ       00000001B
VFLS0         equ       00000010B
VFLS1         equ       00000100B
nSRESET       equ       00001000B
nHRESET       equ       00010000B
TVCC          equ       00100000B
ShiftAction   equ       01000000B
SresetFlag    equ       10000000B

;********************************
;*****  BDM command define  *****
;********************************
;

;
;*****  Trap Enable Data    *****
;
TrapEnableDataHead    equ   01100000B     ; 7:control, 6:mode, 5:start

  I1_WatchPointTrapEnable    equ  01000000B        ; Instruction
  I2_WatchPointTrapEnable    equ  00100000B
  I3_WatchPointTrapEnable    equ  00010000B
  I4_WatchPointTrapEnable    equ  00001000B
  D1_WatchPointTrapEnable    equ  00000100B        ; Data
  D2_WatchPointTrapEnable    equ  00000010B

;
;*****  Debug Port Command  *****
;
DebugPortCmdHead      equ   11100000B     ; 7:control, 6:mode, 5:start
;
NOP                   equ   00000000B
SRESET                equ   00000001B
HRESET                equ   00000010B
EndDownlad            equ   01000011B
StratDownload         equ   01100011B
NegateMaskableBkpt    equ   00011111B
AssertMaskableBkpt    equ   00111111B
NegateNonmaskableBkpt equ   00011111B
AssertNonmaskableBkpt equ   01011111B
;
;*****  Debug Instruction/Data  *****
DebugInstrHead        equ   00100000B      ; 7:control, 6:mode, 5:start
DebugDataHead         equ   10100000B      ; 7:control, 6:mode, 5:start

;********************************
;*****  BDM Status define   *****
;********************************
;
;*****         Status           *****
;
ValidData             equ   00000000B
SequencingErr         equ   10000000B
CpuInterrut           equ   01000000B
Null                  equ   11000000B
;
;*****         Data            *****

FreezeActive          equ   00000001B       ;  freeze status = 1 ,
                                            ;  when the core is in debug mode
DownloadInProgress    equ   00000010B       ;  download in progress = 0
                                            ;  when debug port in download
                                            ;  is negated.



;********************************
;*****  Variable define     *****
;********************************

BdmCtrlBuff        db    1
SerialInBdmBuff    db    4
SerialOutBdmStatus db    1
SerialOutBdmBuff   db    4







