/****************************************************************************
**
**  Name:  emuemul.h
**
**  Description:
**     Michelle emulation-group routines.
**     include:
**     "Read/write registers",
**     "Reset the emulator",
**     "Instruction step(s)"
**
**  Status:  preliminary
**
**  $Log:   S:/tbird/arcppc/fw/860/emuemul.h_v  $
** 
**    Rev 1.2   02 Apr 1998 08:57:12   Cathy
** disable EE (external interrupt) before step if EE enable.
** 
**    Rev 1.1   28 Aug 1997 10:23:40   cjchen
** No change.
** 
**    Rev 1.0   18 Jul 1997 15:12:54   cjchen
** Initial revision.
** 
**    Rev 1.0   11 Feb 1997 16:16:48   kevin
** Initial revision.
** 
**    Rev 1.1   29 Nov 1996 14:25:46   gene
** added EmuSetIntReg/EmuGetIntReg
** 
**    Rev 1.0   03 Jun 1996 14:18:50   gene
** Initial revision.
**
** Copyright (C) 1992 Microtek International, Inc.
**
*****************************************************************************/

#define _EMU_EMUL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _EMU_LIB_
#include "emulib.h"
#endif

#ifndef _EMU_ERROR_
#include "emuerror.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#define REG86_NUMBER 14

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  EmuReset
**
**  Description: Michelle reset routine,
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        "O.K." -- Normal return
**        "Fatal error on emulator" -- Fatal HW error; check status-code
**
**
*****************************************************************************/
VOID EmuReset(VOID);

/****************************************************************************
**
**  EmuGetReg
**
**  Description: Michelle emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuGetReg(REG_MODE regMode, U16 regId);

/****************************************************************************
**
**  EmuGetReg
**
**  Description: Michelle emulation routine, to get values of all registers.
**
**  Parameters:
**     input:
**        none
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuGetAllReg(VOID);


/****************************************************************************
**
**  EmuSetReg(VOID)
**
**  Description: Michelle emulation routine, to step certain step(s).
**
**  Parameters:
**     input:
**        regId  --
**        value  --
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuSetReg(REG_MODE regMode, U16 regId, U32 value);


/****************************************************************************
**
**  EmuStepRange
**
**  Description: Michelle emulation routine, to set value to certain register.
**
**  Parameters:
**     input:
**        addr1 -- unsigned long,
**        addr2 -- unsignde long
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
*****************************************************************************/
VOID EmuStepRange(ADDR *addr1,ADDR *addr2);
U8 DisableExtInt(void);
void EnableExtInt(void);
STATUS ReadMem(ADDR *addr, U8 *buff, U16 dataLen) ;

/***************************************************************************
**
**  EmuSetIntReg
**
**  Description: Emulation routine, to set a internal register.
**
**  Parameters:
**     input:
**        regOffset -- unsigned long,
**        value  -- unsigned long,
**        len  -- unsigned integer.
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuSetIntReg(U16 regOffset,U16 len,U32 value,U16 relocatable);

/***************************************************************************
**
**  EmuGetIntReg
**
**  Description: Emulation routine, to get a internal register.
**
**  Parameters:
**     input:
**        regOffset -- unsigned long,
**        len  -- unsigned integer.
**
**     output:
**        return status code(error-code) in to the output processor.
**        Could be : "OK" -- Normal return.
**                   "Hardware fatal error" -- error processing
**
****************************************************************************/
VOID EmuGetIntReg(U16 regOffset,U16 len,U16 relocatable);

/******************************** E O F ***********************************/

