/****************************************************************************
**
** Name: trctman.h
**
** Description:
**   Header file for trigger and trace operation
**
** Status: PRELIMINARY
**
** $Log:   S:/tbird/arcppc/fw/860/trctman.h_v  $
** 
**    Rev 1.0   18 Jul 1997 15:12:58   cjchen
** Initial revision.
** 
**    Rev 1.0   11 Feb 1997 16:17:04   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 14:19:24   gene
** Initial revision.
** 
** Copyright (C) 1992 Microtek International. All rights reserved.
**
****************************************************************************/

#define _TRCTMAN_

                       /****************************
                        *                          *
                        *      INCLUDE FILES       *
                        *                          *
                        ****************************/

#ifndef _EMU_BASE_TYPES_
#include "emutypes.h"
#endif

#ifndef _TRCLIB_
#include "trclib.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

typedef enum { MODE_16BIT, MODE_32BIT } EMU_MODE;
typedef enum { PRE_TRIG, CENTER_TRIG, POST_TRIG } TRIG_LOC;
typedef enum { CLOCK_LIST, CYCLE_LIST } LIST_FORM;
typedef enum { CLOCK_TRACE, CYCLE_TRACE } TRACE_FORM;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************************************************************
**
**  ConfigTrace
**
**  Description:
**    Set the trace memory to 1, 2, 4, 8, 16, 32, 64, 128, or 256 trace buffers
**    Set the trigger location to PRE_TRIG, CENTER_TRIG, or POST_TRIG
**    Set EP to break (or not break) when the trace memory are full
**    This function only changes the global variables "traceBufferNumber",
**    "triggerLocation" and "breakOnFull", but does not change bitStreamBuffer
**    or configure XLX_TMAN
**
**  Parameters:
**    input:
**      traceBufNum: number of trace buffers
**      trigLoc: trigger location
**      breakFull: break on trace memory full
**    output:
**      none
**
*******************************************************************************/
RETCODE ConfigTrace(U16 traceBufNum, TRIG_LOC trigLoc, BOOLEAN breakFull);

/******************************************************************************
**
**  GetTrigInfoOfTrcBuf
**
**  Description:
**    Get trigger informations of trace buffers
**    Trigger informations including
**                     trigPhyFrameOfTrcBuf[trcBufLogID]
**                     startLogFrameOfTrcBuf[trcBufLogID]
**                     endLogFrameOfTrcBuf[trcBufLogID]
**    This function will get these informations then set
**                     gotTrigInfoOfTrcBuf[trcBufLogID] = TRUE
**
**  Parameters:
**    input:
**      trcBufLogID: trace buffer logical ID
**    output:
**      none
**
*******************************************************************************/
RETCODE GetTrigInfoOfTrcBuf(U16 trcBufLogID);

/******************************************************************************
**
**  InitialTraceMachine
**
**  Description:
**    After system power on, this function will check if XLX_EREC1, XLX_EREC2
**    or XLX_TMAN exist, then according to the emulation mode, program these
**    Xilinx Chip to their initial configuration and initial VRAM
**
**  Parameters:
**    input:
**      emuMode: emulation mode (MODE_16BIT or MODE_32BIT)
**    output:
**      none
**
*******************************************************************************/
RETCODE InitialTraceMachine(EMU_MODE emuMode);

/******************************************************************************
**
**  IsTMANBreak
**
**  Description:
**    Check if EP is stopped by XLX_TMAN
**    It may be "trigger break" or "break on trace memory full"
**
**  Parameters:
**    input:
**      none
**    output:
**      none
**
*******************************************************************************/
BOOLEAN IsTMANBreak(VOID);

/******************************************************************************
**
**  ListTraceBuffer
**
**  Description:
**    List trace data from trace buffer "trcBufLogID" frame "logFrameNum"
**
**  Parameters:
**    input:
**      log: point to structure shown as follows
**        log->traceBufId: trace buffer logical ID
**        log->traceform: list form (CLOCK_LIST or CYCLE_LIST)
**        log->startFrame: logical frame number from which the list starts
**      qualify: point to structure which includes the qualify-list information
**      frameContents: pointer to list data
**    output:
**      none
**
*******************************************************************************/
RETCODE ListTraceBuffer(TRACE_HEAD *log, QUALIFY_LIST *qualify,
                        VOID *frameContents);

/******************************************************************************
**
**  ProgramTMANStatic
**
**  Description:
**    Program XLX_TMAN to STATIC configuration (TMANStaticXCByte[])
**    Trace memory can be listed, if XLX_TMAN is under STATIC configuration
**    The *endTrcBufLogID (the logic ID of the trace buffer where trace halt at)
**    and *cntAfterTraceHalt (the counter0/counter1 values after trace halt)
**    are also been got
**
**  Parameters:
**    input:
**      none
**    output:
**      *endTrcBufLogID: the logic ID of the trace buffer where trace halt at
**      *cntAfterTraceHalt: the counter0/counter1 values after trace halt
**
*******************************************************************************/
RETCODE ProgramTMANStatic(U16 *endTrcBufLogID, U32 *cntAfterTraceHalt);

/******************************************************************************
**
**  ProgramTMANTrace
**
**  Description:
**    Program XLX_TMAN to TRACE configuration (TMANTraceXCByte[])
**    EP bus can be traced into trace memory, if XLX_TMAN is under TRACE
**    configuration
**
**  Parameters:
**    input:
**      none
**    output:
**      none
**
*******************************************************************************/
RETCODE ProgramTMANTrace(VOID);

/******************************************************************************
**
**  WriteSeqRAMs
**
**  Description:
**    Write state machine data to Sequential RAMs
**
**  Parameters:
**    input:
**      levelID: trigger level
**      data: pointer to the data written into Sequential RAMs
**    output:
**      none
**
*******************************************************************************/
RETCODE WriteSeqRAMs(U8 levelID, U8 *data);

/********************************* EOF *************************************/
