/****************************************************************************
**
**  Name:  EVENTS.H
**
**  Description:
**      All events used by PowerViews servers are enumerated here.
**
**  Status:  CODED
**
**  Copyright (C) 1992 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _EVENTS_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif
#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

                       /*********************************
                       *                                *
                       *   EVENT NOTIFICATION DEFINES   *
                       *                                *
                       *********************************/

/* Events in the id 20-29 range are supported by multiple servers/presenters.
   Specifically,
        Halted events are EVENT_xxx_HALTED, and id 20
        Edit events are EVENT_xxx_EDIT, and id 21
   Events in the 30-49 range for all other events.
   Events starting at 50 are internal (not used by more than a single
       component).
   Events starting at 0x100 are generic events supported by multiple
       servers and presenters.
*/

/* Event a callback can propagate to close the application */
#define EVENT_CLOSE_APPLICATION (MODULE_GENERIC | 30)

/*---------------------------------*/
/*            BKPT EVENTS          */
/*---------------------------------*/
#define EVENT_BKPT_HALTED       (MODULE_BREAKPOINT | 20)
#define EVENT_BKPT_EDIT         (MODULE_BREAKPOINT | 21)

/* High Level event for presenters indicating emulation started successfully*/
#define EVENT_HL_BKPTEXEC_EMUL_STARTED     (MODULE_BREAKPOINT | 30)

/* High Level event for presenters indicating emulator is being stepped but
   is not done yet */
#define EVENT_HL_BKPTEXEC_EMUL_STEPPING    (MODULE_BREAKPOINT | 31)

/* High Level event for presenters indicating emulation pending*/
#define EVENT_HL_BKPTEXEC_EMUL_PENDING     (MODULE_BREAKPOINT | 32)

#define EVENT_CPU_HALTED        (MODULE_CPU        | 20)
#define EVENT_CPU_EDIT          (MODULE_CPU        | 21)
#define EVENT_CPU_PC_EDIT       (MODULE_CPU        | 30)
#define EVENT_CPU_SP_EDIT       (MODULE_CPU        | 31)
#define EVENT_CPU_FP_EDIT       (MODULE_CPU        | 32)
#define EVENT_CPU_IMMR_EDIT     (MODULE_CPU        | 33)

#define EVENT_DASM_HALTED       (MODULE_DISASSEMBLY | 20)
#define EVENT_DASM_SYM_CHANGED  (MODULE_DISASSEMBLY | 21)

#define EVENT_LDR_STARTPC       (MODULE_LOADER_ELF | 30)
#define EVENT_LDR_STACKTOP      (MODULE_LOADER_ELF | 31)
#define EVENT_LDR_LOADCOMPLETE  (MODULE_LOADER_ELF | 32)
#define EVENT_LDR_MEMCHANGED    (MODULE_LOADER_ELF | 33)

/* generated whenever map changes... memory should be updated */
#define EVENT_MAP_EDIT          (MODULE_MAP        | 21)

#define EVENT_MEM_HALTED        (MODULE_MEMORY     | 20)
/* generated whenever any memory location(s) may have changed */
#define EVENT_MEM_EDIT          (MODULE_MEMORY     | 21)
/* events used to update src windows if memory change matches their range */
#define EVENT_MEM_MEMORY_CHANGED_SRC0_RANGE  (MODULE_MEMORY | 31)
#define EVENT_MEM_MEMORY_CHANGED_SRC1_RANGE  (MODULE_MEMORY | 32)

#define EVENT_STK_HALTED        (MODULE_STACK      | 20)
/* generated when stack frame is recalculated */
#define EVENT_STK_STACK_CHANGED    (MODULE_STACK      | 30)
/* generated when the stack alarm is tested and found to be over the limit */
#define EVENT_STK_ALARM_OVER_LIMIT (MODULE_STACK      | 31)
/* generated when the alarm conditions change */
#define EVENT_STK_ALARM_CHANGE     (MODULE_STACK      | 32)
#define EVENT_STK_ALARM_ENABLED    (MODULE_STACK      | 33)
#define EVENT_STK_ALARM_DISABLED   (MODULE_STACK      | 34)
/* generated when the HWM conditions change */
#define EVENT_STK_HWM_ENABLED      (MODULE_STACK      | 35)
#define EVENT_STK_HWM_DISABLED     (MODULE_STACK      | 36)
#define EVENT_STK_STACK_OVERFLOW   (MODULE_STACK      | 37)
#define EVENT_STK_STACK_UNDERFLOW  (MODULE_STACK      | 38) 
#define EVENT_STK_BASE_SIZE_AVAIL  (MODULE_STACK      | 39)


/*---------------------------------*/
/*          SYMBOL EVENTS          */
/*---------------------------------*/
/* generated after an initial symbol load OR when previous symbols were
   deleted followed by loading of new symbols.   The purpose of the latter
   is for presenters/servers to be able to keep existing symbol names and
   only recalculate addresses from them. */
#define EVENT_SYMBOL_INIT_LOAD  (MODULE_SYMBOLS    | 30)

/* generated after a single module's on-demand symbols are loaded */
#define EVENT_SYMBOL_ONDEMAND_LOAD (MODULE_SYMBOLS | 31)

/* generated ONLY from the removeSymbols CLI command which
   deletes symbols but does not reload symbols. */
#define EVENT_SYMBOL_DELETED    (MODULE_SYMBOLS    | 32)

/* generated whenever a base address has been changed via the CLI */
/* this is needed by any presenter or server that has stored a symbol and */
/* its address, since the address may have changed if that symbol is in the
/* group associated with the changed base */
#define EVENT_SYMBOL_BASE_CHANGED  (MODULE_SYMBOLS | 33)


#define EVENT_TRACE_CLEAR_TRACE     (MODULE_TRACE | 30)
#define EVENT_TRACE_DEBUG_EMON      (MODULE_TRACE | 31)
#define EVENT_TRACE_NEW_SUB_BUFFER  (MODULE_TRACE | 32)
#define EVENT_TRACE_TRACING_OFF     (MODULE_TRACE | 33)
#define EVENT_TRACE_TRACING_ON      (MODULE_TRACE | 34)
#define EVENT_TRACE_HEADER_CHANGED  (MODULE_TRACE | 35)

#define EVENT_TRIG_HALTED       (MODULE_TRIGGER    | 20)
#define EVENT_TRIG_TRC_BUF_NUM  (MODULE_TRIGGER    | 21)

#define EVENT_VAR_HALTED        (MODULE_VAR        | 20)
#define EVENT_VAR_EDIT          (MODULE_VAR        | 21)


/* generate an event to be sure the entire app queue is flushed of events */
#define EVENT_CLI_COMMAND_COMPLETE  (MODULE_CLI | 0x50)

/*---------------------------------*/
/*          BKROOT EVENTS          */
/*---------------------------------*/
/* used to indicate when runaccess state has been changed */
#define EVENT_BKROOT_RUNACCESS_ON  (MODULE_BKROOT | 20)
#define EVENT_BKROOT_RUNACCESS_OFF (MODULE_BKROOT | 21)


/*----------------------------------*/
/*     ACTOR LAUNCH EVENTS          */
/*----------------------------------*/
/* used by C++ presenters to inform actor buttonBarclass to launch */
/* the specific presenter                                          */
#define EVENT_LAUNCH_BKPNT         (MODULE_GENERIC | 0x100)
#define EVENT_LAUNCH_CPU           (MODULE_GENERIC | 0x101)
#define EVENT_LAUNCH_EVENT         (MODULE_GENERIC | 0x102)
#define EVENT_LAUNCH_MEM           (MODULE_GENERIC | 0x103)
#define EVENT_LAUNCH_PERI          (MODULE_GENERIC | 0x104)
#define EVENT_LAUNCH_SHELL         (MODULE_GENERIC | 0x105)
#define EVENT_LAUNCH_SOURCE        (MODULE_GENERIC | 0x106)
#define EVENT_LAUNCH_STACK         (MODULE_GENERIC | 0x107)
#define EVENT_LAUNCH_STAT          (MODULE_GENERIC | 0x108)
#define EVENT_LAUNCH_TB            (MODULE_GENERIC | 0x109)
#define EVENT_LAUNCH_TRC           (MODULE_GENERIC | 0x10a)
#define EVENT_LAUNCH_TRG           (MODULE_GENERIC | 0x10b)
#define EVENT_LAUNCH_VAR           (MODULE_GENERIC | 0x10c)

/******************************** E O F ***********************************/
