/*****************************************************************************
**
**    Name:    trig.h
** 
**    Description: 
**       Routines to set up the trigger and trace management hardware
**
**    Status: PRELIMINARY
**
**    $Log:   S:/tbird/arcppc/inc/trig.h_v  $
** 
**    Rev 1.0   15 Jan 1997 17:36:32   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 11:25:50   gene
** Initial revision.
** 
**    Rev 1.1   15 Nov 1995 14:42:26   kevin
** add TrigExtEventGet() prototype
** 
**    Rev 1.0   14 Sep 1995 14:22:40   kevin
** Initial revision.
**  
**     Rev 1.10   16 Dec 1992 15:36:36   mindy
**  moved dq to fw
**  
**     Rev 1.9   21 Oct 1992 06:25:20   mindy
**  changed U8 FAR * to LPSTR to remove warnings
**  
**     Rev 1.8   23 Jul 1992 07:01:56   doug
**  convert to new generic shared data 
**  
**     Rev 1.7   16 Jun 1992 08:45:28   mindy
**  added TrigEventInTrigger and changed parameters to program hardware
**  
**     Rev 1.6   28 Apr 1992 08:11:20   mindy
**  Can now get the number of trace buffers from the trigger server - trigger
**  presenter needed a way to access this information without "opening" a trac
**  server.
**  
**     Rev 1.5   15 Nov 1991 14:57:38   mindy
**  removed prd2 temp. TrigSetEvent
**  
**     Rev 1.4   01 Nov 1991 09:14:36   mindy
**  Many changes made to support final version of trigger presenter.
**  
**     Rev 1.3   02 Oct 1991 12:25:06   ernie
**  Added TrigSetEvent routine for PDR2
**  
**     Rev 1.2   28 Aug 1991 11:31:50   ernie
**  Renumbered enumerations for real trigger server
**
**     Rev 1.1   21 Aug 1991 11:25:22   tom
**  Updated types, include file format.
 * 
 *    Rev 1.0   14 Jun 1991 13:34:42   jim
 * Initial revision.
**
**    $Header:   S:/tbird/arcppc/inc/trig.h_v   1.0   15 Jan 1997 17:36:32   kevin  $
**
*****************************************************************************/

#define _TRIG_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASETYPE_
#include "basetype.h"
#endif
#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/*****************************************************************************
** 
**    TrigInitTrigServer
** 
**    Description:
**       Initializes trigger server.
** 
**    Parameters:
**       input:
**          none
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigInitTrigServer(VOID);

/*****************************************************************************
** 
**    TrigInitTrigServerCli
** 
**    Description:
**       Registers the trigger server's routines with the CLI server, and
**       performs other trigger server initialization.
** 
**    Parameters:
**       input:
**          cliHandle:  registration target for servers.
**          dllHandle:  handle to use in messages to tag this DLL.
**
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigInitTrigServerCli(HANDLE cliHandle, HANDLE dllHandle);

/*****************************************************************************
** 
**    TrigActionGet
** 
**    Description:
**       Returns the action mask at the current sequence level and 
**       event condition.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          mask:          action mask 
**
*****************************************************************************/
RETCODE EXPORT TrigActionGet(DESCRIPTOR id, ACTION_MASK FAR *mask);

/*****************************************************************************
** 
**    TrigActionSet
** 
**    Description:
**       Enables the specified actions to occur at the active sequence 
**       level and event condition.  Each call is OR'd into the existing set.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          action:        specifies actions
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigActionSet(DESCRIPTOR id, ACTION_MASK action);

/*****************************************************************************
** 
**    TrigActionClear
** 
**    Description:
**       Clears the specified actions from the current action mask
**       at the active sequence level and event condition.  
**       Each call ANDs the ones complement of action with the existing value.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          action:        specifies actions
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigActionClear(DESCRIPTOR id, ACTION_MASK action);

/*****************************************************************************
** 
**    TrigCounterFunctionGet
** 
**    Description:
**       Returns usage of the 2 10 bit counters.  Are they used as two 
**       counters or a single 20 bit timer.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          function:      counter mode
**
*****************************************************************************/
RETCODE EXPORT TrigCounterFunctionGet(DESCRIPTOR id, 
                                      COUNTER_TYPE FAR *function);

/*****************************************************************************
** 
**    TrigCounterFunctionSet
** 
**    Description:
**       Determines if the 2 10 bit counters will be used as two counters or 
**       a single 20 bit timer.  Defaults to counter function.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          function:      selects counter mode
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigCounterFunctionSet(DESCRIPTOR id, COUNTER_TYPE function);

/*****************************************************************************
** 
**    TrigCounterValueGet
** 
**    Description:
**       Returns the terminal count value specified at the sequence level 
**       indicated by current sequence level.  If counter function is set
**       to timer than the 'counter' field is ignored.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          counter:       specifies which counter
**       output:
**          value:         terminal count value specified
**
*****************************************************************************/
RETCODE EXPORT TrigCounterValueGet(DESCRIPTOR id, U16 counter,
                                   U32 FAR *value);

/*****************************************************************************
** 
**    TrigCounterValueSet
** 
**    Description:
**       Set the terminal count value for specified counter.  If currently in 
**       timer mode than the 'counter' is ignored.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          counter:       specifies which counter
**          value:         terminal count value
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigCounterValueSet(DESCRIPTOR id, U16 counter, U32 value);

/*****************************************************************************
** 
**    TrigEventClear
** 
**    Description:
**       Clears all input and action conditions at the active sequence level
**       and event condition.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigEventClear(DESCRIPTOR id);

/*****************************************************************************
** 
**    TrigEventEnableGet
** 
**    Description:
**       Returns TRUE if event at the current sequence level and 
**       event condition is enabled.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          enableEvt:     Is event input used?
**
*****************************************************************************/
RETCODE EXPORT TrigEventEnableGet(DESCRIPTOR id, BOOLEAN FAR *enableEvt);

/*****************************************************************************
** 
**    TrigEventEnableSet
** 
**    Description:
**       At the active sequence level and event condition the input mask 
**       is set to either watch for the event (enable=TRUE) or disable
**       watching for the event. 
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          enable:        determines if event should active
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigEventEnableSet(DESCRIPTOR id, BOOLEAN enable);

/*****************************************************************************
** 
**    TrigExtGet
** 
**    Description:
**       Returns the EXT status at the current sequence level and 
**       event condition.  
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          enableExt:     Is external trigger used?
**
*****************************************************************************/
RETCODE EXPORT TrigExtGet(DESCRIPTOR id, BOOLEAN FAR *enableExt);

/*****************************************************************************
** 
**    TrigExtSet
** 
**    Description:
**       At the active sequence level and event condition the EXT condition
**       is either actived (if enableExt=TRUE) or cleared.  
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          enable:        determines if event should include EXT condition.
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigExtSet(DESCRIPTOR id, BOOLEAN enable);

/*****************************************************************************
** 
**    TrigEventGet
** 
**    Description:
**       Returns the current event in use.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          event:         event condition
**
*****************************************************************************/
RETCODE EXPORT TrigEventGet(DESCRIPTOR id, EVENT_COND FAR *event);

/*****************************************************************************
** 
**    TrigEventNameGet
** 
**    Description:
**       Returns the event name of the event assigned to the active event.
**       An error returned if the active event is not one of the event 0-7
**       conditions.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          maxLen:        max number of characters event name can be.
**       output:
**          eventName:     pointer to memory storage where event name
**                         should be copied. Returns string name of event
**                         assigned to active event
**
*****************************************************************************/
RETCODE EXPORT TrigEventNameGet(DESCRIPTOR id, LPSTR eventName, U16 maxLen);

/*****************************************************************************
** 
**    TrigEventNameSet
** 
**    Description:
**       Assigns the event associated with the string 'eventName' to be the 
**       event0-7 of the currently active trigger.  The currently active event
**       condition determines which of the events 0 - 7 we are assigning.  
**       If the active event condition is one of the terminal counts or 
**       EXT an error is returned.  Event0-7 can be re-assigned or NULLED 
**       out by passing in a NULL string. Events that are not assigned are
**       set to "always true".
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          eventName:     string name of event
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigEventNameSet(DESCRIPTOR id, LPSTR eventName);

/*****************************************************************************
** 
**    TrigEventServerGet
** 
**    Description:
**       Returns the descriptor of the trigger's event server.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          serverId:      id for trigger's event server.
**
*****************************************************************************/
RETCODE EXPORT TrigEventServerGet(DESCRIPTOR id, DESCRIPTOR FAR *serverId);

/*****************************************************************************
** 
**    TrigEventSet
** 
**    Description:
**       Sets the current event to which of the event conditions the following
**       routines should use.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          event:         event condition
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigEventSet(DESCRIPTOR id, EVENT_COND event);

/*****************************************************************************
** 
**    TrigFillActionGet
** 
**    Description:
**       Retutns what action occurs when the trace is full. If enableBreak 
**       is TRUE emulation breaks when the trace buffer is full.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          enableBreak:   enable/disable break
**
*****************************************************************************/
RETCODE EXPORT TrigFillActionGet(DESCRIPTOR id, BOOLEAN FAR *enableBreak);

/*****************************************************************************
** 
**    TrigFillActionSet
** 
**    Description:
**       Globally sets what action should occur when the trace is full.  If
**       enableBreak is TRUE we will break emulation when the trace buffer 
**       is full.  Default is to not break emulation when trace buffer 
**       is full.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          enableBreak:   enable/disable break
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigFillActionSet(DESCRIPTOR id, BOOLEAN enableBreak);

/*****************************************************************************
** 
**    TrigQualifierGet
** 
**    Description:
**       Returns the what type of cycles the trigger is using to qualify
**       the event condition.  Either the cycles are qualified on clock
**       cycles (raw - straight from processor) or on bus cycles which
**       waits until a valid address, data and status condition is present
**       before a single cycle is complete.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          value:         qualifier mode
**
*****************************************************************************/
RETCODE EXPORT TrigQualifierGet(DESCRIPTOR id, QUAL_MODE FAR *mode);

/*****************************************************************************
** 
**    TrigQualifierSet
** 
**    Description:
**       Tells trigger hardware which qualifying mode to use.  Either
**       clock cycles or bus cycles.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          action:        qualifier mode
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigQualifierSet(DESCRIPTOR id, QUAL_MODE mode);

/*****************************************************************************
** 
**    TrigSeqLevelGet
** 
**    Description:
**       Returns the current sequence level for the indicated trigger
**       (DESCRIPTOR).
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          seqLevel:      sequence level
**
*****************************************************************************/
RETCODE EXPORT TrigSeqLevelGet(DESCRIPTOR id, U16 FAR *seqLevel);

/*****************************************************************************
** 
**    TrigSeqLevelSet
** 
**    Description:
**       Sets the current sequence level for the indicated trigger 
**       (DESCRIPTOR).
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          seqLevel:      sequence level
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigSeqLevelSet(DESCRIPTOR id, U16 seqLevel);

/*****************************************************************************
** 
**    TrigTraceConfigureGet
** 
**    Description:
**       Returns the number of trace buffers the trace store should be 
**       divided into.  Defaults to be one big trace buffer.
**
**    Parameters:
**       input:
**          id:            id number of calling routine.
**       output:
**          numBuffers:    number of trace buffers.
**
*****************************************************************************/
RETCODE EXPORT TrigTraceConfigureGet(DESCRIPTOR id, U16 FAR *numBuffers);

/*****************************************************************************
** 
**    TrigTraceConfigureSet
** 
**    Description:
**       Selects the number of trace buffers the trace store should be 
**       divided into.  Defaults to be one big trace buffer.
**
**    Parameters:
**       input:
**          id:            id number of calling routine.
**          numBuffers:    number of trace buffers.
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigTraceConfigureSet(DESCRIPTOR id, U16 numBuffers);

/*****************************************************************************
** 
**    TrigTraceModeGet
** 
**    Description:
**       Returns the trace mode.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          mode:          specifies trace mode
**
*****************************************************************************/
RETCODE EXPORT TrigTraceModeGet(DESCRIPTOR id, TRACE_MODE FAR *mode);

/*****************************************************************************
** 
**    TrigTraceModeSet
** 
**    Description:
**       Globally sets the trace mode.  Default trace mode is PRE_TRACE.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          mode:          specifies trace mode
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigTraceModeSet(DESCRIPTOR id, TRACE_MODE mode);

/*****************************************************************************
** 
**    TrigTriggerClear
** 
**    Description:
**       Clears the entire trigger to don't cares.  This includes all
**       activated input masks, action masks and event assignments.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigTriggerClear(DESCRIPTOR id);

/*****************************************************************************
** 
**    TrigTriggerClose
** 
**    Description:
**       Removes indicated descriptor's state information.
** 
**    Parameters:
**       input:
**          id:            id number of descriptor to close
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigTriggerClose(DESCRIPTOR id);

/*****************************************************************************
** 
**    TrigTriggerOpen
** 
**    Description:
**       If fileName is given that file is opened and the trigger set up 
**       is read from the file.  If no fileName is found then a new
**       trigger is created with the following defaults:  counter type
**       defaults to COUNTERS; trace mode defaults to PRE_TRACE; no break
**       is forced then trace buffer is full and the number of trace buffers
**       is one.  In either situation (i.e.: reading in an existing trigger
**       or creating a new trigger) the current sequence level will be
**       reset to level 0.
**
**    Parameters:
**       input:
**          fileName:      File name of file to open (optional)
**          templateName:  name of template for event server to use
**       output:
**          id:            id number assigned to calling routine.
**
*****************************************************************************/
RETCODE EXPORT TrigTriggerOpen(DESCRIPTOR FAR *id, LPSTR fileName,
                               LPSTR templateName);

/*****************************************************************************
** 
**    TrigTriggerProgram
** 
**    Description:
**       Programs the indicated trigger setup into the trigger hardware.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigTriggerProgram(VOID);

/*****************************************************************************
** 
**    TrigTriggerSaveAs
** 
**    Description:
**       Saves all the information pertaining to the trigger.
**       This includes the activated input masks, action masks and event
**       name assignments.
**
**    Parameters:
**       input:
**          id:            id number assigned to calling routine.
**          fileName:      name of file
**       output:
**          none
**
*****************************************************************************/
RETCODE EXPORT TrigTriggerSaveAs(DESCRIPTOR id, LPSTR fileName);

/*****************************************************************************
** 
**    TrigEventInTrigger
** 
**    Description:
**       This routine checks the current trigger event names against the
**       incoming event to see if that event is used.
**
**    Parameters:
**       input:
**          event:         event name to check for
**       output:
**          found:         Returns TRUE if event name found and is used
**
*****************************************************************************/
RETCODE EXPORT TrigEventInTrigger(LPSTR event, BOOLEAN FAR *found);
                                                                              
/*****************************************************************************
** 
**    TrigExtEventGet
** 
*****************************************************************************/
RETCODE EXPORT TrigExtEventGet(DESCRIPTOR id, U16 *extEvent) ;

/*****************************************************************************
** 
**    TrigDescGet
** 
*****************************************************************************/
RETCODE EXPORT TrigDescGet(DESCRIPTOR FAR *id);
/*********************************** E O F **********************************/
