#define IDM_ENABLEHWBKPT	404
#define _WHPTEXEC_


#define IWATCHPOINT             100
#define IDC_I_A_CONDITION       101
#define IDC_I_A_ADDRESS         102
#define IDC_I_B_CONDITION       111
#define IDC_I_B_ADDRESS         112
#define IDC_I_C_CONDITION       121
#define IDC_I_C_ADDRESS         122
#define IDC_I_D_CONDITION       131
#define IDC_I_D_ADDRESS         132
#define IDC_I_IW0_BREAK         141
#define IDC_I_IW0_RELATION      142
#define IDC_I_IW1_BREAK         151
#define IDC_I_IW1_RELATION      152
#define IDC_I_IW2_BREAK         161
#define IDC_I_IW2_RELATION      162
#define IDC_I_IW3_BREAK         171
#define IDC_I_IW3_RELATION      172
#define IDC_I_OK                180
#define IDC_I_CANCEL            181

#define LWATCHPOINT            200
#define IDC_L_E_ENABLE          201
#define IDC_L_E_CONDITION       202
#define IDC_L_E_ADDRESS         203
#define IDC_L_E_RW              204
#define IDC_L_F_ENABLE          211
#define IDC_L_F_CONDITION       212
#define IDC_L_F_ADDRESS         213
#define IDC_L_F_RW              214
#define IDC_L_G_ENABLE          221
#define IDC_L_G_CONDITION       222
#define IDC_L_G_SIGNED          223
#define IDC_L_G_DATA            224
#define IDC_L_G_MASK            225
#define IDC_L_G_SIZE            226
#define IDC_L_H_ENABLE          231
#define IDC_L_H_CONDITION       232
#define IDC_L_H_SIGNED          233
#define IDC_L_H_DATA            234
#define IDC_L_H_MASK            235
#define IDC_L_H_SIZE            236
#define IDC_L_LW0_ENABLE        241
#define IDC_L_LW0_IW            242
#define IDC_L_LW0_LADDR         243
#define IDC_L_LW0_LDATA         244
#define IDC_L_LW1_ENABLE        251
#define IDC_L_LW1_IW            252
#define IDC_L_LW1_LADDR         253
#define IDC_L_LW1_LDATA         254
#define IDC_L_OK                260
#define IDC_L_CANCEL            261

#define COUNTER                 300
#define IDC_C_A_ENABLE          301
#define IDC_C_A_COUNT           302
#define IDC_C_A_IW0             303
#define IDC_C_A_LW0             304
#define IDC_C_B_ENABLE          311
#define IDC_C_B_COUNT           312
#define IDC_C_B_IW1             313
#define IDC_C_B_LW1             314
#define IDC_C_OK                320
#define IDC_C_CANCEL            321

#define IDC_HELP                322

#define IDM_IWATCHPOINT         400
#define IDM_LWATCHPOINT         401
#define IDM_COUNTER             402
#define IDM_NONMASK_BIT         403
#define IDM_BREAKPOINT          410

#define IDM_HELP                420
#define IDM_HLPHLP              421
#define IDM_HLPWHPT             422

#define Watchpoint_Menu         500
#define IDM_MENU_EXIT           501

typedef enum { EQUAL=4, LESS_THAN, GREATER_THAN, NOT_EQUAL } WHPT_CONDITION;
typedef enum { R_W=1, R, W } WHPT_RW;
typedef enum { ACCESS_WORD=1, ACCESS_HALFWORD,ACCESS_BYTE} WHPT_SIZE;
typedef enum {IW0, IW1, IW2, IW3} WHPT_IW;
typedef enum {LW0, LW1} WHPT_LW;
typedef enum {IW=1, LW} WHPT_ILW;
typedef enum {E, F, EANDF, EORF} WHPT_LADDR;
typedef enum {G, H, GANDH, GORH} WHPT_LDATA;

typedef struct {
   WHPT_CONDITION condition[4];
   U32 addr[4];
   BOOLEAN enable[4];
   U16 relation[4]; //A=0x10, AandB=0x11
} I_WATCHPOINT;

typedef struct {
   BOOLEAN enable[2];
   WHPT_CONDITION condition[2];
   U32 addr[4];
   WHPT_RW rw[2];
} L_ADDR;

typedef struct {
   BOOLEAN enable[2];
   WHPT_CONDITION condition[2];
   BOOLEAN sign[2];
   U32 data[2];
   U32 mask[2];
   WHPT_SIZE size[2];
} L_DATA;

typedef struct {
   BOOLEAN enable[2];
   WHPT_IW iw[2];
   WHPT_LADDR laddr[2];
   WHPT_LDATA ldata[2];
} L_WATCHPOINT;

typedef struct {
  BOOLEAN enable[2];
  U32 count[2];
  WHPT_ILW ilw[2];
} WATCHPOINT_COUNTER;

RETCODE EXPORT WhptGetWatchpoints(I_WATCHPOINT *iwhpt,L_ADDR *laddr,
    L_DATA *ldata,L_WATCHPOINT *lwhpt, WATCHPOINT_COUNTER *whptCounter);

RETCODE EXPORT Sds2AbiFwLoadWatchpoints(I_WATCHPOINT iwhpt,L_ADDR laddr,
   L_DATA ldata,L_WATCHPOINT lwhpt,WATCHPOINT_COUNTER whptCounter);

RETCODE EXPORT Sds2AbiFwSetBkptNonmask(U16 enable);
RETCODE EXPORT Sds2AbiFwSetISCT_SER(U16 value);
