/****************************************************************************
**
**  Name:  ERR.H
**
**  Description:
**      Error defines for IEEE 695 Loader.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcppc/l695/err.h_v  $
** 
**    Rev 1.0   17 Jan 1997 09:21:02   kevin
** Initial revision.
** 
**    Rev 1.0   14 Sep 1995 08:19:02   kevin
** Initial revision.
** 
**    Rev 1.40   30 Aug 1993 11:05:44   ron
** Changes for Load Progress dialog
** 
**    Rev 1.39   03 Aug 1993 17:20:44   nghia
** Removed LERR_xxxxx to use standard error codes define in ERRCODEC.H
** 
**    Rev 1.38   27 Jul 1993 22:32:32   nghia
** Defined LERR_LOADFILE_HAD_INCOMPATIBLE_TOOLCHAIN.
** 
**    Rev 1.37   21 Jul 1993 16:30:08   ron
** moved ER_OPTIMIZED to mkerrors.h
** 
**    Rev 1.36   15 Jul 1993 10:57:04   nghia
** Temporary define ER_OPTIMIZED for LD695.
** Defined LERR_UNRECOGNIZED_BLK.
** 
**    Rev 1.35   15 Jul 1993 07:32:34   doug
** Added missing error messages.
** 
**    Rev 1.34   14 Jul 1993 12:53:30   doug
** Errors consolidated in errtext/mkerrors.h.
** 
**    Rev 1.33   13 Jul 1993 15:00:26   courtney
** New error codes for asm blocks.
** 
**    Rev 1.32   13 Jul 1993 10:09:34   ernie
** Added LERR_SDS_TIMEOUT definition
** 
**    Rev 1.31   16 Jun 1993 12:22:22   mindy
** Fixed compile problem
** 
**    Rev 1.30   14 Jun 1993 11:17:12   nghia
** Removed the TBIRDERR and TBIRDWARN to enforce using the new error code.
** 
**    Rev 1.29   06 Jun 1993 21:16:56   courtney
** New error codes for C++.
** 
**    Rev 1.28   03 Jun 1993 18:37:12   nghia
** Revised error codes to remove TBRIDWARN and TBIRDERR macros usage.
** 
**    Rev 1.27   01 Jun 1993 12:03:14   nghia
** Merged rev 1.15.1.0 (pv 1.3 bmw release) to trunk.
** 
**    Rev 1.26   03 May 1993 15:03:28   nghia
** Added LERR_NO_LINENUMS_ADDED
** 
**    Rev 1.25   16 Apr 1993 13:56:18   nghia
** Added LERR_NO_STKINFO error.
** 
**    Rev 1.24   12 Apr 1993 17:56:36   nghia
** Added LERR_INCOMPATIBLE_CPU and LERR_DEFSEC_NOT_FOUND.
** 
**    Rev 1.23   23 Mar 1993 18:10:10   courtney
** Added error code: too many sections.
** 
**    Rev 1.22   22 Mar 1993 17:00:08   nghia
** Move ERR.C prototypes to this file. Removed unnecesary variable.
** 
**    Rev 1.21   08 Mar 1993 09:54:58   nghia
** Cleanup and aligned error id.
** 
**    Rev 1.20   11 Jan 1993 11:48:34   courtney
** Added new error code.
** 
**    Rev 1.19   03 Dec 1992 17:22:26   courtney
** Added error code.
** 
**    Rev 1.18   09 Nov 1992 07:28:24   courtney
** added no run accesses and no reg update errors
** 
**    Rev 1.17   07 Oct 1992 18:51:58   courtney
** New error code.
** 
**    Rev 1.16   14 Sep 1992 10:32:56   courtney
** New defines for _InfoMsg state flag.
** 
**    Rev 1.15   03 Sep 1992 12:07:18   courtney
** Added error code.
** 
**    Rev 1.14   21 Aug 1992 09:29:14   courtney
** New error code.
** 
**    Rev 1.13   14 Aug 1992 10:06:28   courtney
** New error code.
** 
**    Rev 1.12   03 Jun 1992 10:34:20   courtney
** Added error code.
** 
**    Rev 1.11   01 Jun 1992 20:13:08   courtney
** Added error code.
** 
**    Rev 1.10   18 May 1992 08:47:54   courtney
** Brackets around hosterrs.h inclusion.
** 
**    Rev 1.9   07 May 1992 16:09:10   courtney
** Added new error code, enumeration for kinds of informational messages.
** 
**    Rev 1.8   15 Apr 1992 14:25:52   courtney
** Added error code (for PPR #5512).
** 
**    Rev 1.7   01 Apr 1992 15:57:44   courtney
** Added error code.
** 
**    Rev 1.6   24 Mar 1992 21:08:10   courtney
** New error code for not finding a start PC (this is an optional
** record, also its format is an extension to the 695 spec).
** 
**    Rev 1.5   10 Feb 1992 08:57:06   courtney
** Added error code.
** 
**    Rev 1.4   30 Jan 1992 15:54:50   courtney
** Added new error definition for error return on unregister code buffers.
** 
**    Rev 1.3   15 Jan 1992 10:11:30   courtney
** Added new error message for register translation.
** 
**    Rev 1.2   09 Jan 1992 16:58:00   courtney
** Additional error codes added.
** 
**    Rev 1.1   31 Dec 1991 10:52:54   courtney
** Added new error message numbers.
** 
**    Rev 1.0   12 Dec 1991 13:42:46   courtney
** Initial revision.
**
**  $Header:   S:/tbird/arcppc/l695/err.h_v   1.0   17 Jan 1997 09:21:02   kevin  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __ERR__
#define __ERR__

/* TBird error definitions */
#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

/* errors are now in errtext/mkerrors.h */

/* returns from _Query */
#define QOK         0
#define QCANCEL     1

enum INFOMSG {LD_COMPLETE, LD_CODE_LOADED, LD_SYM_LOADED};


/* modes for _InfoMsg display */
#define IM_COLLECT  0   /* collect string */
#define IM_DISPLAY  1   /* display all collected */

extern CHAR *lerrmsg[];
extern BOOL runMode;

S16 SendMessageToCLI(CHAR *);

/* Prototypes in ERR.C */
VOID Warning(RETCODE);
VOID WarningEx(RETCODE, LPSTR);
U16  Query(RETCODE);
VOID InfoMsg(CHAR *);
VOID InitInfostring(VOID);

#endif
