/****************************************************************************
**
**  Name:  LDR.H
**
**  Description:
**      All 695-loader API's (external entry points) have the prefix: Ldr
**      Major header file used by IEEE 695 Loader.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcppc/l695/ldr.h_v  $
** 
**    Rev 1.0   17 Jan 1997 09:21:12   kevin
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:32:12   gene
** Initial revision.
** 
**    Rev 1.42   30 Aug 1993 11:05:50   ron
** Changes for Load Progress dialog
** 
**    Rev 1.41   14 Jul 1993 11:50:16   nghia
** Revised ProcessArgs() to include 1 more parameter - LPSTR for module ref.
** 
**    Rev 1.40   13 Jul 1993 10:07:46   ernie
** 1. Changed interface to Get695Bytes to return RETCODE.
** 2. Removed definitions for CODEBUF and lcode.c routines.  These are no
**    longer used.
** 
**    Rev 1.39   16 Jun 1993 10:38:48   mindy
** Trying to get file to compile
** 
**    Rev 1.38   16 Jun 1993 08:33:40   mindy
** Change lxlate.c prototypes. 
** 
**    Rev 1.37   25 May 1993 10:36:36   ernie
** 1. Changed INITIAL_CH to 0xffff (a non-character value).  Previously,
**    pushback would fail (lrecord.c) if the pushed back character was 0xff.
** 2. Added prototype for new function Get695Bytes().
** 
**    Rev 1.36   03 May 1993 15:07:02   nghia
** Revised LXlate routines to return RETCODE.
** Removed template file for CPU specific - build it with ProcInsertCpu.
** 
**    Rev 1.35   27 Apr 1993 09:28:10   doug
** rename configuration file for CPU32 family
** 
**    Rev 1.34   12 Apr 1993 16:21:28   nghia
** Revised Get695STrecord() to return RETCODE.
** 
**    Rev 1.33   23 Mar 1993 17:13:52   nghia
** Changed LSECTION prototypes to return RETCODE.
** Updated MatchRecord and Match2Record.
** 
**    Rev 1.32   23 Mar 1993 10:15:24   nghia
** Revised Close695File() prototype to return RETCODE instead of S16.
** 
**    Rev 1.31   22 Mar 1993 16:54:38   nghia
** Moved Err functions to err.h
** 
**    Rev 1.30   08 Mar 1993 10:36:34   nghia
** Major cleanup for names and comments.
** 
**    Rev 1.29   03 Dec 1992 17:25:28   courtney
** Added prototype.
** 
**    Rev 1.28   21 Oct 1992 16:34:18   courtney
** Revised prototypes for local error reporting functions, to take
** retcode-type error code, instead of static string.
** 
**    Rev 1.27   14 Sep 1992 10:36:32   courtney
** Now that TMalloc is used, can remove handles.
** 
**    Rev 1.26   21 Aug 1992 09:35:20   courtney
** Added enum for loadfile formats supported.
** 
**    Rev 1.25   05 Aug 1992 10:26:16   courtney
** Revised type of ldr_access field in CODEBUF structure to match
** size indicated in Shared Data template (sdtempl.h).
** 
**    Rev 1.24   31 Jul 1992 19:18:10   courtney
** Nice configuration file names; processor ID names.
** 
**    Rev 1.23   24 Jul 1992 15:32:54   doug
** get access and verify from memory server
** 
**    Rev 1.22   22 Jul 1992 16:42:54   doug
** conversion to generic shared data
** 
**    Rev 1.21   03 Jun 1992 10:34:34   courtney
** Revised prototypes.
** 
**    Rev 1.20   12 May 1992 09:29:36   courtney
** Inline build flag FASTBUF.
** 
**    Rev 1.19   07 May 1992 16:08:44   courtney
** Added file buffer (4K size), prototype revisions.
** 
**    Rev 1.18   15 Apr 1992 14:26:44   courtney
** Revised prototypes (for PPR #5512).
** 
**    Rev 1.17   03 Apr 1992 10:26:04   courtney
** Removed PATHLEN, moved to ldrsvr.h so that callback callers can use.
** 
**    Rev 1.16   01 Apr 1992 15:57:58   courtney
** New fields in CODEBUF structure reactivated to support code-load
** coalescing.  Get/Fill695_Stream prototypes removed (are now static
** to ldata.c).
** 
**    Rev 1.14   24 Mar 1992 21:09:46   courtney
** Prototype for Process_TrailPart().
** 
**    Rev 1.13   23 Mar 1992 14:40:02   mindy
** changes made to combine LD packets to min # write packets
** 
**    Rev 1.12   21 Mar 1992 15:18:14   courtney
** Revised prototype for _Fill695_Stream to return nbytes written.
** 
**    Rev 1.11   17 Feb 1992 16:32:40   courtney
** Added prototype for _Fill695_Stream, to handle $RE code type.
** 
**    Rev 1.10   14 Feb 1992 13:26:20   courtney
** Added result field to CODE_BUFFER type.
** 
**    Rev 1.9   10 Feb 1992 12:52:48   courtney
** SDS headers are #included here, and bracketed.
** 
**    Rev 1.8   10 Feb 1992 10:37:12   courtney
** Need to #include sshared.h so shared data items can be declared.
** 
**    Rev 1.7   10 Feb 1992 09:49:58   courtney
** Changes to support real SDS data passing.
** 
**    Rev 1.6   30 Jan 1992 15:56:06   courtney
** Revised CODEBUF struct to reflect actual shared data members for
** downloading code (these are MC68030-specific memory buffers).
** The Loader now depends on sd68030.h, no longer on sdinit.h.
** 
**    Rev 1.5   27 Jan 1992 15:50:46   courtney
** Revised prototypes for _BuildXlate and _Rxlate to pass U16 instead
** of S16 for register index type.
** 
**    Rev 1.4   25 Jan 1992 14:02:00   courtney
** Added prototypes for register mapping routines to support variable
** lifetime.
** 
**    Rev 1.3   13 Jan 1992 09:54:16   courtney
** Removed dependency on basemem.h include file.
** 
**    Rev 1.2   09 Jan 1992 17:02:08   courtney
** Prototype revision - _ProcessHdr now takes flags parameter.
** 
**    Rev 1.1   31 Dec 1991 10:56:52   courtney
** Added a new field to the SEC_INFO structure to retain handle to memory
** for this node, for later free.
** 
**    Rev 1.0   12 Dec 1991 13:45:02   courtney
** Initial revision.
**
**  $Header:   S:/tbird/arcppc/l695/ldr.h_v   1.0   17 Jan 1997 09:21:12   kevin  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __LDR__
#define __LDR__
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <stdio.h>
#include <string.h>

#ifndef _SSHARED_
#include "sshared.h"
#endif

#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

#ifndef _LDRSRV_
#include "ldrsvr.h"
#endif

#ifndef __LRECORD__
#include "lrecord.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
/* Loadfile type */
typedef enum {
   LFILE_UNKNOWN,  /* Unrecognizable loadfile */
   LFILE_695,      /* IEEE 695 (default) */
   LFILE_SREC      /* Srecord */
}  LFILE_TYPE;

#define ARGLEN    64        /* CLI command-line argument length */
#define INITIAL_CH	0xffff	/* initial value for pushback ch */
#define UNUSED  0xffff		/* initial value for code buffer section index */
#define BYTE_MASK  0x00ff	/* mask for value returned from Get695Byte */
#define LDR_BUFSIZE 4096

/* method of invocation */
#define INTERACTIVE 1
#define BATCH       2

/* Now for code downloading, Loader only uses a single code buffer to memory */
#define NUM_LOAD_BUFFERS  1
/* memory shared data member is defined to be 256 bytes */
#define MAX_LBUFFSIZE  SIZE_FILL

/* processor id values */
#define CPU_68K	 1
#define CPU_332  2

/* values for optional AD field */
#define BYTE_ORDER_8086	0xcc
#define BYTE_ORDER_68K	0xcd

/* number of parts in file */
#define MAX_PARTS  8

/* max number of sections */
#define MAX_SECTIONS    32

/* section type */
#define SECTYPE_ABS	1	/* absolute */
#define SECTYPE_REL	2	/* relocatable */

/* offset fields in 695 header */
#define W0	0
#define W1	1
#define W2	2
#define W3	3
#define W4	4
#define W5	5
#define W6	6
#define W7	7

/* IEEE 695 header structures */
typedef struct {
	U16 MAU;
	U16 MAU_len;
	U16 endian;
} AD_INFO;

typedef struct {
	U16 hdr_cpu;
	char hdr_filename[IEEE_IDNLEN];
	AD_INFO ad_info;
	U32 hdr_AD;
	U32 hdr_env;
	U32 hdr_sec;
	U32 hdr_ext;
	U32 hdr_dbg;
	U32 hdr_data;
	U32 hdr_trlr;
	U32 hdr_modend;
} HDR695;

/* Section Info structure */
typedef struct {
	char 	name[IEEE_IDNLEN];	/* section name */
	U16		sindex;				/* section index */
	U16		type;				/* type (absolute/relocatable) */
	U16		modifier;			/* modifier (code/ROM/data) */
	U16		align;				/* alignment */
	U32		size;				/* size */
	U32		offset;				/* section base offset */
} SEC_INFO;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/
/* LDR.C routines */
RETCODE ProcessArgs(LPSTR, U32, U32 *, LPSTR, BOOLEAN *, U16 *, LPSTR, LPSTR);
RETCODE ProcessHdr(HANDLE, U16, LFILE_TYPE *);
RETCODE EXPORT LdrProgressInc(void);
RETCODE EXPORT LdrProgressDone(RETCODE lderr);

/* LSECTION.C routines */
RETCODE ProcessSecPart(HANDLE, U16);
RETCODE FreeSections(U16);
RETCODE PSGetCode(U32 *, U32 *);
RETCODE PSGetData(U32 *, U32 *);

/* LDATA.C routines */
RETCODE ProcessDataPart(HANDLE, U32 *);

/* LEXTERN.C routines */
RETCODE ProcessExtPart(HANDLE);

/* LENV.C routines */
RETCODE ProcessTrailPart(HANDLE, U32 *);

/* LRECORD.C routines */
RETCODE MatchRecord(HANDLE, U16);
RETCODE Match2Record(HANDLE, U16);
RETCODE Get695Number(HANDLE, U16 *);
RETCODE Get695Offset(HANDLE, U32 *);
RETCODE Get695TIndex(HANDLE, U32 *, U32);
RETCODE Get695Idn(HANDLE, LPSTR);
RETCODE Get695LongIdn(VOID);
RETCODE Get695Op(VOID);
RETCODE Get695Byte(HANDLE, U16 *);
RETCODE Get695Bytes(HANDLE, U8 *, U16);

RETCODE Get695STrecord(HANDLE, U16 *, U16 *);
U16 Get695Srecord(HANDLE, U16 *, U32 *);
S16 Get695Nrecord(HANDLE, U16 *, LPSTR);
S16 Get695ATrecord(HANDLE, U16 *, U16 *, U16 *, U16 *);

RETCODE Peek695Byte(HANDLE, U16 *);
VOID Clear695Byte(VOID);
VOID Unget695Byte(HANDLE, U16);
VOID ClearParseState(VOID);
LONG Seek695File(HANDLE, LONG, S16);

S16 Open695File(LPSTR, OFSTRUCT *);
RETCODE Close695File(HANDLE);

#ifdef SDS_DEBUG
VOID SdsSetup(VOID);
VOID SdsLog(U16, U32, LPSTR, U32);
VOID SdsTerminate(VOID);
#endif

/* LXLATE.C routines */
RETCODE SetupXlateTable(VOID);
RETCODE Rxlate(U16 r695, U16 FAR *cpuRegId);
RETCODE CheckRegisterIndex(U16 r695);

#endif
/******************************** E O F ***********************************/
