/****************************************************************************
**
**  Name:  LMANGLE.H
**
**  Description:
**    Defines and prototypes for C++ mangling routines (lmangle.c).
**
**  $Log:   S:/tbird/arcppc/l695/lmangle.h_v  $
** 
**    Rev 1.0   17 Jan 1997 09:21:18   kevin
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:32:20   gene
** Initial revision.
** 
**    Rev 1.0   06 Jun 1993 21:23:40   courtney
** Initial revision.
**
**  $Header:   S:/tbird/arcppc/l695/lmangle.h_v   1.0   17 Jan 1997 09:21:18   kevin  $
**
**  Copyright (C) 1991-93 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define __LMANGLE__

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

/* Separates function 'user symbol name' from function/class signature */
#define MANGLE_DELIMETER  "__"
/* note: strstr() returns position if mangled, else NULL */
#define IS_MANGLED(pString)  (strstr(pString, MANGLE_DELIMETER))

/* class vtable prefix */
#define CPP_VTBL     "__vtbl"
/* pointer to item which will have static initializers (?) */
#define CPP_PTBL     "__ptbl"
/* static initializer prefix for module */
#define CPP_STATICI  "__sti"
/* static destructor prefix for module */
#define CPP_STATICD  "__std"
/* 'this' pointer */
#define CPP_THIS     "Xthis"
#define CPP_USERTHIS "this"
/* constructor prefix */
#define CPP_CTOR     "__ct__"
/* destructor prefix */
#define CPP_DTOR     "__dt__"

/* special leading char for dtor */
#define CPP_DTOR_CHAR   '~'

                       /****************************
                        *                          *
                        *        TYPEDEFS          *
                        *                          *
                        ****************************/
struct fnTag;
typedef struct fnTag {
   CHAR fnName[IEEE_IDNLEN];
   struct fnTag *fnNext;
} FNNODE;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  CppFixupLocal
**
**  Description:
**    Demangle local symbol name, returning user name.  Note that duplicate
**    'this' symbols are detected by the Loader (the symbol table does not
**    check for duplicate locals; this is the only case where duplicate symbols
**    can reside at the same lexical level (and is a result of the demangling
**    operation).
**
**  Parameters:
**        pname (in):       mangled name from loadfile
**        puserName (out):  pointer to user name (will be mangled if duplicate)
**
*****************************************************************************/
RETCODE CppFixupLocal(LPSTR pname, LPSTR *puserName);

/****************************************************************************
**
**  CppFixupFunction
**
**  Description:
**    Demangle function symbol name, returning user name.  The Loader checks
**    for duplicate static procedures (the symbol table does not), which can
**    be created as a result of the demangling operation.  Note!!! Phase 3
**    (the *next* phase) for C++ support should expand the existing symbol
**    table structure to be class-oriented in views, allowing the same function
**    member name to reside in different classes.
**
**  Parameters:
**        pname (in):       mangled name from loadfile
**        puserName (out):  pointer to user name (will be mangled if duplicate)
**        oflag (in):       if MCREATE, check for duplicates (initial load)
**                          if MOPEN, do not check duplicates (ondemand load)
**
*****************************************************************************/
RETCODE CppFixupFunction(LPSTR pname, LPSTR *puserName, BOOL oflag);

/****************************************************************************
**
**  CppFixupGlobal
**
**  Description:
**    Demangle global symbol name, returning user name.  Used also to kick
**    out unsupported global symbols (virtual table pointers and such).
**
**  Parameters:
**        pname (in):       mangled name from loadfile
**        puserName (out):  pointer to user name (will be mangled if duplicate)
**
*****************************************************************************/
RETCODE CppFixupGlobal(LPSTR pname, LPSTR *puserName);

/****************************************************************************
**
**  CppFixupMember
**
**  Description:
**    Demangle a struct/union/class (data) member name, return user name.
**
**  Parameters:
**        pname (in):       mangled name from loadfile
**        puserName (out):  pointer to user name
**
*****************************************************************************/
RETCODE CppFixupMember(LPSTR pname, LPSTR *puserName);

/****************************************************************************
**
**  CppClearFunctionTable
**
**  Description:
**    Clear function list constructed for module.
**
*****************************************************************************/
RETCODE CppClearFunctionTable(VOID);

/******************************** E O F ***********************************/
