/****************************************************************************
**
**  Name:  LOPT.H
**
**  Description:
**      Structure to support register lifetime info.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcppc/l695/lopt.h_v  $
** 
**    Rev 1.0   17 Jan 1997 09:21:18   kevin
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 10:32:20   gene
** Initial revision.
** 
**    Rev 1.4   29 Mar 1994 15:19:08   nghia
** Fixed bug for ATN9
** - Added LResetRegs() to reset all variables to DEAD state.
** 
**    Rev 1.3   16 Jun 1993 08:33:56   mindy
** Moved latn9 routine prototypes to in here.  Changed REG_INFO structure
** slightly.
** 
**    Rev 1.2   08 Mar 1993 10:50:02   nghia
** Added compiler directive.
** 
**    Rev 1.1   14 Sep 1992 10:41:10   courtney
** Revise structure (don't need to keep handle with TMalloc).
** 
**    Rev 1.0   12 Dec 1991 13:45:20   courtney
** Initial revision.
**
**  $Header:   S:/tbird/arcppc/l695/lopt.h_v   1.0   17 Jan 1997 09:21:18   kevin  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __LOPT__

#define __LOPT__

/* Note that a particular register may have several of these chained off
   of it.  ATN2's are processed at the start of the function with locals,
   whereas activations come later.  There may be more than a single symbol
   tagged to a particular register throughout the life of the function.
*/
/* Note that the handle needs to be kept so we can free the allocated
   memory.  Supposedly, a near pointer allocated by LocalAlloc can be
   converted to a handle by taking the low 16-bit word.  But, since we're
   building in Borland compact model, data pointers are far, and this
   strategy does not work.  And, we don't like to litter our code with
   Microsoft-isms like near, and far, do we?
*/
typedef struct reginfo {
    U16 nindex;     /* name index for ATN2/ATN10's assigned to this reg */
    VAR_LIFETIME_STATE status;
    SYM_DESCRIPTOR sym;   /* symbol descriptor for ST access */
    struct reginfo *next;
} REG_INFO;

RETCODE LActivate(U16, U32, VAR_LIFETIME_STATE);
RETCODE LSaveVar(U16, SYM_DESCRIPTOR, U16, VAR_LIFETIME_STATE);
RETCODE LClearRegs(VOID);
RETCODE LResetRegs(U16, U32, VAR_LIFETIME_STATE);
#endif

