/****************************************************************************
**
**  Name:  LSYM.C
**
**  Description:
**      Routines in support of Symbol Table access.
**
**  Status:  CODED
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <io.h>
#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

#ifndef __LDR__
#include "ldr.h"
#endif

#ifndef __LDEBUG__
#include "ldebug.h"
#endif

#ifndef __LSYM__
#include "lsym.h"
#endif

#ifndef __ERR__
#include "err.h"
#endif

#ifndef __LPROFILE_
#include "lprofile.h"
#endif


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

extern Elf32_Shdr *section_info[MAX_SECTIONS];
extern U16 nSections, codeSecIndex, dataSecIndex, rtaSecIndex;
extern BOOLEAN findCode, findData, findRTA;
extern BOOLEAN mergeSections;
extern CHAR sectionNames[MAX_NUM_SECTION_NAMES][SIZE_SECTION_NAME];

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
			****************************/
/******************************************************************************
**
**  FindBaseCodeIndex
**
******************************************************************************/
RETCODE FindBaseCodeIndex(U16 *pcindex) {
   LOOP_VAR i;
   /*
   ** Locate CodeBaseIndex:
   ** 1. Search for section defined in PWRVIEWS.INI
   ** 2. if 1 failed - map to the default code section
   */
   if (!findCode) {
      for (i=0; i < nSections; i++) {
         if (stricmp(section_info[i]->sec_name,
            (CHAR *)&sectionNames[CODE_SECT][0]) == 0) {
            *pcindex = codeSecIndex = i;
            /* Save the index found to use later */
            findCode = TRUE;
            return(GOOD);
         }
      }
      /* Used the default code section */
      if (stricmp(section_info[codeSecIndex]->sec_name, (CHAR *)SBASE_CODE) != 0)
         return(ER_SECTION_NOT_FOUND);
      findCode = TRUE;
   }
   *pcindex = codeSecIndex;
   return(GOOD);
}  /* FindBaseCodeIndex */

/* default section base for data symbols */
/* Used when creating Symbol Table entries for ATN5 items, which haven't
   had their address or section index information given yet (may appear
   in Public Part of file.  Though there may be several sections for data
   in an IEEE 695 file, we choose the simple one specified in PWRVIEWS.INI.
   If not found, then use the default one.
*/
/******************************************************************************
**
**  FindBaseDataIndex
**
******************************************************************************/
RETCODE FindBaseDataIndex(U16 *pdindex) {
   LOOP_VAR i;

   /* pdindex - pointer to data index */
   if (!findData) {
      for (i=0; i < nSections; i++) {
         if (stricmp(section_info[i]->sec_name,
               (CHAR *)&sectionNames[DATA_SECT][0]) == 0) {
            *pdindex = dataSecIndex = i;
            findData = TRUE;
            return(GOOD);
         }
      }
      /* Used the default data section */
      if (stricmp(section_info[dataSecIndex]->sec_name, (CHAR *)SBASE_DATA) != 0)
         return(ER_SECTION_NOT_FOUND);
      findData = TRUE;
   }
   *pdindex = dataSecIndex;
   return(GOOD);
}  /* FindBaseDataIndex */

/******************************************************************************
**
**  FindBaseRTAIndex - Find run-time activated base for stack/reg variables
**
******************************************************************************/
RETCODE FindBaseRTAIndex(U16 *psindex)
{
   if (!findRTA)
   {
      if (stricmp(section_info[rtaSecIndex]->sec_name, SBASE_RTA) != 0)
         return(ER_SECTION_NOT_FOUND);
      findRTA = TRUE;
   }
   *psindex = rtaSecIndex;  /* It's the last one in the list */
   return(GOOD);
}  /* FindBaseRTAIndex */

/******************************************************************************
**
**  FindSecModifier
**
******************************************************************************/
U16 FindSecModifier(U16 stype) {
   /* Returns the 'base type' needed for the symbol table, based on modifier
   ** kept in section info.  Note that not all sections have base type
   ** (such as these weird sections the compiler creates for heap base,
   ** and things like this).
   */
   switch (stype) {
      case SECID_CODE:
          return(BASE_CODE);
      case SECID_ROM:
          return(BASE_CODE_DATA);
      case SECID_DATA:
          return(BASE_DATA);
   }
   return(BASE_UNKNOWN);
}  /* FindSecModifier */

/******************************************************************************
**
**  GetTimesstamp
**
******************************************************************************/
RETCODE GetTimestamp(HANDLE hfile, TIMESTAMP_TYPE *pts) {
   struct ftime ft;

   /* Get time info from disk file specified by handle */
   /* Munge info to timestamp type for use by symbol table */
    /* DOS-specific */
    getftime(hfile, &ft);
    pts->year = ft.ft_year+1980;
    pts->month = ft.ft_month;
    pts->day = ft.ft_day;
    pts->hour = ft.ft_hour;
    pts->minute = ft.ft_min;
    pts->second = ft.ft_tsec*2;

    return(GOOD);
}  /* GetTimestamp */

/******************************************************************************
**
**  DiffTimestamp
**
******************************************************************************/
S16 DiffTimestamp(TIMESTAMP_TYPE *pt1, TIMESTAMP_TYPE *pt2) {
   S16 diff;

   /* Return the difference between two 695-style timestamps;
   ** Returns 0 if they are identical in all fields,
   **        <0 if t1 < t2,
   **        >0 if t1 > t2
   ** where the value returned is the amount of difference, in
   ** the first field where they differ.
   */
   if ((diff = pt1->year - pt2->year) != 0)
       return(diff);
   if ((diff = pt1->month - pt2->month) != 0)
       return(diff);
   if ((diff = pt1->day - pt2->day) != 0)
       return(diff);
   if ((diff = pt1->hour - pt2->hour) != 0)
       return(diff);
   if ((diff = pt1->minute - pt2->minute) != 0)
       return(diff);
   if ((diff = pt1->second - pt2->second) != 0)
       return(diff);

   return(0);  /* pt1 == pt2 */
}  /* DiffTimestamp */

/******************************** E O F ***********************************/
