/****************************************************************************
**
**  Name:  SDEBUG.C
**
**  Description:
**      Routines for logging output of SDS calls (during development).
**      Should *not* be linked for final version.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcppc/loader/srec/sdebug.c_v  $
** 
**    Rev 1.0   13 Jan 1998 14:00:36   hera
** Initial revision.
** 
**    Rev 1.0   13 Jan 1998 13:30:56   hera
** Initial revision.
** 
**    Rev 1.0   30 Sep 1997 16:03:28   gene
** Initial revision.
** 
**    Rev 1.3   04 Jun 1993 10:13:06   nghia
** Revised to meet coding standard.
** PIP for Source.
** 
**    Rev 1.2   12 Feb 1993 18:02:52   nghia
** Updated for release.
** 
**    Rev 1.1   21 Aug 1992 10:24:54   courtney
** Include basewind.h.
** 
**    Rev 1.0   31 Dec 1991 09:34:08   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arcppc/loader/srec/sdebug.c_v   1.0   13 Jan 1998 14:00:36   hera  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifndef _BASEWIND_
#include "basewind.h"
#endif


                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/
#if SDS_DEBUG
PRIVATE hSdsfile;
PRIVATE CHAR sdbuffer[1024];

                       /****************************
                        *                          *
                        *    EXTERNAL VARIABLES    *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *     LOCAL PROTOTYPES     *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *      EXECUTABLE CODE     *
                        *                          *
                        ****************************/

VOID ssetup(VOID) {
	OFSTRUCT of;

	hSdsfile = OpenFile("sds.dbg", &of, OF_CREATE);
	_lwrite(hSdsfile, "************** SDS output follows *****************\n\n", 53);
}  /* ssetup */

/* Log output to file */
/* note: _lwrite will not handle more than U16 bytes (65535) */
VOID slog(U16 sindex, U32 baseaddr, LPSTR buffer, U32 nbytes) {
   /* sindex - section index
      baseaddr - current base address to write data
		(implied offset from original base for section)
      buffer - bytes to write
      nbytes - number of bytes
   */
	LOOP_VAR i;
	char cbyte[10];

	wsprintf(sdbuffer, "Section Index:  %d,  Current Base Address:  0x%lx\n", 
		sindex, baseaddr);
	_lwrite(hSdsfile, sdbuffer, lstrlen((LPSTR)sdbuffer));
	wsprintf(sdbuffer, "Constant bytes follow:\n");
	_lwrite(hSdsfile, sdbuffer, lstrlen((LPSTR)sdbuffer));

	if (nbytes > UINT_MAX)
		wsprintf(sdbuffer, "Warning!! Attempt to write %ld bytes, can only write %d at most\n",
			nbytes, UINT_MAX);
	for (i=0; i<nbytes; i++) {
		sprintf(cbyte, "%02x ", buffer[i]);
		_lwrite(hSdsfile, cbyte, strlen(cbyte));
	}

	wsprintf(sdbuffer, "\nNbytes:  %d\n\n", nbytes);
	_lwrite(hSdsfile, sdbuffer, lstrlen((LPSTR)sdbuffer));
}  /* slog */

VOID sterminate(VOID) {
	_lclose(hSdsfile);
}  /* sterm */

#endif

/********************************** E O F ***********************************/
