/****************************************************************************
**
**  Name:  SLDR.H
**
**  Description:
**      All Srecord Loader API's (external entry points) have the prefix: SLD
**      Major header file used by the Srecord Loader
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcppc/loader/srec/sldr.h_v  $
** 
**    Rev 1.0   13 Jan 1998 14:00:38   hera
** Initial revision.
** 
**    Rev 1.0   13 Jan 1998 13:30:58   hera
** Initial revision.
** 
**    Rev 1.0   30 Sep 1997 16:03:30   gene
** Initial revision.
** 
**    Rev 1.10   13 Jul 1993 09:45:44   ernie
** Removed prototypes for unused routines in sdata.c
** 
**    Rev 1.9   04 Jun 1993 10:25:48   nghia
** Revised to meet coding standard.
** PIP for Source.
** 
**    Rev 1.8   12 Feb 1993 18:23:52   nghia
** Updated system types.
** Cleanup messes.
** 
**    Rev 1.7   06 Nov 1992 17:34:22   courtney
** Update local nSections after freeing.
** 
**    Rev 1.6   22 Oct 1992 17:19:18   courtney
** Revise prototype to ProcessSymbols to take flag.
** 
**    Rev 1.5   22 Oct 1992 16:12:30   courtney
** Revised prototypes for local error reporting functions.
** 
**    Rev 1.4   25 Sep 1992 21:06:32   courtney
** Added symbol support.
** 
**    Rev 1.3   25 Sep 1992 05:54:58   courtney
** Add prototypes.
** 
**    Rev 1.2   25 Sep 1992 05:43:00   courtney
** Remove handles from structs (using TMalloc); update protos.
** 
**    Rev 1.1   21 Aug 1992 10:26:58   courtney
** Update for 332 support, update CodeBuf structure (copied from 695
** Loader).
** 
**    Rev 1.0   31 Dec 1991 09:37:14   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arcppc/loader/srec/sldr.h_v   1.0   13 Jan 1998 14:00:38   hera  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#define _SLDR_
                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

#include <stdio.h>
#include <string.h>

#ifndef _SSHARED_
#include "sshared.h"
#endif
#ifndef _SDPROBE_
#include "sdprobe.h"
#endif

#ifndef _SLDRSVR_
#include "sldrsvr.h"
#endif

#ifndef __SLRECORD__
#include "slrecord.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define MAX_RECLEN  255
#define MAX_ASC_LENGTH  21

#define PATHLEN  128
#define INITIAL_CH	0xff	/* initial value for pushback ch */
#define UNUSED  0xffff		/* initial value for code buffer section index */
#define BYTE_MASK  0x00ff	/* mask for value returned from Get695Byte */

#define MAX_SECTIONS  3
#define SBASE_CODE    "code"
#define SBASE_SYMBOL  "symbol"

/* method of invocation */
#define INTERACTIVE 1
#define BATCH       2


/* processor id values (only 68K supported at this time) */
#define CPU_68K	1
/* values for optional AD field */
#define BYTE_ORDER_8086	0xcc
#define BYTE_ORDER_68K	0xcd

/* fake base indexes set up for Srecord loading, to keep all servers happy */
#define SCODE_INDEX 1   /* keeps SDS happy */
#define SSYM_INDEX  2   /* keeps Symbol Server happy */

/* for code downloading */
/* for now, Loader only uses a single code buffer to memory */
#define NUM_LOAD_BUFFERS  1
/* memory shared data member is defined to be 256 bytes */
#define MAX_LBUFFSIZE  SIZE_FILL

/* processor id values */
#define CPU_68K	 1
#define CPU_332  2

/* section type info */
typedef struct {
	char 	name[IEEE_IDNLEN];	/* section name */
	U16		sindex;				/* section index */
	U16		type;				/* type (absolute/relocatable) */
	U16		modifier;			/* modifier (code/ROM/data) */
	U16		align;				/* alignment */
	U32		size;				/* size */
	U32		offset;				/* section base offset */
} SEC_INFO;

/* code buffer structure */
typedef struct {
	/* fields used by SDS */
	DESCRIPTOR	sds_semaphore;
	MEMBER_INDEX  sds_mbr;
	DESCRIPTOR	sds_access;
	DESCRIPTOR	sds_verify;
	DESCRIPTOR	sds_offset;
	DESCRIPTOR	sds_space;
	DESCRIPTOR	sds_nbytes;
    DESCRIPTOR  sds_plength;
	DESCRIPTOR	sds_pbuffer;
    DESCRIPTOR  sds_command;
    DESCRIPTOR  sds_result;     /* currently unused */
	/* fields used by Loader - these contain values */
	LPSTR		ldr_pbuf;       /* pointer to buffer */
	U16			ldr_sindex;     /* section index */
    BOOL		ldr_written;    /* currently unused, we write as we get 'em */
    BOOLEAN     ldr_result;     /* result of last write operation */
    ACCESS_SIZE ldr_access;     /*  access size */
    BOOLEAN     ldr_verify;     /* verify memory writes */
    U32         ldr_offset;     /* offset of address */
    ADDR_SPACE  ldr_space;      /* address space */
    U32         ldr_nbytes;     /* bytes of data in current load */
} CODEBUF;

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/* routines local to DLL */
RETCODE RegisterCodeBufs(VOID);
RETCODE UnregisterCodeBufs(VOID);
S16 ProcessArgs(LPSTR, U32, U32 [], LPSTR, U16 *);
S16 ProcessHdr(HANDLE);

/* SCODE.C routines */
RETCODE RegisterCodeBufs(VOID);

/* SSECTION.C routines */
S16 ProcessSecPart(U16);
RETCODE FreeSections(U16 *);

/* SDATA.C routines */
RETCODE ProcessDataPart(FILE *, U32 *);

/* SSYM.C routines */
S16 ProcessSymbols(FILE *, U32 *, BOOLEAN);
VOID ProcessGlobalSyms(S8 *);

/* slrecord.c routines */
/* We declare pointers in a generic way, to be memory-model independent */
/* We still may need to cast in call, for near/far conversion
	(& generates a near call, regardless of memory model, hence
	a cast to far * may be required)
*/
S16 MatchRecord(HANDLE, U16, U16);
S16 Match2Record(HANDLE, U16, U16);
S16 Get695Number(HANDLE, U16 *);
S16 Get695Offset(HANDLE, U32 *);
S16 Get695TIndex(HANDLE, U32 *, U32);
S16 Get695Idn(HANDLE, LPSTR);
S16 Get695LongIdn(VOID);
S16 Get695Op(VOID);
S16 Get695Byte(HANDLE, U16 *);

S16 Peek695Byte(HANDLE, U16 *);
VOID Clear695Byte(VOID);
VOID Unget695Byte(HANDLE, U16);

/* SLRECORD.C routines */
S16 GetCodeSrec(S16, U8 *);
VOID InitHexTable(VOID);
S16 GetSrec(FILE *, U8 *);
S16 SrecType(U8 *);
VOID PushSrec(U8 *);
U8 *NextPair(U8 *, U16 *);
U8 *NextAddr(U8 *, U16, U32 *);
S8 *GetModule(S8 *, S8 *);

/* MACRO */
#define HEX_TO_BIN(c) (isdigit(c) ? (c) - '0' : (c) - 'A' + 10)

#ifdef SDS_DEBUG
VOID ssetup(VOID);
VOID slog(U16, U32, LPSTR, U32);
VOID sterminate(VOID);
#endif

/******************************** E O F *************************************/
