/****************************************************************************
**
**  Name:  memcli.h
**
**  Description:
**     Memory CLI commands
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcppc/mem/memcli.h_v  $
** 
**    Rev 1.1   20 Mar 1998 15:58:52   Winky
** 
** Add MemCliUploadMemory function.
** 
**    Rev 1.0   15 Jan 1997 14:18:24   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 11:03:42   gene
** Initial revision.
** 
**    Rev 1.4   22 Sep 1995 11:19:50   gene
** added compare
** 
**    Rev 1.2   15 Sep 1995 14:49:48   gene
** added selftest
** 
**    Rev 1.1   14 Sep 1995 16:22:34   kevin
** adde checksum
** 
**    Rev 1.0   07 Sep 1995 09:14:02   gene
** Initial revision.
** 
**    Rev 1.2   28 Feb 1992 11:38:56   doug
** simple read, write, and fill
**
**  $Header:   S:/tbird/arcppc/mem/memcli.h_v   1.1   20 Mar 1998 15:58:52   Winky  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _MEMCLI_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define MAX_CLI_FILL_LENGTH 0x100

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

RETCODE SendCliMessage(HANDLE cliHandle, LPSTR msgPtr);

/**************************************************************************
**
** InitCServer
**
** Description: Initialize the commands for the Memory Server.
**
** Parameters:
**    input:
**       cliHandle:  CLI Server Handle
**       dllHandle:  DLL Handle.
**
**    output:
**       return a 1 to indicate success
**
***************************************************************************/
RETCODE EXPORT InitCServer(HANDLE cliHandle, HANDLE dllHandle) ;

/***************************************************************************
**
**  MemCliDumpMemory
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to the read(dump) memory content
**
**  input:
**     <none>
**
**  output:
**     message:
**     <none> :
**
*****************************************************************************/
RETCODE EXPORT MemCliDumpMemory(LPSTR cmdString, U32 argc, U32 argv[]) ;


/***************************************************************************
**
**  MemCliWriteMemory
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to the write memory content
**
**  input:
**     <none>
**
**  output:
**     message:
**     <none> :
**
*****************************************************************************/
RETCODE EXPORT MemCliWriteMemory(LPSTR cmdString, U32 argc, U32 argv[]) ;

/***************************************************************************
**
**  MemCliFillMemory
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to the fill(write) memory content
**
**  input:
**     <none>
**
**  output:
**     message:
**     <none> :
**
*****************************************************************************/
RETCODE EXPORT MemCliFillMemory(LPSTR cmdString, U32 argc, U32 argv[]) ;

/***************************************************************************
**
** MemCliChecksum
**
** Description:
**    Cli interface to the checksum command
**
** Syntax:
**    checksum <address1> <address2> 
**
*****************************************************************************/
RETCODE EXPORT MemCliChecksum(LPSTR cmdString, U32 argc, U32 argv[]);

/***************************************************************************
**
**  MemCliSelfTest
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to the self-test of MICEpack
**
**     Syntax:
**        selftest
**
**  input:
**     <none>
**
**  output:
**     <none> :
**
*****************************************************************************/
RETCODE EXPORT MemCliSelfTest(LPSTR cmdString, U32 argc, U32 argv[]); 

/***************************************************************************
**
** MemCliRamtst
**
** Description:
**    Cli interface to the ramtst command
**
** Syntax:
**    ramtst <address1> <address2> [<space>]
**
*****************************************************************************/
RETCODE EXPORT MemCliRamtst(LPSTR cmdString, U32 argc, U32 argv[]) ;

/*****************************************************************
**
** MemCliCompare
**  registered with CLI in the .RC file
**
** Description:
**    Cli interface to the compare memory
**
** Syntax: compare <from_start_address> <from_end_address | LENGTH <len>>
**         TO <to_address>
**
** Input:
**    cmdString
**    argc
**    argv
**
** Output: no parameters
**
**
**     DLL entry point from CLI.
**     Calls ParseCliCompareMemory, then MemComapre().
**
**
*****************************************************************************/
RETCODE EXPORT MemCliCompareMemory(LPSTR cmdString, U32 argc, U32 argv[]) ;


/***************************************************************************
**
**  MemCliUploadMemory
**
**  Status:  PRELIMINARY
**
**  description:
**     Cli interface to the read memory content and write it into a s-record
**     format file
**
*****************************************************************************/
RETCODE EXPORT MemCliUploadMemory(LPSTR cmdString, U32 argc, U32 argv[]) ;


/******************************** E O F ***********************************/
