/****************************************************************************
**
**  Name:  memendian.c
**
**  Description:
**     This is the memory server code for endian conversion.
**
**  $Log:   S:/tbird/arcppc/mem/memendia.c_v  $
** 
**    Rev 1.0   15 Jan 1997 14:18:26   kevin
** Initial revision.
** 
**    Rev 1.0   03 Jun 1996 11:03:46   gene
** Initial revision.
** 
**    Rev 1.0   07 Sep 1995 09:14:00   gene
** Initial revision.
** 
**    Rev 1.1   16 Jul 1993 11:54:02   ernie
** Cleaned up warnings.
** 
**    Rev 1.0   14 Jul 1993 11:53:26   marilyn
** Initial revision.
**
**  $Header:   S:/tbird/arcppc/mem/memendia.c_v   1.0   15 Jan 1997 14:18:26   kevin  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _PROC_
#include "proc.h"
#endif

#ifndef _TBIRDMEM_
#include "tbirdmem.h"
#endif

                       /****************************
                        *                          *
                        *     LOCAL DEFINITIONS    *
                        *                          *
                        ****************************/


 extern ENDIAN_TYPE endian;            /* from memory.c */

                        /****************************
                         *                          *
                         *     LOCAL PROTOTYPES     *
                         *                          *
                         ****************************/


                        /****************************
                         *                          *
                         *      EXECUTABLE CODE     *
                         *                          *
                         ****************************/

U16 EXPORT MemSwapBytesInWord(U16 theWord) {                    
   if (endian == BIG_ENDIAN) {
      U16 result = ((theWord&0x00ff)<<8) + ((theWord&0xff00)>> 8);
      return result;
   }
   else
      return theWord;
}

U32 EXPORT MemSwapBytesInLong(U32 theLong) {
   if (endian == BIG_ENDIAN) {
      U8 *aByte = (U8 *)&theLong;
      U32 result = (((U32)aByte[0])<<24) + (((U32)aByte[1])<<16) +
            (((U32)aByte[2])<<8) + ((U32)aByte[3]);
      return result;
   }
   else
      return theLong;
}

U32 EXPORT MemSwapWordsInLong(U32 theLong) {
   if (endian == BIG_ENDIAN) {
      U16 *aWord = (U16 *)&theLong;
      U32 result = (((U32)aWord[0])<<16) + ((U32)aWord[1]);
      return result;
   }
   else
      return theLong;
}

U8 EXPORT MemChooseByteInWord(U16 theWord, U32 position) {
   U8 *aByte = (U8 *)&theWord;
   if (endian == BIG_ENDIAN)
      return(aByte[1-((U16)position&1)]);
   else
      return(aByte[(U16)position]);
}

U8 EXPORT MemChooseByteInLong(U32 theLong, U32 position) {
   U8 *aByte = (U8 *)&theLong;
   if (endian == BIG_ENDIAN) 
      return(aByte[3-((U16)position&3)]);
   else
      return(aByte[(U16)position]);
}

U16 EXPORT MemChooseWordInLong(U32 theLong, U32 position) {
   U16 *aWord = (U16 *)&theLong;
   if (endian == BIG_ENDIAN) 
      return(aWord[1-(((U16)position&2)>>1)]);
   else
      return(aWord[(U16)position]);
}

/********************************* E O F ***********************************/
