/*----------------------------------------------------------------------------
** Name: memmanag.h
**
** Title: Memory Manager header
**
** Purpose:
**  Define the interface for the memory manager routines.
**
** Status: PRELIMINARY | CODED | TESTED
**
** $Log:   S:/tbird/arcppc/symbol/memmanag.h_v  $
** 
**    Rev 1.4   03 Jun 1998 17:24:02   hera
** 
**    Rev 1.3   31 Mar 1998 12:00:34   Winky
** No change.
** 
**    Rev 1.2   12 Mar 1997 14:47:44   hera
** No change.
** 
**    Rev 1.1   03 Mar 1997 15:48:08   hera
** 
**    Rev 1.0   07 Sep 1995 11:16:40   gene
** Initial revision.
** 
**    Rev 1.7   10 Jul 1992 18:36:02   brucea
** Changed: size of initial table and expand table sizes to 8K
** General cleanup
** 
**    Rev 1.6   15 Jun 1992 15:35:14   brucea
** Removed: LPU8 definition - already in basictyp.h
** 
**    Rev 1.5   15 Jun 1992 09:07:16   brucea
** Added: typedef LPU8 for use with GetString call
** 
**    Rev 1.4   09 Dec 1991 09:21:44   john
** Added code to handle reinitializing the TABLE entries.  This was
** done to support removing all symbols from the symbol table.
** 
**    Rev 1.3   11 Nov 1991 13:56:24   brucea
** Added NULL_DESCRIPTOR 0L
** 
**    Rev 1.2   06 Nov 1991 14:51:42   brucea
** Changed initialization of tableHandle to 0 from 0L
** 
**    Rev 1.1   23 Oct 1991 13:00:22   john
** Added a conditional to comment out the class definition when this
** file gets included for a C compile (instead of a C++ compile)
** 
**    Rev 1.0   05 Sep 1991 11:05:24   brucea
** Initial revision.
**
** $Header:   S:/tbird/arcppc/symbol/memmanag.h_v   1.4   03 Jun 1998 17:24:02   hera  $
**
** Copyright (C) 1991 Microtek International.  All rights reserved.
**
**--------------------------------------------------------------------------*/

#define _MEMMANAG_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif

#ifndef _SYMERROR_
#include "symerror.h"
#endif
                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define INITIAL_TABLE_SIZE (1024L * 8L)
#define MIN_EXPAND_SIZE    (1024L * 8L)
#define NULL_DESCRIPTOR 0L


typedef U32 TABLE_OFFSET;
typedef U8 huge * HPU8;                        // huge pointer to U8
typedef TABLE_OFFSET huge * HP_TABLE_OFFSET;   // huge pointer to TABLE_OFFSET

                       /**********************************
                        *                                *
                        *   MEMBER FUNCTION PROTOTYPES   *
                        *                                *
                        **********************************/
#ifdef __cplusplus
class Table
   {
protected:
   HANDLE tableHandle;        //Windows handle to table memory
   HPU8 hpTableObject;        //huge pointer to top of table memory
   TABLE_OFFSET tableSize;    //how big the table is
   U32 initialSize;           //size of initial GlobalAlloc
   U32 expandSize;            //size of incremental expansion


public:

//---------------------------------------------------------------------------
// Table    // constructor
// Purpose:
//    Table constructor.  Initializes private and protected variables.
//---------------------------------------------------------------------------
Table() {   // constructor
   tableHandle = 0;
   tableSize = 0L;
   initialSize = INITIAL_TABLE_SIZE;
   expandSize = MIN_EXPAND_SIZE;
}; // end of Table constructor


//---------------------------------------------------------------------------
// GetExpandSize
//
// Purpose:
//    Return the value of the variable that holds the amount of bytes to
//    expand the table with a ReAlloc
// 
//---------------------------------------------------------------------------
U32 GetExpandSize() { return expandSize; };


//---------------------------------------------------------------------------
// GetHugeDataPtr
//
// Purpose:
//    Returns a huge pointer to the item in the table referenced from the
//    tableDataOffset offset.  Does the pointer arithmetic.
//---------------------------------------------------------------------------
HPU8 GetHugeDataPtr(TABLE_OFFSET tableDataOffset)  {
   return (hpTableObject + tableDataOffset);
}; // end of GetHugeDataPtr


//---------------------------------------------------------------------------
// GetInitialSize
//
// Purpose:
//    Return the value of the variable that holds the initial size of table
//    allocation
//---------------------------------------------------------------------------
U32 GetInitialSize() { return initialSize; };


//---------------------------------------------------------------------------
// GetTableSize
//
// Purpose:
//    Return the size of the table that has been alloc'ed to date
//---------------------------------------------------------------------------
TABLE_OFFSET GetTableSize() { return tableSize; };

   
//------------------------------------------------------------------------
// InitOrExtendTable
//
// Purpose:
//    Initialize table if tableSize = 0 else
//    extend the table by <expandSize>.
//
// Input parameters:
//    allocFlag:
//       0 if memory does not need to be zeroed upon initialization
//       GMEM_ZEROINIT if memory needs to be zeroed upon initialization
//
// Output parameters: None
//
// Error:
//    Reports ER_SYM_OUT_OF_MEMORY if memory cannot be Alloc'ed or ReAlloc'ed
//------------------------------------------------------------------------
RETCODE InitOrExtendTable(WORD zeroInitFlag);


//---------------------------------------------------------------------------
// ObliterateTable
//
// Purpose:
//    Unlocks, then frees the table to Windows memory.
//---------------------------------------------------------------------------
VOID ObliterateTable(VOID);


//---------------------------------------------------------------------------
// SetExpandSize
//
// Purpose:
//    Sets the amount of size increase of a ReAlloc when the table is full
//---------------------------------------------------------------------------
VOID SetExpandSize(U32 size) { expandSize = size; };


//---------------------------------------------------------------------------
// SetInitialSize
//
// Purpose:
//    Set initial table size
//---------------------------------------------------------------------------
VOID SetInitialSize(U32 size) { initialSize = size; };

};  // end of class Table
#endif

/******************************** E O F *************************************/
