/****************************************************************************
**
**  Name:  symclipr.h
**
**  Description:
**     Prototypes for the routines that print the symbol table to the cli.
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcppc/symbol/symclipr.h_v  $
** 
**    Rev 1.4   03 Jun 1998 17:24:18   hera
** No change.
** 
**    Rev 1.3   31 Mar 1998 12:00:54   Winky
** No change.
** 
**    Rev 1.2   12 Mar 1997 14:48:06   hera
** No change.
** 
**    Rev 1.1   03 Mar 1997 15:48:34   hera
** 
**    Rev 1.0   07 Sep 1995 11:16:50   gene
** Initial revision.
** 
**    Rev 1.9   10 Jul 1992 18:38:58   brucea
** Added: SymConvSymAddrToText
** 
**    Rev 1.8   24 Jun 1992 18:13:16   brucea
** Changed: SymPrintSymbol, SymPrintSymbols to EXPORTed functions
** 
**    Rev 1.7   20 Apr 1992 09:12:22   brucea
** Changed: removed EXPORT from SymPrintSymbol, SymPrintSymbols
** Added: SymPrintLines
** 
**    Rev 1.6   06 Jan 1992 12:37:26   john
** Added indent level parameter
** 
**    Rev 1.5   09 Dec 1991 12:19:54   john
** Renamed PrintSymbols and PrintSymbol.  These names conflicted
** with the renamed CLI command PrintSymbols.
** Updated the prototype for SymPrintBases.
** 
**    Rev 1.4   03 Dec 1991 17:16:44   brucea
** Added EXPORT to PrintSymbols
** 
**    Rev 1.3   23 Oct 1991 17:14:30   john
** Removed EXPORT from not exportable functions
** 
**    Rev 1.2   23 Oct 1991 12:58:54   john
** Needed to add the EXTERN "C" statement to allow PrintSymbols
** to be called from ytab.c.
** 
**    Rev 1.1   22 Oct 1991 13:51:20   john
** Added prototype for PrintSymbol.
** 
**    Rev 1.0   25 Sep 1991 13:35:08   john
** Initial revision.
**
**  $Header:   S:/tbird/arcppc/symbol/symclipr.h_v   1.4   03 Jun 1998 17:24:18   hera  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _SYMCLIPR_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _BASEWIND_
#include "basewind.h"
#endif
#ifndef _MEMMANAG_
#include "memmanag.h"
#endif
#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define SYMCLIPR_ADDR_TEXT_WIDTH 40

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

#ifdef __cplusplus
extern "C" {
#endif

RETCODE EXPORT
SymPrintSymbol(TABLE_OFFSET symbol, 
               SYM_DISPLAY_TYPE displayType,
               U16 indentLevel);

RETCODE EXPORT
SymPrintSymbols(SYM_DISPLAY_TYPE displayType);

RETCODE SymPrintLines(SYM_DESCRIPTOR modDesc);

//--------------------------------------------------------------------------
// SymConvSymAddrToText
//
// Output format:
//    Fixed addresses:
//       Displays fixed address as xxx-yyy where xxx is the start address and
//       yyy is the end address; then displays the range as [rrr].
//       Start and end addresses are is hex, the range is in decimal
//    Stack-based addresses:
//       Displays as a single signed decimal number followed by [sss] size.
//
// Input Parameter:
//    symbol: symbol being printed
//
// Output Parameter:
//    str: alloc'ed by caller using size SYMCLIPR_ADDR_TEXT_WIDTH
//--------------------------------------------------------------------------
RETCODE SymConvSymAddrToText(SYM_DESCRIPTOR symbol, LPSTR str);

#ifdef __cplusplus
}
#endif

RETCODE SymPrintBases(SYM_DISPLAY_TYPE displayType);

/******************************** E O F ***********************************/
