/****************************************************************************
**
**  Name:  LQUEUE.H
**
**  Description:
**      High-level interface to firmware load buffers.  Shared by 695 and
**      s-record loaders.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arcm332/inc/lqueue.h_v  $
** 
**    Rev 1.0   13 Jul 1993 10:18:28   ernie
** Initial revision.
** 
**  $Header:   S:/tbird/arcm332/inc/lqueue.h_v   1.0   13 Jul 1993 10:18:28   ernie  $
**
**  Copyright (C) 1993 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef _LQUEUE_
#define _LQUEUE_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASEWIND_
#include "basewind.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
#define BYTES_TO_TRANSMIT(n) \
   (((n) < 0x100ul) ? 1 : ((n) < 0x10000ul) ? 2 : 4)

typedef RETCODE EXPORT (*LOAD_FUNC)(VOID *info, U8 *bufPtr, U16 numBytes);

                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/****************************************************************************
**
**  LdrQueueInit
**
**  description:
**    Initializes static variables that control enqueuing load commands
**    en route to the box.  Called once before loading begins.
**
*****************************************************************************/
RETCODE EXPORT LdrQueueInit(VOID);


/****************************************************************************
**
**  LdrQueueSetAddressRecord
**
**  description:
**    Enqueues a set address record.
**
**  parameters:
**    addr:   address for following data records
**    bytes:  number of bytes of addr needed to send (use BYTES_TO_TRANSMIT
**              macro)
**
*****************************************************************************/
RETCODE EXPORT LdrQueueSetAddressRecord(U32 addr, U8 bytes);


/****************************************************************************
**
**  LdrQueueDataRecord
**
**  description:
**    Enqueues a data record.  If possible (no intervening set address or
**    repeat count commands), the data is appended to the end of the last
**    command and the byte count increased.
**
**  parameters:
**    info:        loader-specific info about current file postion
**    FillInBytes: function to call to copy bytes from file to memory.
**    currentLoadAddr:  beginning address of load record
**    repCount:    number of times to repeat data
**    byteCount:   length of data in bytes
**
*****************************************************************************/
RETCODE EXPORT LdrQueueDataRecord(VOID *info, LOAD_FUNC FillInBytes,
      U32 currentLoadAddr, U32 repCount, U32 byteCount);


/****************************************************************************
**
**  LdrQueueFlush
**
**  description:
**    Sends current load buffer to box.  Does not wait for box to process
**    buffer.
**
**  paramters:
**    currentLoadAddr:   Current load address
**
*****************************************************************************/
RETCODE EXPORT LdrQueueFlush(U32 currentLoadAddr);


/****************************************************************************
**
**  LdrQueueWait
**
**  description:
**    Waits for all load buffers to empty and propagates any errors 
**    returned from the box.  Called at the end of the load process
**    after all data has been queued.
**
*****************************************************************************/
RETCODE EXPORT LdrQueueWait(VOID);


/****************************************************************************
**
**  LdrQueueCheckLoadAbort
**
**  description:
**    If user abort requested, send load abort command to box.  Box will
**    clean up and return ER_LOAD_ABORTED for all packets in progress.
**
*****************************************************************************/
RETCODE EXPORT LdrQueueCheckLoadAbort(VOID);

/****************************************************************************
**
**  LdrQueueGetLoadAbort
**
**  description:
**    Return whether the load has been aborted already.
**
**  parameters:
**    abort (output)  TRUE indicates abort has been requested.
*****************************************************************************/
RETCODE EXPORT LdrQueueGetLoadAbort(BOOLEAN *abort);

#endif
