/****************************************************************************
**
**  Name:  sdprobe.h
**
**  Description:
**     Processor-specific shared data assignments of registers and signals
**
**  Status:  PRELIMINARY
**
**  $Log:   S:/tbird/arcm332/flash/public/sdprobe.h_v  $
** 
**    Rev 1.18.2.1   23 Jan 1996 21:16:10   Joyce
** Support MMU and FPU
** 
**    Rev 1.18.2.1.1.1   04 Jan 1996 09:12:22   joseph
** 1. Added new members for "mmu address query".
** 2. Added new member to replace SDN_REG3F which had been temporarily used for 
**    number of map blocks REALLY installed.
** 
**    Rev 1.18.2.1.1.0   03 Jan 1996 11:31:06   joseph
** Added new members for "Physical" address of memory commands.  This is a temp
** version for Joyce.
** 
**    Rev 1.18.2.1   05 Nov 1995 17:09:46   joseph
** Changes for MC68040 MMU/FPU registers support.
** 
**    Rev 1.18.2.0   02 Jul 1994 11:40:12   galli
** PDL 040 changes; merged 1.17.1.0 and 1.18.
** 
**    Rev 1.18   21 Apr 1994 16:24:58   john
** Added SIM_VALID member
**
**    Rev 1.17.1.0   02 Jul 1994 11:38:10   galli
** PDL 040 changes to 1.17.
** 
**    Rev 1.17   30 Mar 1994 15:02:12   STEVE
** Forgot to include definition of BDM_SPEED.
** 
**    Rev 1.16   30 Mar 1994 10:38:08   ernie
** Added bdmspeed member
** 
**    Rev 1.15   04 Mar 1994 10:43:32   john
** Added definitions for CPU32+ signals
** 
**    Rev 1.14   07 Oct 1993 12:40:08   ernie
** Added SD_STEP_MASK member
** 
**    Rev 1.13   22 Jul 1993 14:46:44   mindy
** changed fw_lines to avoid crossing boundry
** 
**    Rev 1.12   22 Jul 1993 12:18:34   mindy
** made fwline area larger.
** 
**    Rev 1.11   13 Jul 1993 08:12:14   ernie
** Added bus error retry member
** 
**    Rev 1.10   26 May 1993 10:45:56   ernie
** Reduced number of characters in an sd name
** 
**    Rev 1.9   24 Mar 1993 08:27:16   ernie
** Merged branch
** 
**    Rev 1.8.1.1   05 Mar 1993 15:12:06   ernie
** Added cpu16 register names
** 
**    Rev 1.8.1.0   25 Feb 1993 08:03:46   ernie
** No change.
** 
**    Rev 1.8   16 Dec 1992 15:36:52   mindy
** moved dq to fw
** 
**    Rev 1.7   09 Dec 1992 10:40:26   mindy
** changed dq'r interface
** 
**    Rev 1.6   02 Nov 1992 12:53:32   ernie
** Added abort for dq sync function
** 
**    Rev 1.5   14 Oct 1992 14:44:44   ernie
** Added dequeuer sync-up interfaces
** 
**    Rev 1.4   14 Sep 1992 08:12:50   ernie
** Added SD_SIM_ADDRESS shared data member
** 
**    Rev 1.3   19 Aug 1992 08:18:06   ernie
** Added processor-specific shared data members for configuring chip-
** select hardware.
** 
**    Rev 1.2   05 Aug 1992 15:31:16   ernie
** Added hidden registers to register list for diagnostic purposes.
** 
**    Rev 1.1   21 Jul 1992 12:40:38   doug
** a) the pc, stack, and frame pointers must be first 3
** b) added a7 to simplify stack code (firmware handles overlaps)
** 
**    Rev 1.0   20 Jul 1992 09:44:48   doug
** Initial revision.
** 
**  $Header:   S:/tbird/arcm332/flash/public/sdprobe.h_v   1.18.2.1   23 Jan 1996 21:16:10   Joyce  $
**
*****************************************************************************/
#define _SDPROBE_

#ifndef _SDTEMPL_
#include "sdtempl.h"
#endif

#ifndef _SDNUM_
#include "sdnum.h"
#endif

typedef enum {
   BDM_SLOW, BDM_FAST,
   BDM_END=0x7fff
} BDM_SPEED;

typedef struct {
   S32 frameNo;
   U32 addr;
   BOOLEAN inst;
   BOOLEAN write;
   U16 data[9];
} FW_LINES;

#define SD_DUMP_PHYSICAL "dump physical"
#define SD_FILL_PHYSICAL "fill physical"
#define SD_SEARCH_PHYSICAL "search physical"
#define SD_COPY_SRC_PHYSICAL "copy source physical"
#define SD_COPY_DES_PHYSICAL "copy dest physical"

#define SD_MMU_ADDR_QUERY_LOGICAL "mmu address query logical"
#define SD_MMU_ADDR_QUERY_SPACE "mmu address query space"
#define SD_MMU_ADDR_QUERY_PHYSICAL "mmu address query physical"
#define SD_MMU_ADDR_QUERY_RESULTS "mmu address query results"

#define SD_NUM_MAP_BLOCK_INSTALLED "number of map blocks installed"

/* CPU32 register names */
#define SD_PC SD_REG00
#define SD_A7 SD_REG01
#define SD_A6 SD_REG02
#define SD_D0 SD_REG03
#define SD_D1 SD_REG04
#define SD_D2 SD_REG05
#define SD_D3 SD_REG06
#define SD_D4 SD_REG07
#define SD_D5 SD_REG08
#define SD_D6 SD_REG09
#define SD_D7 SD_REG0A
#define SD_A0 SD_REG0B
#define SD_A1 SD_REG0C
#define SD_A2 SD_REG0D
#define SD_A3 SD_REG0E
#define SD_A4 SD_REG0F
#define SD_A5 SD_REG10
#define SD_SR SD_REG11
#define SD_SSP SD_REG12
#define SD_USP SD_REG13
#define SD_SFC SD_REG14
#define SD_DFC SD_REG15
#define SD_VBR SD_REG16
#define SD_FAR SD_REG17
#define SD_PCC SD_REG18
#define SD_SSW SD_REG19

/* CPU16 register names */
#define SD_IP SD_REG00
#define SD_SP SD_REG01
#define SD_IZ SD_REG02
#define SD_IY SD_REG03
#define SD_IX SD_REG04
#define SD_D  SD_REG05
#define SD_E  SD_REG06
#define SD_EK SD_REG07
#define SD_CCR SD_REG08
#define SD_HR SD_REG09
#define SD_IR SD_REG0A
#define SD_AML SD_REG0B
#define SD_AMH SD_REG0C
#define SD_SL SD_REG0D
#define SD_XM SD_REG0E
#define SD_YM SD_REG0F
#define SD_PCR SD_REG10   /* raw pc register = ip+6 */

/* EC040 register names */
#define SD_PC SD_REG00
#define SD_A7 SD_REG01
#define SD_A6 SD_REG02
#define SD_D0 SD_REG03
#define SD_D1 SD_REG04
#define SD_D2 SD_REG05
#define SD_D3 SD_REG06
#define SD_D4 SD_REG07
#define SD_D5 SD_REG08
#define SD_D6 SD_REG09
#define SD_D7 SD_REG0A
#define SD_A0 SD_REG0B
#define SD_A1 SD_REG0C
#define SD_A2 SD_REG0D
#define SD_A3 SD_REG0E
#define SD_A4 SD_REG0F
#define SD_A5 SD_REG10
#define SD_SR SD_REG11
#define SD_ISP SD_REG12
#define SD_USP SD_REG13
#define SD_SFC SD_REG14
#define SD_DFC SD_REG15
#define SD_VBR SD_REG16
#define SD_CACR SD_REG17
#define SD_DACR0 SD_REG18
#define SD_DACR1 SD_REG19
#define SD_IACR0 SD_REG1A
#define SD_IACR1 SD_REG1B
#define SD_MSP SD_REG1C

/* LC040 register names */
#define SD_PC SD_REG00
#define SD_A7 SD_REG01
#define SD_A6 SD_REG02
#define SD_D0 SD_REG03
#define SD_D1 SD_REG04
#define SD_D2 SD_REG05
#define SD_D3 SD_REG06
#define SD_D4 SD_REG07
#define SD_D5 SD_REG08
#define SD_D6 SD_REG09
#define SD_D7 SD_REG0A
#define SD_A0 SD_REG0B
#define SD_A1 SD_REG0C
#define SD_A2 SD_REG0D
#define SD_A3 SD_REG0E
#define SD_A4 SD_REG0F
#define SD_A5 SD_REG10
#define SD_SR SD_REG11
#define SD_ISP SD_REG12
#define SD_USP SD_REG13
#define SD_SFC SD_REG14
#define SD_DFC SD_REG15
#define SD_VBR SD_REG16
#define SD_CACR SD_REG17
#define SD_DTTR0 SD_REG18
#define SD_DTTR1 SD_REG19
#define SD_ITTR0 SD_REG1A
#define SD_ITTR1 SD_REG1B
#define SD_MSP SD_REG1C
#define SD_MMUSR SD_REG1D
#define SD_URP SD_REG1E
#define SD_SRP SD_REG1F
#define SD_TC SD_REG20

/* 040 register names */
#define SD_PC SD_REG00
#define SD_A7 SD_REG01
#define SD_A6 SD_REG02
#define SD_D0 SD_REG03
#define SD_D1 SD_REG04
#define SD_D2 SD_REG05
#define SD_D3 SD_REG06
#define SD_D4 SD_REG07
#define SD_D5 SD_REG08
#define SD_D6 SD_REG09
#define SD_D7 SD_REG0A
#define SD_A0 SD_REG0B
#define SD_A1 SD_REG0C
#define SD_A2 SD_REG0D
#define SD_A3 SD_REG0E
#define SD_A4 SD_REG0F
#define SD_A5 SD_REG10
#define SD_SR SD_REG11
#define SD_ISP SD_REG12
#define SD_USP SD_REG13
#define SD_SFC SD_REG14
#define SD_DFC SD_REG15
#define SD_VBR SD_REG16
#define SD_CACR SD_REG17
#define SD_DTTR0 SD_REG18
#define SD_DTTR1 SD_REG19
#define SD_ITTR0 SD_REG1A
#define SD_ITTR1 SD_REG1B
#define SD_MSP SD_REG1C
#define SD_MMUSR SD_REG1D
#define SD_URP SD_REG1E
#define SD_SRP SD_REG1F
#define SD_TC SD_REG20
#define SD_FPCR SD_REG21
#define SD_FPSR SD_REG22
#define SD_FPIAR SD_REG23
#define SD_FP0_EXT SD_REG24
#define SD_FP0_HDW SD_REG25
#define SD_FP0_LDW SD_REG26
#define SD_FP1_EXT SD_REG27
#define SD_FP1_HDW SD_REG28
#define SD_FP1_LDW SD_REG29
#define SD_FP2_EXT SD_REG2A
#define SD_FP2_HDW SD_REG2B
#define SD_FP2_LDW SD_REG2C
#define SD_FP3_EXT SD_REG2D
#define SD_FP3_HDW SD_REG2E
#define SD_FP3_LDW SD_REG2F
#define SD_FP4_EXT SD_REG30
#define SD_FP4_HDW SD_REG31
#define SD_FP4_LDW SD_REG32
#define SD_FP5_EXT SD_REG33
#define SD_FP5_HDW SD_REG34
#define SD_FP5_LDW SD_REG35
#define SD_FP6_EXT SD_REG36
#define SD_FP6_HDW SD_REG37
#define SD_FP6_LDW SD_REG38
#define SD_FP7_EXT SD_REG39
#define SD_FP7_HDW SD_REG3A
#define SD_FP7_LDW SD_REG3B

#define SDN_PC SDN_REG00
#define SDN_A7 SDN_REG01
#define SDN_A6 SDN_REG02
#define SDN_D0 SDN_REG03
#define SDN_D1 SDN_REG04
#define SDN_D2 SDN_REG05
#define SDN_D3 SDN_REG06
#define SDN_D4 SDN_REG07
#define SDN_D5 SDN_REG08
#define SDN_D6 SDN_REG09
#define SDN_D7 SDN_REG0A
#define SDN_A0 SDN_REG0B
#define SDN_A1 SDN_REG0C
#define SDN_A2 SDN_REG0D
#define SDN_A3 SDN_REG0E
#define SDN_A4 SDN_REG0F
#define SDN_A5 SDN_REG10
#define SDN_SR SDN_REG11
#define SDN_SSP SDN_REG12
#define SDN_USP SDN_REG13
#define SDN_SFC SDN_REG14
#define SDN_DFC SDN_REG15
#define SDN_VBR SDN_REG16
#define SDN_FAR SDN_REG17
#define SDN_PCC SDN_REG18
#define SDN_SSW SDN_REG19

#define SDN_IP SDN_REG00
#define SDN_SP SDN_REG01
#define SDN_IZ SDN_REG02
#define SDN_IY SDN_REG03
#define SDN_IX SDN_REG04
#define SDN_D  SDN_REG05
#define SDN_E  SDN_REG06
#define SDN_EK SDN_REG07
#define SDN_CCR SDN_REG08
#define SDN_HR SDN_REG09
#define SDN_IR SDN_REG0A
#define SDN_AML SDN_REG0B
#define SDN_AMH SDN_REG0C
#define SDN_SL SDN_REG0D
#define SDN_XM SDN_REG0E
#define SDN_YM SDN_REG0F
#define SDN_PCR SDN_REG10   /* raw pc register = ip+6 */

#define SDN_PC SDN_REG00
#define SDN_A7 SDN_REG01
#define SDN_A6 SDN_REG02
#define SDN_D0 SDN_REG03
#define SDN_D1 SDN_REG04
#define SDN_D2 SDN_REG05
#define SDN_D3 SDN_REG06
#define SDN_D4 SDN_REG07
#define SDN_D5 SDN_REG08
#define SDN_D6 SDN_REG09
#define SDN_D7 SDN_REG0A
#define SDN_A0 SDN_REG0B
#define SDN_A1 SDN_REG0C
#define SDN_A2 SDN_REG0D
#define SDN_A3 SDN_REG0E
#define SDN_A4 SDN_REG0F
#define SDN_A5 SDN_REG10
#define SDN_SR SDN_REG11
#define SDN_ISP SDN_REG12
#define SDN_USP SDN_REG13
#define SDN_SFC SDN_REG14
#define SDN_DFC SDN_REG15
#define SDN_VBR SDN_REG16
#define SDN_CACR SDN_REG17
#define SDN_DACR0 SDN_REG18
#define SDN_DACR1 SDN_REG19
#define SDN_IACR0 SDN_REG1A
#define SDN_IACR1 SDN_REG1B
#define SDN_MSP SDN_REG1C

#define SDN_PC SDN_REG00
#define SDN_A7 SDN_REG01
#define SDN_A6 SDN_REG02
#define SDN_D0 SDN_REG03
#define SDN_D1 SDN_REG04
#define SDN_D2 SDN_REG05
#define SDN_D3 SDN_REG06
#define SDN_D4 SDN_REG07
#define SDN_D5 SDN_REG08
#define SDN_D6 SDN_REG09
#define SDN_D7 SDN_REG0A
#define SDN_A0 SDN_REG0B
#define SDN_A1 SDN_REG0C
#define SDN_A2 SDN_REG0D
#define SDN_A3 SDN_REG0E
#define SDN_A4 SDN_REG0F
#define SDN_A5 SDN_REG10
#define SDN_SR SDN_REG11
#define SDN_ISP SDN_REG12
#define SDN_USP SDN_REG13
#define SDN_SFC SDN_REG14
#define SDN_DFC SDN_REG15
#define SDN_VBR SDN_REG16
#define SDN_CACR SDN_REG17
#define SDN_DTTR0 SDN_REG18
#define SDN_DTTR1 SDN_REG19
#define SDN_ITTR0 SDN_REG1A
#define SDN_ITTR1 SDN_REG1B
#define SDN_MSP SDN_REG1C
#define SDN_MMUSR SDN_REG1D
#define SDN_URP SDN_REG1E
#define SDN_SRP SDN_REG1F
#define SDN_TC SDN_REG20

#define SDN_PC SDN_REG00
#define SDN_A7 SDN_REG01
#define SDN_A6 SDN_REG02
#define SDN_D0 SDN_REG03
#define SDN_D1 SDN_REG04
#define SDN_D2 SDN_REG05
#define SDN_D3 SDN_REG06
#define SDN_D4 SDN_REG07
#define SDN_D5 SDN_REG08
#define SDN_D6 SDN_REG09
#define SDN_D7 SDN_REG0A
#define SDN_A0 SDN_REG0B
#define SDN_A1 SDN_REG0C
#define SDN_A2 SDN_REG0D
#define SDN_A3 SDN_REG0E
#define SDN_A4 SDN_REG0F
#define SDN_A5 SDN_REG10
#define SDN_SR SDN_REG11
#define SDN_ISP SDN_REG12
#define SDN_USP SDN_REG13
#define SDN_SFC SDN_REG14
#define SDN_DFC SDN_REG15
#define SDN_VBR SDN_REG16
#define SDN_CACR SDN_REG17
#define SDN_DTTR0 SDN_REG18
#define SDN_DTTR1 SDN_REG19
#define SDN_ITTR0 SDN_REG1A
#define SDN_ITTR1 SDN_REG1B
#define SDN_MSP SDN_REG1C
#define SDN_MMUSR SDN_REG1D
#define SDN_URP SDN_REG1E
#define SDN_SRP SDN_REG1F
#define SDN_TC SDN_REG20
#define SDN_FPCR SDN_REG21
#define SDN_FPSR SDN_REG22
#define SDN_FPIAR SDN_REG23
#define SDN_FP0_EXT SDN_REG24
#define SDN_FP0_HDW SDN_REG25
#define SDN_FP0_LDW SDN_REG26
#define SDN_FP1_EXT SDN_REG27
#define SDN_FP1_HDW SDN_REG28
#define SDN_FP1_LDW SDN_REG29
#define SDN_FP2_EXT SDN_REG2A
#define SDN_FP2_HDW SDN_REG2B
#define SDN_FP2_LDW SDN_REG2C
#define SDN_FP3_EXT SDN_REG2D
#define SDN_FP3_HDW SDN_REG2E
#define SDN_FP3_LDW SDN_REG2F
#define SDN_FP4_EXT SDN_REG30
#define SDN_FP4_HDW SDN_REG31
#define SDN_FP4_LDW SDN_REG32
#define SDN_FP5_EXT SDN_REG33
#define SDN_FP5_HDW SDN_REG34
#define SDN_FP5_LDW SDN_REG35
#define SDN_FP6_EXT SDN_REG36
#define SDN_FP6_HDW SDN_REG37
#define SDN_FP6_LDW SDN_REG38
#define SDN_FP7_EXT SDN_REG39
#define SDN_FP7_HDW SDN_REG3A
#define SDN_FP7_LDW SDN_REG3B

/* CPU32 and CPU16 signal names */
#define SD_CLK_SIG   SD_SIG00
#define SD_RESET_SIG SD_SIG01

#define SDN_CLK_SIG   SDN_SIG00
#define SDN_RESET_SIG SDN_SIG01

/* CPU32P signal names */
#define SD_CLK_SIG   SD_SIG00
#define SD_RESETH_SIG SD_SIG01
#define SD_RESETS_SIG SD_SIG02

#define SDN_CLK_SIG   SDN_SIG00
#define SDN_RESETH_SIG SDN_SIG01
#define SDN_RESETS_SIG SDN_SIG02

/* EC040 signal names */
#define SD_RSTI_SIG SD_SIG00
#define SD_IPL_SIG SD_SIG01
#define SD_TEA_SIG SD_SIG02
#define SD_CDIS_SIG SD_SIG03

#define SDN_RSTI_SIG SDN_SIG00
#define SDN_IPL_SIG SDN_SIG01
#define SDN_TEA_SIG SDN_SIG02
#define SDN_CDIS_SIG SDN_SIG03

/* LC040 signal names */
#define SD_RSTI_SIG SD_SIG00
#define SD_IPL_SIG SD_SIG01
#define SD_TEA_SIG SD_SIG02
#define SD_CDIS_SIG SD_SIG03
#define SD_MDIS_SIG SD_SIG04

#define SDN_RSTI_SIG SDN_SIG00
#define SDN_IPL_SIG SDN_SIG01
#define SDN_TEA_SIG SDN_SIG02
#define SDN_CDIS_SIG SDN_SIG03
#define SDN_MDIS_SIG SDN_SIG04

/* 040 signal names */
#define SD_RSTI_SIG SD_SIG00
#define SD_IPL_SIG SD_SIG01
#define SD_TEA_SIG SD_SIG02
#define SD_CDIS_SIG SD_SIG03
#define SD_MDIS_SIG SD_SIG04

#define SDN_RSTI_SIG SDN_SIG00
#define SDN_IPL_SIG SDN_SIG01
#define SDN_TEA_SIG SDN_SIG02
#define SDN_CDIS_SIG SDN_SIG03
#define SDN_MDIS_SIG SDN_SIG04

#define NUM_REGISTERS 0x17
#define NUM_REGISTERS_INCLUDING_HIDDEN 0x19 /* Does not include SSW */
#define NUM_REGISTERS_68EC040 0x1D
#define NUM_REGISTERS_68LC040 0x21
#define NUM_REGISTERS_MC68040 0x3C


#ifdef SHARED_DATA_MEMBERS
/*
** Processor-specific shared data member definitions
*/
#define SIZE_FW_INST   2800  /* (sizeof(FW_LINES)*100 */

#define SD_CONFIG_CS_HW_CMD "configcs hardware command"
#define SD_CONFIG_CS_HW_RESULT "configcs hardware result"
#define SD_SIM_ADDRESS "sim register bank address"
#define SD_SIM_VALID "sim valid"
#define SD_FIND_FLUSH_BUFFER  "find flush buffer"
#define SD_FIND_FLUSH_START   "find flush start"
#define SD_FIND_FLUSH_ABORT   "find flush abort"
#define SD_FIND_FLUSH_FOUND   "find flush found"
#define SD_FIND_FLUSH_INSTS   "find flush instructions"
#define SD_FIND_FLUSH_COUNT   "find flush instruction count"
#define SD_FIND_FLUSH_END     "find flush ending frame"
#define SD_DQSYNC_FETCH_FRAME "dqsync fetch frame"
#define SD_DQSYNC_EXEC_FRAME  "dqsync exec frame"
#define SD_BERR_RETRY         "bus error retry"
#define SD_STEP_MASK          "step mask"
#define SD_BDM_SPEED          "bdm speed"

/*
** Write TRUE to the CMD member to cause firmware to read current contents
** of chip select registers.  This information is immediately used to
** reconfigure map and execution breakpoints, and is loaded into local
** storage and used for subsequent map and execution breakpoints.  Chip
** select information is also used to configure the source of DQ and
** source for A19-A23 for the trace.  The result of the operation is
** written to the result member.
*/
{1, SD_CONFIG_CS_HW_CMD,   SDN_CONFIG_CS_HW_CMD,   SIZE_BOOL,   WR, RD }
{1, SD_CONFIG_CS_HW_RESULT,SDN_CONFIG_CS_HW_RESULT,SIZE_RETCODE,RD, WR }
/*
** SD_SIM_VALID indicates the sim is accessable.  This is extremely
** important for the 330/340/360 processors.
**
** SD_SIM_ADDRESS indicates the starting address of the SIM register
** block.  For the 332, this will be either 0xfffa00 or 0x7ffa00.  This
** information is used by the event and trigger servers.
*/
{1, SD_SIM_VALID,          SDN_SIM_VALID,          SIZE_BOOL,   RD, WR }
{1, SD_SIM_ADDRESS,        SDN_SIM_ADDRESS,        SIZE_LONG,   RD, WR }

/*
** This block is for accelerating the dequeuer.  Write trace buffer
** information (logical frame numbers) to buffer and starting frame.
** Writing start kicks off the firmware.  Found indicates whether
** a flush was found. 
** Flush inst contains an array of FW_LINES of instructions or data
** accesses. Flush count is the number of "dq" lines. And finally
** flush end is the frame number of the last dq'd instruction.
*/
{1, SD_FIND_FLUSH_BUFFER,  SDN_FIND_FLUSH_BUFFER,  SIZE_WORD,   WR, RD }
{1, SD_FIND_FLUSH_START,   SDN_FIND_FLUSH_START,   SIZE_LONG,   WR, RD }
{1, SD_FIND_FLUSH_ABORT,   SDN_FIND_FLUSH_ABORT,   SIZE_BOOL,   WR, RD }
{1, SD_FIND_FLUSH_FOUND,   SDN_FIND_FLUSH_FOUND,   SIZE_BYTE,   RD, WR }
{1, SD_FIND_FLUSH_INSTS,   SDN_FIND_FLUSH_INSTS,   SIZE_FW_INST,RD, WR }
{1, SD_FIND_FLUSH_COUNT,   SDN_FIND_FLUSH_COUNT,   SIZE_WORD,   RW, RW }
{1, SD_FIND_FLUSH_END,     SDN_FIND_FLUSH_END,     SIZE_LONG,   RD, WR }
/*
** Bus error retry member.  When set TRUE, unterminated memory cycles
** are ended by asserting BERR.
*/
{1, SD_BERR_RETRY,         SDN_BERR_RETRY,         SIZE_BOOL,   WR, RD }

{1, SD_STEP_MASK,          SDN_STEP_MASK,          SIZE_BOOL,   WR, RD }

{1, SD_BDM_SPEED,          SDN_BDM_SPEED,          SIZE_ENUM,   WR, RD }

/* Physical Addr Specifiers for Memory Commands */
{NUM_DUMP, SD_DUMP_PHYSICAL,  SDN_DUMP_PHYSICAL,  SIZE_BOOL,     RW, RD }
{NUM_FILL, SD_FILL_PHYSICAL,  SDN_FILL_PHYSICAL,  SIZE_BOOL,     RW, RD }
{NUM_SEARCH, SD_SEARCH_PHYSICAL,  SDN_SEARCH_PHYSICAL,  SIZE_BOOL,     RW, RD }
{NUM_COPY, SD_COPY_SRC_PHYSICAL,SDN_COPY_SRC_PHYSICAL,SIZE_BOOL,     RW, RD }
{NUM_COPY, SD_COPY_DES_PHYSICAL,SDN_COPY_DES_PHYSICAL,SIZE_BOOL,     RW, RD }

{1, SD_MMU_ADDR_QUERY_LOGICAL, SDN_MMU_ADDR_QUERY_LOGICAL, SIZE_LONG, RW, RD }
{1, SD_MMU_ADDR_QUERY_SPACE, SDN_MMU_ADDR_QUERY_SPACE, SIZE_ENUM, RW, RD }
{1, SD_MMU_ADDR_QUERY_PHYSICAL, SDN_MMU_ADDR_QUERY_PHYSICAL, SIZE_LONG, RW, RW }
{1, SD_MMU_ADDR_QUERY_RESULTS, SDN_MMU_ADDR_QUERY_RESULT, SIZE_RETCODE, RW, RW }

{1, SD_NUM_MAP_BLOCK_INSTALLED, SDN_NUM_MAP_BLOCK_INSTALLED, SIZE_LONG, RD, WR}

#endif
