/****************************************************************************
**
**  Name:  sdtempl.h
**
**  Description:
**     Shared data template for Tbird
**
**     This file should not be directly included by source files...instead
**     include sdprobe.h.
**
**  $Log:   S:/tbird/arccore/flash/public/sdtempl.h_v  $
** 
**    Rev 1.30.1.0   17 May 1994 15:27:36   ernie
** Added serial number to load response packet.
** 
**    Rev 1.30   04 Mar 1994 08:37:14   ernie
** Added 2 more break causes to end of list for 386
** 
**    Rev 1.29   01 Mar 1994 15:50:08   marilyn
** Added PMODE defs.
** 
**    Rev 1.28   28 Feb 1994 10:40:12   marilyn
** Expanded ADDR_SPACE definition to include Intel spaces.
** 
**    Rev 1.27   14 Feb 1994 13:07:30   marilyn
** Expanded support of PROBE_TYPE to include M68306, M68349, M68040, M68EC040,
** M68LC040, I80386, and I80486.
** 
**    Rev 1.26   08 Nov 1993 20:20:10   mindy
** Added member SD_MAX_TRACE_BUFFER.  This member is updated as part
** of the UPDATE_PER_MINUTE group.
** 
**    Rev 1.25   13 Jul 1993 08:13:32   ernie
** Changed loader interface for efficiency
** 
**    Rev 1.24   09 Jun 1993 08:30:22   ernie
** Added memory search members
** 
**    Rev 1.23   26 May 1993 10:45:52   ernie
** Reduced number of characters in an sd name
** 
**    Rev 1.22   25 May 1993 15:02:58   ernie
** Increased number of dump buffers from 8 to 32
** 
**    Rev 1.21   13 Apr 1993 08:34:04   doug
** Updated comments for clarification.
** 
**    Rev 1.20   09 Apr 1993 07:02:04   ernie
** Added memory copy members
** 
**    Rev 1.19   30 Mar 1993 14:43:06   ernie
** Added 68334, 68360 processors
** 
**    Rev 1.18   22 Mar 1993 07:26:16   ernie
** Added member SD_EMULATION_RESULT for returning errors from GO, etc.
** 
**    Rev 1.17   12 Jan 1993 10:28:28   john
** made addr_space enums match in addr.h and sdtempl.h
** 
**    Rev 1.16   17 Dec 1992 07:00:30   ernie
** Merged branch 1.13.1.1
** 
**    Rev 1.15   16 Dec 1992 15:37:58   mindy
** moved dq to fw
** 
**    Rev 1.14   03 Dec 1992 08:43:58   ernie
** Added new sd member SD_MOM_PRESENT
** 
**    Rev 1.13   21 Oct 1992 10:22:22   john
** added command/response entries for map
** 
**    Rev 1.12   15 Oct 1992 15:38:44   doug
** new loader interface
** 
**    Rev 1.11   12 Oct 1992 14:34:12   doug
** new loader interface that minimizes overhead by using a structure of
** data
** 
**    Rev 1.10   09 Oct 1992 14:40:12   doug
** reset cpu now has a value to decide whether to update the emulation status;
** changed size to byte, not enum, so the shared data size remains the same
** 
**    Rev 1.9   20 Aug 1992 13:52:58   ernie
** Added enable sequencer ack member for handshaking
** 
**    Rev 1.8   19 Aug 1992 08:19:22   ernie
** 1. Changed trace status member SD_TRACING to host read-only.
** 2. Changed verify error parameter block to be per fill buffer.
** 3. Changed comments on trace status member block to reflect changes
**    in coding.
** 
**    Rev 1.7   31 Jul 1992 08:55:22   ernie
** Added SPACE_END to ADDR_SPACE enum to force word size in firmware
** 
**    Rev 1.6   29 Jul 1992 12:46:38   ernie
** Removed definition of STROBE enumeration.  This enumeration is now
** used exclusively in the low-level firmware file fwps.c.
** 
**    Rev 1.5   27 Jul 1992 09:03:18   ernie
** Removed spurious definition of NULLPTR
** 
**    Rev 1.4   23 Jul 1992 07:38:30   doug
** new breakpoint format
** 
**    Rev 1.3   21 Jul 1992 12:40:08   doug
** added shared data access from sdbase.h
** 
**    Rev 1.2   20 Jul 1992 15:50:56   doug
** address space is duplicated in addr.h, so share; also add null pointer
** 
**    Rev 1.1   20 Jul 1992 10:03:10   doug
** sdbase.h is not needed; its definitions are in sdtempl
** 
**    Rev 1.0   20 Jul 1992 09:38:18   doug
** Initial revision.
** 
**  $Header:   S:/tbird/arccore/flash/public/sdtempl.h_v   1.30.1.0   17 May 1994 15:27:36   ernie  $
**
*****************************************************************************/

#define _SDTEMPL_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/
#ifndef _BASETYPE_
#include "basetype.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/
/*
**
**  The access definitions are used for the shared data member access fields.
**
*/
typedef enum { RD, WR, RD_WR } SHARED_DATA_ACCESS;
#define RW RD_WR

/*
** ## Start of Shared Data Definitions ##
*/
/*
** ## Definitions ##
**
** The quantity definitions are for the "Quantity" field of the shared data
** members.
*/
#define NUM_DUMP          32
#define NUM_FILL          2
#define NUM_COPY          1
#define NUM_SEARCH        1
#define NUM_LOAD          4
#define NUM_MAP_ENTRIES   16
#define NUM_RDWR          4
#define NUM_RDWR_WINDOWS NUM_RDWR   /* backward compatibility */

#define NUM_TRACE         8      /* Maximum of 8 simultaneous trace windows */
#define NUM_TRACE_WINDOWS NUM_TRACE /* backward compatibility */
#define NUM_SUBBUFFERS    1024
#define NUM_GROUPS        4
#define NUM_LEVELS        4
#define NUM_COUNTERS      2

#define MAX_TRCBUFFERS    512

#define NUM_PA_RANGES     7
#define NUM_EVENTS        8
#define NUM_CA_RANGES     4

/*
** The size definitions are for the "Size" field for the shared data members.
*/
#define SIZE_BOOL         1
#define SIZE_BYTE         1
#define SIZE_BIT          SIZE_BYTE
#define SIZE_CHAR         1
#define SIZE_DOWNLOAD_BUFFER NUM_BYTES_IN_DOWNLOAD_BUFF
#define SIZE_LOAD_RESULT  8
#define SIZE_ENUM         2
#define SIZE_LONG         4
#define SIZE_QUAD_WORD    8
#define SIZE_RETCODE      SIZE_LONG
#define SIZE_ULONG        4
#define SIZE_WORD         2
#define SIZE_RDWR         256
#define SIZE_RDWR_WINDOW  SIZE_RDWR   /* backward compatibility */
#define SIZE_DUMP         256
#define SIZE_FILL         256
#define SIZE_SEARCH       256
#define SIZE_LOAD         2048 /* buffer for multiple load data packets */

#define SIZE_TRIGGER       178  /* sizeof(FW_TRIGGER) */
#define SIZE_EVTREC_RANGE  13   /* lo=4,hi=4,mask=4,not=1 */
#define SIZE_EVTREC_CONFIG 104  /* (8*SIZE_EVTREC_RANGE) - 8 ranges per grp */
#define SIZE_TRACE         1024
#define SIZE_TRACE_WRITE   256
#define SIZE_FRAME_TYPE    SIZE_ENUM
#define SIZE_TRACE_MODE    SIZE_ENUM
#define SIZE_QUAL_MODE     SIZE_ENUM

#define SIZE_TIMESTAMP     6
#define SIZE_TIMESTAMPS    6144            /* 6*1024 */
#define SIZE_PA_TIME       6
#define SIZE_CA_RESULTS    1024            /* 256 longs */
#define SIZE_SWAT_RW       256
#define SIZE_SWAT_MODE     SIZE_ENUM
#define SIZE_PA_EVENT      SIZE_ENUM

#define TMOD_40MHZ          2   /* min compatibility to have 2 vram banks */
/*
** The shared data member names are for the "Name" field for the shared data
** members.
*/
#define SD_MAX_NAME 31 /* the maximum number of characters a name can have */
/* sdinit */
#define SD_CONNECT "connect to emulator"
#define SD_DISCONNECT "disconnect from emulator"
#define SD_MOM_COMPATIBILITY "mom compatibility number"
#define SD_MOM_MAJOR_VERSION "mom major version number"
#define SD_MOM_MINOR_VERSION "mom minor version number"
#define SD_MOM_PRESENT "mom is installed"
#define SD_PROBE_MAJOR_VERSION "probe major version number"
#define SD_PROBE_MINOR_VERSION "probe minor version number"
#define SD_PROBE_TYPE "probe type"
#define SD_RESET "reset emulator"
#define SD_SWAT_COMPATIBILITY "swat compatibility number"
#define SD_SWAT_MAJOR_VERSION "swat major version number"
#define SD_SWAT_MINOR_VERSION "swat minor version number"
#define SD_SWAT_PRESENT "swat is installed"
#define SD_TBIRD_STATUS "tbird box current status"
#define SD_PROBE_COMPATIBILITY "probe compatibility number"
#define SD_TRACE_0_COMPATIBILITY "trace 0 compatibility number"
#define SD_TRACE_0_MAJOR_VERSION "trace 0 major version number"
#define SD_TRACE_0_MINOR_VERSION "trace 0 minor version number"
#define SD_TRACE_0_SLOT_PRESENT "trace 0 board is installed"
#define SD_TRACE_1_COMPATIBILITY "trace 1 compatibility number"
#define SD_TRACE_1_MAJOR_VERSION "trace 1 major version number"
#define SD_TRACE_1_MINOR_VERSION "trace 1 minor version number"
#define SD_TRACE_1_SLOT_PRESENT "trace 1 board is installed"
#define SD_TRACE_2_COMPATIBILITY "trace 2 compatibility number"
#define SD_TRACE_2_MAJOR_VERSION "trace 2 major version number"
#define SD_TRACE_2_MINOR_VERSION "trace 2 minor version number"
#define SD_TRACE_2_SLOT_PRESENT "trace 2 board is installed"
#define SD_TRACE_3_COMPATIBILITY "trace 3 compatibility number"
#define SD_TRACE_3_MAJOR_VERSION "trace 3 major version number"
#define SD_TRACE_3_MINOR_VERSION "trace 3 minor version number"
#define SD_TRACE_3_SLOT_PRESENT "trace 3 board is installed"
#define SD_RDWR_SEMAPHORE "rd/wr semaphore"
#define SD_RDWR_READ_WRITE "rd/wr read or write flag"
#define SD_RDWR_SPACE "rd/wr motherboard/probe space"
#define SD_RDWR_ADDR "rd/wr address"
#define SD_RDWR_NUM_BYTES "rd/wr number of bytes"
#define SD_RDWR_BUFFER "rd/wr buffer"
#define SD_NUM_SHARED_DATA_BYTES "number of bytes in shared data"
#define SD_SHARED_DATA_START_INDEX "member index to start reading at"
#define SD_SHARED_DATA_LENGTH "number of bytes to read"
#define SD_FIRMWARE_MAJOR_VERSION "firmware major version number"
#define SD_FIRMWARE_MINOR_VERSION "firmware minor version number"
#define SD_FIRMWARE_COMPATIBILITY "firmware compatibility number"
#define SD_PROBE_INIT "probe initialization request"
#define SD_PRBINIT_RESP "probe initialzation response"
/* sdtrace */
#define SD_ACTIVE_BUFFER        "active trace buffer"
#define SD_BUFFER_EMON          "emon status for active buffer"
#define SD_BUFFER_CHECK         "valid trace buffer?"
#define SD_BUFFER_CHECK_EMON    "emon status for buffer check"
#define SD_BUFFER_OLDEST        "oldest frame in active buffer"
#define SD_BUFFER_YOUNGEST      "youngest frame in active buffer"
#define SD_BRK_ON_TRACE_FULL    "break on trace full"
#define SD_CLEAR_TRACE          "clear trace"
#define SD_TRACE_EMPTY          "trace empty"
#define SD_COUNTER_VALUE        "counter value"
#define SD_CURRENT_SUBBUFFER    "current subbuffer"
#define SD_MAX_TRACE_BUFFER     "max trace buffer"
#define SD_TRIC_DIAGNOSTIC_MODE "tric diagnostic mode"
#define SD_ENABLE_SEQUENCER     "enable sequencer"
#define SD_ENABLE_SEQUENCER_ACK "enable sequencer acknowledge"
#define SD_EVTREC               "evtrec"
#define SD_FOUND_SEARCH_EVENT   "search event found"
#define SD_QUAL_MODE            "qualifier mode"
#define SD_INC_TRACE_BUFFER     "increment trace buffer"
#define SD_LINKCURS_BUFFER      "linked cursor buffer"
#define SD_LINKCURS_EMON        "linked cursor emon status"
#define SD_LINKCURS_FRAME       "linked cursor frame"
#define SD_LINKCURS_ADDRESS     "address of frame"
#define SD_LINKCURS_INST        "frame instruction status"
#define SD_NUM_TRCBUFS          "number of trace buffers"
#define SD_RESET_SEQUENCE_LEVEL "reset sequence level"
#define SD_SEARCH_EVENT         "search event"
#define SD_SEARCH_BUFFER        "search buffer"
#define SD_SEARCH_EMON          "search emon"
#define SD_SEARCH_START_FRAME   "search starting frame"
#define SD_SEQUENCE_LEVEL       "sequence level"
#define SD_TERMINAL_COUNT_A     "terminal count a"
#define SD_TERMINAL_COUNT_B     "terminal count b"
#define SD_TRACE_BUFF_LEN       "trace buffer length"
#define SD_TRACE_GET_STATUS     "trace get status"
#define SD_TRACE_MODE           "trace mode"
#define SD_TRACE_SEMAPHORE      "trace semaphore"
#define SD_TRACE_START_FRAME    "trace start frame"
#define SD_FRAME_TYPE           "trace frame type"
#define SD_TRACE_STORE          "trace store"
#define SD_TRACE_WRITE_ADDRESS  "trace write address"
#define SD_TRACE_WRITE_LENGTH   "trace write length"
#define SD_TRACE_WRITE_DATA     "trace write data"
#define SD_SET_TRACING          "set tracing"
#define SD_FW_TRACING_STATUS    "fw tracing status"
#define SD_TRACING              "tracing"
#define SD_TRIGGER_INFO         "trigger action info"
#define SD_TRIGGER_PROG_ABORT   "trigger program abort"
#define SD_TRIGGER_PROGRAM_ACK  "trigger program acknowledge"
#define SD_TRIGOUT_ENABLE       "trigger out enable"
#define SD_UPDATES_PER_MINUTE   "updates per minute"
/* sdswat */
#define SD_SWAT_MODE             "swat mode"
#define SD_UPDATE_TIMESTAMP      "update timestamp"
#define SD_TIMESTAMPS            "timestamps"
#define SD_CLOCK_RATE            "clock rate"
#define SD_MEASURE_CLOCK         "measure clock"
#define SD_PA_CLEAR              "pa clear"
#define SD_PA_EVENT_SETUP        "pa event setup"
#define SD_PA_GET_RESULTS        "pa get results"
#define SD_PA_INVOCATION_COUNT   "pa invocation count"
#define SD_PA_ELAPSED_TIME       "pa elapsed time"
#define SD_PA_MAX_TIME           "pa max time"
#define SD_PA_MIN_TIME           "pa min time"
#define SD_PA_RUN                "pa run"
#define SD_PA_TOTAL_TIME         "pa total time"
#define SD_PA_COLLECTION_TIME    "pa collection time"
#define SD_CA_GRANULARITY        "ca granularity"
#define SD_CA_BASE               "ca base"
#define SD_CA_CLEAR              "ca clear"
#define SD_CA_RUN                "ca run"
#define SD_CA_READ_SEMAPHORE     "ca read semaphore"
#define SD_CA_READ_SEGMENT       "ca read segment"
#define SD_CA_READ_ADDRESS       "ca read address"
#define SD_CA_READ_LENGTH        "ca read length"
#define SD_CA_RESULTS            "ca results"
#define SD_SWAT_WRITE_ADDRESS    "swat write address"
#define SD_SWAT_WRITE_LENGTH     "swat write length"
#define SD_SWAT_WRITE_DATA       "swat write data"
#define SD_SWAT_READ_ADDRESS     "swat read address"
#define SD_SWAT_READ_LENGTH      "swat read length"
#define SD_SWAT_READ_DATA        "swat read data"
/* sdemul */
#define SD_BKPT_ADDR "breakpoint address"
#define SD_BKPT_SPACE "breakpoint space"
#define SD_BKPT_ID "breakpoint id"
#define SD_BKPT_CMD "breakpoint command"
#define SD_BKPT_ENABLE "breakpoint enable"
#define SD_BKPT_RESULT "breakpoint result"
#define SD_GO   "go"
#define SD_GR   "gr"
#define SD_STEP "step"
#define SD_HALT "halt"
#define SD_RESET_CPU "reset cpu"
#define SD_EMULATION_STATE "emulation state"
#define SD_EMULATION_RESULT "emulation result"
#define SD_BREAK_CAUSE "break cause"

#define SD_REG00 "register 00"
#define SD_REG01 "register 01"
#define SD_REG02 "register 02"
#define SD_REG03 "register 03"
#define SD_REG04 "register 04"
#define SD_REG05 "register 05"
#define SD_REG06 "register 06"
#define SD_REG07 "register 07"
#define SD_REG08 "register 08"
#define SD_REG09 "register 09"
#define SD_REG0A "register 0A"
#define SD_REG0B "register 0B"
#define SD_REG0C "register 0C"
#define SD_REG0D "register 0D"
#define SD_REG0E "register 0E"
#define SD_REG0F "register 0F"
#define SD_REG10 "register 10"
#define SD_REG11 "register 11"
#define SD_REG12 "register 12"
#define SD_REG13 "register 13"
#define SD_REG14 "register 14"
#define SD_REG15 "register 15"
#define SD_REG16 "register 16"
#define SD_REG17 "register 17"
#define SD_REG18 "register 18"
#define SD_REG19 "register 19"
#define SD_REG1A "register 1A"
#define SD_REG1B "register 1B"
#define SD_REG1C "register 1C"
#define SD_REG1D "register 1D"
#define SD_REG1E "register 1E"
#define SD_REG1F "register 1F"
#define SD_REG20 "register 20"
#define SD_REG21 "register 21"
#define SD_REG22 "register 22"
#define SD_REG23 "register 23"
#define SD_REG24 "register 24"
#define SD_REG25 "register 25"
#define SD_REG26 "register 26"
#define SD_REG27 "register 27"
#define SD_REG28 "register 28"
#define SD_REG29 "register 29"
#define SD_REG2A "register 2A"
#define SD_REG2B "register 2B"
#define SD_REG2C "register 2C"
#define SD_REG2D "register 2D"
#define SD_REG2E "register 2E"
#define SD_REG2F "register 2F"
#define SD_REG30 "register 30"
#define SD_REG31 "register 31"
#define SD_REG32 "register 32"
#define SD_REG33 "register 33"
#define SD_REG34 "register 34"
#define SD_REG35 "register 35"
#define SD_REG36 "register 36"
#define SD_REG37 "register 37"
#define SD_REG38 "register 38"
#define SD_REG39 "register 39"
#define SD_REG3A "register 3A"
#define SD_REG3B "register 3B"
#define SD_REG3C "register 3C"
#define SD_REG3D "register 3D"
#define SD_REG3E "register 3E"
#define SD_REG3F "register 3F"
#define SD_SIG00 "signal 00"
#define SD_SIG01 "signal 01"
#define SD_SIG02 "signal 02"
#define SD_SIG03 "signal 03"
#define SD_SIG04 "signal 04"
#define SD_SIG05 "signal 05"
#define SD_SIG06 "signal 06"
#define SD_SIG07 "signal 07"
#define SD_SIG08 "signal 08"
#define SD_SIG09 "signal 09"
#define SD_SIG0A "signal 0A"
#define SD_SIG0B "signal 0B"
#define SD_SIG0C "signal 0C"
#define SD_SIG0D "signal 0D"
#define SD_SIG0E "signal 0E"
#define SD_SIG0F "signal 0F"

#define SD_NUM_MAP_BLOCKS "number of map blocks"
#define SD_SIZE_MAP_BLOCK "size of map block"
#define SD_GRAN_MAP_BLOCK "granularity of map block"
#define SD_MAP_ENABLE "map enable"
#define SD_MAP_PROTECT "map protect"
#define SD_MAP_ADDR "map address"
#define SD_MAP_LENGTH "map size"
#define SD_MAP_COMMAND "map command"
#define SD_MAP_RESULTS "map results"

#define SD_DUMP_SEMAPHORE "dump semaphore"
#define SD_DUMP_OFFSET "dump offset"
#define SD_DUMP_SPACE "dump space"
#define SD_DUMP_LENGTH "dump buffer length"
#define SD_DUMP_BUFFER "dump buffer"
#define SD_DUMP_RESULT "dump result"
#define SD_DUMP_ACCESS "dump access size"

#define SD_FILL_ABORT "fill abort"
#define SD_FILL_SEMAPHORE "fill semaphore"
#define SD_FILL_OFFSET "fill offset"
#define SD_FILL_SPACE "fill space"
#define SD_FILL_LENGTH "fill length"
#define SD_FILL_PATLENGTH "fill pattern length"
#define SD_FILL_BUFFER "fill pattern buffer"
#define SD_FILL_ACCESS "fill access size"
#define SD_FILL_VERIFY "fill verify flag"
#define SD_FILL_COMMAND "fill command"
#define SD_FILL_RESULTS "fill results"
#define SD_VERIFY_OFFSET "verify offset"
#define SD_VERIFY_SPACE "verify space"
#define SD_VERIFY_EXPECTED "verify expected data"
#define SD_VERIFY_ACTUAL "verify actual data"

#define SD_SEARCH_ABORT "search abort"
#define SD_SEARCH_OFFSET "search offset"
#define SD_SEARCH_SPACE "search space"
#define SD_SEARCH_LENGTH "search length"
#define SD_SEARCH_PATLENGTH "search pattern length"
#define SD_SEARCH_NOT "search not"
#define SD_SEARCH_FORWARD "search forward"
#define SD_SEARCH_PATTERN "search pattern"
#define SD_SEARCH_ACCESS "search access size"
#define SD_SEARCH_COMMAND "search command"
#define SD_SEARCH_FOUND "search found"

#define SD_COPY_ABORT "copy abort"
#define SD_COPY_SEMAPHORE "copy semaphore"
#define SD_COPY_SRC_OFFSET "copy source offset"
#define SD_COPY_SRC_SPACE "copy source space"
#define SD_COPY_SRC_TARG "copy source targ"
#define SD_COPY_LENGTH "copy length"
#define SD_COPY_DES_OFFSET "copy source offset"
#define SD_COPY_DES_SPACE "copy source space"
#define SD_COPY_DES_TARG "copy source targ"
#define SD_COPY_ACCESS "copy access size"
#define SD_COPY_VERIFY "copy verify flag"
#define SD_COPY_COMMAND "copy command"
#define SD_COPY_RESULTS "copy results"
#define SD_COPY_VFY_OFFSET "copy verify offset"
#define SD_COPY_VFY_SPACE "copy verify space"
#define SD_COPY_VFY_EXPECTED "copy verify expected data"
#define SD_COPY_VFY_ACTUAL "copy verify actual data"

#define SD_LOAD_COMMAND "load command"
#define SD_LOAD_RESULT "load result"
#define SD_LOAD_ACCESS "load access"
#define SD_LOAD_VERIFY "load verify"
#define SD_LOAD_SPACE "load space"
#define SD_LOAD_DATA "load data"
#define SD_LVERIFY_OFFSET "load verify offset"
#define SD_LVERIFY_SPACE "load verify space"
#define SD_LVERIFY_EXPECTED "load verify expected data"
#define SD_LVERIFY_ACTUAL "load verify actual data"

/*
** These are enumeratations for those members whose values should be
** interpreted as enumerations and not just values.
*/
typedef enum {
  /*
  ** Original entries:
  **   Do not change this ordering
  */
  PROBE_NONE=0,
  M68000, M68010, M68020, M68030, M68040,
  I8086, I8088, I80186, I80C186, I80188, I80286,
  I80386, I80386SX, I80486, I80486SX,
  /*
  ** Modern entries:
  **   Each processor/probe group is allocated a generous region.
  **   The probe EEPROM contains the family designator.
  **   The family member is determined by firmware during initialization
  **      and changed to the particular choice.
  **   The _TB suffix indicates a Tbird probe, and _SH indicates a steelhead.
  */
  M683XX_FAMILY=0x1000,
  M68330_TB, M68331_TB, M68332_TB, M68333_TB, M68334_TB, M68340_TB,
  M68HC16Y1_TB, M68HC16Z1_TB, M68HC16Z2_TB,
  M683XX_FAMILY_SH=0x1080,
  M68330_SH, M68331_SH, M68332_SH, M68333_SH, M68334_SH, M68340_SH,
  M68HC16Y1_SH, M68HC16Z1_SH, M68HC16Z2_SH,


  CPU32PLUS_FAMILY=0x1100,
  M68360_TB, M68349_TB,
  M68360_SH, M68349_SH,

  M68000_FAMILY=0x1200,
  M68306_MP,

  M68040_FAMILY=0x1300,
  M68040_TB, M68EC040_TB, M68LC040_TB,
  M68040_SH, M68EC040_SH, M68LC040_SH,

  I80C186_FAMILY=0x1400,
  I80C186_TB, I80C186XL_TB, I80C186EA_TB, I80C186EB_TB, I80C186EC_TB,
  I80C188_TB, I80C188XL_TB, I80C188EA_TB, I80C188EB_TB, I80C188EC_TB,
  I80C186_SH, I80C186XL_SH, I80C186EA_SH, I80C186EB_SH, I80C186EC_SH,
  I80C188_SH, I80C188XL_SH, I80C188EA_SH, I80C188EB_SH, I80C188EC_SH,
  I80C186_MP, I80C186XL_MP, I80C186EA_MP, I80C186EB_MP, I80C186EC_MP,
  I80C188_MP, I80C188XL_MP, I80C188EA_MP, I80C188EB_MP, I80C188EC_MP,

  I80386_FAMILY=0x1500,
  I80386CX_TB, I80386SX_TB, I80386EX_TB, I80386DX_TB,
  I80386CX_SH, I80386SX_SH, I80386EX_SH, I80386DX_SH,

  I80486_FAMILY=0x1600,
  I80486SX_TB, I80486DX_TB,
  I80486SX_SH, I80486DX_SH,

  PT_NEXT_TO_USE=0x1700,   /* More will be added as needed. */

  PT_DUMMY=0x7fff
} PROBE_TYPE;

typedef enum {
   AT_RESET,  /* box is at the reset point, no need to reset before using */
   DOWNLOAD_IN_PROGRESS, /* someone is downloading code to the box */
   NOT_AVAILABLE, /* box is currently being used by someone */
   AVAILABLE, /* box has been used, but is now available (should be reset) */
   TS_DUMMY=0x7fff
} TBIRD_STATUS;

typedef enum {
  TRACE_PRE, TRACE_POST, TRACE_CENTER, 
  TM_DUMMY=0x7fff
} TRACE_MODE;

typedef enum {
   BUS_CYCLE, CLOCK_CYCLE, BINARY_CYCLE, 
   TC_DUMMY=0x7fff
} TRACE_CYCLES;

typedef enum {
  QUAL_CLOCK, QUAL_BUS, 
  QM_DUMMY=0x7fff
} QUAL_MODE;

typedef enum {
  SWAT_NONE, SWAT_TIMESTAMP, SWAT_PA, SWAT_CA,
  SM_DUMMY=0x7fff
} SWAT_MODE;

typedef enum {
  PMODE_REAL, PMODE_V86, PMODE_P16, PMODE_P32, PMODE_SMM,
  PMODE_END=0x7fff
} PMODE;

/*
** The following enumeration specifies the options available for programming
** response of SWAT hardware to each of the 8 events.  PA_STARTx and PA_STOPx
** are used for the start and stop of procedure x.  PA_RANGEx is the event
** activated when the address falls within the specified range.  PA_RANGEQUAL
** indicates that the correct type of cycle exists for PA_RANGEx to be valid
** (e.g. memory code read), and PA_NOP is programmed for all unused events.
*/

typedef enum {
  PA_START0, PA_START1, PA_START2, PA_START3,
  PA_STOP0,  PA_STOP1,  PA_STOP2,  PA_STOP3,
  PA_RANGE0, PA_RANGE1, PA_RANGE2, PA_RANGE3,
  PA_RANGE4, PA_RANGE5, PA_RANGE6, PA_RANGEQUAL, PA_NOP,
  PE_DUMMY=0x7fff
} PA_EVENT;

typedef enum {
   BKPT_NOP, BKPT_CLEAR, BKPT_SET, BKPT_CLEAR_ALL, BKPT_CMD_END=0x7fff
} BKPT_CMD ;

typedef enum {
   EM_HALTED, EM_HUNG, EM_RUNNING, EM_STEPPING, EM_END=0x7fff
} EMULATION_STATE;

typedef enum {
   CAUSE_NONE, CAUSE_RESET, CAUSE_HALT, CAUSE_BUSBRK,
   CAUSE_STEP, CAUSE_BKPT, CAUSE_OVERLAY_ACCESS, CAUSE_DOUBLE_BUS_FAULT,
   CAUSE_EXTERNAL, CAUSE_STEPFAIL,
   CAUSE_DR_ACCESS, CAUSE_TASK_BKPT,
   CAUSE_END=0x7fff
} BREAK_CAUSE;

typedef enum {
   BYTE_SIZE=1, WORD_SIZE=2, DWORD_SIZE=4, SIZE_END=0x7fff
} ACCESS_SIZE;

#ifndef _ADDR_SPACE_
typedef enum {
   SPACE_UNDEF0, SPACE_UD, SPACE_UP, SPACE_UNDEF3, SPACE_UNDEF4,
   SPACE_SD, SPACE_SP, SPACE_CPU, SPACE_DONT_CARE,
   SPACE_USER, SPACE_SMM, SPACE_IO, SPACE_DEFAULT = 0x7fff
} ADDR_SPACE;
#define _ADDR_SPACE_
#endif

typedef enum {
   MAP_RAM, MAP_ROM, MAP_ROM_NOBRK, MAP_NOACCESS, MAP_END=0x7fff
} MAP_PROTECT;

typedef enum {
   RESET_CPU_AND_UPDATE_STATUS, ONLY_RESET_CPU
} CPU_RESET;

typedef enum {
   LOAD_START, LOAD_FINISH, LOAD_ABORT, LOAD_COMMAND_END=0x7fff
} LOAD_COMMAND;

typedef struct {
   RETCODE retcode;
   U32 serialNumber;
} LOAD_RESULT;

/*
** Read/write definitions
*/
#define SD_RDWR_READ  0
#define SD_RDWR_WRITE 1

#define SD_RDWR_XDATA_8751 0  /* various 8751 probe spaces */
#define SD_RDWR_IDATA_8751 1
#define SD_RDWR_SFR_8751   2
#define SD_RDWR_CODE_8751  3
#define SD_RDWR_MOM        4  /* motherboard space (address in linear space)

/* The following section is for trigger information programming shared
   between the host and firmware.  The host informs the firmware of the
   trigger information and the firmware programs the sequencer.
 */      
#define CNTR0_COND         8
#define CNTR1_COND         9

typedef enum { NULL_MASK=0, SEQ_MASK=1, RESET_MASK=2, TRIG_CONT_MASK=4,
   TRIG_HALT_MASK=8, EM_BRK_MASK=0x10, INC0_MASK=0x20, INC1_MASK=0x40,
   RST0_MASK=0x80, RST1_MASK=0x100, START_TMR_MASK=0x200, STOP_TMR_MASK=0x400,
   RST_TMR_MASK=0x800, EXT_TRIG_ON=0x1000, EXT_TRIG_OFF=0x2000,
   AM_DUMMY = 0x7fff
} ACTION_MASK;

typedef enum {  /* these values match the hardware bit positions */
   EV0_COND=1, EV1_COND=2, EV2_COND=4, EV3_COND=8,
   EV4_COND=0x10, EV5_COND=0x20, EV6_COND=0x40, EV7_COND=0x80,
   TC0_COND=0x100, TC1_COND=0x200, EXT_COND=0x400,
   EC_DUMMY=0x7fff
} EVENT_COND;

typedef enum { COUNTERS, TIMER, CT_DUMMY=0x7fff } COUNTER_TYPE;

#define NUM_EVENT_COND     11
#define NUM_LEVELS         4
typedef struct {
   S32 frameNumber;
   U32 rGroup;
   U32 sGroup;
   U32 tGroup;
} TRACE_INFO;

typedef struct {
   COUNTER_TYPE counterMode;                     /* counter or timer */
   BOOLEAN useEvt[NUM_EVENT_COND][NUM_LEVELS];   /* use evt on this lvl? */
   BOOLEAN useExt[NUM_EVENT_COND][NUM_LEVELS];   /* use ext on this lvl? */
   ACTION_MASK action[NUM_EVENT_COND][NUM_LEVELS];
} FW_TRIGGER;

/*
**
** ## Shared Data Members ##
**
** This is the list of members.  The shared data are will be created from
** this list.
**
** The format for a shared data member is:
**       { <quantity>, <name>, <number of bytes>, <host_access>, <fw access> }
**
** <quantity>       How many copies of this member there are.
**
** <name>           The name used to access the member.
**
** <numberdef>      The symbol #defined to the member number in sdnumber.h
**
** <number of bytes>The size of the entry in bytes.
**
** <host access>    Host side access permission
**
** <fw access>      Firmware side access permission.
**
*/
#ifdef SHARED_DATA_MEMBERS
/*
**
**  During initialization, the host and the firmware need to get synced up
**  (regardless of whether the host or the box is booted first).  To do this
**  as simply as possible, the box will always be treated as a server to the
**  host (client).
**
**  When the box boots, it will fully initialize and not send any data to the
**  host.  When the host boots, it will query the box.  If no response, it
**  can flag the user and request that the box be connected/powered before
**  trying again.  Eventually, the host will get a response from the box.
**
**  The interaction will be as follows:
**     - host asks the box for the number of bytes in its shared data image
**     - box returns information
**     - if the size matches its image, the host asks for entire contents of
**       shared data
**     - box uploads entire shared data image
**     - host and box are now in sync; host can continue initialization and
**       should immediately check that the probe type, number of TMOD boards,
**       hardware version numbers, etc. are as expected.
**
**  NOTE that this interaction does not require the host shared data server
**  to know that the probe type is (making it processor independent).
**
**  This is accomplished in the following way:
**     - host sets SD_SHARED_DATA_START_INDEX to 0
**     - host sets SD_SHARED_DATA_LENGTH to 4 bytes, the size of the first
**       shared data member, SD_NUM_SHARED_DATA_BYTES
**     - box has task registered on SD_SHARED_DATA_LENGTH and returns the
**       data requested
**     - host uses SdReadMember to confirm that the shared data length matches
**       its expected value (SD_NUM_SHARED_DATA_BYTES)
**     - if size does not match, host displays incompatibility message (in
**       future, the user could be prompted to download the flash code).
**     - if size matches, host then sets SD_SHARED_DATA_LENGTH to the entire
**       shared data size (gotten from SD_NUM_SHARED_DATA_BYTES).  Note that
**       SD_SHARED_DATA_START_INDEX is still 0.
**     - box's registered task returns all the bytes and host updates its
**       shared data area
**     - both sides have identical shared data images now
**
**  NOTE:  For the host to get the correct configuration information,
**         sdinit.h shared data members can only be added at the end.  To
**         maintain backwards compatibility, members cannot be deleted or
**         moved around.
**
**  NOTE that these members can be used at other times to re-sync, like if
**  the host has a fatal error or wants to come up passively (re-starting
**  session).
**
*/
{1, SD_NUM_SHARED_DATA_BYTES,   SDN_NUM_SHARED_DATA_BYTES,   SIZE_LONG, RD,RW}
{1, SD_SHARED_DATA_START_INDEX, SDN_SHARED_DATA_START_INDEX, SIZE_LONG, RW,RD}
{1, SD_SHARED_DATA_LENGTH,      SDN_SHARED_DATA_LENGTH,      SIZE_LONG, RW,RD}
/*
**
** Configuration.  Use the following to find out what hardware is connected.
**
*/
{ 1, SD_PROBE_TYPE,           SDN_PROBE_TYPE,           SIZE_ENUM, RD, RW }
{ 1, SD_MOM_PRESENT,          SDN_MOM_PRESENT,          SIZE_BOOL, RD, RW }
{ 1, SD_TRACE_0_SLOT_PRESENT, SDN_TRACE_0_SLOT_PRESENT, SIZE_BOOL, RD, RW }
{ 1, SD_TRACE_1_SLOT_PRESENT, SDN_TRACE_1_SLOT_PRESENT, SIZE_BOOL, RD, RW }
{ 1, SD_TRACE_2_SLOT_PRESENT, SDN_TRACE_2_SLOT_PRESENT, SIZE_BOOL, RD, RW }
{ 1, SD_TRACE_3_SLOT_PRESENT, SDN_TRACE_3_SLOT_PRESENT, SIZE_BOOL, RD, RW }
{ 1, SD_SWAT_PRESENT,         SDN_SWAT_PRESENT,         SIZE_BOOL, RD, RW }

/*
**
** Hardware Versions
**
** Version numbering is in the form <major>.<minor>.<compatibility>
**    <major> : major hardware change
**    <minor> : minor board spin
**    <compatibility> : number changed if hardware is not backwards compatible
**
*/
{ 1, SD_MOM_MAJOR_VERSION,    SDN_MOM_MAJOR_VERSION,     SIZE_CHAR, RD, RW}
{ 1, SD_MOM_MINOR_VERSION,    SDN_MOM_MINOR_VERSION,     SIZE_CHAR, RD, RW}
{ 1, SD_MOM_COMPATIBILITY,    SDN_MOM_COMPATIBILITY,     SIZE_CHAR, RD, RW}
{ 1, SD_PROBE_MAJOR_VERSION,  SDN_PROBE_MAJOR_VERSION,   SIZE_CHAR, RD, RW}
{ 1, SD_PROBE_MINOR_VERSION,  SDN_PROBE_MINOR_VERSION,   SIZE_CHAR, RD, RW}
{ 1, SD_PROBE_COMPATIBILITY,  SDN_PROBE_COMPATIBILITY,   SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_0_MAJOR_VERSION,SDN_TRACE_0_MAJOR_VERSION, SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_0_MINOR_VERSION,SDN_TRACE_0_MINOR_VERSION, SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_0_COMPATIBILITY,SDN_TRACE_0_COMPATIBILITY, SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_1_MAJOR_VERSION,SDN_TRACE_1_MAJOR_VERSION, SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_1_MINOR_VERSION,SDN_TRACE_1_MINOR_VERSION, SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_1_COMPATIBILITY,SDN_TRACE_1_COMPATIBILITY, SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_2_MAJOR_VERSION,SDN_TRACE_2_MAJOR_VERSION, SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_2_MINOR_VERSION,SDN_TRACE_2_MINOR_VERSION, SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_2_COMPATIBILITY,SDN_TRACE_2_COMPATIBILITY, SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_3_MAJOR_VERSION,SDN_TRACE_3_MAJOR_VERSION, SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_3_MINOR_VERSION,SDN_TRACE_3_MINOR_VERSION, SIZE_CHAR, RD, RW}
{ 1, SD_TRACE_3_COMPATIBILITY,SDN_TRACE_3_COMPATIBILITY, SIZE_CHAR, RD, RW}
{ 1, SD_SWAT_MAJOR_VERSION,   SDN_SWAT_MAJOR_VERSION,    SIZE_CHAR, RD, RW}
{ 1, SD_SWAT_MINOR_VERSION,   SDN_SWAT_MINOR_VERSION,    SIZE_CHAR, RD, RW}
{ 1, SD_SWAT_COMPATIBILITY,   SDN_SWAT_COMPATIBILITY,    SIZE_CHAR, RD, RW}

/*
**
** Firmware Versions
**
*/
{ 1, SD_FIRMWARE_MAJOR_VERSION, SDN_FIRMWARE_MAJOR_VERSION, SIZE_CHAR, RD, RW}
{ 1, SD_FIRMWARE_MINOR_VERSION, SDN_FIRMWARE_MINOR_VERSION, SIZE_CHAR, RD, RW}
{ 1, SD_FIRMWARE_COMPATIBILITY, SDN_FIRMWARE_COMPATIBILITY, SIZE_CHAR, RD, RW}

/*
**
** Connecting  (NOTE:  NO LONGER BEING USED.  LEFT IN FOR COMPATIBILITY.
**
** Use SD_TBIRD_STATUS to find the current state of the TBird.
** Use SD_CONNECT to request connection to box.  Write a 1 for request; when
**    firmware sets to 0, the connection has been granted.  An error will be
**    given if someone else is using the box.
** Use SD_RESET to reset the box (will return error if someone else is
**    connected or is in the process of connecting)
** Use SD_DISCONNECT to disconnect from box and allow someone else to use it.
**
*/
{ 1, SD_TBIRD_STATUS, SDN_TBIRD_STATUS,  SIZE_ENUM,         RD,    RW }
{ 1, SD_CONNECT,      SDN_CONNECT,       SIZE_BYTE,         RW,    RW }
{ 1, SD_RESET,        SDN_RESET,         SIZE_BYTE,         WR,    RW }
{ 1, SD_DISCONNECT,   SDN_DISCONNECT,    SIZE_BYTE,         WR,    RW }

/*
**
** Read/Write Motherboard and Probe Space
**
**    This is a high level method for the host to be able to peek and poke
**    at motherboard and probe address spaces.
**
** To use, the host should:
**   1.  Grab one of the semaphores so you have exclusive access.
**   2.  Find out the member index you were given.
**   3.  Fill in the appropriate information (read or write, probe space,
**       address, and bytes (if write).
**   4.  Fill in the number of bytes field.  This causes the read or write
**       to occur.
**   5.  When the firmware completes the operation, the number of bytes field
**       is set to 0.  If it is a read, the bytes are then available to read.
**
** Since there are multiple read/write buffers, the host can grab more than
** one buffer and therefore, speed up operations.
**
*/
{ NUM_RDWR, SD_RDWR_SEMAPHORE,  SDN_RDWR_SEMAPHORE,  SIZE_BYTE, RW, RD }
{ NUM_RDWR, SD_RDWR_READ_WRITE, SDN_RDWR_READ_WRITE, SIZE_BYTE, RW, RD }
{ NUM_RDWR, SD_RDWR_SPACE,      SDN_RDWR_SPACE,      SIZE_WORD, RW, RD }
{ NUM_RDWR, SD_RDWR_ADDR,       SDN_RDWR_ADDR,       SIZE_LONG, RW, RD }
{ NUM_RDWR, SD_RDWR_NUM_BYTES,  SDN_RDWR_NUM_BYTES,  SIZE_LONG, RW, RW }
{ NUM_RDWR, SD_RDWR_BUFFER,     SDN_RDWR_BUFFER,     SIZE_RDWR, RW, RW }

/*
** Probe initialization members
**
**  When the firmware boots, it attempts to initialize the probe.  If the
**  target is off during this time, the initialization will fail.  The
**  current initialization error number is written to SD_PRBINIT_RESP to
**  allow the host to pop up an informative error box and retry the
**  initialization by writing any data to SD_PROBE_INIT.
*/
{        1, SD_PROBE_INIT,      SDN_PROBE_INIT,      SIZE_BYTE,    WR, RD }
{        1, SD_PRBINIT_RESP,    SDN_PRBINIT_RESP,    SIZE_RETCODE, RD, WR }

/*
** Trace System Setup
** NOTES:
**    These items must be written while the sequencer is disabled (see
**    SD_ENABLE_SEQUENCER below).
**
**    The sequencer programming determines whether counters are interpreted
**    as timers or counters.  See the trace system spec for details.
*/
{1, SD_TRIGGER_INFO,         SDN_TRIGGER_INFO,        SIZE_TRIGGER,   WR, RD }
{1, SD_TRIGGER_PROG_ABORT,   SDN_TRIGGER_PROG_ABORT,  SIZE_BOOL,      WR, RD }
{1, SD_TRIGGER_PROGRAM_ACK,  SDN_TRIGGER_PROGRAM_ACK, SIZE_RETCODE,   RD, WR }
{1, SD_NUM_TRCBUFS,          SDN_NUM_TRCBUFS,         SIZE_WORD,      RW, RD }
{1, SD_BRK_ON_TRACE_FULL,    SDN_BRK_ON_TRACE_FULL,   SIZE_BOOL,      RW, RD }
{1, SD_TRACE_MODE,           SDN_TRACE_MODE,          SIZE_TRACE_MODE,RW, RD }
{1, SD_TRIC_DIAGNOSTIC_MODE, SDN_TRIC_DIAGNOSTIC_MODE,SIZE_BOOL,      RW, RD }
{NUM_GROUPS, SD_EVTREC,      SDN_EVTREC,         SIZE_EVTREC_CONFIG,  RW, RD }
{1, SD_QUAL_MODE,            SDN_QUAL_MODE,           SIZE_QUAL_MODE, RW, RD }
{1, SD_TERMINAL_COUNT_A,     SDN_TERMINAL_COUNT_A,    SIZE_WORD,      RW, RD }
{1, SD_TERMINAL_COUNT_B,     SDN_TERMINAL_COUNT_B,    SIZE_WORD,      RW, RD }
{1, SD_TRIGOUT_ENABLE,       SDN_TRIGOUT_ENABLE,      SIZE_BOOL,      RW, RD }

/*
** Real-time monitor and control
**
** NOTE:  The value written to SD_UPDATES_PER_MINUTE controls how often the
**   members in this group are updated by the firmware.  At that frequency,
**   the firmware polls each item and writes it to the shared data area. A
**   zero written to SD_UPDATES_PER_MINUTE disables the update function. The
**   items are all written when emulation stops.
**   Members updated: SD_TRACING, SD_SEQUENCE_LEVEL, SD_CURRENT_SUBBUFFER,
**   SD_COUNTER_VALUE0, SD_COUNTER_VALUE1, SD_MAX_TRACE_BUFFER.
**
**   The status items may also be updated by the firmware on command from
**   the host when SD_TRACE_GET_STATUS is written TRUE.  This allows the host
**   to control the update period.  Firmware sets back to FALSE when done.
**   Members updated: SD_TRACING, SD_SEQUENCE_LEVEL, SD_CURRENT_SUBBUFFER,
**   SD_COUNTER_VALUE0, SD_COUNTER_VALUE1, SD_TRIGGER_POSITION,
**   SD_MAX_TRACE_BUFFER.
**
**   When the host writes these items, the trace system is notified and
**   changes its behavior appropriately. 
*/
{   1,  SD_UPDATES_PER_MINUTE,    SDN_UPDATES_PER_MINUTE, SIZE_LONG, RW, RD }
{   1,  SD_TRACE_GET_STATUS,      SDN_TRACE_GET_STATUS,   SIZE_BOOL, RW, RW }
{   1,  SD_TRACING,               SDN_TRACING,            SIZE_BOOL, WR, RW }
{   1,  SD_TRACE_EMPTY,           SDN_TRACE_EMPTY,        SIZE_BOOL, RD, RW }
{   1,  SD_CURRENT_SUBBUFFER,     SDN_CURRENT_SUBBUFFER,  SIZE_WORD, RD, RW }
{   1,  SD_MAX_TRACE_BUFFER,      SDN_MAX_TRACE_BUFFER,   SIZE_WORD, RD, WR }
{   1,  SD_SEQUENCE_LEVEL,        SDN_SEQUENCE_LEVEL,     SIZE_WORD, RD, RW }
{ NUM_COUNTERS, SD_COUNTER_VALUE, SDN_COUNTER_VALUE,      SIZE_WORD, RD, RW }

/*
** Immediate Actions
** NOTE: The action is accomplished by writing TRUE to the member.  The
**   firmware completes the operation, then writes FALSE to the member.
*/
{1, SD_CLEAR_TRACE,          SDN_CLEAR_TRACE,          SIZE_BOOL, RW,RW}
{1, SD_INC_TRACE_BUFFER,     SDN_INC_TRACE_BUFFER,     SIZE_BOOL, RW,RW}
{1, SD_RESET_SEQUENCE_LEVEL, SDN_RESET_SEQUENCE_LEVEL, SIZE_BOOL, RW,RW}
{1, SD_ENABLE_SEQUENCER,     SDN_ENABLE_SEQUENCER,     SIZE_BOOL,    WR, RD }
{1, SD_ENABLE_SEQUENCER_ACK, SDN_ENABLE_SEQUENCER_ACK, SIZE_RETCODE, RD, WR }

/*
** Tracing must be completely set before server continues. To change
** tracing write value to SD_SET_TRACING then wait until SD_FW_TRACING_STATUS
** is written
*/
{1,  SD_SET_TRACING,         SDN_SET_TRACING,          SIZE_BOOL, RW, RD }
{1,  SD_FW_TRACING_STATUS,   SDN_FW_TRACING_STATUS,    SIZE_BOOL, WR, RW }

/*
** Trace Search
** To execute search the host fills in the starting frame, search event
** and number of frames.  Writing the number of frames causes the firmware
** to begin the search.  The host should pend on the found search event
** flag to know when the search is complete.
*/
{ 1, SD_SEARCH_BUFFER,         SDN_SEARCH_BUFFER,      SIZE_WORD,   RW, RD }
{ 1, SD_SEARCH_EMON,           SDN_SEARCH_EMON,        SIZE_BOOL,   RW, RD }
{ 1, SD_SEARCH_START_FRAME,    SDN_SEARCH_START_FRAME, SIZE_LONG,   RW, RW }
{NUM_GROUPS, SD_SEARCH_EVENT,  SDN_SEARCH_EVENT, SIZE_EVTREC_RANGE, RW, RD }
{ 1, SD_FOUND_SEARCH_EVENT,    SDN_FOUND_SEARCH_EVENT, SIZE_BOOL,   RD, RW }

/*
** Trace Find instruction address
** To support linked cursors we need to move this routine to the firmware
** to speed up the linked cursor information retrieval.
** To execute fill in the buffer and frame for linked cursor inquiry.
** writing the frame will activate the firmware.  Which will fill in the
** address and instruction status (i.e.: is frame and instruction frame).
*/
{ 1, SD_LINKCURS_BUFFER,       SDN_LINKCURS_BUFFER,    SIZE_WORD,   RW, RD }
{ 1, SD_LINKCURS_EMON,         SDN_LINKCURS_EMON,      SIZE_BOOL,   RW, RW }
{ 1, SD_LINKCURS_FRAME,        SDN_LINKCURS_FRAME,     SIZE_LONG,   RW, RW }
{ 1, SD_LINKCURS_ADDRESS,      SDN_LINKCURS_ADDRESS,   SIZE_LONG,   RD, WR }
{ 1, SD_LINKCURS_INST,         SDN_LINKCURS_INST,      SIZE_BOOL,   RD, RW }

/* Use these fields to check out the buffer or frame numbers for a
   given buffer.  Whenever buffer check changes the firmware will update
   the oldest and youngest frame values.
 */      
{ 1,    SD_BUFFER_CHECK,      SDN_BUFFER_CHECK,      SIZE_WORD, RW, RD }
{ 1,    SD_BUFFER_CHECK_EMON, SDN_BUFFER_CHECK_EMON, SIZE_BOOL, RW, RD }
{ 1,    SD_BUFFER_OLDEST,     SDN_BUFFER_OLDEST,     SIZE_LONG, RD, WR }
{ 1,    SD_BUFFER_YOUNGEST,   SDN_BUFFER_YOUNGEST,   SIZE_LONG, RD, WR }
/*
** Trace Buffer Access Windows
** NOTE:  Writing the SD_TRACE_BUFF_LEN field actually causes the read action
**        Negative Length means backward read.
*/
{ NUM_TRACE, SD_TRACE_SEMAPHORE,   SDN_TRACE_SEMAPHORE,   SIZE_BYTE, RW, RD }
{ NUM_TRACE, SD_ACTIVE_BUFFER,     SDN_ACTIVE_BUFFER,     SIZE_WORD, RW, RD }
{ NUM_TRACE, SD_BUFFER_EMON,       SDN_BUFFER_EMON,       SIZE_BOOL, RW, RD }
{ NUM_TRACE, SD_FRAME_TYPE,        SDN_FRAME_TYPE,  SIZE_FRAME_TYPE, RW, RD }
{ NUM_TRACE, SD_TRACE_START_FRAME, SDN_TRACE_START_FRAME, SIZE_LONG, RW, RD }
{ NUM_TRACE, SD_TRACE_BUFF_LEN,    SDN_TRACE_BUFF_LEN,    SIZE_LONG, RW, RW }
{ NUM_TRACE, SD_TRACE_STORE,       SDN_TRACE_STORE,       SIZE_TRACE,RD, RW }

/*
** Trace buffer write command (for diagnostics only)
**
** The write action is initiated by writing to SD_TRACE_WRITE_LENGTH.
** This command causes firmware to update trace read windows.
*/
{1, SD_TRACE_WRITE_ADDRESS, SDN_TRACE_WRITE_ADDRESS, SIZE_LONG,        RW, RD}
{1, SD_TRACE_WRITE_LENGTH,  SDN_TRACE_WRITE_LENGTH,  SIZE_LONG,        RW, RD}
{1, SD_TRACE_WRITE_DATA,    SDN_TRACE_WRITE_DATA,    SIZE_TRACE_WRITE, RW, RD}


{   1,   SD_SWAT_MODE,    SDN_SWAT_MODE,     SIZE_SWAT_MODE,   RW, RD }

/*
** timestamp
**
** NOTES:
**    The timestamp fields are updated whenever emulation stops or when the
**    user reads the trace buffer by writing to SD_TRACE_BUFF_LEN.
**
**    The clock rate is measured by writing TRUE to SD_MEASURE_CLOCK.  The
**    measured value is put in SD_CLOCK_RATE by the firmware, then
**    SD_MEASURE_CLOCK written with FALSE.
*/
{ 1,  SD_UPDATE_TIMESTAMP, SDN_UPDATE_TIMESTAMP, SIZE_BOOL,       RW, RW }
{ 1,  SD_TIMESTAMPS,       SDN_TIMESTAMPS,       SIZE_TIMESTAMPS, RD, RW }
{ 1,  SD_MEASURE_CLOCK,    SDN_MEASURE_CLOCK,    SIZE_BOOL,       RW, RW }
{ 1,  SD_CLOCK_RATE,       SDN_CLOCK_RATE,       SIZE_LONG,       RD, RW }
/*
** pa
**
** NOTES:
**    Each event is assigned a specific purpose from the PA_EVENT enumeration
**    defined above using SD_PA_EVENT_SETUP.
**
**    PA is started by writing TRUE to SD_PA_RUN.  This bit ANDed with EMON
**    actually enables the PA collection.
**
**    PA results are updated whenever SD_PA_GET_RESULTS is written TRUE, and
**    when emulation turns off.  Results may be read while collecting.
**    Firware writes SD_PA_GET_RESULTS with FALSE when update is complete.
**
**    If the SD_UPDATES_PER_MINUTES item (see sdtrace.h) contains a non-zero
**    value, the pa results are updated periodically according to the timer.
**    If the host wants only some periodic data updated, it should unregister
**    those shared data items which it does not need.
*/
{NUM_EVENTS,    SD_PA_EVENT_SETUP,  SDN_PA_EVENT_SETUP, SIZE_PA_EVENT, RW, RD}
{   1,          SD_PA_RUN,          SDN_PA_RUN,         SIZE_BOOL,     RW, RD}
{   1,          SD_PA_CLEAR,        SDN_PA_CLEAR,       SIZE_BOOL,     RW, RW}
{   1,          SD_PA_GET_RESULTS,  SDN_PA_GET_RESULTS, SIZE_BOOL,     RW, RW}
{NUM_PA_RANGES, SD_PA_INVOCATION_COUNT, SDN_PA_INVOCATION_COUNT, SIZE_PA_TIME,  RD, RW }
{NUM_PA_RANGES, SD_PA_ELAPSED_TIME, SDN_PA_ELAPSED_TIME, SIZE_PA_TIME, RD, RW}
{NUM_PA_RANGES, SD_PA_TOTAL_TIME,   SDN_PA_TOTAL_TIME,   SIZE_PA_TIME, RD, RW}
{NUM_PA_RANGES, SD_PA_MAX_TIME,     SDN_PA_MAX_TIME,     SIZE_PA_TIME, RD, RW}
{NUM_PA_RANGES, SD_PA_MIN_TIME,     SDN_PA_MIN_TIME,     SIZE_PA_TIME, RD, RW}
{1,       SD_PA_COLLECTION_TIME,    SDN_PA_COLLECTION_TIME,SIZE_PA_TIME,RD,RW}
/*
** ca
**
** NOTES:
**    CA is started by writing TRUE to SD_CA_RUN.  This bit ANDed with EMON
**    actually enables CA collection.
**
**    CA is cleared by writing TRUE to SD_CA_CLEAR.  When the operation is
**    completed, firmware sets SD_CA_CLEAR back to FALSE.
**
**    CA results are returned in SD_CA_RESULTS whenever SD_CA_READ_LENGTH is
**    written.  Each result is a U32 which contains the CA RAM address of
**    the next content transition, and the content of CA RAM after the
**    transition.  Results may be read while collecting.  After the
**    specified number of results are written, the firmware writes the address
**    of the final transition to SD_CA_READ_ADDRESS and the actual number of
**    results returned in SD_CA_READ_LENGTH.  SD_CA_READ_SEMAPHORE is used by
**    the host-side shared data server to arbitrate between multiple
**    requestors of coverage results.
**    
*/
{1,          SD_CA_GRANULARITY,    SDN_CA_GRANULARITY,   SIZE_WORD, RW, RD }
{NUM_CA_RANGES, SD_CA_BASE,        SDN_CA_BASE,          SIZE_LONG, RW, RD }
{1,          SD_CA_CLEAR,          SDN_CA_CLEAR,         SIZE_BOOL, RW, RW }
{1,          SD_CA_RUN,            SDN_CA_RUN,           SIZE_BOOL, RW, RD }
{2,          SD_CA_READ_SEMAPHORE, SDN_CA_READ_SEMAPHORE,SIZE_BYTE, RW, RD }
{1,          SD_CA_READ_SEGMENT,   SDN_CA_READ_SEGMENT,  SIZE_BYTE, RW, RW }
{1,          SD_CA_READ_ADDRESS,   SDN_CA_READ_ADDRESS,  SIZE_LONG, RW, RW }
{1,          SD_CA_READ_LENGTH,    SDN_CA_READ_LENGTH,   SIZE_LONG, RW, RW }
{1,          SD_CA_RESULTS,        SDN_CA_RESULTS,  SIZE_CA_RESULTS,RD, RW }
/*
** diagnostic commands
**
** NOTES:
**    Commands are used to read and write Swat RAM directly in any of the
**    operating modes.  Writing to SD_SWAT_xxx_LENGTH causes the operation
**    to occur.
*/
{1, SD_SWAT_WRITE_ADDRESS, SDN_SWAT_WRITE_ADDRESS, SIZE_LONG,    RW, RD    }
{1, SD_SWAT_WRITE_LENGTH,  SDN_SWAT_WRITE_LENGTH,  SIZE_LONG,    RW, RD    }
{1, SD_SWAT_WRITE_DATA,    SDN_SWAT_WRITE_DATA,    SIZE_SWAT_RW, RW, RD    }
{1, SD_SWAT_READ_ADDRESS,  SDN_SWAT_READ_ADDRESS,  SIZE_LONG,    RW, RD    }
{1, SD_SWAT_READ_LENGTH,   SDN_SWAT_READ_LENGTH,   SIZE_LONG,    RW, RD    }
{1, SD_SWAT_READ_DATA,     SDN_SWAT_READ_DATA,     SIZE_SWAT_RW, RD, RW }

/*
** Breakpoints
**
**   Host software writes: the logical address of the 
**     SD_BKPT_ADDR    logical address of breakpoint
**     SD_BKPT_SPACE   address space (used for swb, but not for xbrk)
**     SD_BKPT_ID      id number of breakpoint
**     SD_BKPT_CMD     operation to perform on breakpoint.
**                       Writing to this member causes firmware invocation.
**     SD_BKPT_ENABLE  global enable/disable for all bkpts.  This must
**                       normally be set TRUE before GO and FALSE before STEP.
**   Firmware writes to SD_BKPT_RESULT when the operation is completed.
** 
**   Note that the firmware stores the breakpoints in a table and does not 
**   activate the breakpoints until emulation starts.  Breakpoints are
**   activated only if SD_BKPT_ENABLE is TRUE.
*/
{   1, SD_BKPT_ADDR,   SDN_BKPT_ADDR,   SIZE_LONG,    WR,    RD   }
{   1, SD_BKPT_SPACE,  SDN_BKPT_SPACE,  SIZE_ENUM,    WR,    RD   }
{   1, SD_BKPT_ID,     SDN_BKPT_ID,     SIZE_WORD,    WR,    RD   }
{   1, SD_BKPT_CMD,    SDN_BKPT_CMD,    SIZE_ENUM,    WR,    RD   }
{   1, SD_BKPT_ENABLE, SDN_BKPT_ENABLE, SIZE_BOOL,    WR,    RD   }
{   1, SD_BKPT_RESULT, SDN_BKPT_RESULT, SIZE_RETCODE, RD,    WR   }

/*
** Emulation Control
**
**   Writing to any command initiator member (GO, GR, ... , RESET) causes
**   the firmware to perform the indicated operation.  Whether or not the
**   firmware succeeds, it will write the resulting emulation state to
**   SD_EMULATION_STATE, then the error result to SD_EMULATION_RESULT.
**
**   SD_GO starts emulation using the current register values.
**   SD_GR starts emulation by resetting the processor.  For the 68k family,
**       this differs from SD_GO by fetching the SSP and PC from memory
**       while emulating.  This may make a difference for some targets.
**   SD_STEP is a U32 and indicates the number of assembly-level instructions
**       to step.  SD_EMULATION_STATE will indicate STEPPING until the count
**       is exhausted.  SD_STEP is not updated by the firmware.
**   SD_HALT attempts to stop emulation.  When emulation stops, the register
**       values are updated and SD_EMULATION_STATE is set to HALTED.
**   SD_RESET_CPU resets the processor and immediately enters debug mode.
**       Registers are filled in with their initialization values.
**       SD_EMULATION state is set to HALTED.
**   SD_BREAK_CAUSE indicates the cause of the last break in emulation and
**       is written once when emulation stops.
*/
{   1, SD_GO,              SDN_GO,              SIZE_BIT,   WR,    RD  }
{   1, SD_GR,              SDN_GR,              SIZE_BIT,   WR,    RD  }
{   1, SD_STEP,            SDN_STEP,            SIZE_LONG,  WR,    RD  }
{   1, SD_HALT,            SDN_HALT,            SIZE_BIT,   WR,    RD  }
{   1, SD_RESET_CPU,       SDN_RESET_CPU,       SIZE_BYTE,  WR,    RD  }
{   1, SD_EMULATION_RESULT,SDN_EMULATION_RESULT,SIZE_RETCODE,RD,   RW  }
{   1, SD_EMULATION_STATE, SDN_EMULATION_STATE, SIZE_ENUM,  RD,    RW  }
{   1, SD_BREAK_CAUSE,     SDN_BREAK_CAUSE,     SIZE_ENUM,  RD,    RW  }

/*
** Registers
**
**  The register back is a generic set of 64 32-bit registers.  There should
**  be no more than one register assigned to each member by processor-
**  specific firmware.  If a register is larger than 32 bits, it must be
**  broken into sections and assigned to multiple members.
*/
{   1, SD_REG00,  SDN_REG00,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG01,  SDN_REG01,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG02,  SDN_REG02,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG03,  SDN_REG03,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG04,  SDN_REG04,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG05,  SDN_REG05,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG06,  SDN_REG06,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG07,  SDN_REG07,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG08,  SDN_REG08,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG09,  SDN_REG09,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG0A,  SDN_REG0A,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG0B,  SDN_REG0B,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG0C,  SDN_REG0C,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG0D,  SDN_REG0D,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG0E,  SDN_REG0E,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG0F,  SDN_REG0F,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG10,  SDN_REG10,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG11,  SDN_REG11,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG12,  SDN_REG12,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG13,  SDN_REG13,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG14,  SDN_REG14,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG15,  SDN_REG15,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG16,  SDN_REG16,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG17,  SDN_REG17,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG18,  SDN_REG18,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG19,  SDN_REG19,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG1A,  SDN_REG1A,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG1B,  SDN_REG1B,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG1C,  SDN_REG1C,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG1D,  SDN_REG1D,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG1E,  SDN_REG1E,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG1F,  SDN_REG1F,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG20,  SDN_REG20,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG21,  SDN_REG21,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG22,  SDN_REG22,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG23,  SDN_REG23,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG24,  SDN_REG24,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG25,  SDN_REG25,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG26,  SDN_REG26,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG27,  SDN_REG27,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG28,  SDN_REG28,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG29,  SDN_REG29,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG2A,  SDN_REG2A,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG2B,  SDN_REG2B,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG2C,  SDN_REG2C,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG2D,  SDN_REG2D,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG2E,  SDN_REG2E,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG2F,  SDN_REG2F,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG30,  SDN_REG30,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG31,  SDN_REG31,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG32,  SDN_REG32,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG33,  SDN_REG33,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG34,  SDN_REG34,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG35,  SDN_REG35,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG36,  SDN_REG36,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG37,  SDN_REG37,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG38,  SDN_REG38,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG39,  SDN_REG39,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG3A,  SDN_REG3A,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG3B,  SDN_REG3B,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG3C,  SDN_REG3C,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG3D,  SDN_REG3D,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG3E,  SDN_REG3E,        SIZE_LONG,  RW,    RW   }
{   1, SD_REG3F,  SDN_REG3F,        SIZE_LONG,  RW,    RW   }

/*
** Signals
**
**  The signal control bank allows up to 16 signals to be enabled
**  or disabled.  A TRUE value indicates enabled; FALSE is disabled.
*/
{   1, SD_SIG00,  SDN_SIG00,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG01,  SDN_SIG01,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG02,  SDN_SIG02,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG03,  SDN_SIG03,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG04,  SDN_SIG04,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG05,  SDN_SIG05,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG06,  SDN_SIG06,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG07,  SDN_SIG07,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG08,  SDN_SIG08,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG09,  SDN_SIG09,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG0A,  SDN_SIG0A,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG0B,  SDN_SIG0B,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG0C,  SDN_SIG0C,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG0D,  SDN_SIG0D,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG0E,  SDN_SIG0E,        SIZE_BOOL,  RW,    RD      }
{   1, SD_SIG0F,  SDN_SIG0F,        SIZE_BOOL,  RW,    RD      }

/*
** Memory Map
**
**  SD_NUM_MAP_BLOCKS indicates the number of independent overlay RAM
**  blocks installed.  This may be any number from 0 up to NUM_MAP_ENTRIES.
**  SD_SIZE_MAP_BLOCK is the maximum mappable quantity per map block, and
**  SD_GRAN_MAP_BLOCK is the minimum mappable quantity.  These are set by
**  firmware during boot.
**
**  To configure a given overlay block, write to the configuration members.
**  SD_MAP_ENABLE   TRUE for overlay, FALSE for target.
**  SD_MAP_PROTECT  Determines access rights (ram/rom/rom_nobrk/none)
**                     Automatically set to RAM when emulation is off.
**  SD_MAP_ADDR     the logical address of the base of the map block.
**  SD_MAP_LENGTH   the number of bytes to map (must be a multiple of
**                     SD_GRAN_MAP_BLOCK and less than or equal to
**                     SD_SIZE_MAP_BLOCK).
**
**  Writing to SD_MAP_LENGTH triggers the mapping firmware.
**
*/
{              1, SD_NUM_MAP_BLOCKS, SDN_NUM_MAP_BLOCKS, SIZE_LONG, RD, WR}
{              1, SD_SIZE_MAP_BLOCK, SDN_SIZE_MAP_BLOCK, SIZE_LONG, RD, WR}
{              1, SD_GRAN_MAP_BLOCK, SDN_GRAN_MAP_BLOCK, SIZE_LONG, RD, WR}
{NUM_MAP_ENTRIES, SD_MAP_ENABLE,     SDN_MAP_ENABLE,     SIZE_BOOL, RW, RD}
{NUM_MAP_ENTRIES, SD_MAP_PROTECT,    SDN_MAP_PROTECT,    SIZE_ENUM, RW, RD}
{NUM_MAP_ENTRIES, SD_MAP_ADDR,       SDN_MAP_ADDR,       SIZE_LONG, RW, RD}
{NUM_MAP_ENTRIES, SD_MAP_LENGTH,     SDN_MAP_LENGTH,     SIZE_LONG, RW, RD}
{NUM_MAP_ENTRIES, SD_MAP_COMMAND,    SDN_MAP_COMMAND,    SIZE_BIT,  RW, RW}
{NUM_MAP_ENTRIES, SD_MAP_RESULTS,    SDN_MAP_RESULTS,    SIZE_RETCODE, RW, RW}

/*
** Read Memory Buffers
**
** Writing to the ...BUFFER_LENGTH field causes the memory read to occur.
** The MEMORY_READ_RESULT member is written when the read is completed.
*/
{NUM_DUMP, SD_DUMP_SEMAPHORE, SDN_DUMP_SEMAPHORE, SIZE_BIT,      RW, RD }
{NUM_DUMP, SD_DUMP_ACCESS,    SDN_DUMP_ACCESS,    SIZE_ENUM,     RW, RD }
{NUM_DUMP, SD_DUMP_OFFSET,    SDN_DUMP_OFFSET,    SIZE_LONG,     RW, RD }
{NUM_DUMP, SD_DUMP_SPACE,     SDN_DUMP_SPACE,     SIZE_ENUM,     RW, RD }
{NUM_DUMP, SD_DUMP_LENGTH,    SDN_DUMP_LENGTH,    SIZE_LONG,     RW, RD }
{NUM_DUMP, SD_DUMP_BUFFER,    SDN_DUMP_BUFFER,    SIZE_DUMP,     RW, RW }
{NUM_DUMP, SD_DUMP_RESULT,    SDN_DUMP_RESULT,    SIZE_RETCODE,  RW, RW }

/*
** Write Memory Commands
**
** The host fills in all the parameters and then writes TRUE to the
** SD_FILL_COMMAND member.  When the firmware is done with the fill, it
** writes an error code to SD_FILL_RESULTS.
**
** The host aborts the fill command by writing TRUE to SD_FILL_ABORT.  The
** firmware will monitor this member and when it aborts, it will write
** an error code to SD_FILL_RESULTS and set FILL_ABORT back to false.
** If the abort was taken, the error code is set to so indicate.
*/
{NUM_FILL, SD_FILL_ABORT,     SDN_FILL_ABORT,     SIZE_BOOL,     WR, RW }
{NUM_FILL, SD_FILL_SEMAPHORE, SDN_FILL_SEMAPHORE, SIZE_BIT,      RW, RD }
{NUM_FILL, SD_FILL_ACCESS,    SDN_FILL_ACCESS,    SIZE_ENUM,     RW, RD }
{NUM_FILL, SD_FILL_VERIFY,    SDN_FILL_VERIFY,    SIZE_BOOL,     RW, RD }
{NUM_FILL, SD_FILL_OFFSET,    SDN_FILL_OFFSET,    SIZE_LONG,     RW, RD }
{NUM_FILL, SD_FILL_SPACE,     SDN_FILL_SPACE,     SIZE_ENUM,     RW, RD }
{NUM_FILL, SD_FILL_LENGTH,    SDN_FILL_LENGTH,    SIZE_LONG,     RW, RD }
{NUM_FILL, SD_FILL_PATLENGTH, SDN_FILL_PATLENGTH, SIZE_LONG,     RW, RD }
{NUM_FILL, SD_FILL_BUFFER,    SDN_FILL_BUFFER,    SIZE_FILL,     RW, RD }
{NUM_FILL, SD_FILL_COMMAND,   SDN_FILL_COMMAND,   SIZE_BIT,      RW, RW }
{NUM_FILL, SD_FILL_RESULTS,   SDN_FILL_RESULTS,   SIZE_RETCODE,  RW, RW }
{NUM_FILL, SD_VERIFY_OFFSET,  SDN_VERIFY_OFFSET,  SIZE_LONG,     RD, WR }
{NUM_FILL, SD_VERIFY_SPACE,   SDN_VERIFY_SPACE,   SIZE_ENUM,     RD, WR }
{NUM_FILL, SD_VERIFY_EXPECTED,SDN_VERIFY_EXPECTED,SIZE_LONG,     RD, WR }
{NUM_FILL, SD_VERIFY_ACTUAL,  SDN_VERIFY_ACTUAL,  SIZE_LONG,     RD, WR }

/*
** Search Memory Commands
**
** The host fills in all the parameters and then writes TRUE to the
** SD_SEARCH_COMMAND member.  When the firmware is done with the fill, it
** writes the result and error code to SD_SEARCH_FOUND.
**
** The host aborts the command by writing TRUE to SD_SEARCH_ABORT.  The
** firmware will monitor this member and when it aborts, it will write
** an error code to SD_SEARCH_FOUND and set SD_SEARCH_ABORT back to false.
** If the abort was taken, the error code is set to so indicate.
*/
{NUM_SEARCH, SD_SEARCH_ABORT,     SDN_SEARCH_ABORT,     SIZE_BOOL,     WR, RW }
{NUM_SEARCH, SD_SEARCH_ACCESS,    SDN_SEARCH_ACCESS,    SIZE_ENUM,     RW, RD }
{NUM_SEARCH, SD_SEARCH_OFFSET,    SDN_SEARCH_OFFSET,    SIZE_LONG,     RW, RD }
{NUM_SEARCH, SD_SEARCH_SPACE,     SDN_SEARCH_SPACE,     SIZE_ENUM,     RW, RD }
{NUM_SEARCH, SD_SEARCH_LENGTH,    SDN_SEARCH_LENGTH,    SIZE_LONG,     RW, RD }
{NUM_SEARCH, SD_SEARCH_PATLENGTH, SDN_SEARCH_PATLENGTH, SIZE_LONG,     RW, RD }
{NUM_SEARCH, SD_SEARCH_NOT,       SDN_SEARCH_NOT,       SIZE_BOOL,     RW, RD }
{NUM_SEARCH, SD_SEARCH_FORWARD,   SDN_SEARCH_FORWARD,   SIZE_BOOL,     RW, RD }
{NUM_SEARCH, SD_SEARCH_PATTERN,   SDN_SEARCH_PATTERN,   SIZE_SEARCH,   RW, RD }
{NUM_SEARCH, SD_SEARCH_COMMAND,   SDN_SEARCH_COMMAND,   SIZE_BIT,      RW, RW }
{NUM_SEARCH, SD_SEARCH_FOUND,     SDN_SEARCH_FOUND,     SIZE_BOOL,     RW, RW }

/*
** Copy Memory Commands
**
** The host fills in all the parameters and then writes TRUE to the
** SD_COPY_COMMAND member.  When the firmware is done with the fill, it
** writes an error code to SD_COPY_RESULTS.
**
** The host aborts the fill command by writing TRUE to SD_COPY_ABORT.  The
** firmware will monitor this member and when it aborts, it will write
** an error code to SD_COPY_RESULTS and set SD_COPY_ABORT back to false.
** If the abort was taken, the error code is set to so indicate.
*/
{NUM_COPY, SD_COPY_ABORT,       SDN_COPY_ABORT,       SIZE_BOOL,     WR, RW }
{NUM_COPY, SD_COPY_SEMAPHORE,   SDN_COPY_SEMAPHORE,   SIZE_BIT,      RW, RD }
{NUM_COPY, SD_COPY_ACCESS,      SDN_COPY_ACCESS,      SIZE_ENUM,     RW, RD }
{NUM_COPY, SD_COPY_VERIFY,      SDN_COPY_VERIFY,      SIZE_BOOL,     RW, RD }
{NUM_COPY, SD_COPY_SRC_OFFSET,  SDN_COPY_SRC_OFFSET,  SIZE_LONG,     RW, RD }
{NUM_COPY, SD_COPY_SRC_SPACE,   SDN_COPY_SRC_SPACE,   SIZE_ENUM,     RW, RD }
{NUM_COPY, SD_COPY_SRC_TARG,    SDN_COPY_SRC_TARG,    SIZE_BOOL,     RW, RD }
{NUM_COPY, SD_COPY_LENGTH,      SDN_COPY_LENGTH,      SIZE_LONG,     RW, RD }
{NUM_COPY, SD_COPY_DES_OFFSET,  SDN_COPY_DES_OFFSET,  SIZE_LONG,     RW, RD }
{NUM_COPY, SD_COPY_DES_SPACE,   SDN_COPY_DES_SPACE,   SIZE_ENUM,     RW, RD }
{NUM_COPY, SD_COPY_DES_TARG,    SDN_COPY_DES_TARG,    SIZE_BOOL,     RW, RD }
{NUM_COPY, SD_COPY_COMMAND,     SDN_COPY_COMMAND,     SIZE_BIT,      RW, RW }
{NUM_COPY, SD_COPY_RESULTS,     SDN_COPY_RESULTS,     SIZE_RETCODE,  RW, RW }
{NUM_COPY, SD_COPY_VFY_OFFSET,  SDN_COPY_VFY_OFFSET,  SIZE_LONG,     RD, WR }
{NUM_COPY, SD_COPY_VFY_SPACE,   SDN_COPY_VFY_SPACE,   SIZE_ENUM,     RD, WR }
{NUM_COPY, SD_COPY_VFY_EXPECTED,SDN_COPY_VFY_EXPECTED,SIZE_LONG,     RD, WR }
{NUM_COPY, SD_COPY_VFY_ACTUAL,  SDN_COPY_VFY_ACTUAL,  SIZE_LONG,     RD, WR }

/*
** Download Memory Commands
**
** The host writes SD_LOAD_ACCESS, SD_LOAD_VERIFY, and SD_LOAD_SPACE once
** before the load begins, then writes LOAD_START to SD_LOAD_COMMAND.
** As each data record (see l695\ldata.c for format) is written to
** SD_LOAD_DATA, firmware processes the record, then writes the result to
** to SD_LOAD_RESULT.  When done or on error, the host
** must write LOAD_FINISH to SD_LOAD_COMMAND to allow firmware to release
** resources.  A value of LOAD_ABORT written to SD_LOAD_COMMAND will abort
** any load in progress.
*/
{       1, SD_LOAD_ACCESS,     SDN_LOAD_ACCESS,     SIZE_ENUM,     RW, RD }
{       1, SD_LOAD_VERIFY,     SDN_LOAD_VERIFY,     SIZE_BOOL,     RW, RD }
{       1, SD_LOAD_SPACE,      SDN_LOAD_SPACE,      SIZE_ENUM,     RW, RD }
{       1, SD_LOAD_COMMAND,    SDN_LOAD_COMMAND,    SIZE_ENUM,     RW, RD }
{NUM_LOAD, SD_LOAD_DATA,       SDN_LOAD_DATA,       SIZE_LOAD,     RW, RW }
{NUM_LOAD, SD_LOAD_RESULT,     SDN_LOAD_RESULT,     SIZE_LOAD_RESULT, RD, RW }
{NUM_LOAD, SD_LVERIFY_OFFSET,  SDN_LVERIFY_OFFSET,  SIZE_LONG,     RD, WR }
{NUM_LOAD, SD_LVERIFY_SPACE,   SDN_LVERIFY_SPACE,   SIZE_ENUM,     RD, WR }
{NUM_LOAD, SD_LVERIFY_EXPECTED,SDN_LVERIFY_EXPECTED,SIZE_LONG,     RD, WR }
{NUM_LOAD, SD_LVERIFY_ACTUAL,  SDN_LVERIFY_ACTUAL,  SIZE_LONG,     RD, WR }

#endif
/*
** ## End of Shared Data Definitions ##
*/
/******************************** E O F ***********************************/
