//
//      PowerViews LAN Server Installation script.
//      (c) 1993-4, Microtek International Inc. All rights reserved.
//
//      Begin program with variable declaration
//
// Define some predefined constants. Can be used for numbers only.
//
#define MAX_SIZE         255

#define BASE_FILE_SIZE   35000  // << minimum space available on disk

declare // Must use declare keyword to start variable declaration

        string szBitmapPath[MAX_SIZE]; // path for bitmap
        string szText[MAX_SIZE]; // Declare string vars
        string szTemp[MAX_SIZE], szTemp2[MAX_SIZE];
        string szDefPath[MAX_SIZE], szResultPath[MAX_SIZE];
        string szNFSPath[MAX_SIZE];
        string szDisk[50];
        string szFilePath[MAX_SIZE];
        string szErrMsg[MAX_SIZE], szErrFile[100];
        string szREADME[100], szPath[200];
        string szWinDir[50];
        string szReadFile[30], szTbird[30], szInstall[80];
        string szPgrp[40];
        string szInetAddress[20];
        number nSpace;
        number nSize;
        number hostFileHandle;
        string szNextDisk[MAX_SIZE];
        number nResult;
        number nNextDisk;
        number nDoneFlag;

program /* Must use program keyword to start the statements */


Start:
       // perform system setup
       call SystemSetup;

       // Determine target location for files
       szWinDir = TARGETDIR;

       GetDisk(TARGETDIR, szDisk);
       szDefPath = szDisk ^ "pwrviews";

TargetLoc:
       // Want to ask user for a path to install PowerViews
       AskPath("Please enter the directory where PowerViews is installed.",
          szDefPath, szResultPath);
       if LAST_RESULT = FALSE then call ConfirmCancel; endif;
       // make sure directory is correct:  is pwrviews.exe there?
       szFilePath = szResultPath ^ "pwrviews.exe";
       if (GetFileInfo(szFilePath, FILE_SIZE, nSize, szTemp) != 0) then
          szText = "PowerViews is not installed in the specified " +
             "directory.  Please verify the directory name.";
          MessageBox(szText, WARNING);
          goto TargetLoc;
       endif;

       GetDisk(szResultPath, szDisk);

       // If correct disk entered, then BeginInstall;
       if (ExistsDisk(szDisk) != EXISTS) then
          // Invalid disk entered, reprompt
          szText = szResultPath +
             "- is an invalid disk, press Ok to return to the path selection";
          MessageBox(szText, WARNING);
          goto TargetLoc;
       endif;

BeginInstall:
       GetDisk(szResultPath, szDisk);
       StrConcat(szDisk, ":");

       // Check to see if enough space is free on the destination.
       if (GetDiskSpace(szDisk) < nSpace) then
          szText = "Not enough space on " + szDisk +
             "- Please free disk space or re-install PowerViews on another disk";
          MessageBox(szText, WARNING);
          goto TargetLoc;
       endif;

EnterDiskAgain:
       TARGETDIR = szResultPath;

       // Ask user to enter a disk in drive.
       // Check to see if compress.exe file exists on this disk
       // If it does, then it must the right disk.
       szText =
          "Please enter the source path for PowerViews LAN Server disk 1.";
       if (EnterDisk(szText, "wslansvr.dl$") != TRUE) then
          call ConfirmCancel;  // Call to confirm cancel
          goto EnterDiskAgain;       // returned, therefore continue
       endif;
       
       call FileTransfer1;

       call FixPwrviewsIni;

       call FixInternetInfo;

Complete:

       call CreateGroupAndIcons;

       if (AskYesNo("Would you like to view the README file?", TRUE) = YES) then
          szREADME = TARGETDIR ^ szReadFile;
          LaunchApp("notepad.exe", szREADME);
       endif;

       exit;  //Exit installation program.

//---------------------------------------------------------------------
//
//    SystemSetup
//
//    Descrip:  Perform system setup.
//
//
//---------------------------------------------------------------------
SystemSetup:
       Disable(BACKGROUND);
       // Set the color of the background to be BLUE
       SetColor(BACKGROUND, RGB(0,0,128));
       SetColor(STATUSBAR, RGB(0,0,128));

       SetStatusWindow(0, szInstall);

       // display file info.txt in info window
       SetInfoWindow("Information ", "info.txt");

       nSpace = BASE_FILE_SIZE;

       // Initialize the parameters
       szPgrp = "PowerViews";

       // Enable various objects.
       Enable(BITMAPFADE);    // All bitmaps will fade into the screen.
       Enable(INDVFILESTATUS); // Shows all filenames when copied.
       Disable(HELP);        //
       Enable(EXIT);         // Exit Button
       Disable(PAUSE);         // no pause button
       Enable(STATUS);       // Status, % Complete Bar Window
       Enable(INFO);         // Info Windows
       Enable(FEEDBACK_FULL); // Feedback window enabled
       Enable(BACKGROUND);

       // Set up status window
       StatusUpdate(ON, 100);  // automatically update status when files copied
       StatusSetStyle(STATUS, FONTCOLOR, BLUE);  // set text to blue

       // display bitmap
       szBitmapPath = SRCDIR ^ "pvtitle.bmp";
       PlaceBitmap(szBitmapPath, 101, 0, 0, UPPER_LEFT);
       Disable(BITMAPFADE);  // once is enough

       szReadFile = "readnet.txt";
       szTbird = "pwrviews.exe pwrviews.ima";

       return;

//---------------------------------------------------------------------
//
//    FileTransfer1
//
//    Descrip:  This procedure will transfer all the files that are
//              required for the PowerViews product.
//
//
//---------------------------------------------------------------------
FileTransfer1:

       // remember to add new files to file list
       FileSetBeginDefine("All");
       CopyFile(szReadFile, szReadFile);
       CompressGet("wslansvr.dl$", "*.*", INCLUDE_SUBDIR);
       CompressGet("winsock.dl$", "*.*", INCLUDE_SUBDIR);
       FileSetEndDefine("All");

       nNextDisk = 1;
       nDoneFlag = FALSE;

       while (nDoneFlag != TRUE)
          nResult = FileSetPerform("All", nNextDisk);

          switch(nResult)
             case FS_TONEXTDISK:
                // nNextDisk contains the disk number of the next disk needed.
                NumToStr(szNextDisk, nNextDisk);
                szTemp = "Please enter disk " + szNextDisk;
                EnterDisk(szTemp, "");
             case FS_DONE:
                // all the files have been copied...
                nDoneFlag = TRUE;
             case FS_TARGETREADONLY:
                // target directory is read-only.
                nDoneFlag = TRUE;
                FileSetEndPerform("All");
                MessageBox("Target directory is read-only.", SEVERE);
                goto TargetLoc;
             case FS_OUTOFSPACE:
                // ran out of space.
                nDoneFlag = TRUE;
                FileSetEndPerform("All");
                MessageBox("Target directory is full.", SEVERE);
                goto TargetLoc;
             case FS_INCORRECTDISK:
                // wrong disk inserted.
                MessageBox("Please insert the correct disk.", WARNING);
             case FS_DISKONEREQUIRED:
                // disk one required
                MessageBox("Please insert disk 1.", WARNING);
             default:
                // some other error occurred.
                nDoneFlag = TRUE;
                FileSetEndPerform("All");
                MessageBox("File set installation failed.", WARNING);
                goto TargetLoc;
          endswitch;
       endwhile;

       // free up file list space
       FileSetEndPerform("All");

       return;

//---------------------------------------------------------------------
//
//    FixPwrviewsIni
//
//    Descrip:  Make a backup copy of pwrviews.ini, and then make the
//              modifications for network support.
//
//
//---------------------------------------------------------------------
FixPwrviewsIni:

       // get user's permission to overwrite pwrviews.ini
       szTemp =
          "File pwrviews.ini must be changed for network communication.  " +
          "OK to change pwrviews.ini?";
       if (AskYesNo(szTemp, YES) = NO) then
          szTemp =
             "Before using network communication, edit pwrviews.ini with " +
             "comm/type = lanserver, and network/emulators = " +
             "powerpack.";
          MessageBox(szTemp, INFORMATION);
          return;
       endif;

       // make a backup of the old pwrviews.ini if there is one
       szTemp = TARGETDIR;  // save TARGETDIR
       TARGETDIR = szWinDir;
       szPath = SRCDIR; // save SRCDIR
       SRCDIR = TARGETDIR;
       CopyFile("pwrviews.ini", "pwrviews.bak"); // don't care if it fails
       TARGETDIR = szTemp; // restore TARGETDIR
       SRCDIR = szPath; // restore SRCDIR

       // change the network strings
       szTemp = WINDIR ^ "pwrviews.ini";
       WriteProfString(szTemp, "comm", "type", "lanserver");  // << comm type
       WriteProfString(szTemp, "network", "emulators", "powerpack");

       szErrMsg = "The original pwrviews.ini file in " + WINDIR +
          " has been copied to pwrviews.bak.";
       MessageBox(szErrMsg, INFORMATION);

       return;

//---------------------------------------------------------------------
//
//    FixInternetInfo
//
//    Descrip:  Add host names to the etc/hosts file.  // << file name
//
//---------------------------------------------------------------------
FixInternetInfo:

NFSLoc:
       // get user's permission to overwrite etc\hosts
       szTemp =
          "The emulator's Internet address must be added to the network name" +
          " server, or to the local hosts file.  " +
          "OK to change local hosts file?";
       if (AskYesNo(szTemp, YES) = NO) then
          szTemp =
             "Before using network communication, add Internet address entry" +
             " for powerpack to network name server or local hosts file.";
          MessageBox(szTemp, INFORMATION);
          return;
       endif;

       // ask user for a path to LAN Server
       AskPath("Please enter the directory where LAN Server is installed.",
          "C:\\TCPDOS", szNFSPath);
       if LAST_RESULT = FALSE then call ConfirmCancel; endif;

       // make sure directory is correct:  is etc\hosts there?
       szTemp = szNFSPath ^ "etc\\hosts";
       if (GetFileInfo(szTemp, FILE_SIZE, nSize, szTemp2) != 0) then
          szText = "etc\\hosts file not found in the specified " +
             "directory.  Please verify the directory name.";
          MessageBox(szText, WARNING);
          goto NFSLoc;
       endif;

       // make a backup of etc\hosts
       szTemp = TARGETDIR;  // save TARGETDIR
       TARGETDIR = szNFSPath;
       szPath = SRCDIR; // save SRCDIR
       SRCDIR = TARGETDIR;
       if (CopyFile("etc\\hosts", "etc\\hosts.bak") != 0) then
           MessageBox("Unable to create backup of etc\\hosts file.", WARNING);
           return;
       endif;

       // restore TARGETDIR, SRCDIR
       TARGETDIR = szTemp;
       SRCDIR = szPath;

       // append powerviews internet address, host name to etc\hosts file
       AskText("Please enter the Internet address of the emulator.",
          "192.9.200.50", szInetAddress);
       if LAST_RESULT = FALSE then call ConfirmCancel; endif;
       OpenFileMode(FILE_MODE_APPEND);
       if (OpenFile(hostFileHandle, szNFSPath, "ETC\\HOSTS") != 0) then
          MessageBox("Unable to modify etc\\hosts file.", WARNING);
          return;
       endif;
 
       szTemp = szInetAddress + "   powerpack";
       if (WriteLine(hostFileHandle, szTemp) != 0) then
          MessageBox("Unable to modify etc\\hosts file.", WARNING);
          return;
       endif;

       CloseFile(hostFileHandle);

       szErrMsg = "The original etc\\hosts file in " + szNFSPath +
          " has been copied to etc\\hosts.bak.";
       MessageBox(szErrMsg, INFORMATION);

       return;

//---------------------------------------------------------------------
//
//    CreateGroupAndIcons
//
//    Descrip:  Create the program group and icons.
//
//
//---------------------------------------------------------------------
CreateGroupAndIcons:

       TARGETDIR = szResultPath;
       // Now create a program group & icons

       AppCommand(PROGMAN, CMD_RESTORE);

       // Add an icon for README
       szPath = TARGETDIR ^ szReadFile;
       szPath = "notepad.exe " + szPath;
       AddProgItem(szPgrp, "PowerViews LAN Server xx.yyzz ReadMe", szPath, "");

       AppCommand(PROGMAN, CMD_PUSHDOWN);

       SetStatusWindow(100, "Installation complete...");

       return;

//---------------------------------------------------------------------
//
//    ConfirmCancel
//
//    Descrip:  This procedure will confirm with the users if they want
//              to terminate the installation of the PowerViews product.
//
//
//---------------------------------------------------------------------
ConfirmCancel:

          AskYesNo("Are you sure you want to CANCEL installation?", FALSE);

          if LAST_RESULT = FALSE then return; endif;

          exit;

//---------------------------------------------------------------------
//
//    CopyError
//
//    Descrip:  This procedure will display an error when PowerViews is
//              unable to decompress or copy a file.
//
//
//---------------------------------------------------------------------
CopyError:

        szErrMsg = "Unable to copy or decompress file: " + szErrFile;
        MessageBox(szErrMsg, SEVERE);

        return;
