//
//      PowerViews PC-NFS Installation script.
//      (c) 1993, Microtek International Inc. All rights reserved.
//
//      Begin program with variable declaration
//
// Define some predefined constants. Can be used for numbers only.
//
#define MAX_SIZE         255

#define BASE_FILE_SIZE   35000  // << minimum space available on disk

declare // Must use declare keyword to start variable declaration

        string szText[MAX_SIZE]; // Declare string vars
        string szTemp[MAX_SIZE], szTemp2[MAX_SIZE];
        string szDefPath[MAX_SIZE], szResultPath[MAX_SIZE];
        string szNFSPath[MAX_SIZE];
        string szDisk[50];
        string szFilePath[255];
        string szErrMsg[255], szErrFile[100];
        string szREADME[100], szPath[200];
        string szWinDir[50];
        string szReadFile[30], szTbird[30], szInstall[80];
        string szPgrp[40];
        string szInetAddress[20];
        string szHostName[50];
        number nSpace;
        number nSize;
        number hostFileHandle;

program /* Must use program keyword to start the statements */


Start:
       // perform system setup
       call SystemSetup;

       // Determine target location for files
       StrCopy(szWinDir, TARGETDIR);

       GetDisk(TARGETDIR, szDisk);
       StrCopy(szDefPath, szDisk);
       StrConcat(szDefPath, "\\PWRVIEWS"); // Note: the double slashes

TargetLoc:
       // Increment % Complete Bar to 1 %, & display message
       SetStatusWindow(5, szInstall);

       // Want to ask user for a path to install PowerViews
       AskPath("Please enter the directory where PowerViews is installed.",
          szDefPath, szResultPath);
       if LAST_RESULT = FALSE then call ConfirmCancel; endif;
       // make sure directory is correct:  is pwrviews.exe there?
       StrCopy(szFilePath, szResultPath);
       StrConcat(szFilePath, "\\PWRVIEWS.EXE");
       GetFileInfo(szFilePath, FILE_SIZE, nSize, szTemp);

       // if LAST_RESULT is != 0, pwrviews.exe was not found
       if LAST_RESULT != 0 then
          StrCopy(szText, "PowerViews is not installed in the specified ");
          StrConcat(szText, "directory.  Please verify the directory name.");
          MessageBox(szText, WARNING);
          goto TargetLoc;
       endif;

       GetDisk(szResultPath, szDisk);

       // If correct disk entered, then BeginInstall;
       ExistsDisk(szDisk);
       if LAST_RESULT != EXISTS then
          // Invalid disk entered, reprompt
          StrCopy(szText, szResultPath);
          StrConcat(szText, "- is an invalid disk, press Ok to return to the path selection");
          MessageBox(szText, WARNING);
          goto TargetLoc;
       endif;

BeginInstall:
       SetStatusWindow(7, szInstall);
       GetDisk(szResultPath, szDisk);
       StrConcat(szDisk, ":");

       // Check to see if enough space is free on the destination.
       // GetDiskSpace returns free space in LAST_RESULT.
       GetDiskSpace(szDisk);
       if LAST_RESULT < nSpace then
          StrCopy(szText, "Not enough space on ");
          StrConcat(szText, szDisk);
          StrConcat(szText,
           "- Please free disk space or re-install PowerViews on another disk");
          MessageBox(szText, WARNING);
          goto TargetLoc;
       endif;

       SetStatusWindow(9, szInstall);

EnterDiskAgain:
       StrCopy(TARGETDIR, szResultPath);

       // Ask user to enter a disk in drive.
       // Check to see if compress.exe file exists on this disk
       // If it does, then it must the right disk.
       StrCopy(szText,
          "Please enter the source path for PowerViews PC-NFS disk 1.");
       EnterDisk(szText, "ws_pcnfs.dl$");

       if LAST_RESULT != TRUE then
          call ConfirmCancel;  // Call to confirm cancel
          goto EnterDiskAgain;       // returned, therefore continue
       endif;
       
       call FileTransfer1;

       call FixPwrviewsIni;

       call FixInternetInfo;

Complete:

       call CreateGroupAndIcons;

       AskYesNo("Would you like to view the README file?", TRUE);
       if LAST_RESULT = YES then
          StrCopy(szREADME, TARGETDIR);
          AppendToPath(szREADME, szReadFile);
          LaunchApp("notepad.exe", szREADME);
       endif;

       exit;  //Exit installation program.

//---------------------------------------------------------------------
//
//    SystemSetup
//
//    Descrip:  Perform system setup.
//
//
//---------------------------------------------------------------------
SystemSetup:
       Disable(BACKGROUND);
       // Set the color of the background to be BLUE
       SetColor(BACKGROUND, RGB(0,0,64));
       SetColor(STATUSBAR, RED);
       SetFont(FONT_TITLE, STYLE_NORMAL, "Tms Rmn");

       StrCopy(szInstall, "Installing PowerViews PC-NFS Communications");

       SetTitle(szInstall, 18, RGB(255,255,255)); // << test all screen res
       SetStatusWindow(1, szInstall);

       // display file info.txt in info window
       SetInfoWindow("Information ", "info.txt");

       // Initialize the parameters
       StrCopy(szPgrp, "PowerViews");
       StrCopy(szReadFile, "readnet.txt");
       StrCopy(szTbird, "pwrviews.exe pwrviews.ima"); 

       nSpace = BASE_FILE_SIZE;

       // Enable various objects.
       Enable(BITMAPFADE);    // All bitmaps will fade into the screen.
       Enable(INDVFILESTATUS); // Shows all filenames when copied.
       Disable(HELP);        //
       Enable(EXIT);         // Exit Button
       Enable(STATUS);       // Status, % Complete Bar Window
       Enable(TEXT);         // Info Windows
       Enable(FEEDBACK_FULL); // Feedback window enabled
       Enable(BACKGROUND);
       Delay(2);

       return;

//---------------------------------------------------------------------
//
//    FileTransfer1
//
//    Descrip:  This procedure will transfer all the files that are
//              required for the PowerViews product.
//
//
//---------------------------------------------------------------------
FileTransfer1:

       SetStatusWindow(13, "Copying file ... rdme_net.txt");
       StatusUpdate(ON, 20);
       CopyFile(szReadFile, szReadFile);
       if LAST_RESULT < 0 then
          StrCopy(szErrFile, szReadFile);
          call CopyError;
       endif;
                     
       SetStatusWindow(21, "Decompressing... ws_pcnfs.dl$");
       StatusUpdate(ON, 90);
       DeCompress("ws_pcnfs.dl$", "ws_pcnfs.dll");
       if LAST_RESULT < 0 then
          StrCopy(szErrFile, "ws_pcnfs.dll");
          call CopyError;
       endif;

       return;

//---------------------------------------------------------------------
//
//    FixPwrviewsIni
//
//    Descrip:  Make a backup copy of pwrviews.ini, and then make the
//              modifications for network support.
//
//
//---------------------------------------------------------------------
FixPwrviewsIni:

       SetStatusWindow(91, "Updating pwrviews.ini");

       // get user's permission to overwrite pwrviews.ini
       StrCopy(szTemp,
         "File pwrviews.ini must be changed for network communication.  ");
       StrConcat(szTemp, "OK to change pwrviews.ini?");
       AskYesNo(szTemp, YES);
       if LAST_RESULT = NO then
          StrCopy(szTemp,
             "Before using network communication, edit pwrviews.ini with ");
          StrConcat(szTemp, "comm/type = pcnfs, and network/emulators = ");
          StrConcat(szTemp, "powerpack.");
          MessageBox(szTemp, INFORMATION);
          return;
       endif;

       // make a backup of the old pwrviews.ini if there is one
       StrCopy(szTemp, TARGETDIR);  // save TARGETDIR
       StrCopy(TARGETDIR, szWinDir);
       StrCopy(szPath, SRCDIR); // save SRCDIR
       StrCopy(SRCDIR, TARGETDIR);
       CopyFile("pwrviews.ini", "pwrviews.bak"); // don't care if it fails
       StrCopy(TARGETDIR, szTemp); // restore TARGETDIR
       StrCopy(SRCDIR, szPath); // restore SRCDIR

       // change the network strings
       StrCopy(szTemp, WINDIR);
       StrConcat(szTemp, "\\pwrviews.ini");
       WriteProfString(szTemp, "comm", "type", "pcnfs");  // << comm type
       WriteProfString(szTemp, "network", "emulators", "powerpack");

       StrCopy(szErrMsg, "The original pwrviews.ini file in ");
       StrConcat(szErrMsg, WINDIR);
       StrConcat(szErrMsg, " has been copied to pwrviews.bak.");
       MessageBox(szErrMsg, INFORMATION);

       return;

//---------------------------------------------------------------------
//
//    FixInternetInfo
//
//    Descrip:  Add host names to the nfs/hosts file.  // << file name
//
//---------------------------------------------------------------------
FixInternetInfo:

NFSLoc:
       SetStatusWindow(95, "Updating hosts file");

       // get user's permission to overwrite hosts
       StrCopy(szTemp,
         "The emulator's Internet address must be added to the local ");
       StrConcat(szTemp,
         "hosts file, or to the network host database.  ");
       StrConcat(szTemp, "OK to change local hosts file?");
       AskYesNo(szTemp, YES);
       if LAST_RESULT = NO then
          StrCopy(szTemp,
             "Before using network communication, add Internet address entry");
          StrConcat(szTemp,
             " for powerpack to local hosts file or network host database.");
          MessageBox(szTemp, INFORMATION);
          return;
       endif;

       // ask user for a path to pc-nfs
       AskPath("Please enter the directory where PC-NFS is installed.",
          "C:\\NFS", szNFSPath);
       if LAST_RESULT = FALSE then call ConfirmCancel; endif;

       // make sure directory is correct:  is hosts there?
       StrCopy(szTemp, szNFSPath);
       StrConcat(szTemp, "\\hosts");
       GetFileInfo(szTemp, FILE_SIZE, nSize, szTemp2);

       // if LAST_RESULT is != 0, pwrviews.exe was not found
       if LAST_RESULT != 0 then
          StrCopy(szText, "PC-NFS is not installed in the specified ");
          StrConcat(szText, "directory.  Please verify the directory name.");
          MessageBox(szText, WARNING);
          goto NFSLoc;
       endif;

       // make a backup of hosts
       StrCopy(szTemp, TARGETDIR);  // save TARGETDIR
       StrCopy(TARGETDIR, szNFSPath);
       StrCopy(szPath, SRCDIR); // save SRCDIR
       StrCopy(SRCDIR, TARGETDIR);
       CopyFile("hosts", "hosts.bak");
       if LAST_RESULT != 0 then
           MessageBox("Unable to create backup of hosts file.", WARNING);
           return;
       endif;

       // restore TARGETDIR, SRCDIR
       StrCopy(TARGETDIR, szTemp);
       StrCopy(SRCDIR, szPath);

       // append powerviews internet address, host name to hosts file
       AskText("Please enter the Internet address of the emulator.",
          "192.9.200.50", szInetAddress);
       if LAST_RESULT = FALSE then call ConfirmCancel; endif;
       OpenFileMode(FILE_MODE_APPEND);
       OpenFile(hostFileHandle, szNFSPath, "HOSTS");
       if LAST_RESULT != 0 then
          MessageBox("Unable to modify nfs\\hosts file.", WARNING);
          return;
       endif;
 
       StrCopy(szTemp, szInetAddress);
       StrConcat(szTemp, "   powerpack");
       WriteLine(hostFileHandle, szTemp);
       if LAST_RESULT != 0 then
          MessageBox("Unable to modify nfs\\hosts file.", WARNING);
          return;
       endif;

       CloseFile(hostFileHandle);

       StrCopy(szErrMsg, "The original hosts file in ");
       StrConcat(szErrMsg, szNFSPath);
       StrConcat(szErrMsg, " has been copied to hosts.bak.");
       MessageBox(szErrMsg, INFORMATION);

       return;

//---------------------------------------------------------------------
//
//    CreateGroupAndIcons
//
//    Descrip:  Create the program group and icons.
//
//
//---------------------------------------------------------------------
CreateGroupAndIcons:

       StrCopy(TARGETDIR, szResultPath);
       // Now create a program group & icons

       SetStatusWindow(98, "Creating Program Group & Icons");
       Delay(1);
       AppCommand(PROGMAN, CMD_RESTORE);

       // Add an icon for README
       StrCopy(szPath, "notepad.exe ");
       StrConcat(szPath, TARGETDIR);
       AppendToPath(szPath, szReadFile);
       AddProgItem(szPgrp, "PowerViews PC-NFS xx.yyzz ReadMe", szPath, "");

       AppCommand(PROGMAN, CMD_PUSHDOWN);

       SetStatusWindow(100, "Installation complete...");
       Delay(2); //Artificial Delay

       return;

//---------------------------------------------------------------------
//
//    ConfirmCancel
//
//    Descrip:  This procedure will confirm with the users if they want
//              to terminate the installation of the PowerViews product.
//
//
//---------------------------------------------------------------------
ConfirmCancel:

          AskYesNo("Are you sure you want to CANCEL installation?", FALSE);

          if LAST_RESULT = FALSE then return; endif;

          exit;

//---------------------------------------------------------------------
//
//    CopyError
//
//    Descrip:  This procedure will display an error when PowerViews is
//              unable to decompress or copy a file.
//
//
//---------------------------------------------------------------------
CopyError:

        StrCopy(szErrMsg, "Unable to copy or decompress file: ");
        StrConcat(szErrMsg, szErrFile);
        MessageBox(szErrMsg, SEVERE);

        return;
