/****************************************************************************
**
**  Name:  ERR.H
**
**  Description:
**      Error defines for Srecord Loader.
**
**  Status:  CODED
**
**  $Log:   S:/tbird/arccore/loader/srec/err.h_v  $
** 
**    Rev 1.5   26 Jul 1993 09:39:04   ernie
** Consolidated errors in mkerrors.h
** 
**    Rev 1.4   04 Jun 1993 10:03:12   nghia
** Revised all error codes to encode severity info in this header file.
** Revised prototypes for Warning() and WarningEx().
** All error codes is copy directly from L695 to ensure the same indices.
** PIP for Source.
** 
**    Rev 1.3   12 Feb 1993 17:57:46   nghia
** No change.
** 
**    Rev 1.2   25 Sep 1992 05:40:04   courtney
** Updated.
** 
**    Rev 1.1   21 Aug 1992 10:22:36   courtney
** Update.
** 
**    Rev 1.0   31 Dec 1991 09:32:36   courtney
** Initial revision.
** 
**  $Header:   S:/tbird/arccore/loader/srec/err.h_v   1.5   26 Jul 1993 09:39:04   ernie  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/
#ifndef __ERR__
#define __ERR__

/* TBird error definitions */
#ifndef _HOSTERRS_
#include "hosterrs.h"
#endif

#define LERR_CANNOT_OPEN            ER_CANNOT_OPEN
#define LERR_INVALID_IDN            ER_INVALID_IDN
#define LERR_BADGET                 ER_BADGET
#define LERR_BAD_SECREC             ER_BAD_SECREC
#define LERR_UNRECOGNIZED_SEC       ER_UNRECOGNIZED_SEC
#define LERR_BAD_SEEK               ER_BAD_SEEK
#define LERR_REC_NOT_HANDLED        ER_REC_NOT_HANDLED
#define LERR_BAD_ATI_RECORD_IN_FILE ER_BAD_ATI_RECORD_IN_FILE
#define LERR_ATN_EXPT               ER_ATN_EXPT
#define LERR_ATTR_NOT_HANDLED       ER_ATTR_NOT_HANDLED
#define LERR_BBFUNCTION_EXPT        ER_BBFUNCTION_EXPT
#define LERR_CANNOT_ADD_SYM         ER_CANNOT_ADD_SYM
#define LERR_CANNOT_ADD_FUNC        ER_CANNOT_ADD_FUNC
#define LERR_SYMBASE                ER_SYMBASE
#define LERR_LINE_EXPT              ER_LINE_EXPT
#define LERR_CANNOT_ADD_MOD         ER_CANNOT_ADD_MOD
#define LERR_SECTION_NOT_FOUND      ER_SECTION_NOT_FOUND
#define LERR_UNEXPECTED_TYPE        ER_UNEXPECTED_TYPE
#define LERR_INT_TOO_BIG            ER_INT_TOO_BIG
#define LERR_NOTYET_IMPL            ER_NOTYET_IMPL
#define LERR_SYM_TYPE               ER_SYM_TYPE
#define LERR_NOT_CPU                ER_NOT_CPU
#define LERR_UNRECOGNIZED_BLK       ER_UNRECOGNIZED_BLK
#define LERR_BAD_HDR                ER_BAD_HDR
#define LERR_BAD_PART               ER_BAD_PART
#define LERR_MODULE_NOT_FOUND       ER_MODULE_NOT_FOUND
#define LERR_SYM_NOT_UPDATED        ER_SYM_NOT_UPDATED
#define LERR_LINE_NOT_ADDED         ER_LINE_NOT_ADDED
#define LERR_BAD_NEST               ER_BAD_NEST
#define LERR_CANNOT_ADD_PUBLIC      ER_CANNOT_ADD_PUBLIC
#define LERR_CLI_FAILED             ER_CLI_FAILED
#define LERR_INVALID_ARGS           ER_INVALID_ARGS
#define LERR_BAD_FILE               ER_BAD_FILE
#define LERR_NO_MEMORY              ER_NO_MEMORY
#define LERR_FN_NOT_FOUND           ER_FN_NOT_FOUND
#define LERR_MODREF                 ER_MODREF
#define LERR_NO_MDESC               ER_NO_MDESC
#define LERR_MODTIME                ER_MODTIME
#define LERR_USER_ABORT             ER_USER_ABORT
#define LERR_BAD_FREE               ER_BAD_FREE
#define LERR_SYM_ALREADY            ER_SYM_ALREADY
#define LERR_NO_XLATE               ER_NO_XLATE
#define LERR_BAD_UNREGISTER         ER_BAD_UNREGISTER
#define LERR_CODE_STREAM            ER_CODE_STREAM
#define LERR_NO_PC                  ER_NO_PC
#define LERR_CODEBUF_SIZE           ER_CODEBUF_SIZE
#define LERR_REGTABLE               ER_REGTABLE
#define LERR_LDR_ABORT              ER_LDR_ABORT
#define LERR_SKIP_MODULE            ER_SKIP_MODULE
#define LERR_NOCODE                 ER_NOCODE
#define LERR_CLOSE_SYM              ER_CLOSE_SYM
#define LERR_UNRECOG_LFILE          ER_UNRECOG_FILE
#define LERR_SREC_NOTYET            ER_SREC_NOTYET
#define LERR_OPTIMIZED              ER_OPTIMIZED
#define LERR_NORUNACCESS            ER_NORUNACCESS
#define LERR_NOREG_UPDATE           ER_NOREG_UPDATE
#define LERR_SYM_ALREADY_CLI        ER_SYM_ALREADY_CLI
#define LERR_IN_PROGRESS            ER_IN_PROGRESS
#define LERR_CANNOT_FIND_WDIR       ER_CANNOT_FIND_WDIR
#define LERR_CANNOT_FIND_PFILE      ER_CANNOT_FIND_PFILE
#define LERR_NO_SECTION_NAME_DEFINED ER_NO_SECTION_NAME_DEFINED
#define LERR_INVALID_SECTION_NAME   ER_INVALID_SECTION_NAME
#define LERR_MISSING_SECTION_NAME   ER_MISSING_SECTION_NAME
#define LERR_NO_TOOLS_SUPPORT_DEFINED ER_NO_TOOLS_SUPPORT_DEFINED
#define LERR_CANNOT_GET_TOOL_NAME   ER_CANNOT_GET_TOOL_NAME
#define LERR_MISSING_TOOLS_SUPPORT  ER_MISSING_TOOLS_SUPPORT
#define LERR_NO_TOOLUSE_DEFINED     ER_NO_TOOLUSE_DEFINED
#define LERR_MUST_DEFINE_TOOLUSE    ER_MUST_DEFINE_TOOLUSE
#define LERR_TOOL_NAME_TOO_LONG     ER_TOOLNAME_TOO_LONG
#define LERR_BAD_LNUM_BLOCK_IN_FILE ER_BAD_LNUM_BLOCK_IN_FILE
#define LERR_CANNOT_WRITE_TO_FILE   ER_CANNOT_WRITE_TO_FILE
#define LERR_TOOMANY_SEC            ER_TOOMANY_SEC
#define LERR_INCOMPATIBLE_CPU       ER_INCOMPATIBLE_CPU
#define LERR_DEFSEC_NOT_FOUND       ER_DEFSEC_NOT_FOUND
#define LERR_NO_LINENUMS_ADDED      ER_NO_LINENUMS_ADDED

/* returns from _Query */
#define QOK         0
#define QCANCEL     1

enum INFOMSG {LD_COMPLETE, LD_CODE_LOADED, LD_SYM_LOADED};


/* modes for _InfoMsg display */
#define IM_COLLECT  0   /* collect string */
#define IM_DISPLAY  1   /* display all collected */

extern CHAR *lerrmsg[];
extern BOOL runMode;

S16 SendMessageToCLI(CHAR *);

/* Prototypes in ERR.C */
VOID Warning(RETCODE);
VOID WarningEx(RETCODE, LPSTR);
U16  Query(RETCODE);
VOID InfoMsg(CHAR *, U16);
VOID InitInfostring(VOID);

#endif
