;       C STARTUP FOR 68HC16
;       Modified COSMIC sample for samphc16
;
	.external _main, __memory
	.external ._main, .__bss__
	.public _exit, __stext
	.psect _bss
sbss:
	.psect _text
__stext:
	ldk     #.__bss__
	tbek
	tbxk
	tbyk
	tbzk
	tbsk
	ldx     #sbss           ; start of bss
	clrd                    ; to be zeroed
	bra     mtest           ; start loop
bcl:
	std     0,x             ; clear memory
	aix     #2              ; next word
mtest:
	cpx     #__memory       ; end of memory ?
	blo     bcl             ; no, continue
	ldx     #0              ; zero x register
	ldab    #4              ; turn off watchdog; enable bus monitor
	stab    0FA21H,x        ; assume xk = 0, still.
	ldd     #43CFH          ; stop timers on FREEZE, enable show cycles
	std     0FA00H,x        ; assume xk = 0, still.
;       aix     #80H            ; 128 byte stack
;       txs                     ; for instance
	lds     #0B80H          ; or direct initialization
	jsr     _main,#._main   ; call application
_exit:
	bra     _exit           ; loop here if return
;
.end
