/*      RESET AND INTERRUPT VECTORS
 *      Copyright (c) 1991 by COSMIC (France)
 */

extern @far @port void  _stext(void);           /* startup routine */
/* extern @port void recept(void);               character receive handler */

static @port void _dummit(void);

static const struct reset {
	@far @port void (*rst)(void);           /* reset + code extension */
	unsigned short isp;                     /* initial stack pointer */
	unsigned short dpp;                     /* direct page pointer */
	@port void (*vector[22])(void);         /* interrupt vectors */
	} _reset = {    
	_stext,         /* start address */
	0x0B80,         /* stack pointer */
	0x0000,         /* page pointer */
	_dummit,        /* Breakpoint */
	_dummit,        /* Bus Error */
	_dummit,        /* Software Interrupt */
	_dummit,        /* Illegal Instruction */
	_dummit,        /* Divide by Zero */
	_dummit,        /* Reserved */
	_dummit,        /* Reserved */
	_dummit,        /* Reserved */
	_dummit,        /* Reserved */
	_dummit,        /* Reserved */
	_dummit,        /* Uninitialized Interrupt */
	_dummit,        /* Reserved */
	_dummit,        /* Level 1 Interrupt Autovector */
	_dummit,        /* Level 2 Interrupt Autovector */
	_dummit,        /* Level 3 Interrupt Autovector */
	_dummit,        /* Level 4 Interrupt Autovector */
	_dummit,        /* Level 5 Interrupt Autovector */
	_dummit,        /* Level 6 Interrupt Autovector */
	_dummit,        /* Level 7 Interrupt Autovector */
	_dummit,        /* Spurious Interrupt */
	_dummit,                /* Serial Interrupt from SCI */
	_dummit,
	};

/* empty function to receive an undefined interrupt
 */
static @port void _dummit(void)
	{
	}

