/****************************************************************************
**
**  Name:  vartable.h
**
**  Description:
**     Contains definitions for internal use of the variable server tables.
**
**  Status:  PRELIMINARY 
**
**  $Log:   S:/tbird/arccore/varsrv/vartable.h_v  $
** 
**    Rev 1.14   24 Oct 1992 10:44:48   marilyn
** For beta.
** 
**    Rev 1.13   21 Oct 1992 16:16:52   marilyn
** Added some additional fields to the entry struct to support frame access.
** 
**    Rev 1.12   10 Sep 1992 15:23:06   marilyn
** Added current linenum info to context_type struct.
** 
**    Rev 1.11   04 Aug 1992 16:53:18   marilyn
** Removed childVarId from variable table entry struct.
** 
**    Rev 1.10   31 Jul 1992 16:51:38   marilyn
** Changed define.
** 
**    Rev 1.9   28 May 1992 16:37:16   marilyn
** Added frameNum field to variable table entry.
** 
**    Rev 1.8   04 May 1992 17:12:08   marilyn
** Added support for bit offsets.
** 
**    Rev 1.7   17 Apr 1992 16:24:10   marilyn
** Added dereferencedPtr field to varTable entry structure.
** 
**    Rev 1.6   03 Apr 1992 08:58:34   marilyn
** No change.
** 
**    Rev 1.5   23 Mar 1992 09:01:10   marilyn
** Updated interfaces to stack server, cpu server, and mem server.
** 
**    Rev 1.4   19 Mar 1992 14:58:00   marilyn
** Changed size field for size of type from U32 to U16.
** 
**    Rev 1.3   28 Feb 1992 10:29:32   marilyn
** Removed all references to context.h
** 
**    Rev 1.2   23 Jan 1992 17:43:18   marilyn
** No change.
** 
**    Rev 1.1   22 Jan 1992 17:35:48   marilyn
** No change.
** 
**    Rev 1.0   17 Jan 1992 08:36:46   marilyn
** Initial revision.
** 
**    Rev 1.1   17 Jan 1992 07:59:04   marilyn
** integration version
** 
**    Rev 1.0   16 Oct 1991 10:07:56   marilyn
** Initial revision.
**
**  $Header:   S:/tbird/arccore/varsrv/vartable.h_v   1.14   24 Oct 1992 10:44:48   marilyn  $
**
**  Copyright (C) 1991 Microtek International.  All rights reserved.
**
*****************************************************************************/

#define _VARTABLE_

                       /****************************
                        *                          *
                        *       INCLUDE FILES      *
                        *                          *
                        ****************************/

#ifndef _SYMBLSVR_
#include "symblsvr.h"
#endif

                       /****************************
                        *                          *
                        *        DEFINITIONS       *
                        *                          *
                        ****************************/

#define VARTABLE_WFLAGS (GMEM_MOVEABLE|GMEM_NODISCARD|GMEM_ZEROINIT)

#define NUM_VARTABLE_INCREMENT 5
#define VS_MAX_CLIENTS	127
#define VS_MAX_RADIX	10
#define VS_MAX_STRING   256

#define NOROOT 0xFFFFFFFFL

#define VS_VARID_MASK   0x00FFFFFFL

typedef U8 VS_STRING_TYPE[VS_MAX_STRING];

typedef struct  {
      DESCRIPTOR     pcAddrDesc;
      SYM_DESCRIPTOR module;
      SYM_DESCRIPTOR function;
      SYM_DESCRIPTOR lowestLevel;
      U32 symOffset;
      LINENUM_TYPE currentLinenum;
      COLUMN_TYPE currentColumn;
      LINENUM_DESCRIPTOR linenumIndex;
}  CONTEXT_TYPE;

typedef CONTEXT_TYPE *CONTEXT;

typedef struct {
   DESCRIPTOR rootVarId;
   U16 bufferNum;
   U16 lineNum;
   LPSTR varString;
}  VS_COMPONENT_INFO_TYPE;

typedef struct {
   SYM_DESCRIPTOR rootSymbol;
   LPSTR varString;
   U16 selectedVarOffset;
} VS_COMPOSITE_INFO_TYPE;

typedef struct {
   DESCRIPTOR memAddr;
   TYPE_INDEX typeIndex;
} VS_INTERP_MEM_TYPE;

typedef struct {
   SYM_DESCRIPTOR symbol;
   TYPE_INDEX typeIndex;
} VS_INTERP_VAR_TYPE;

typedef enum  {
   SYMBOL_TAG = 0,
   COMPONENT_TAG = 1,
   COMPOSITE_TAG = 2,
   INTERPRET_MEM_TAG = 3,
   INTERPRET_VAR_TAG = 4
}  VAR_SELECTION_TAG;

typedef struct {
   VAR_SELECTION_TAG selection;
   union {
      SYM_DESCRIPTOR symbol;
      VS_COMPONENT_INFO_TYPE component;
      VS_COMPOSITE_INFO_TYPE composite;
      VS_INTERP_MEM_TYPE interpMem;
      VS_INTERP_VAR_TYPE interpVar;
   } var;
} VS_VAR_SELECTION_TYPE;

typedef struct bitfieldInfo {   /* structure based on TYPE_BITFIELD_TYPE */
                                /* in symblsvr.h                         */
   U8 bitfieldSigned;           /* the first 3 fields must match         */
   U16 size;
   TYPE_INDEX baseTypeIndex;
   U16 bitOffset;
} TYPE_BITFIELD_INFO;

typedef struct subcomponent {    /* structure based on TYPE_HEADER_TYPE */
   TYPE_CLASS typeChoice;        /* in symblsvr.h                       */
   union {                       /* the first 4 fields must match       */
      SIMPLE_TYPE simpleType;
      COMPLEX_TYPE complexType;
   } t;
   U32 size;
   LPSTR typeName;
   VS_STRING_TYPE typeNameStr;
   TYPE_INDEX typeIndex;
   TYPE_BITFIELD_INFO bitfieldInfo;
   struct subcomponent *next;
}TYPE_SUBHEADER_TYPE;

typedef struct component {       /* structure based on TYPE_S_U_STRUCT */
   LPSTR varName;                /* in symblsvr.h                      */
   TYPE_INDEX typeIndex;         /* the first 3 fields must match      */
   U16 offset;
   U16 bitOffset;
   TYPE_SUBHEADER_TYPE typeInfo;
   VS_STRING_TYPE varNameStr;
   struct component *next;
} VS_COMPONENT_TYPE;

typedef struct  {
   BOOLEAN used;
   BOOLEAN active;
   BOOLEAN interActive;
   BOOLEAN readOnly;
   U8 frameNum;
   U8 frameType;
   U32 frameSize;
   U32 errorCode;
   VS_STRING_TYPE varName;
   DESCRIPTOR clientId;
   DESCRIPTOR rootVarId;
   CONTEXT_TYPE context;
   VS_VAR_SELECTION_TYPE varInfo;
   SYM_DESCRIPTOR symDescriptor;
   U16 memberCount;
   U16 baseTypeMemberCount;
   TYPE_SUBHEADER_TYPE typeInfo;
   BOOLEAN dereferencedPtr;
   VAR_STORAGE_CLASS storageClass;
   VAR_REGISTER_CLASS registerClass;
   GET_VAR_ADDR_STRUCT address;
   VS_COMPONENT_TYPE *compListPtr;
} VS_VAR_ENTRY_TYPE;


typedef	VS_VAR_ENTRY_TYPE	 *VS_VAR_TABLE_TYPE;


typedef struct  {
   DESCRIPTOR	currentRadix;
   DESCRIPTOR	defaultRadix;
   DESCRIPTOR	legalRadix;
}  RADIX_INFO_TYPE;


typedef struct  {
   BOOLEAN	used;
   HWND winHandle;
   U32 varTableEntryCount;
   LPSTR radixStrings;
   RADIX_INFO_TYPE	radixInfo[VS_MAX_RADIX];
}  VS_CLIENT_ENTRY_TYPE;


typedef VS_CLIENT_ENTRY_TYPE	*VS_CLIENT_TABLE_TYPE;


                       /****************************
                        *                          *
                        *        PROTOTYPES        *
                        *                          *
                        ****************************/

/******************************** E O F ***********************************/
