// memdlg.cpp : implementation file
//

#include "stdafx.h"
#include "tutorial.h"
#include "memdlg.h"
#include "mainFrm.h"
#include "io.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif
extern void Delay(int nDelay,BOOL bShow=0);

extern BOOL g_bAuto;
extern BOOL g_mbCanDoNext;
extern UINT g_uTick;
/////////////////////////////////////////////////////////////////////////////
// CMemGotoDlg dialog


CMemGotoDlg::CMemGotoDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMemGotoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemGotoDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
 if(g_bAuto)
    AfxGetApp()->m_pMainWnd->KillTimer(IDAUTO);
	    
 g_mbCanDoNext=0;   


 Create(IDD,pParent);
}

void CMemGotoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemGotoDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemGotoDlg, CDialog)
	//{{AFX_MSG_MAP(CMemGotoDlg)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CMemGotoDlg message handlers
BOOL CMemGotoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_uFocus=CLOSEFOCUS;
	m_AddressText = new CTEdit(&m_uFocus,FALSE,"0xE0",NULL);

    m_AddressText->SubclassDlgItem(IDC_MEM_GOTO_EDIT1,this);
	m_BtnOk = new CTButton(0,0);
	m_BtnOk->SubclassDlgItem(IDC_MEM_GOTO_BUTTON1,this);
	        
	CButton *pHelpBtn=(CButton *)GetDlgItem(ID_HELP);
	if(pHelpBtn)
	  pHelpBtn->ShowWindow(SW_SHOW);
    ((CButton *)GetDlgItem(IDC_MEM_GOTO_RADIO1))->SetCheck(TRUE);
    
   if(g_bAuto)
     AfxGetApp()->m_pMainWnd->SetTimer(IDAUTO,5000,NULL);
    g_mbCanDoNext=1;   

	return TRUE;  // return TRUE  unless you set the focus to a control
}
 
void CMemGotoDlg::SetAddress()
{                
    CPoint pointDes;
    CPoint pointSrc;
//   CPoint pointOk;
// CRect rectWin;
 SetSysFilter(1);        
 GetCursorPos(&pointSrc);
/*
 m_AddressText->GetWindowRect(&rectWin);
 pointDes.x=rectWin.right-4;
 pointDes.y=rectWin.top+rectWin.Height()/2;
 GetCursorPos(&pointSrc);
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MoveCursor(pointDes,pointSrc,0,55,8,1);
 pointOk=pointDes;
*/
 m_AddressText->SetEditText("0xE0",0,0,0,0,0);
 Delay(1000);
/*
 m_BtnOk->GetWindowRect(&rectWin);
 pointDes.x=rectWin.left+rectWin.Width()/2;
 pointDes.y=rectWin.top+rectWin.Height()/2;
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MoveCursor(pointDes,pointOk,0,55,4,1);
*/
 m_BtnOk->SetButtonDown(0,1,0,55,4);
 GetCursorPos(&pointDes);
 PostMessage(WM_COMMAND,IDCANCEL);
 
 Delay(500);                   
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MemGoto();
 Delay(50);
 
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MoveCursor(pointSrc,pointDes,0);
}

void CMemGotoDlg::OnCancel()
{
 DestroyWindow();
}

void CMemGotoDlg::OnDestroy()
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here
	delete m_AddressText;
	delete m_BtnOk;
	
}

/////////////////////////////////////////////////////////////////////////////
// CMemSearchDlg dialog
CMemSearchDlg::CMemSearchDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMemSearchDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemSearchDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	g_mbCanDoNext=0;
    if(g_bAuto)
        AfxGetApp()->m_pMainWnd->KillTimer(IDAUTO);
	Create(IDD,pParent);
}

void CMemSearchDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemSearchDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemSearchDlg, CDialog)
	//{{AFX_MSG_MAP(CMemSearchDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMemSearchDlg message handlers
BOOL CMemSearchDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_uFocus=CLOSEFOCUS;
	m_SearchText = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_SearchText->SubclassDlgItem(IDC_MEMSRH_EDIT1,this);
	m_BtnOk = new CTButton(0,0);
	m_BtnOk->SubclassDlgItem(IDC_MEMSRH_OK,this);
	        
	CButton *pHelpBtn=(CButton *)GetDlgItem(ID_HELP);
	if(pHelpBtn)
	  pHelpBtn->ShowWindow(SW_SHOW);
	FilterLMClk(1,GetSafeHwnd());

    g_mbCanDoNext=1; 
    if(g_bAuto)
      AfxGetApp()->m_pMainWnd->SetTimer(IDAUTO,5000,NULL);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}
void CMemSearchDlg::OnCancel()
{          
 delete m_BtnOk;
 delete m_SearchText;  
 FilterLMClk(0,0);
 DestroyWindow();
}

void CMemSearchDlg::SearchItem()
{                
 CPoint pointDes;
 CPoint pointSrc;

// CPoint pointOk;
// CRect rectWin;
 SetSysFilter(1);        
 GetCursorPos(&pointSrc);
/*
 m_SearchText->GetWindowRect(&rectWin);
 pointDes.x=rectWin.right-4;
 pointDes.y=rectWin.top+rectWin.Height()/2;
 GetCursorPos(&pointSrc);
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MoveCursor(pointDes,pointSrc,0,55,8,1);
 pointOk=pointDes;
*/
 m_SearchText->SetEditText("79",0,0,0,0,0);

 Delay(1000);
/*
 m_BtnOk->GetWindowRect(&rectWin);
 pointDes.x=rectWin.left+rectWin.Width()/2;
 pointDes.y=rectWin.top+rectWin.Height()/2;
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MoveCursor(pointDes,pointOk,0,55,4,1);
*/
 m_BtnOk->SetButtonDown(0,1,0,55,4);
 GetCursorPos(&pointDes);
 
 PostMessage(WM_COMMAND,IDCANCEL);
 Delay(500);                   
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MemSearch();
 Delay(50);
 
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MoveCursor(pointSrc,pointDes,0);
}
/////////////////////////////////////////////////////////////////////////////
// CMemAsmDlg dialog
CMemAsmDlg::CMemAsmDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMemAsmDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemAsmDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
    g_mbCanDoNext=0; 
    if(g_bAuto)
      AfxGetApp()->m_pMainWnd->KillTimer(IDAUTO);

	Create(IDD,pParent);
}

void CMemAsmDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemAsmDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CMemAsmDlg, CDialog)
	//{{AFX_MSG_MAP(CMemAsmDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMemAsmDlg message handlers

BOOL CMemAsmDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	m_uFocus = CLOSEFOCUS;
	m_pAsm   = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pAsm->SubclassDlgItem(IDC_DSMEDIT2_EDIT2,this);
	m_pAcept = new CTButton(0,0);
	m_pAcept->SubclassDlgItem(IDC_DSMEDIT2_BUTTON2,this);
	m_pOk    = new CTButton(0,0);
	m_pOk->SubclassDlgItem(IDC_DSMEDIT2_BUTTON1,this);                                              
	GetDlgItem(IDC_DSMEDIT2_EDIT1)->SetWindowText("0004");
    g_mbCanDoNext=1; 
    if(g_bAuto)
      AfxGetApp()->m_pMainWnd->SetTimer(IDAUTO,5000,NULL);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMemAsmDlg::OnCancel()
{          
 delete m_pAsm;
 delete m_pAcept;
 delete m_pOk;
 DestroyWindow();
}
void CMemAsmDlg::ModifyCode()
{
 CPoint pointDes;
 CPoint pointSrc;
// CPoint pointAct;
// CPoint pointOk;
// CRect rectWin;
 GetCursorPos(&pointSrc);
 SetSysFilter(1);
/*
 m_pAsm->GetWindowRect(&rectWin);
 pointDes.x=rectWin.right-10;
 pointDes.y=rectWin.top+rectWin.Height()/2;
 GetCursorPos(&pointSrc);
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MoveCursor(pointDes,pointSrc,0,55,8,1);
*/
 m_pAsm->SetEditText("mov a,00h",0,0,0,0,0);
 Delay(3000);        
/*
 m_pAcept->GetWindowRect(&rectWin);
 pointAct.x=rectWin.left+rectWin.Width()/2;
 pointAct.y=rectWin.top+rectWin.Height()/2;
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MoveCursor(pointAct,pointDes,0,55,2,1);
*/
 m_pAcept->SetButtonDown(0,1,0,55,2);
 m_pAsm->SetWindowText("");   
 GetDlgItem(IDC_DSMEDIT2_EDIT1)->SetWindowText("0006");
 Delay(1000);
 
/* 
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MoveCursor(pointDes,pointAct,0,55,2,1);
*/
 m_pAsm->SetEditText("add a,#01H",0,0,0,0,0,55,2);
 Delay(3000);

/*
 m_pOk->GetWindowRect(&rectWin);
 pointOk.x=rectWin.left+rectWin.Width()/2;
 pointOk.y=rectWin.top+rectWin.Height()/2;
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MoveCursor(pointOk,pointDes,0,55,4,1);
*/
 m_pOk->SetButtonDown(0,1,0,55,4);

 PostMessage(WM_COMMAND,IDCANCEL);
 Delay(500);
 
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MemModifyCode();                         
 GetCursorPos(&pointDes);
 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
 MoveCursor(pointSrc,pointDes,0,55,8,1);
 
 SetMouse(1);
 SetSysFilter(0);
}

/////////////////////////////////////////////////////////////////////////////
// CMemDlg dialog
CMemDlg::CMemDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMemDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CMemDlg)
	//}}AFX_DATA_INIT
    g_mbCanDoNext=0; 
    if(g_bAuto)
      AfxGetApp()->m_pMainWnd->KillTimer(IDAUTO);
	Create(IDD,pParent);
}

void CMemDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMemDlg)
	//}}AFX_DATA_MAP
}

void CMemDlg::ShowChecksumDlg(int nCmdShow)
{
        CWnd* pWnd;
        pWnd = GetDlgItem(IDC_CHECKSUM_BUTTON1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_CHECKSUM_BUTTON2);
        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_CHECKSUM_FRAME3D1);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_CHECKSUM_FRAME3D2);
//        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_CHECKSUM_MH3DCOMBO1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_CHECKSUM_MH3DCOMBO2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_CHECKSUM_MH3DCOMBO3);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_CHECKSUM_MH3DCOMBO4);
        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_CHECKSUM_MH3DLABEL1);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_CHECKSUM_PANEL3D1);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_CHECKSUM_PANEL3D2);
//        pWnd->ShowWindow(nCmdShow);
        if (nCmdShow == SW_SHOW)
          SetDefID(IDC_CHECKSUM_BUTTON1);
}

void CMemDlg::ShowCompareDlg(int nCmdShow)
{
    CWnd* pWnd;

        pWnd = GetDlgItem(IDC_COMPARE_BUTTON1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COMPARE_BUTTON2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COMPARE_BUTTON3);
        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_COMPARE_CHECK3D1);
//        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COMPARE_COMBO1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COMPARE_COMBO2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COMPARE_COMBO3);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COMPARE_COMBO4);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COMPARE_EDIT1);
        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_COMPARE_FRAME3D1);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_COMPARE_FRAME3D2);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_COMPARE_FRAME3D3);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_COMPARE_FRAME3D4);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_COMPARE_PANEL3D1);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_COMPARE_PANEL3D2);
//        pWnd->ShowWindow(nCmdShow);
        if (nCmdShow == SW_SHOW)
          SetDefID(IDC_COMPARE_BUTTON1);
/*

    if ( m_nSpaceType >= 1 && m_nSpaceType <= 2 ) {
    }
    else {
        pWnd = GetDlgItem(IDC_COMPARE_BUTTON1);
        pWnd->EnableWindow(FALSE);
    }
*/
}

void CMemDlg::ShowCopyDlg(int nCmdShow)
{
        CWnd* pWnd;
        pWnd = GetDlgItem(IDC_COPY_BUTTON1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COPY_BUTTON2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COPY_COMBO1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COPY_COMBO2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COPY_COMBO3);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_COPY_COMBO4);
        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_COPY_FRAME3D1);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_COPY_FRAME3D3);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_COPY_PANEL3D1);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_COPY_PANEL3D3);
//        pWnd->ShowWindow(nCmdShow);
        if (nCmdShow == SW_SHOW)
          SetDefID(IDC_COPY_BUTTON1);
/*
    if ( m_nSpaceType >= 1 && m_nSpaceType <= 2 ) {
    }
    else {
        pWnd = GetDlgItem(IDC_COPY_BUTTON1);
        pWnd->EnableWindow(FALSE);
    }
*/
}

void CMemDlg::ShowFillDlg(int nCmdShow)
{
        CWnd* pWnd;
        pWnd = GetDlgItem(IDC_FILL_BUTTON1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_FILL_BUTTON2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_FILL_COMBO1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_FILL_COMBO2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_FILL_COMBO3);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_FILL_COMBO4);
        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_FILL_FRAME3D1);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_FILL_FRAME3D2);
///        pWnd->ShowWindow(nCmdShow);
///        pWnd = GetDlgItem(IDC_FILL_PANEL3D1);
//        pWnd->ShowWindow(nCmdShow);
//        pWnd = GetDlgItem(IDC_FILL_PANEL3D2);
//        pWnd->ShowWindow(nCmdShow);
        if (nCmdShow == SW_SHOW)
          SetDefID(IDC_FILL_BUTTON1);

}

void CMemDlg::ShowSearchDlg(int nCmdShow)
{
        CWnd* pWnd;
        pWnd = GetDlgItem(IDC_SEARCH_BUTTON1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_SEARCH_BUTTON2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_SEARCH_COMBO1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_SEARCH_COMBO2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_SEARCH_COMBO3);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_SEARCH_COMBO4);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_SEARCH_EDIT1);
        pWnd->ShowWindow(nCmdShow);
/*
        pWnd = GetDlgItem(IDC_SEARCH_FRAME3D1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_SEARCH_FRAME3D2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_SEARCH_FRAME3D3);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_SEARCH_PANEL3D1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_SEARCH_PANEL3D2);
        pWnd->ShowWindow(nCmdShow);
*/
        if (nCmdShow == SW_SHOW)
          SetDefID(IDC_SEARCH_BUTTON1);

/*
    if ( m_nSpaceType >= 1 && m_nSpaceType <= 2 ) {
    }
    else {
        pWnd = GetDlgItem(IDC_SEARCH_BUTTON1);
        pWnd->EnableWindow(FALSE);
    }
*/
}

void CMemDlg::ShowTestDlg(int nCmdShow)
{
        CWnd* pWnd;
        pWnd = GetDlgItem(IDC_TEST_BUTTON1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_TEST_BUTTON2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_TEST_COMBO1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_TEST_COMBO2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_TEST_COMBO3);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_TEST_EDIT1);
        pWnd->ShowWindow(nCmdShow);
/*
        pWnd = GetDlgItem(IDC_TEST_FRAME3D1);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_TEST_FRAME3D2);
        pWnd->ShowWindow(nCmdShow);
        pWnd = GetDlgItem(IDC_TEST_PANEL3D1);
        pWnd->ShowWindow(nCmdShow);
*/
        if (nCmdShow == SW_SHOW)
          SetDefID(IDC_TEST_BUTTON1);

}

void CMemDlg::SetTab(int nTabToActivate)
{           
     
    switch (m_activeTab)
    {
    	case 0:
            ShowChecksumDlg(SW_HIDE);    
    		break;
    	case 1:
    		ShowCompareDlg(SW_HIDE);
    		break;
    	case 2:
    		ShowCopyDlg(SW_HIDE);
    		break;
    	case 3:
    		ShowFillDlg(SW_HIDE);
    		break;
    	case 4:
    		ShowSearchDlg(SW_HIDE);
    		break;
    	case 5:
    		ShowTestDlg(SW_HIDE);
    		break;
    	default:
    		break;
    } 

    switch (nTabToActivate)
    {
    	case 0:          
    	    if(m_Bitmap.m_hObject)
    	       m_Bitmap.DeleteObject();
    	    m_Bitmap.LoadBitmap(IDB_CHECKSUM);   
    		ShowChecksumDlg(SW_SHOW);    
    		break;
    	case 1:                     
    	    if(m_Bitmap.m_hObject)
    	       m_Bitmap.DeleteObject();
    	    m_Bitmap.LoadBitmap(IDB_COMPARE);   
    	    ShowCompareDlg(SW_SHOW);
    	    GetDlgItem(IDC_COMPARE_BUTTON2)->
                       ShowWindow(SW_HIDE);
    		break;
    	case 2:                  
    	    if(m_Bitmap.m_hObject)
    	       m_Bitmap.DeleteObject();
    	    m_Bitmap.LoadBitmap(IDB_COPY);   
    	    ShowCopyDlg(SW_SHOW);
    		break;
    	case 3:                  
    	    if(m_Bitmap.m_hObject)
    	       m_Bitmap.DeleteObject();
    	    m_Bitmap.LoadBitmap(IDB_FILL);   
    	    ShowFillDlg(SW_SHOW);
    		break;
    	case 4:
    	    if(m_Bitmap.m_hObject)
    	       m_Bitmap.DeleteObject();
    	    m_Bitmap.LoadBitmap(IDB_SEARCH);   
    		ShowSearchDlg(SW_SHOW);
    		break;
    	case 5:
    	    if(m_Bitmap.m_hObject)
    	       m_Bitmap.DeleteObject();
    	    m_Bitmap.LoadBitmap(IDB_TEST);   
    		ShowTestDlg(SW_SHOW);
    		break;
    		
    	default:
    		break;
    }                            
    Invalidate();
    UpdateWindow();
    m_activeTab = int(nTabToActivate);
	
}

void CMemDlg::InitItem()
{

    m_pStartAddress = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pStartAddress ->SubclassDlgItem(IDC_CHECKSUM_MH3DCOMBO1,this);
    m_pEndAdress    = new CTComboBox(&m_uFocus,0,0,0,0);   
    m_pEndAdress    ->SubclassDlgItem(IDC_CHECKSUM_MH3DCOMBO2,this);
    m_pEndAdr       = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pEndAdr       ->SubclassDlgItem(IDC_CHECKSUM_MH3DCOMBO3,this);
    m_pChecksum     = new CTButton(0,0);
	m_pChecksum     ->SubclassDlgItem(IDC_CHECKSUM_BUTTON1,this);


    m_pCStartAdr     = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pCStartAdr     ->SubclassDlgItem(IDC_COMPARE_COMBO1,this);
    m_pCEndAdr       = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pCEndAdr       ->SubclassDlgItem(IDC_COMPARE_COMBO3,this);
    m_pCScendAdr     = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pCScendAdr     ->SubclassDlgItem(IDC_COMPARE_COMBO4,this);
    m_pCSelAdr       = new CTComboBox(&m_uFocus,0,0,0,0);   
    m_pCSelAdr       ->SubclassDlgItem(IDC_COMPARE_COMBO2,this);
    m_pCompare       = new CTButton(0,0);
	m_pCompare       ->SubclassDlgItem(IDC_COMPARE_BUTTON1,this);
       
    m_pCopStartAdr   = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pCopStartAdr   ->SubclassDlgItem(IDC_COPY_COMBO1,this);
    m_pCopEndAdr     = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pCopEndAdr     ->SubclassDlgItem(IDC_COPY_COMBO3,this);
    m_pCopSelAdr     = new CTComboBox(&m_uFocus,0,0,0,0);   
    m_pCopSelAdr     ->SubclassDlgItem(IDC_COPY_COMBO2,this);
    m_pCopDesAdr     = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pCopDesAdr     ->SubclassDlgItem(IDC_COPY_COMBO4,this);
    m_pCopy          = new CTButton(0,0);
	m_pCopy          ->SubclassDlgItem(IDC_COPY_BUTTON1,this);
       
    m_pFStartAdr     = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pFStartAdr     ->SubclassDlgItem(IDC_FILL_COMBO1,this);
    m_pFEndAdr       = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pFEndAdr       ->SubclassDlgItem(IDC_FILL_COMBO3,this);
    m_pFSelAdr       = new CTComboBox(&m_uFocus,0,0,0,0);   
    m_pFSelAdr       ->SubclassDlgItem(IDC_FILL_COMBO2,this);
    m_pFDesAdr       = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pFDesAdr       ->SubclassDlgItem(IDC_FILL_COMBO4,this);
    m_pFill          = new CTButton(0,0);
	m_pFill          ->SubclassDlgItem(IDC_FILL_BUTTON1,this);

    m_pSStartAdr     = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pSStartAdr     ->SubclassDlgItem(IDC_SEARCH_COMBO1,this);
    m_pSEndAdr       = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pSEndAdr       ->SubclassDlgItem(IDC_SEARCH_COMBO3,this);
    m_pSScendAdr     = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pSScendAdr     ->SubclassDlgItem(IDC_SEARCH_COMBO4,this);
    m_pSSelAdr       = new CTComboBox(&m_uFocus,0,0,0,0);   
    m_pSSelAdr       ->SubclassDlgItem(IDC_SEARCH_COMBO2,this);
    m_pSearch        = new CTButton(0,0);
	m_pSearch        ->SubclassDlgItem(IDC_SEARCH_BUTTON1,this);

    m_pTStartAddress = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pTStartAddress ->SubclassDlgItem(IDC_TEST_COMBO1,this);
    m_pTEndAdress    = new CTComboBox(&m_uFocus,0,0,0,0);   
    m_pTEndAdress    ->SubclassDlgItem(IDC_TEST_COMBO2,this);
    m_pTEndAdr       = new CTEdit(&m_uFocus,FALSE,"0x30",NULL);
    m_pTEndAdr       ->SubclassDlgItem(IDC_TEST_COMBO3,this);
    m_pTest          = new CTButton(0,0);
	m_pTest          ->SubclassDlgItem(IDC_TEST_BUTTON1,this);
}
void CMemDlg::DeleteItem()
{
    delete m_pStartAddress;
    delete m_pEndAdr;
    delete m_pEndAdress;
    delete m_pChecksum;

    delete m_pCStartAdr;
    delete m_pCEndAdr;
    delete m_pCSelAdr;
    delete m_pCompare;
    delete m_pCScendAdr;

    delete m_pCopStartAdr;
    delete m_pCopEndAdr;
    delete m_pCopSelAdr;
    delete m_pCopDesAdr;
    delete m_pCopy;
    
    delete m_pFStartAdr;
    delete m_pFEndAdr;
    delete m_pFSelAdr;
    delete m_pFDesAdr;
    delete m_pFill;

    delete m_pSStartAdr;
    delete m_pSEndAdr;
    delete m_pSSelAdr;
    delete m_pSearch;
    delete m_pSScendAdr;

    delete m_pTStartAddress;
    delete m_pTEndAdr;
    delete m_pTEndAdress;
    delete m_pTest;                
    if(m_Bitmap.GetSafeHandle())
       m_Bitmap.DeleteObject();
    
}              

BEGIN_MESSAGE_MAP(CMemDlg, CDialog)
	//{{AFX_MSG_MAP(CMemDlg)
	ON_WM_NCLBUTTONDOWN()
	ON_WM_PAINT()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CMemDlg message handlers
void CMemDlg::OnNcLButtonDown(UINT nFlags, CPoint point)
{
	// TODO: Add your message handler code here and/or call default
	
	//CDialog::OnLButtonDown(nFlags, point);
}

BOOL CMemDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	((CMainFrame *)(AfxGetApp()->m_pMainWnd))->SetDlgWnd((CDialog *)this);
	FilterLMClk(1,GetSafeHwnd());            
    InitItem(); 
	// TODO: Add extra initialization here
    CWnd* ctrl;
    ShowChecksumDlg(SW_HIDE);    
    ShowCompareDlg(SW_HIDE);
    ShowCopyDlg(SW_HIDE);
    ShowFillDlg(SW_HIDE);
    ShowSearchDlg(SW_HIDE);
    ShowTestDlg(SW_HIDE);

    ctrl = GetDlgItem(IDC_TEST_COMBO2);
    ((CComboBox *)ctrl)->SetCurSel(0);

    ctrl = GetDlgItem(IDC_SEARCH_COMBO2);
    ((CComboBox *)ctrl)->SetCurSel(0);

    ctrl = GetDlgItem(IDC_COPY_COMBO2);
    ((CComboBox *)ctrl)->SetCurSel(0);

    ctrl = GetDlgItem(IDC_FILL_COMBO2);
    ((CComboBox *)ctrl)->SetCurSel(0);

    ctrl = GetDlgItem(IDC_COMPARE_COMBO2);
    ((CComboBox *)ctrl)->SetCurSel(0);

    ctrl = GetDlgItem(IDC_COMPARE_BUTTON2);
    ctrl->ShowWindow(SW_HIDE);

    ctrl = GetDlgItem(IDC_SEARCH_COMBO4);
    ((CComboBox *)ctrl)->LimitText(52);

    ctrl = GetDlgItem(IDC_CHECKSUM_MH3DCOMBO2);
    ((CComboBox *)ctrl)->SetCurSel(0);

    ctrl = GetDlgItem(IDC_CHECKSUM_MH3DCOMBO4);
    ((CComboBox *)ctrl)->SetCurSel(0);

	SetTab(0);           

    g_mbCanDoNext=1; 
    if(g_bAuto)
    {
       AfxGetApp()->m_pMainWnd->SetTimer(IDAUTO,10000,NULL);
       g_uTick=10000;
    } 
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMemDlg::OnCancel()
{
  DeleteItem();
  FilterLMClk(0,0);            
  DestroyWindow();
} 

void CMemDlg::OnOk()
{
  DeleteItem();
  FilterLMClk(0,0);            
  DestroyWindow();
} 

/*-------------------------------------------------------*/
/*            CheckSum Action                            */
/*-------------------------------------------------------*/
void CMemDlg::Checksum()
{              
	 CPoint pointDes;
	 CPoint pointSrc;
	 GetCursorPos(&pointDes);
	 SetSysFilter(1);     
	 
	 m_pStartAddress->SetEditText("10",0,0,0,0,0,55,8);
	 Delay(2000);        
	 
	 m_pEndAdress->SetCombo(0,0,0,0,0,0,55,4);
	 Delay(2000);
	 
	 m_pEndAdr->SetEditText("20",0,0,0,0,0,55,4);
	 Delay(2000);
	
	 m_pChecksum->SetButtonDown(0,1,0,55,4);
	 SetDlgItemText(IDC_CHECKSUM_MH3DLABEL1,"0x2CA");
	 Delay(1000);
	 
	 GetCursorPos(&pointSrc);
	 ((CMainFrame *)AfxGetApp()->m_pMainWnd)->
	 MoveCursor(pointDes,pointSrc,0,55,4,1);
	 
	 SetMouse(1);
	 SetSysFilter(0);
}
/*-------------------------------------------------------*/
/*            Compare  Action                            */
/*-------------------------------------------------------*/
void CMemDlg::Compare()
{                 
     Delay(1000);
	 CPoint pointDes;
	 CPoint pointSrc;
	 GetCursorPos(&pointDes);
	 SetSysFilter(1);     
	 
	 m_pCStartAdr->SetEditText("10",0,0,0,0,0,55,8);
	 Delay(2000);        
	 
	 m_pCSelAdr->SetCombo(1,0,0,0,0,0,55,4);
	 Delay(2000);
	 
	 m_pCEndAdr->SetEditText("4",0,0,0,0,0,55,4);
	 Delay(2000);
	
	 m_pCScendAdr->SetEditText("30",0,0,0,0,0,55,4);
	 Delay(2000);    
	 
	 m_pCompare->SetButtonDown(0,1,0,55,4);
	 
	 HFILE hFile=_lopen("compare.txt",READ);
	 if(hFile!=HFILE_ERROR)
	   {      
	    LPSTR lpTxt = new char[600];
	    _fmemset(lpTxt,0,600);
	    _lread(hFile,lpTxt,44*4+18);
	    _lclose(hFile);
	    GetDlgItem(IDC_COMPARE_EDIT1)->SetWindowText(lpTxt);
	    GetDlgItem(IDC_COMPARE_EDIT1)->EnableScrollBar(SB_VERT,
	                                                   ESB_DISABLE_BOTH);
	    delete lpTxt; 
	    Delay(1000);
	   }
	   
	 SetMouse(1);
	 SetSysFilter(0);
}
/*-------------------------------------------------------*/
/*               Copy  Action                            */
/*-------------------------------------------------------*/
void CMemDlg::Copy()
{                 
     Delay(1000);
	 CPoint pointDes;
	 CPoint pointSrc;
	 GetCursorPos(&pointDes);
	 SetSysFilter(1);     
	 
	 m_pCopStartAdr->SetEditText("100",0,0,0,0,0,55,4);
	 Delay(2000);        
	 
	 m_pCopSelAdr->SetCombo(0,0,0,0,0,0,55,4);
	 Delay(2000);
	 
	 m_pCopEndAdr->SetEditText("200",0,0,0,0,0,55,4);
	 Delay(2000);
	
	 m_pCopDesAdr->SetEditText("300",0,0,0,0,0,55,4);
	 Delay(2000);    
	 
	 m_pCopy->SetButtonDown(0,1,0,55,4);
	 
	 SetMouse(1);
	 SetSysFilter(0);

}

/*-------------------------------------------------------*/
/*               Fill  Action                            */
/*-------------------------------------------------------*/
void CMemDlg::Fill()
{                 
     Delay(1000);
	 CPoint pointDes;
	 CPoint pointSrc;
	 GetCursorPos(&pointDes);
	 SetSysFilter(1);     
	 
	 m_pFStartAdr->SetEditText("100",0,0,0,0,0,55,4);
	 Delay(2000);        
	 
	 m_pFSelAdr->SetCombo(1,0,0,0,0,0,55,4);
	 Delay(2000);
	 
	 m_pFEndAdr->SetEditText("10",0,0,0,0,0,55,4);
	 Delay(2000);
	
	 m_pFDesAdr->SetEditText("00",0,0,0,0,0,55,4);
	 Delay(2000);    
	 
	 m_pFill->SetButtonDown(0,1,0,55,4);
	 
	 SetMouse(1);
	 SetSysFilter(0);

}

/*-------------------------------------------------------*/
/*            Compare  Action                            */
/*-------------------------------------------------------*/
void CMemDlg::Search()
{                 
     Delay(1000);
	 CPoint pointDes;
	 CPoint pointSrc;
	 GetCursorPos(&pointDes);
	 SetSysFilter(1);     
	 
	 m_pSStartAdr->SetEditText("100",0,0,0,0,0,55,8);
	 Delay(2000);        
	 
	 m_pSSelAdr->SetCombo(0,0,0,0,0,0,55,4);
	 Delay(2000);
	 
	 m_pSEndAdr->SetEditText("200",0,0,0,0,0,55,4);
	 Delay(2000);
	
	 m_pSScendAdr->SetEditText("ef",0,0,0,0,0,55,4);
	 Delay(2000);    
	 
	 m_pSearch->SetButtonDown(0,1,0,55,4);
	 
	 char lpTxt[] ={"1>Find At 0x82 \r\n2>Find At 0xB4\0"} ;
	 GetDlgItem(IDC_SEARCH_EDIT1)->SetWindowText(lpTxt);
	 GetDlgItem(IDC_SEARCH_EDIT1)->EnableScrollBar(SB_VERT,
	                                                ESB_DISABLE_BOTH);
	 Delay(1000);
	   
	 SetMouse(1);
	 SetSysFilter(0);
}
/*-------------------------------------------------------*/
/*                Test Action                            */
/*-------------------------------------------------------*/
void CMemDlg::Test()
{              
	 CPoint pointDes;
	 CPoint pointSrc;
	 GetCursorPos(&pointDes);
	 SetSysFilter(1);     
	 
	 m_pTStartAddress->SetEditText("100",0,0,0,0,0,55,8);
	 Delay(2000);        
	 
	 m_pTEndAdress->SetCombo(0,0,0,0,0,0,55,4);
	 Delay(2000);
	 
	 m_pTEndAdr->SetEditText("200",0,0,0,0,0,55,4);
	 Delay(2000);
	
	 m_pTest->SetButtonDown(0,1,0,55,4);
	 SetDlgItemText(IDC_TEST_EDIT1,"TEST OK!");
	 Delay(1000);
	 
	 SetMouse(1);
	 SetSysFilter(0);
}

void CMemDlg::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	
	// TODO: Add your message handler code here
	CRect rect;
	GetClientRect(&rect);
	CDC dcMap;
	dcMap.CreateCompatibleDC(&dc);
	dcMap.SelectObject(&m_Bitmap); 
	dc.BitBlt(0,0,rect.Width(),rect.Height(),&dcMap,0,0,SRCCOPY);
	dcMap.DeleteDC();

	// Do not call CDialog::OnPaint() for painting messages
}
