// srcwnd.h : header file
//              
/////////////////////////////////////////////////////////////////////////////
// CTWnd window
class CTWnd : public CMDIChildWnd
{
// Construction
public:
	CTWnd(UINT idMenu,UINT idSub,BOOL bTutorial,BOOL bSetByUser=TRUE);

// Attributes
protected:
    BOOL      m_bTutorial; 
protected:    
    CString   m_sClassName;
    CMenu     *m_pFrameMenu;
    CMenu     *m_pWndMenu; 
    BOOL      m_bSetByUser; 
    BOOL      m_bMouseClk;
public:                      

// Operations
public:
virtual void ChangToUseOperate(BOOL bSet=1);

// Implementation
public:
	virtual ~CTWnd();

protected:
	// Generated message map functions
	//{{AFX_MSG(CTWnd)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnNcLButtonDblClk(UINT nFlags, CPoint point);
	afx_msg void OnNcLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnNcLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnNcMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// CSCrollWnd window

class CSCrollWnd : public CTWnd
{
// Construction
public:
	CSCrollWnd(UINT idMenu,UINT idSub,BOOL bTutorial,BOOL bSetByUser=TRUE);

// Attributes
public:
virtual void ChangToUseOperate(BOOL bSet=1);
// Operations
public:
   void SetXCaret(int x){m_nXCaret=x;};
// Implementation
protected:
   int       m_nFontWidth;   //hscroll unit
   int       m_nFontHeight;  //vscroll unit
   int       m_xClient;      //window width
   int       m_yClient;      //window height
   int       m_nMaxHeight;   //vscroll lines
   int       m_nMaxWidth;    //hscroll lines
   int       m_nVertPos;     //v Pos
   int       m_nLines;       //total lines
   int       m_nCLines;      //window left/top total lines
   int       m_nHorzPos;     //h Pos
   int       m_nVertOld;     
   int       m_nHorzOld;  
   POINT     m_pointCaret;   //Caret Pos
   int       m_nXCaret;      //x start pos
   int       m_nXPage;       
   int       m_nYPage;    
protected:
   CBitmap   *m_pBitContent;   

public:
	virtual ~CSCrollWnd();

protected:
	// Generated message map functions
	//{{AFX_MSG(CSCrollWnd)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnPaint();
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar);
	afx_msg void OnKillFocus(CWnd* pNewWnd);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////
// CSrcWnd window

class CSrcWnd : public CSCrollWnd//CTWnd
{
// Construction
public:
	CSrcWnd(UINT idMenu,UINT idSub,BOOL bTutorial,BOOL bSetByUser=TRUE);

// Attributes 
private:
   UINT      *m_pLineIndex;
   HGLOBAL    m_hMemIdx;
private: 
   UINT      m_uCtrlID;
   int       m_nWin_Modal;
   int       m_nBK;
   HCURSOR   m_hCursor;
   HCURSOR   m_hArrow;
   BOOL      m_bSetBk;
   BOOL      *m_pLineBp;
   BOOL      m_bDelete;
   int       m_nStepLine;
   int       m_nOldStep;
   int 	     m_nStep;
   HBITMAP   m_hBitmap;
   CBitmap   *m_pBpMap;
   CBitmap   *m_pOldBp;
// Operations        
public:
virtual void ChangToUseOperate(BOOL bSet=1);
void GetLineBpInfo(CTListBox *pListBox,CTEdit *pEdit);
void AddBp(long Line,CTListBox *pListBox); 
BOOL DeleteBp(CTListBox *pListBox);
void ChangeMode(UINT nMode);  
void OnVRunStepover();
void Step(int nStep);
void LButtonDown( CPoint point);
void SetBP(){m_bSetBk=1;};
protected:
   void SetStepLine(int nStepLineint,int nOldLine=-1);
   void BuildContent(int nidB1,int nidB2,CBitmap *pBitmap,int nxSCroll,
                     BOOL bObject=0,LPSTR lpTitle=0);
// Implementation
public:
	virtual ~CSrcWnd();

protected:
	// Generated message map functions
	//{{AFX_MSG(CSrcWnd)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnRunBreakpoint();
	afx_msg void OnMDIActivate(BOOL bActivate, CWnd* pActivateWnd, CWnd* pDeactivateWnd);
	afx_msg void OnRunGo();
	afx_msg void OnViewMixed();
	afx_msg void OnViewSourceonly();
	afx_msg void OnRunStepover();
	afx_msg void OnTimer(UINT nIDEvent);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////
