/////////////////////////////////////////////////////////////////////////////
//
//  File name:  BTNBAR.CPP
//

#include "stdafx.h"
#include "resource.h"
//#include "xview.h"

//#include "zqueue.h"                   
//#include "uicom.h"                   
//#include "srccom.h"
#include "hwtip.h"
#include "toolbar.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
//  Toolbar button index

enum {
    BTN_MODULE = 0,
    BTN_PREV_MODULE,
    BTN_NEXT_MODULE,
    BTN_LOAD,
    BTN_SEARCH,
    BTN_SRC_MODE,
    BTN_MIX_MODE,
    BTN_BUS_MODE,
    BTN_INS_MODE,
    BTN_BP,
    BTN_GO,
    BTN_HALT,
    BTN_RESET,
    BTN_STEPI,
    BTN_STEPO,
    BTN_GO_OVER,
    BTN_GO_UNTIL,
    BTN_WATCH,
    BTN_STATEMENT,
    BTN_INST,
    BTN_LOCAL_VAR,
    BTN_FRAME1,
    BTN_FRAMEn,
    BTN_FRAME,
    BTN_ADD_VAR,
    BTN_DEL_VAR,
    BTN_HELP
};                  


    
/////////////////////////////////////////////////////////////////////////////
// CButtonBar

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::CButtonBar
//
//  Description: Constructor of the class CButtonBar
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
CButtonBar::CButtonBar()
 : nActiveId(WID_MAIN)
{
//	m_pTip = new CVBControl;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::~CButtonBar
//
//  Description: Destructor of the class CButtonBar
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
CButtonBar::~CButtonBar()
{                           
//	m_pTip->DestroyWindow();
//	delete m_pTip;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::CreateBar
//
//  Description: Create the tool bar 
//
//  Input:  
//      pOwner -- the owner of the toolbar
//
//  Output: None
//
//  Return: TRUE -- Success
//          FALSE -- Failed
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::CreateBar(CWnd       *pOwner,
                           CStatusBar *pBar,
                           UINT       uNotify )
{           
    if(!Create(pOwner,pBar,40,uNotify) || 
       !LoadBitmap(IDR_MAINFRAME)     || 
       !NewMain())
    {
        TRACE("Failed to create button bar\n");
        return FALSE;
    }             
    
//    m_pTip->Create("MHTIP.VBX;MhTip;MhTip1", NULL, CRect(0, 0, 50, 20),
//    	this, IDC_MHTIP1);
    return TRUE;
}                                        

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::Del
//
//  Description: Delete controls when the toolbar inactive
//
//  Input:  None
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void CButtonBar::Del(void)
{                        
    m_isCmbSrch = FALSE;
    switch(nActiveId) {
        case WID_TRACE:
            m_cmbSrch.DestroyWindow();
            break;
        case WID_SOURCE:
            m_cmbSrch.DestroyWindow();
            break;
        case WID_VARIABLE:
            m_cmbSrch.DestroyWindow();
            break;
        case WID_STACK:
            m_cmbSrch.DestroyWindow();
            break;
    }
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::NewMain
//
//  Description: Make toolbar of main window active
//
//  Input:  None
//
//  Output: None
//
//  Return: TRUE -- Success
//          FALSE -- Failed
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewMain(void)
{
    BOOL is = SetButtons(NULL, 11);
    if(is) {
        SetButtonInfo(0, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE,
                      IDS_TIP_BM);
        SetButtonInfo(1, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD,
                      IDS_TIP_LOAD);
        SetButtonInfo(2, ID_SEPARATOR, TBBS_SEPARATOR, 6,
                      ID_SEPARATOR);
        SetButtonInfo(3, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET,
                      IDS_TIP_RESET);
        SetButtonInfo(4, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP,
                      IDS_TIP_BP);
        SetButtonInfo(5, ID_RUN_GO, TBBS_BUTTON, BTN_GO,
                      IDS_TIP_GO);
//        SetButtonInfo(5, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        SetButtonInfo(6, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPI,
                      IDS_TIP_SI);
        SetButtonInfo(7, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPO,
                      IDS_TIP_SO);
        SetButtonInfo(8, ID_RUN_GOUNTILRETURN, TBBS_BUTTON, BTN_GO_OVER,
                      IDS_TIP_GUR);
        SetButtonInfo(9, ID_SEPARATOR, TBBS_SEPARATOR, 6,
                      ID_SEPARATOR);
        /*SetButtonInfo(11, IDM_STEP_STATEMENT, TBBS_BUTTON, BTN_STATEMENT);
        SetButtonInfo(12, IDM_STEP_INSTRUCTION, TBBS_BUTTON, BTN_INST);
        SetButtonInfo(13, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(10, ID_HELP, TBBS_BUTTON, BTN_HELP,
                      IDS_TIP_HELP);
        Invalidate();
        nActiveId = WID_MAIN;
        return TRUE;
    } else  return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewSource(void)
{
    BOOL is = SetButtons(NULL, 20);
    if(is) {
        SetButtonInfo(0, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE,
                      IDS_TIP_BM);
        SetButtonInfo(1, ID_FILE_PREVMODULE, TBBS_BUTTON, BTN_PREV_MODULE,
                      IDS_TIP_PM);
        SetButtonInfo(2, ID_FILE_NEXTMODULE, TBBS_BUTTON, BTN_NEXT_MODULE,
                      IDS_TIP_NM);
        SetButtonInfo(3, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD,
                      IDS_TIP_LOAD);
        SetButtonInfo(4, ID_SEPARATOR, TBBS_SEPARATOR, 6,
                      ID_SEPARATOR);
        SetButtonInfo(5, IDC_SRCHCOMBO, TBBS_SEPARATOR, 80,
                      IDS_TIP_SEARCH);
        SetButtonInfo(6, ID_SEPARATOR, TBBS_SEPARATOR, 6,
                      ID_SEPARATOR);
        SetButtonInfo(7, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH,
                      IDS_TIP_SN);
        SetButtonInfo(8, ID_SEPARATOR, TBBS_SEPARATOR, 6,
                      ID_SEPARATOR);
        SetButtonInfo(9, ID_VIEW_SOURCEONLY, TBBS_BUTTON, BTN_SRC_MODE,
                      IDS_TIP_SM);
        SetButtonInfo(10, ID_VIEW_MIXED, TBBS_BUTTON, BTN_MIX_MODE,
                      IDS_TIP_MIX );
        SetButtonInfo(11, ID_SEPARATOR, TBBS_SEPARATOR, 6,
                      ID_SEPARATOR);
        SetButtonInfo(12, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET,
                      IDS_TIP_RESET); 
        SetButtonInfo(13, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP,
                      IDS_TIP_BP);
        SetButtonInfo(14, ID_RUN_GO, TBBS_BUTTON, BTN_GO,
                      IDS_TIP_GO);
        //SetButtonInfo(14, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        //SetButtonInfo(16, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_WATCH);
        SetButtonInfo(15, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPI,
                      IDS_TIP_SI);
        SetButtonInfo(16, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPO,
                      IDS_TIP_SO);
        SetButtonInfo(17, ID_RUN_GOUNTILRETURN, TBBS_BUTTON, BTN_GO_OVER,
                      IDS_TIP_GUR);
        SetButtonInfo(18, ID_SEPARATOR, TBBS_SEPARATOR, 6,
                      ID_SEPARATOR);
        /*SetButtonInfo(20, IDM_STEP_STATEMENT, TBBS_BUTTON, BTN_STATEMENT);
        SetButtonInfo(21, IDM_STEP_INSTRUCTION, TBBS_BUTTON, BTN_INST);
        SetButtonInfo(22, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(19, ID_HELP, TBBS_BUTTON, BTN_HELP,
                      IDS_TIP_HELP);

        CRect rect;
        GetItemRect(5, &rect);
        rect.top = 1;
        rect.bottom = rect.top + 100;
        if(!m_cmbSrch.Create(CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, 
            rect, this, IDC_SRCHCOMBO)) {
            TRACE("Failed to create combo-box\n");
            return FALSE;
        }           
        m_isCmbSrch = TRUE;                 
        Invalidate();
        nActiveId = WID_SOURCE;
        return TRUE;
    } else  return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewVariable(void)
{
    BOOL is = SetButtons(NULL, 18);
    if(is) {
        SetButtonInfo(0, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);
        SetButtonInfo(1, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        SetButtonInfo(2, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(3, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET); 
        SetButtonInfo(4, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        SetButtonInfo(5, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        //SetButtonInfo(5, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        SetButtonInfo(6, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPI);
        SetButtonInfo(7, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPO);
        SetButtonInfo(8, ID_RUN_GOUNTILRETURN, TBBS_BUTTON, BTN_GO_OVER);
        SetButtonInfo(9, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        /*SetButtonInfo(11, IDM_STEP_STATEMENT, TBBS_BUTTON, BTN_STATEMENT);
        SetButtonInfo(12, IDM_STEP_INSTRUCTION, TBBS_BUTTON, BTN_INST);
        SetButtonInfo(13, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(10, ID_VARIABLE_ADD, TBBS_BUTTON, BTN_ADD_VAR);
        SetButtonInfo(11, ID_VARIABLE_DELETE, TBBS_BUTTON, BTN_DEL_VAR);
        SetButtonInfo(12, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(13, IDC_SRCHCOMBO, TBBS_SEPARATOR, 80);
        SetButtonInfo(14, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(15, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH);
        SetButtonInfo(16, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(17, ID_HELP, TBBS_BUTTON, BTN_HELP);

        CRect rect;
        GetItemRect(13, &rect);
        rect.top = 1;
        rect.bottom = rect.top + 100;
        if(!m_cmbSrch.Create(CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, 
            rect, this, IDC_SRCHCOMBO)) {
            TRACE("Failed to create combo-box\n");
            return FALSE;
        }           
        m_isCmbSrch = TRUE;                 
        

        Invalidate();
        nActiveId = WID_VARIABLE;
        return TRUE;
    } else  return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewStack(void)
{
    BOOL is = SetButtons(NULL, 17);
    if(is) {
        SetButtonInfo(0, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);
        SetButtonInfo(1, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        SetButtonInfo(2, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(3, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET); 
        SetButtonInfo(4, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        SetButtonInfo(5, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        //SetButtonInfo(5, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        SetButtonInfo(6, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPI);
        SetButtonInfo(7, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPO);
        SetButtonInfo(8, ID_RUN_GOUNTILRETURN, TBBS_BUTTON, BTN_GO_OVER);
        SetButtonInfo(9, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        /*SetButtonInfo(11, IDM_STEP_STATEMENT, TBBS_BUTTON, BTN_STATEMENT);
        SetButtonInfo(12, IDM_STEP_INSTRUCTION, TBBS_BUTTON, BTN_INST);
        SetButtonInfo(13, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(10, ID_EDIT_SELECTLOCALVARIABLES, TBBS_BUTTON, 
                            BTN_LOCAL_VAR);
        SetButtonInfo(11, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(12, IDC_SRCHCOMBO, TBBS_SEPARATOR, 80);
        SetButtonInfo(13, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(14, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH);
        SetButtonInfo(15, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(16, ID_HELP, TBBS_BUTTON, BTN_HELP);

        CRect rect;
        GetItemRect(12, &rect);
        rect.top = 1;
        rect.bottom = rect.top + 100;
        if(!m_cmbSrch.Create(CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, 
            rect, this, IDC_SRCHCOMBO)) {
            TRACE("Failed to create combo-box\n");
            return FALSE;
        }           
        m_isCmbSrch = TRUE;                 
        

        Invalidate();
        nActiveId = WID_STACK;
        return TRUE;
    } else  return FALSE;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewCpu(void)
{
    BOOL is = NewMain();
    if(is)  nActiveId = WID_CPU;
    return  is;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewPeri(void)
{
    BOOL is = NewMain();
    if(is)  nActiveId = WID_PERI;
    return  is;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewMemory(void)
{
    BOOL is = NewMain();
    if(is)  nActiveId = WID_MEMORY;
    return  is;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewShell(void)
{
    BOOL is = NewMain();
    if(is)  nActiveId = WID_SHELL;
    return  is;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewBMem(void)
{
    BOOL is = NewMain();
    if(is)  nActiveId = WID_BMEM;
    return  is;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
BOOL CButtonBar::NewTrace(void)
{
    BOOL is = SetButtons(NULL, 18);
    if(is) {
        SetButtonInfo(0, ID_FILE_BROWSEMODULE, TBBS_BUTTON, BTN_MODULE);
        SetButtonInfo(1, ID_FILE_LOAD, TBBS_BUTTON, BTN_LOAD);
        SetButtonInfo(2, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(3, ID_RUN_RESET, TBBS_BUTTON, BTN_RESET);
        SetButtonInfo(4, ID_RUN_BREAKPOINT, TBBS_BUTTON, BTN_BP);
        SetButtonInfo(5, ID_RUN_GO, TBBS_BUTTON, BTN_GO);
        //SetButtonInfo(5, ID_RUN_HALT, TBBS_BUTTON, BTN_HALT);
        SetButtonInfo(6, ID_RUN_STEPINTO, TBBS_BUTTON, BTN_STEPI);
        SetButtonInfo(7, ID_RUN_STEPOVER, TBBS_BUTTON, BTN_STEPO);
        SetButtonInfo(8, ID_RUN_GOUNTILRETURN, TBBS_BUTTON, BTN_GO_OVER);
        SetButtonInfo(9, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        /*SetButtonInfo(11, IDM_STEP_STATEMENT, TBBS_BUTTON, BTN_STATEMENT);
        SetButtonInfo(12, IDM_STEP_INSTRUCTION, TBBS_BUTTON, BTN_INST);
        SetButtonInfo(13, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(10, ID_EDIT_GOTOSTARTFRAME, TBBS_BUTTON, BTN_FRAME1);
        SetButtonInfo(11, ID_EDIT_GOTOENDFRAME, TBBS_BUTTON, BTN_FRAMEn);
        SetButtonInfo(12, ID_EDIT_GOTOFRAME, TBBS_BUTTON, BTN_FRAME);
        SetButtonInfo(13, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(14, ID_VIEW_BUS, TBBS_BUTTON, BTN_BUS_MODE);
        SetButtonInfo(15, ID_VIEW_INSTRUCTION, TBBS_BUTTON, BTN_INS_MODE);
        SetButtonInfo(16, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        /*SetButtonInfo(21, IDC_SRCHCOMBO, TBBS_SEPARATOR, 80);
        SetButtonInfo(22, ID_SEPARATOR, TBBS_SEPARATOR, 6);
        SetButtonInfo(23, ID_EDIT_SEARCHNEXT, TBBS_BUTTON, BTN_SEARCH);
        SetButtonInfo(24, ID_SEPARATOR, TBBS_SEPARATOR, 6);*/
        SetButtonInfo(17, ID_HELP, TBBS_BUTTON, BTN_HELP);      

/*        CRect rect;
        GetItemRect(21, &rect);
        rect.top = 1;
        rect.bottom = rect.top + 100;
        if(!m_cmbSrch.Create(CBS_DROPDOWN|CBS_AUTOHSCROLL|WS_VISIBLE, 
            rect, this, IDC_SRCHCOMBO)) {
            TRACE("Failed to create combo-box\n");
            return FALSE;
        }           
        m_isCmbSrch = TRUE;     
            
        m_cmbSrch.AddString("abcd");
        m_cmbSrch.AddString("efgh");
        m_cmbSrch.AddString("1234");
        m_cmbSrch.AddString("5678");
        m_cmbSrch.AddString("AGBCD");
        m_cmbSrch.AddString("ORI R UET UITU");
        m_cmbSrch.SetCurSel(0);*/
        
        Invalidate();
        nActiveId = WID_TRACE;
        return TRUE;
    } else  return FALSE;
}                   

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CButtonBar::AddSrchText
//
//  Description: Add search text to the search combobox
//
//  Input:  
//      str -- the search text
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void CButtonBar::AddSrchText(const char * str)
{
    if(!m_isCmbSrch)    return;
    CString strTemp;
    if(m_cmbSrch.GetCount()) {
        m_cmbSrch.GetLBText(0, strTemp);
        if(strTemp == str)  return;
    }    
    m_cmbSrch.InsertString(0, str);
    m_cmbSrch.SetCurSel(0);
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CString CButtonBar::GetSrchText(void)
{
    ASSERT(nActiveId == WID_SOURCE || nActiveId == WID_TRACE);
    
    if(!m_isCmbSrch)    return  "";
    int nSel = m_cmbSrch.GetCurSel();
    if(nSel == CB_ERR)  return  "";
    CString str;
    m_cmbSrch.GetLBText(nSel, str);
    return  str;
}

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   
//
//  Description: 
//
//  Input:  
//
//  Output: 
//
//  Return: 
//
/////////////////////////////////////////////////////////////////////////////
CString CButtonBar::GetSrchEditText(void)
{                
    CString str;
    m_cmbSrch.GetWindowText(str);
    return  str;
}

BEGIN_MESSAGE_MAP(CButtonBar, CTipToolBar)
    //{{AFX_MSG_MAP(CButtonBar)
        // NOTE - the ClassWizard will add and remove mapping macros here.
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

//	ON_VBXEVENT(VBN_SETCAPTION, IDC_MHTIP1, OnSetcaptionMhtip1)

/////////////////////////////////////////////////////////////////////////////
// CButtonBar message handlers
/*void CButtonBar::OnSetcaptionMhtip1(UINT, int, CWnd*, LPVOID lpParams)
{
	
	char StrBuff[256];
	int StrBuffLen;
		
	StrBuffLen = ::GetWindowText((HWND)AFX_NUM_EVENTPARAMINDEX(int, lpParams, 3), StrBuff, 255);
	
	m_pTip->SetStrProperty("Caption", "ifuodiufg"StrBuff);
	m_pTip->ShowWindow(SW_SHOW);	
}
*/
////////////////////////////////////(EOF)////////////////////////////////////
