// Tutpaint.cpp :
//
#define  __cplusplus
#include "stdafx.h"
#include "tutorial.h"

#include "mainfrm.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

//display a bitmap  
extern void Delay(int nDelay,BOOL bShow=0);
extern BOOL g_mbCanDoNext;
extern BOOL g_bAuto;

BOOL CMainFrame::PaintBitmap(CDC &dc,
                             CRect DestRect,
                             CRect SrcRect,
                             CBitmap *pBitmap,
                             BOOL bDelete/*=0*/,
                             DWORD dwFlag/*=SRCCOPY*/)
{
 CBitmap *pOldBitmap;
 CDC *MemDC = new CDC;
 
 if(!MemDC->CreateCompatibleDC(&dc))
   return 0;
 pOldBitmap=(CBitmap *)MemDC->SelectObject(pBitmap);
 
 if(!dc.StretchBlt(DestRect.left,DestRect.top,
               DestRect.Width(),DestRect.Height(),
               MemDC,
               SrcRect.left,SrcRect.top,SrcRect.right,SrcRect.bottom,
               dwFlag))
       
 MemDC->SelectObject(pOldBitmap);
 MemDC->DeleteDC();
 delete MemDC;
 if(bDelete)
   pBitmap->DeleteObject();
 return 1;
}                 

//display wallpaper which not a block
BOOL CMainFrame::PaintWall(CDC &dc,CRect DestRect,CBitmap *pBitmap)
{
 int xCount=0;
 int yCount=0;   
 CDC *SrcDC=new CDC;
 CDC *DesDC=new CDC;
 CBitmap *OldSrcBitmap;
 CBitmap *OldDesBitmap; 
 CRect rectSrc,rectDes;
 BITMAP bm;
 CBitmap *bitmap=new CBitmap; 
 
 pBitmap->GetObject(sizeof(BITMAP),&bm);
 rectSrc.SetRect(0,0,bm.bmWidth,bm.bmHeight);
 bitmap->CreateCompatibleBitmap(&dc,DestRect.Width(),DestRect.Height());
 SrcDC->CreateCompatibleDC(&dc);
 DesDC->CreateCompatibleDC(&dc);
 OldSrcBitmap=(CBitmap *)SrcDC->SelectObject(pBitmap);
 OldDesBitmap=(CBitmap *)DesDC->SelectObject(bitmap);
 xCount=DestRect.Width()/bm.bmWidth;
 yCount=DestRect.Height()/bm.bmHeight;
 
 for(int y=0;y<=yCount;y++)
    for(int x=0;x<=xCount;x++)
       {       
        rectDes.SetRect(x*bm.bmWidth,y*bm.bmHeight,
                        x*bm.bmWidth+bm.bmWidth,
                        y*bm.bmHeight+bm.bmHeight);
        DesDC->BitBlt(rectDes.left,rectDes.top,rectDes.Width(),rectDes.Height(),
                      SrcDC,0,0,SRCCOPY);                
       }    
                   
  SrcDC->SelectObject(OldSrcBitmap);
  DesDC->SelectObject(OldDesBitmap);
  SrcDC->DeleteDC();
  DesDC->DeleteDC();
  delete SrcDC;
  delete DesDC;

  PaintBitmap(dc,DestRect,DestRect,bitmap);
  
  bitmap->DeleteObject();
  delete bitmap;
       
  return 1;     
}
// display move bug
BOOL CMainFrame::MovingBitmap(CDC &dc,CRect DestRect,CBitmap *pBitmap,CBitmap *pMonoBitmap)
{
 CDC pMemDC ;
 CBitmap *pOldBitmap;
 
 pMemDC.CreateCompatibleDC(&dc);
 pOldBitmap=(CBitmap *)pMemDC.SelectObject(pMonoBitmap);
 dc.BitBlt(DestRect.left,DestRect.top,DestRect.Width(),DestRect.Height(),
           &pMemDC,0,0,SRCAND);
 pMemDC.SelectObject(pBitmap);          
 dc.BitBlt(DestRect.left,DestRect.top,DestRect.Width(),DestRect.Height(),
           &pMemDC,0,0,SRCPAINT);  
           
 pMemDC.SelectObject(pOldBitmap);
 pMemDC.DeleteDC();
 return 1;
}

// display a transparent bitmap
BOOL CMainFrame::TransparentBitmap(CDC &dc,CRect DestRect,CBitmap *pBitmap,LPSTR lpResName)
{

 CDC       *pMaskDC = new CDC;
 CDC       *pRevDC = new CDC;          
 CBitmap   *pTempBitmap = new CBitmap;
 CBitmap   *pMaskBitmap ;
 CBitmap   *pRevBitmap = new CBitmap;       
 CBitmap   *pOldMaskBitmap;
 CBitmap   *pOldRevBitmap;
 MONBITMAP monBitmap={dc.GetSafeHdc(),0,0,BLACK};
 BITMAP    bm;
/////////////////////////////////////////// 
  if(!MakeMonBitmap(lpResName,monBitmap))
    {
     if(monBitmap.hRes)
       {
        ::UnlockResource(monBitmap.hRes);
        ::FreeResource(monBitmap.hRes);
       }  
      delete pMaskDC;
      delete pRevDC;
      delete pTempBitmap;
      delete pRevBitmap;   
 
      return 0;
    } 
 pBitmap->GetObject(sizeof(BITMAP),&bm);
 pMaskDC->CreateCompatibleDC(&dc);
 pMaskBitmap = pTempBitmap->FromHandle(monBitmap.hBmp); 
 pOldMaskBitmap=(CBitmap *)pMaskDC->SelectObject(pMaskBitmap);
 CDC *pSrcDC = new CDC;
 CBitmap *pOldBitmap;
 //Get source bitmap
 pSrcDC->CreateCompatibleDC(&dc);
 pOldBitmap=pSrcDC->SelectObject(pBitmap);
 //Revert Bitmap
 pRevDC->CreateCompatibleDC(&dc);
 pRevBitmap->CreateCompatibleBitmap(&dc,bm.bmWidth,bm.bmHeight);
 pOldRevBitmap=(CBitmap *)pRevDC->SelectObject(pRevBitmap);
 pRevDC->BitBlt(0,0,bm.bmWidth,bm.bmHeight,pMaskDC,0,0,SRCCOPY);
 pRevDC->BitBlt(0,0,bm.bmWidth,bm.bmHeight,pSrcDC,0,0,SRCINVERT);
 pSrcDC->SelectObject(pOldBitmap);
 pSrcDC->DeleteDC();
 delete pSrcDC;   
 //display Transparent Bitmap
 dc.BitBlt(DestRect.left,DestRect.top,bm.bmWidth,bm.bmHeight,pMaskDC,0,0,SRCPAINT);//0xb8074a);//SRCPAINT);
 dc.BitBlt(DestRect.left,DestRect.top,bm.bmWidth,bm.bmHeight,pRevDC,0,0,SRCINVERT);
               
/////////////////////////////////////////// 
 if(monBitmap.hRes)
   {
    ::UnlockResource(monBitmap.hRes);
    ::FreeResource(monBitmap.hRes);
   } 

 pMaskDC->SelectObject(pOldMaskBitmap); 
 pRevDC->SelectObject(pOldRevBitmap);
 pMaskDC->DeleteDC();
 pRevDC->DeleteDC();
 ::DeleteObject(monBitmap.hBmp);
 pRevBitmap->DeleteObject();
 delete pMaskDC;
 delete pRevDC;
 delete pTempBitmap;
 delete pRevBitmap;   
 
 return 1;
}
// convert a monotonous bitmap
BOOL CMainFrame::MakeMonBitmap(LPSTR lpBmpName,MONBITMAP & monDIB)
{
 HANDLE           hRes;    
 void             far * lpBits;         
 void             far * lpInfo;
 RGBQUAD          far * lpRGB;
 BITMAPINFOHEADER far * lpDIB;
 BITMAPINFO       far * lpDIBInfo;
 
 hRes=
 ::FindResource(AfxGetApp()->m_hInstance,lpBmpName,RT_BITMAP);
 if(!hRes)  
   return 0;
 hRes=  
 ::LoadResource(AfxGetApp()->m_hInstance,(HRSRC)hRes);
 if(!hRes)
   return 0;
 monDIB.hRes=hRes;  
 lpInfo=(void far *)LockResource(hRes);
 if(!lpInfo)
   return 0;
 lpDIBInfo=(BITMAPINFO far *)lpInfo;  
 lpDIB=(BITMAPINFOHEADER far *)lpInfo;
 lpRGB = (RGBQUAD far *)((LPSTR)lpInfo + sizeof(BITMAPINFOHEADER));
 lpBits=(void far *)((LPSTR)lpInfo + sizeof(BITMAPINFOHEADER)+16*sizeof(RGBQUAD));
 for(int i=0;i<16;i++)
    {
     if(lpRGB[i].rgbRed!=monDIB.uType||
        lpRGB[i].rgbGreen!=monDIB.uType||
        lpRGB[i].rgbBlue!=monDIB.uType)
       {
        lpRGB[i].rgbRed=255-monDIB.uType;
        lpRGB[i].rgbGreen=255-monDIB.uType;
        lpRGB[i].rgbBlue=255-monDIB.uType;

       }   
    }           
  monDIB.hBmp=  
  ::CreateDIBitmap(monDIB.dc,lpDIB,CBM_INIT,lpBits,lpDIBInfo,DIB_RGB_COLORS); 
  return 1;
}

void CMainFrame::DrawLine(CDC &dc,CPen &pen,int nXCurrent,int nYHeight)
{
 
 CPen *pOldPen=(CPen *)dc.SelectObject(&pen);
 
 dc.MoveTo(0,nYHeight);
 dc.LineTo(nXCurrent,nYHeight);
 dc.SelectObject(pOldPen);

}
/*-------------------------------------------------------*/
/*             Draw user transparent bitmap              */
/*-------------------------------------------------------*/ 
void CMainFrame::DrawTPmap(CDC   &dc,
                           CRect &rectMap,
                           LPSTR colorID,LPSTR monoID)
{               
    
  BITMAP  bm;
  CBitmap *pColorBit = new CBitmap;
  CBitmap *pMonoBit = new CBitmap;    
  pColorBit->LoadBitmap(colorID);
  pMonoBit->LoadBitmap(monoID);
  pColorBit->GetObject(sizeof(BITMAP),&bm);
  rectMap.right  = rectMap.left+bm.bmWidth;
  rectMap.bottom = rectMap.top+bm.bmHeight;
  MovingBitmap(dc,rectMap,pColorBit,pMonoBit);
  pMonoBit->DeleteObject();
  pColorBit->DeleteObject();
  delete pMonoBit;
  delete pColorBit;

}                                             

void CMainFrame::DrawTPmap(CDC   &dc,
                           CRect rectMap,
                           LPSTR colorID,
                           LPSTR monoID,
                           HINSTANCE hInst,
                           CBitmap *restoreBit)
{
/*
  RestoreBk(0);
  if(restoreBit)
    {
     restoreBit->CreateCompatibleBitmap(&dc,rectMap.Width(),
                                            rectMap.Height());
     CDC SrcDC;
     SrcDC.CreateCompatibleDC(&dc);
     SrcDC.SelectObject(restoreBit);
     SrcDC.BitBlt(0,0,
                  rectMap.Width(),rectMap.Height(),
                  &dc,rectMap.left,rectMap.top,SRCCOPY);
     SrcDC.DeleteDC();
     OverMsg.bOverMsg=1;
     OverMsg.rectOld=rectMap;             
    }    
*/
  BITMAP  bm;           
  HBITMAP hCBit,hMBit;             
  hCBit=::LoadBitmap(hInst,colorID);
  hMBit=::LoadBitmap(hInst,monoID);
  CDC     SrcDC,DesDC;
  CBitmap ColorBit;
  CBitmap MonoBit; 
  CBitmap *pColorBit = CBitmap::FromHandle(hCBit);
  CBitmap *pMonoBit  = CBitmap::FromHandle(hMBit);    
  if(!pColorBit || !pMonoBit)
    {
     AfxMessageBox("Tutorial can not find resource lib !");
     return;
    }                             
    
  pColorBit->GetObject(sizeof(BITMAP),&bm);
  SrcDC.CreateCompatibleDC(&dc);
  DesDC.CreateCompatibleDC(&dc);
  ColorBit.CreateCompatibleBitmap(&dc,rectMap.Width(),rectMap.Height());
  MonoBit.CreateCompatibleBitmap(&dc,rectMap.Width(),rectMap.Height());
      
  DesDC.SelectObject(&ColorBit);
  SrcDC.SelectObject(pColorBit);
  if(bm.bmHeight<rectMap.Width())
    for(int i=0;i<2;i++)
       {
        DesDC.BitBlt(0,0,bm.bmWidth/2-5,bm.bmHeight,&SrcDC,0,0,SRCCOPY);
        DesDC.StretchBlt(bm.bmWidth/2-5,0,rectMap.Width()-bm.bmWidth+10,
                         bm.bmHeight,
                         &SrcDC,bm.bmWidth/2-5,0,10,bm.bmHeight,SRCCOPY);
        DesDC.BitBlt(rectMap.Width()-(bm.bmWidth/2-5),0,
                     bm.bmWidth/2-5,bm.bmHeight,
                     &SrcDC,bm.bmWidth/2+5,0,SRCCOPY);
        if(!i){
	        DesDC.SelectObject(&MonoBit);
	        SrcDC.SelectObject(pMonoBit);
	       }
       }
    
  SrcDC.DeleteDC();
  DesDC.DeleteDC();

  RestoreBk(dc,0);
  if(restoreBit)
    {
     restoreBit->CreateCompatibleBitmap(&dc,rectMap.Width(),
                                            rectMap.Height());
     CDC SrcDC;
     SrcDC.CreateCompatibleDC(&dc);
     SrcDC.SelectObject(restoreBit);
     SrcDC.BitBlt(0,0,
                  rectMap.Width(),rectMap.Height(),
                  &dc,rectMap.left,rectMap.top,SRCCOPY);
     SrcDC.DeleteDC();
     OverMsg.bOverMsg=1;
     OverMsg.rectOld=rectMap;             
    }    

  MovingBitmap(dc,rectMap,&ColorBit,&MonoBit);
  ::DeleteObject(hCBit);
  ::DeleteObject(hMBit);
  MonoBit.DeleteObject();
  ColorBit.DeleteObject();
}
/*-------------------------------------------------------*/
/*                paint case Message box title           */
/*-------------------------------------------------------*/
void CMainFrame::DrawTitle(CDC      &dc,       // device context
                           LPSTR    lpszText,  // title string
                           COLORREF lineColor) // line color
{
 BITMAP  bm;  
 LOGFONT logFont;
 CFont   font;
// CRect   rectWin;   
 CRect   rectDest;
 CRect   rectSrc;
 CRect   rectTitle;
 CPen    pen(PS_SOLID,1,lineColor);
 CPen    *pOldPen;
 CBitmap *pBitmap = new CBitmap;
 CBitmap *pOldBitmap;
 CDC     *pDC = new CDC;
 CFont   *pOldFont;
 
 _fmemset(&logFont,0,sizeof(LOGFONT));
 logFont.lfHeight=25;
 logFont.lfWidth=10; 
 logFont.lfWeight=300;
 lstrcpy(logFont.lfFaceName,"Arial"); 
 font.CreateFontIndirect(&logFont);
                
 pDC->CreateCompatibleDC(&dc);
 pBitmap->LoadBitmap(IDB_BITMAP1);
 pOldBitmap=(CBitmap *)pDC->SelectObject(pBitmap);

// GetClientRect(&rectWin);
 pBitmap->GetObject(sizeof(BITMAP),&bm);
 rectSrc.SetRect(0,0,bm.bmWidth,bm.bmHeight);
 rectDest.left=WinCxy.x+335;
 rectDest.top=WinCxy.y+263;
 rectDest.right=rectDest.left+300;
 rectDest.bottom=rectDest.top+194;
/*
 rectDest.SetRect(
                  rectWin.right-300,rectWin.bottom-220+8,
                  rectWin.right-300+bm.bmWidth,rectWin.bottom-220+8+bm.bmHeight);
*/
 rectTitle.SetRect(25+1,7,rectDest.Width(),rectDest.Height());
 pDC->SetBkMode(TRANSPARENT);

 pDC->SetTextColor(RGB(0,0,0));
 pOldFont=(CFont *)pDC->SelectObject(&font);
 pDC->DrawText(lpszText,lstrlen(lpszText),&rectTitle,DT_LEFT);

 rectTitle.SetRect(25,7,rectDest.Width(),rectDest.Height());
 pDC->SetTextColor(RGB(255,255,255));
 pDC->DrawText(lpszText,lstrlen(lpszText),&rectTitle,DT_LEFT);
 
 int  xChar=0,i=0;                       
 TEXTMETRIC tm;
 pDC->GetTextMetrics(&tm);
 xChar=int((pDC->GetTextExtent(lpszText,lstrlen(lpszText))).cx)+tm.tmAveCharWidth+25;//(lstrlen(lpszText)+1)*(tm.tmAveCharWidth)+25+6;   
 
 pOldPen = (CPen *)pDC->SelectObject(&pen);
 for(i=0;i<3;i++)
    {
     pDC->MoveTo(xChar,16+i*3);
     pDC->LineTo(rectSrc.Width()-2,16+i*3);
    }                        
 dc.BitBlt(rectDest.left,rectDest.top,rectDest.Width(),rectDest.Height(),
           pDC,0,0,SRCCOPY); 
 
 font.DeleteObject();          
 pDC->SelectObject(pOldFont);
 pDC->SelectObject(pOldBitmap);
 pDC->SelectObject(pOldPen);   
 pDC->DeleteDC();
 delete pDC;
 pBitmap->DeleteObject();
 //PaintBitmap(dc,rectDest,rectSrc,pBitmap,1);
 delete pBitmap;
} 
/*-------------------------------------------------------*/
/*             dispaly  case window message              */
/*             show openning door effection              */
/*-------------------------------------------------------*/
void CMainFrame::DisplayMessage(CDC   &dc,   // device context
                                CRect rect,  // Dest rect where will be draw
                                UINT  msgID, // string id
                                int   nCount,// string count
                                BOOL  bDIP)  // if play openning door default is 1
{            
 int     nHead[9];               
 BITMAP  bm;          
 CRect   rectRgn;
 CRect   rectSubRgn;
 CBrush  brushBlue(m_pBitmap);
 CDC     *pDesDC  = new CDC;
 CDC     *pSrcDC  = new CDC;
 CBitmap *pBitmap = new CBitmap;
 CBitmap *pComMap = new CBitmap;
 CBitmap *pOldDesMap;
 CBitmap *pOldSrcMap;
 
 pDesDC->CreateCompatibleDC(&dc);
 pSrcDC->CreateCompatibleDC(&dc);
 
 pSrcDC->SaveDC();
 CRect  r(0,0,rect.Width(),rect.Height());
 CBrush brush(RGB(255,255,255));
 pBitmap->CreateCompatibleBitmap(&dc,rect.Width(),rect.Height());
 pSrcDC->SelectObject(pBitmap);
 pSrcDC->FillRect(&r,&brush);
 DrawMsgText(pSrcDC,&r,msgID,nCount);
 pSrcDC->RestoreDC(-1);
 
 pBitmap->GetObject(sizeof(BITMAP),&bm);
 rectRgn.SetRect(0,0,bm.bmWidth,bm.bmHeight);
 rectSubRgn=rectRgn;
 pComMap->CreateCompatibleBitmap(&dc,bm.bmWidth,bm.bmHeight);
 
 pOldDesMap=(CBitmap *)pDesDC->SelectObject(pComMap);
 
 pOldSrcMap=(CBitmap *)pSrcDC->SelectObject(pBitmap);
 if(bDIP) // display  door effection
   {
    for(int y=0;y<8;nHead[y]=y*(bm.bmWidth/8),y++);
 
    for(int i=0;i<bm.bmWidth/8;i+=2)
       {
        pDesDC->BitBlt(0,0,bm.bmWidth,bm.bmHeight,pSrcDC,0,0,SRCCOPY);

        if(i==0)
          pDesDC->FillRect(&rectSubRgn,&brushBlue);
        else
          {          
           for(int j=0;j<8;j++)
              {
               rectSubRgn.left=nHead[j];
               rectSubRgn.right=rectSubRgn.left+nHead[1]-i-1;
               pDesDC->FillRect(&rectSubRgn,&brushBlue);

              }//for 
          }//else       
        
        int cy=4;  
        if(i==0)  cy=6;
        else      cy=3;
        
        for(int y=0;y<cy;y++)  
	        dc.BitBlt(rect.left,rect.top,bm.bmWidth,bm.bmHeight,
	               pDesDC,0,0,SRCCOPY);  
          
       }//for 
  }     
  dc.BitBlt(rect.left,rect.top,bm.bmWidth,bm.bmHeight,
               pSrcDC,0,0,SRCCOPY);  
 
  pDesDC->SelectObject(pOldDesMap);
  pSrcDC->SelectObject(pOldSrcMap);
  pDesDC->DeleteDC();
  pSrcDC->DeleteDC();
  pBitmap->DeleteObject();
  pComMap->DeleteObject();
  delete pDesDC;
  delete pSrcDC;
  delete pBitmap;
  delete pComMap;
 
}
/*-------------------------------------------------------*/
/*                     move cursor                       */
/*-------------------------------------------------------*/
void CMainFrame::MoveCursor(CPoint pointDes,
                            CPoint pointSrc,
                            BOOL bBack/*=1*/,
                            int nDelay,//=55,
                            int nStep,//=8)
                            BOOL bFilter/*=0*/)
{      
// SetKey(0);
// SetMouse(0);
 if(pointDes==pointSrc)
    return;
 g_mbCanDoNext=0;   
 if(g_bAuto) 
    KillTimer(IDAUTO);
 SetSysFilter(1);
 nStep+=2;
 int x=0,y=0,cy,cx,b;    
/////////////////////////////////////////////////////////////
 int  nYellow=3;
 int  nOldLED=0;       
 BOOL bFinal=0;
 
 CPlayMeter *play =
 ((CMainFrame *)(AfxGetApp()->m_pMainWnd))->GetMeter();

 if(play)
   play->SetDelayScreen(3,0);
                                                               
/////////////////////////////////////////////////////////////// 
 pointSrc.y=-pointSrc.y;
 pointDes.y=-pointDes.y; 
 cy=pointDes.y>pointSrc.y ? -abs(pointSrc.y) : abs(pointSrc.y);
 cx=pointDes.x>pointSrc.x ? abs(pointSrc.x) : -abs(pointSrc.x);
 if(abs(pointDes.x-pointSrc.x)<
    abs(pointDes.y-pointSrc.y))
   {     
    if(int(pointDes.y-pointSrc.y)==0)     
      {
        for(int i=0;i<abs(pointDes.x-pointSrc.x);i+=nStep)
           {
		       if(!bFinal && (abs(pointDes.x-pointSrc.x)-i)<8)//nStep)
		          { 
		            //nDelay *=2;
		            nStep=1;
		            bFinal=1;
		          }       
	           x=(pointDes.x-pointSrc.x)<0 ? pointSrc.x-i :
	                                         pointSrc.x+i;
	                                         
	           SetCursorPos(x,pointSrc.y);       
               SetCursor(LoadCursor(NULL,IDC_ARROW));
               if((i*nStep)>=(abs(pointDes.x-pointSrc.x)/3*2)) 
                  nYellow=2;
               if(play )
                  play->SetDelayScreen(nYellow,
                                  int(abs(pointDes.x-pointSrc.x)-i*nStep),
                                  (nOldLED==2));
               nOldLED=nYellow;
               Delay(nDelay);           
           
           }   
        return ;   
      }                      
      
    b=pointSrc.x-
        int((LONG)((LONG)pointSrc.y*(LONG)(pointDes.x-pointSrc.x))/
            (pointDes.y-pointSrc.y));
                  
    for(int i=0;i<abs(pointDes.y-pointSrc.y);i+=nStep)
       {     
        if(!bFinal && (abs(pointDes.y-pointSrc.y)-i)<8)//nStep))
          { 
            //nDelay *=2;
            nStep=1;
            bFinal=1;
          }       
          
        int ny=0;
        x=int((LONG)((LONG)(-abs(i+cy))*(LONG)(pointDes.x-pointSrc.x))/
               (pointDes.y-pointSrc.y))+b;
             
           SetCursorPos(x,abs(i+cy));       
             
           if((i*nStep)>=(abs(pointDes.y-pointSrc.y)/4*3)) 
              nYellow=2;
           if(play )
             play->SetDelayScreen(nYellow,
                                  int(abs(pointDes.y-pointSrc.y)-i*nStep),
                                  (nOldLED==2));
           nOldLED=nYellow;
           Delay(nDelay);           
       }
   }     
  else
   {                
    if(int(pointDes.x-pointSrc.x)==0)     
      {
        for(int i=0;i<abs(pointDes.y-pointSrc.y);i+=nStep)
           {
		       if(!bFinal && (abs(pointDes.y-pointSrc.y)-i)<8)
		          { 
		            //nDelay *=2;
		            nStep=1;
		            bFinal=1;
		          }       
	           
	           y=(pointDes.y-pointSrc.y)<0 ? pointSrc.y-i :
	                                         pointSrc.y+i ;
	           SetCursorPos(pointSrc.x,y);       
             
               if((i*nStep)>=(abs(pointDes.y-pointSrc.y)/3*2)) 
                  nYellow=2;
               if(play )
                  play->SetDelayScreen(nYellow,
                                  int(abs(pointDes.y-pointSrc.y)-i*nStep),
                                  (nOldLED==2));
               nOldLED=nYellow;
               Delay(nDelay);           
           
           }   
        return ;   
      }                      

    b=pointSrc.y-
      int((LONG)((LONG)pointSrc.x*(LONG)(pointDes.y-pointSrc.y))/
          (pointDes.x-pointSrc.x));
          
    for(int i=0;i<abs(pointDes.x-pointSrc.x);i+=nStep)
       {
        if(!bFinal && (abs(pointDes.x-pointSrc.x)-i)<8)//nStep)
          {
            //nDelay *=;
            nStep=1;
            bFinal=1;
          }
            
        y=int((LONG)((LONG)abs(cx+i)*(LONG)(pointDes.y-pointSrc.y))/
               (pointDes.x-pointSrc.x))+b;  

        SetCursorPos(abs(i+cx),-y);

        if((i*nStep)>=(abs(pointDes.x-pointSrc.x)/4*3)) 
           nYellow=2;
        if(play )
           play->SetDelayScreen(nYellow,
                                int(abs(pointDes.x-pointSrc.x)-i*nStep),
                                (nOldLED==2));
        nOldLED=nYellow;                        
        Delay(nDelay);       
       }
   }                               
   
  SetCursorPos(pointDes.x,-pointDes.y);
 
  if(bBack)
    SetCursorPos(pointSrc.x,-pointSrc.y);
    
// SetKey(0);
// SetMouse(0);
 
 if(play)
   play->SetDelayScreen(1,0);

 SetSysFilter(bFilter);  
 if(g_bAuto) 
    SetTimer(IDAUTO,5000,NULL);
 g_mbCanDoNext=1;
 
}             

/*-------------------------------------------------------*/
/*              auto menu drap                           */
/*-------------------------------------------------------*/
void CMainFrame::DrapMenu(UINT uSubID,         //top menu pos
                          UINT uMenuID,        //menu hotkey sting value
                          UINT uMenuItemCount, //poup menu item 
                          int  nSeparator) //=0
{ 
 g_mbCanDoNext=0;             
 m_nMenuCount=uMenuItemCount;
 m_uMenuPos=uSubID;
 m_nSeparator=nSeparator;
 PostMessage(WM_SYSCOMMAND,SC_KEYMENU,0);
 PostMessage(WM_SYSKEYDOWN,65+uMenuID-'A',0);
 SetKey(0);
// SetBusy();
 SetSysFilter(1);
 SetTimer(UINT(TIMER),200,NULL);	
// SetMouse(0);
// 
} 
/*-------------------------------------------------------*/
/*              window mouse option                      */
/*-------------------------------------------------------*/
void CMainFrame::WndMouse(int x,int y,UINT nFlags,BOOL bNotMove/*=0*/)
{   
     POINT pointDest;
     POINT pointSrc; 
     POINT point;
     point.x=x;
     point.y=y;
     
     if(GetWnd()==NULL)
        return;
     else
       GetWnd()->ClientToScreen(&point);
    
     if(!bNotMove) 
       {
	     pointDest.x=point.x;
		 pointDest.y=point.y;  
		 GetCursorPos(&pointSrc);
		 MoveCursor(pointDest,pointSrc);    
	   } 
	                  
	 GetWnd()->PostMessage(nFlags,0,MAKELONG(x,y));
}

void CMainFrame::WndBPMouse(int x,int y,UINT nFlags,BOOL bNotMove/*=0*/) 
{
     POINT pointDest;
     POINT pointSrc; 
     POINT point;
     point.x=x;
     point.y=y;
     
     if(GetWnd()==NULL)
        return;
     else
       GetWnd()->ClientToScreen(&point);
    
     if(!bNotMove) 
       {
	     pointDest.x=point.x;
		 pointDest.y=point.y;  
		 GetCursorPos(&pointSrc);
		 MoveCursor(pointDest,pointSrc);    
	   } 
	   
	 //((CSrcWnd *)GetWnd())->LButtonDown(CPoint(x,y));
}
/*-------------------------------------------------------*/
/*           show a popup massage box                    */
/*-------------------------------------------------------*/
void CMainFrame::PopupNoteMsg(CDC     &dc,
                              UINT    ID,
                              int     nCount,
                              CRect   rectDes,
                              CBitmap * restoreBitmap,/*=NULL*/
                              int     nFontHeight,//=16
                              int     nFontWidth, //=6
                              int     nFontWeight)//=200 
                              
{        
 CRect   rectBMsg;
 CRect   rectMsg;
 CRect   rectSrc;
 CDC     *pMsgDC     = new CDC;

 CBitmap *pMsgBitmap = new CBitmap;
 CBitmap *pOldBitmap;

 CBitmap *pBMsgBit   = new CBitmap;
 pBMsgBit->LoadBitmap(IDB_BRUSH);

 CBrush  brush(pBMsgBit);
 CBrush  brushWhite(RGB(255,255,255));
 CBrush  brushBlack(RGB(0,0,0));
 CBrush  *pOldBrush;
///////////////////////////////////////////////////////////
 pMsgDC->CreateCompatibleDC(&dc);
 pMsgBitmap->CreateCompatibleBitmap(&dc,rectDes.Width(),rectDes.Height());
 pOldBitmap = (CBitmap *) pMsgDC->SelectObject(pMsgBitmap);

 rectMsg.SetRect(0,0,rectDes.Width()-4,rectDes.Height()-4);
 rectSrc.SetRect(0,0,rectDes.Width(),rectDes.Height());
 rectBMsg.SetRect(4,4,rectDes.Width(),rectDes.Height());
 pMsgDC->FillRect(&rectSrc,&brushWhite);
 pMsgDC->FillRect(&rectBMsg,&brushBlack);
 pOldBrush=(CBrush *)pMsgDC->SelectObject(&brush);
 pMsgDC->Rectangle(&rectMsg);
 pMsgDC->SelectObject(pOldBrush);    
 
 CPoint pointOrg(4,4);
 if(rectDes.Width()/rectDes.Height()>=1)
   {
    PaintUpArrow(*pMsgDC,pointOrg,int(rectDes.Height()-9),"Note");
     // draw message
    CRect r(40,4,rectDes.Width(),rectDes.Height());
    DrawMsgText(pMsgDC,&r,ID,nCount);
   } 
 else
   {            
    pointOrg.y=2;
    PaintVArrow(*pMsgDC,pointOrg,int(rectDes.Width()-12),"Step by Step");
	// draw message
	CRect r(0,42,rectDes.Width(),rectDes.Height());
	DrawMsgText(pMsgDC,&r,ID,nCount,nFontHeight,nFontWidth,nFontWeight);//12,5,300);
   } 	
 
  if(restoreBitmap)
   {
	 CDC     *pRestoreDC = new CDC; 
	 pRestoreDC->CreateCompatibleDC(&dc);
	 restoreBitmap->CreateCompatibleBitmap(&dc,rectDes.Width(),rectDes.Height());
	 pOldBitmap = (CBitmap *)pRestoreDC->SelectObject(restoreBitmap);
	 pRestoreDC->BitBlt(0,0,rectDes.Width(),rectDes.Height(),
	                    &dc,rectDes.left,rectDes.top,SRCCOPY);
	 pRestoreDC->SelectObject(pOldBitmap);
	 pRestoreDC->DeleteDC();
	 delete pRestoreDC;
   } 
   
 rectSrc.SetRect(0,0,rectDes.Width(),rectDes.Height());                   
 dc.BitBlt(rectDes.left,rectDes.top,rectDes.Width(),rectDes.Height(),
           pMsgDC,0,0,SRCCOPY);
 
///////////////////////////////////////////////////////////
 pMsgDC->SelectObject(pOldBitmap);
 pMsgDC->DeleteDC();
 delete pMsgDC;

 pMsgBitmap->DeleteObject();
 delete pMsgBitmap; 

 pBMsgBit->DeleteObject();
 delete pBMsgBit;
}
                 
/*-------------------------------------------------------*/
/*                show Note Message Box                  */
/*-------------------------------------------------------*/                 
void CMainFrame::SetNoteMsg(UINT ID,      //note string id
                            int  nCount,  //how many id
                            BOOL bClear/*=1*/) 
{ 
 if(nCount==0)
   return;
 if(GetOverMsgBox() && bClear)
    RestoreBk(NOTEMSG);
 
 if(ID)   
    OverMsg.stringID=ID;

 CWindowDC dc(this);
 PopupNoteMsg(dc,OverMsg.stringID=ID,nCount,OverMsg.rectDes,
              bClear==0? NULL : m_pStoreBit,
              StepMsg.lfHeight,StepMsg.lfWidth,StepMsg.lfWeight);
 SetOverMsgBox(1);//declare MsgBox now display.
} 
void CMainFrame::SetStepMsg(UINT ID,
                            int nCount,
                            BOOL bClear/*=1*/)
{
 if(nCount==0)
   return;

 if(GetStepMsgBox() && bClear)
    RestoreBk(STEPMSG);

 if(ID)   
    StepMsg.stringID=ID;

 CWindowDC dc(this);
 PopupNoteMsg(dc,StepMsg.stringID,nCount,StepMsg.rectDes,
              bClear==0?NULL:StepMsg.pStoreBit,
              StepMsg.lfHeight,StepMsg.lfWidth,StepMsg.lfWeight);//12,5,400);
 SetStepMsgBox(1);//declare MsgBox now display.
}                            
/*-------------------------------------------------------*/
/*                  Paint Up Arrow                       */
/*-------------------------------------------------------*/
void CMainFrame::PaintUpArrow( CDC      &dc,      // device context
                               CPoint   Org,      // the point starting to show Arrow As msg box rang
                               int      nLength,  // Arrow Length
                               LPSTR    lpszText, // Arrow Text if no Set NULL
                               COLORREF rgbFill,  // picture filled color default is 128/0/128
                               COLORREF rgbFrame) // picture filled color default is 255/0/255
{                              
 LOGFONT logFont;
 CFont   font;
 CBrush brush(rgbFill);  
 CPen   pen(PS_SOLID,1,rgbFrame);                           
 POINT point[]={7,19,0,19, 19,0, 38,19, 30,19, 30,nLength, 7,nLength};
 dc.SaveDC();      
 dc.SelectObject(&brush); 
 dc.SelectObject(&pen);
 dc.SetViewportOrg(Org.x,Org.y);
 dc.Polygon(point,int(sizeof(point)/sizeof(POINT)));
 // draw text
 _fmemset(&logFont,0,sizeof(LOGFONT));
 logFont.lfHeight=15;
 logFont.lfWidth=8;
 logFont.lfWeight=800;               
 lstrcpy(logFont.lfFaceName,"Arail");
 logFont.lfEscapement/*Orientation*/=-900;
 font.CreateFontIndirect(&logFont);
 dc.SelectObject(&font);
 dc.SetBkMode(TRANSPARENT);
 dc.SetTextColor(RGB(128,128,0));

 int yChar=dc.GetTextExtent(lpszText,lstrlen(lpszText)).cx;
 yChar=int(nLength-19-yChar-2)/3+20;

 if(yChar<0)
    yChar=18;


 dc.SetViewportOrg(27,yChar);
 dc.TextOut(1,5,lpszText,lstrlen(lpszText));
 font.DeleteObject();
 dc.RestoreDC(-1);

}                  

/*-----------------------------------------------------------------*/
/*                  Paint V Arrow                                  */
/*-----------------------------------------------------------------*/
void CMainFrame::PaintVArrow( CDC      &dc,      // device context
                              CPoint   Org,      // the point starting to show Arrow As msg box rang
                              int      nWidth,   // Arrow Width
                              LPSTR    lpszText, // Arrow Text if no Set NULL
                              COLORREF rgbFill,
                              COLORREF rgbFrame)
{

 LOGFONT logFont;
 CFont   font;
 CBrush brush(rgbFill);  
 CPen   pen(PS_SOLID,1,rgbFill);
// CPen  penWhite(PS_SOLID,1,RGB(255,255,255));
 CPen  penFrame(PS_SOLID,2,rgbFrame);
 POINT pointFrame[]={1,20, 19,38, 19,30, nWidth,30, nWidth,9};
 POINT point[]={0,19, 19,0, 19,8, nWidth,8, nWidth,30, 19,30, 19,38};
 dc.SaveDC();      
 dc.SelectObject(&brush);
 dc.SetViewportOrg(Org.x,Org.y);
 dc.SelectObject(&pen);//Yellow);
 dc.Polygon(point,int(sizeof(point)/sizeof(POINT)));
 dc.SelectObject(&penFrame);
 dc.Polyline(pointFrame,int(sizeof(pointFrame)/sizeof(POINT)));
  // draw text
 _fmemset(&logFont,0,sizeof(LOGFONT));
 logFont.lfHeight=20;
 logFont.lfWidth=7;
 logFont.lfWeight=600;
 lstrcpy(logFont.lfFaceName,"Arail");
 font.CreateFontIndirect(&logFont);
 dc.SelectObject(&font);
 dc.SetBkMode(TRANSPARENT);
 dc.SetTextColor(RGB(192,192,192));

 int xChar=dc.GetTextExtent(lpszText,lstrlen(lpszText)).cx;
 xChar=int(nWidth-19-xChar-2)/2+20;

 if(xChar<0)
    xChar=24;

 dc.SetViewportOrg(xChar,9);

 dc.TextOut(2,4,lpszText,lstrlen(lpszText)); 
 dc.SetTextColor(RGB(128,0,128));
 dc.TextOut(0,2,lpszText,lstrlen(lpszText));
 font.DeleteObject();
 dc.RestoreDC(-1);

}                              
/*-----------------------------------------------------------------*/
/*                  Draw Message Text                              */
/*-----------------------------------------------------------------*/
void CMainFrame::DrawMsgText(CDC      *dc,        //device context
                             LPRECT   lpRect,     // text draw rang
                             UINT     textID,     // string tab id
                             int      nCount,     // how many  
                             int      nFontHeight,//=16
                             int      nFontWidth, //=6
                             int      nFontWeight,//=200 
                             COLORREF TextColor)  //=RGB(0,0,0)
{              
  CString  string;
  CFont    font;       
  CFont    *pOldFont;
  LOGFONT  logFont;
  dc->SaveDC();
  _fmemset(&logFont,0,sizeof(LOGFONT));
  logFont.lfHeight=nFontHeight;
  logFont.lfWidth=nFontWidth;
  logFont.lfWeight=nFontWeight;
  lstrcpy(logFont.lfFaceName,"Arial");
  font.CreateFontIndirect(&logFont);
  lpRect->left+=8;
  string.LoadString(textID);
  dc->SetBkMode(TRANSPARENT); 
  dc->SetTextColor(TextColor);
  pOldFont=(CFont *)dc->SelectObject(&font);
  dc->DrawText(string.GetBuffer(string.GetLength()),
               string.GetLength(),
               lpRect,DT_LEFT);
  font.DeleteObject();             
  dc->SelectObject(pOldFont);
  dc->RestoreDC(-1);
} 
/*-------------------------------------------------------*/
/*               Restore Background                      */
/*-------------------------------------------------------*/
void CMainFrame::RestoreBk(BOOL bStep,int nCY/*=0*/)
{
 CWindowDC dc(this);
 RestoreBk(dc,bStep,nCY/*=0*/);
}
void CMainFrame::RestoreBk(CDC &dc,BOOL bStep,int nCY/*=0*/)
{          
    CBitmap *pBitmap;
    CRect   rectDes;
    BOOL    bPaint;
    BITMAP bm;

    
    if(bStep)      
      {
       pBitmap=StepMsg.pStoreBit;
       rectDes=StepMsg.rectOld;
       bPaint=StepMsg.bOverMsg;
      }                       
    else
      {
       pBitmap=m_pStoreBit;
       rectDes=OverMsg.rectOld;
       bPaint=OverMsg.bOverMsg;
      }                       
    if(!bPaint)
      return; 
      
    pBitmap->GetObject(sizeof(BITMAP),&bm);
    CRect rectSrc(0,0,bm.bmWidth,bm.bmHeight);
    if(nCY!=0){
       rectDes.bottom-=nCY;             
       rectSrc.bottom-=nCY;
       PaintBitmap(dc,rectDes,rectSrc,pBitmap,1);
       }
    PaintBitmap(dc,rectDes,rectSrc,pBitmap,1);
    if(bStep)
      SetStepMsgBox(0);
    else  
      SetOverMsgBox(0);
}
                          
/*-------------------------------------------------------*/
/*          Update  Message Cast                         */
/*-------------------------------------------------------*/  
void CMainFrame::WriteMsg(UINT ID,               //Message content string id
                          BOOL bDoorOpen/*=0*/,
                          LPSTR lpTitle/*=NULL*/)
{ 
 m_uMsgID=ID; 
 if(!bDoorOpen)  
    m_uOldMsgMapID=m_uMsgID;  
 SetCaseTitle(lpTitle);
 Invalidate();       
 UpdateWindow();
}

void CMainFrame::ClearFrame()
{
 CRect rect;
 HDC hDC=::GetWindowDC(m_hWndMDIClient);  
 ::GetWindowRect(m_hWndMDIClient,&rect); 
 rect.bottom --;
 ::PatBlt(hDC,0,1,rect.Width(),rect.Height()-1,WHITENESS);
 ::ReleaseDC(m_hWndMDIClient,hDC);
}
