
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/ABIBASE.H__   1.13   13 Dec 1996 11:17:44   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/ABIBASE.H__  $
** 
**    Rev 1.13   13 Dec 1996 11:17:44   ZJRD
** No change.
** 
**    Rev 1.12   22 Nov 1996 10:58:46   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:00   ZJRD
** No change.
** 
**    Rev 1.10   06 Nov 1996 12:58:00   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:46:02   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:48:14   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:41:12   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:15:34   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:45:08   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:31:16   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:44:58   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:26:06   ZJRD
** PIC-SLD version 0.50
** 
**    Rev 1.1   15 Aug 1996 10:04:44   ZJRD
** No change.
** 
**    Rev 1.0   13 Aug 1996 09:17:48   ZJRD
** Initial revision.
** 
****************************************************************************/

/***************************************************************************
**
** File name : abibase.h
**
** Description: define base data types which are used in ABI 
**
** Programmer: Frank Chang
**
**
**    Copyright (C) 1995 Microtek International, Inc.
**    All Rights Reserved
**
****************************************************************************/

#ifndef _ABIBASE_
#define _ABIBASE_

typedef unsigned char UCHAR;
typedef unsigned char BYTE;

#ifndef UINT
typedef unsigned int  UINT;
#endif

#ifndef WORD
typedef unsigned short  WORD;
#endif                  

#ifndef DWORD
typedef unsigned long DWORD;
#endif

#ifndef ULONG
typedef unsigned long ULONG;
#endif

typedef int STATUS;

typedef unsigned char FLAG;

#ifndef BOOL
typedef int  BOOL;
#endif  

#ifndef FALSE
#define FALSE 0
#define TRUE  !FALSE
#endif  

const int BASE_TIME = 10000;

typedef enum {
    ABI_OK      = 0,
    ABI_TIME_OVER = -1,
    ABI_ESCAPE = -2
} ABI_RET;

typedef struct {
    FLAG addrType;
    WORD  addr;
} ADDR;

/* All ABI routines Return codes */
typedef enum {                        
        ICE_OK                          = 0x0,
        ICE_FAIL_STEP,                          //target cannot step
        ICE_FAIL_MEM_WRITE,             //memory write failure
        ICE_FAIL_MAP_INCLUDE,               //map status not included
        ICE_FAIL_MAP_BOUNDARY,          //map address boundary error
        ICE_NOT_FOUND               = 0x5,
        ICE_FOUND,
        ICE_TIME_OUT            = 0x7,
        ICE_PARA_ERROR              = 0x8,
        ICE_EP_RUNNING              = 0x10,
        ICE_TRACE_RUNNING           = 0x11,
        ICE_TRACE_READ_OVER         = 0x12,
        ICE_COMMAND_INVALID         = 0x13, 
        
        ICE_PE_SLEEPING             = 0x20, //new in pic 
        
        ICE_MEM_SEARCH_NOT_FOUND   =0x22,//new in pic
        ICE_MEM_SEARCH_FOUND             =0x23,//new in pic
        ICE_OK_MEM_WRITE        =0x24,//new in pic
        
        ICE_NOT_SELECT_EV1  =0x25,
        ICE_NOT_SELECT_EV2  =0x26,
        ICE_NOT_SELECT_QUALIFY = 0x27,
        ICE_NOT_SELECT_EXBP    = 0x28,

        ICE_FLASH_SW_ERROR  = 0x40,
        ICE_FLASH_EC_ERROR  = 0x41,
        ICE_FLASH_PRG_ERROR = 0x42,
        ICE_FLASH_REC_ERROR = 0x43,
        ICE_NO_RESPONSE     = 0xff
} RET_CODE;
         
         
#endif
