 
/***************************************************************************
**
**    $Header:   D:/PICSLDV/SRC/LOG/ABOUT.CPP   1.13   13 Dec 1996 11:17:46   ZJRD  $
**
**    $Log:   D:/PICSLDV/SRC/LOG/ABOUT.CPP  $
** 
**    Rev 1.13   13 Dec 1996 11:17:46   ZJRD
** PIC/SLD Version 0.98
** 
**    Rev 1.12   22 Nov 1996 10:58:48   ZJRD
** No change.
** 
**    Rev 1.11   11 Nov 1996 12:46:02   ZJRD
** PIC/SLD Versio 0.96
** 
**    Rev 1.10   06 Nov 1996 12:58:00   ZJRD
** No change.
** 
**    Rev 1.9   02 Nov 1996 09:48:08   ZJRD
** No change.
** 
**    Rev 1.8   30 Oct 1996 12:50:30   ZJRD
** No change.
** 
**    Rev 1.7   28 Oct 1996 09:43:18   ZJRD
** No change.
** 
**    Rev 1.6   21 Oct 1996 09:17:34   ZJRD
** No change.
** 
**    Rev 1.5   09 Oct 1996 13:47:08   ZJRD
** No change.
** 
**    Rev 1.4   23 Sep 1996 10:35:52   ZJRD
** No change.
** 
**    Rev 1.3   06 Sep 1996 13:50:22   ZJRD
** No change.
** 
**    Rev 1.2   02 Sep 1996 11:31:28   ZJRD
** No change.
** 
**    Rev 1.1   15 Aug 1996 10:08:46   ZJRD
** PIC/SLD Version 0.20
** 
**    Rev 1.0   13 Aug 1996 09:19:46   ZJRD
** Initial revision.
**
****************************************************************************/

/////////////////////////////////////////////////////////////////////////////
//
//  File name:  ABOUT.CPP
//
//  Description:The implement file for the class: CAboutDialog
//
//  Author:     Roger Zhang
//
//  Date:       03/05/95
//
//  Modification:
//
//      1. 03/05/95, Initial version 
//      2. 05/09/96, Add a bitmap button to the About box, Chen.
//
//
//  Copyright (C) 1995 Microtek International. All rights reserved.
//
/////////////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "resource.h"
#include "xview.h"
                                                              
#include "uicom.h"                                                              
#include "about.h"
#include "cpust.h"
#include "uiserial.h"

/////////////////////////////////////////////////////////////////////////////
// extern function for getting version information
void TstIdentify(CString &, CString &, CString &, 
    CString &, CString &, CString &);

 
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CAboutDialog::CAboutDialog
//
//  Description: The constructor of the class CAboutDialog.
//
//  Input:  None
//
//  Output: None.
//
//  Return: None.
//
/////////////////////////////////////////////////////////////////////////////
CAboutDialog::CAboutDialog() : CDialog(CAboutDialog::IDD),
    m_bShowName(FALSE), m_uTimerID(0)
{
//  m_pTip = new CVBControl;
    //{{AFX_DATA_INIT(CAboutDialog)
    //}}AFX_DATA_INIT
}

CAboutDialog::~CAboutDialog()
{
//  m_pTip->DestroyWindow();
//  delete m_pTip;
}
    
/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CAboutDialog::DoDataExchange
//
//  Description: Exchange data between local variables and dialog controls.
//
//  Input:  
//      pDX -- Pointer to CDataExchange
//
//  Output: None
//
//  Return: None
//
/////////////////////////////////////////////////////////////////////////////
void CAboutDialog::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CAboutDialog)
    DDX_Control(pDX, IDC_LIST_ABOUT_NAME, m_listName);
    //}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDialog, CDialog)
    //{{AFX_MSG_MAP(CAboutDialog)
    ON_BN_DOUBLECLICKED(ID_TEST, OnDoubleclickedButtonAbout)
    ON_WM_TIMER()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()
//  ON_VBXEVENT(VBN_SETCAPTION, IDC_MHTIP2, OnSetcaptionMhtip2)

/////////////////////////////////////////////////////////////////////////////
//
//  Name:   CAboutDialog::OnInitDialog
//
//  Description: Initilize dialog
//
//  Input:  None
//
//  Output: None
//
//  Return: FALSE -- Set focus to a control
//          TRUE  -- Let focus on first control
//
/////////////////////////////////////////////////////////////////////////////
BOOL CAboutDialog::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    // TODO: Add extra initialization here
    CenterWindow();

  //  m_pTip->Create("MHTIP.VBX;MhTip;MhTip1", NULL, CRect(0, 0, 50, 20),
    //  this, IDC_MHTIP2);

    CString str;
    char szBuf[100];

#ifdef _PLUS_
	str = "EasyPack/SLD Plus for PIC Version";
	SetDlgItemText(IDC_STATIC_TITLE,str);
#endif
	
    str = ((CWinSerialPICAgree*)(GetXviewAppJohn()->m_pTheCom))
          ->GetSerialPortNum();            
    SetDlgItemText(IDC_ABOUT_PORT, str);
    
//    str = "NONE";
//    SetDlgItemText(IDC_ABOUT_ADDR, str);
                                      
    str = ((CWinSerialPICAgree*)(GetXviewAppJohn()->m_pTheCom))
          ->GetSerialBaudRate();
    SetDlgItemText(IDC_ABOUT_BAUD, str);        
    
    // Show version information                                              
    CString strDos, strWindows, strVer, strFWVer, strCPU, strClock;
                                                      
    TstIdentify(strCPU, strFWVer, strVer, strDos, strWindows, strClock);
    strClock += " (";                                                    
    strClock += ((CWinSerialPICAgree*)(GetXviewAppJohn()->m_pTheCom))
    	   -> GetPICClockType();      
    strClock += ")";	   
    
    SetDlgItemText(IDC_ABOUT_VER, strVer);
    SetDlgItemText(IDC_ABOUT_CPU, strCPU);
    SetDlgItemText(IDC_ABOUT_CLOCK, strClock);
    SetDlgItemText(IDC_ABOUT_DOS, strDos);
    SetDlgItemText(IDC_ABOUT_WINDOWS, strWindows);
    SetDlgItemText(IDC_ABOUT_FWVER, strFWVer);

    // Draw the bitmap.
    m_btnAbout.AutoLoad(ID_TEST, this);
    
    // Hide the list box.
    GetDlgItem(IDC_LIST_ABOUT_NAME)->ShowWindow(SW_HIDE);

    return TRUE;  // return TRUE  unless you set the focus to a control
}

/*
void CAboutDialog::OnSetcaptionMhtip2(UINT, int, CWnd*, LPVOID lpParams)
{
    
    char StrBuff[256];
    int StrBuffLen;
        
    StrBuffLen = ::GetWindowText((HWND)AFX_NUM_EVENTPARAMINDEX(int, lpParams, 3), StrBuff, 255);
    
    m_pTip->SetStrProperty("Caption", "ifuodiufg"StrBuff);
    m_pTip->ShowWindow(SW_SHOW);    
}
*/

void CAboutDialog::OnDoubleclickedButtonAbout() 
{
    // TODO: Add your control notification handler code here

    // Hide some cotrols.
    m_bShowName = !m_bShowName;
    if ( m_bShowName ) {
        GetDlgItem(IDC_LIST_ABOUT_NAME)->ShowWindow(SW_SHOW);
        
        // Show the engineers' names.
        m_listName.ResetContent();

#ifdef _PLUS_
        m_listName.AddString("EasyPack/SLD Plus for PIC Development Team: ");
#else        
        m_listName.AddString("EasyPack/SLD for PIC Development Team: ");
#endif        
        m_listName.AddString("");

        m_listName.AddString("Program Manager:");
        m_listName.AddString("Cheerson Jeng");
        m_listName.AddString("Dome Liu");
        m_listName.AddString("");

        m_listName.AddString("Lab Manager:");
        m_listName.AddString("Hercules Yao");
        m_listName.AddString("");

        m_listName.AddString("Manual Editor:");
        m_listName.AddString("Kathleen Zhow");
        m_listName.AddString("");

        m_listName.AddString("Test Engineers:");
        m_listName.AddString("Cathy Yang");
        m_listName.AddString("Shirley Dong");
        m_listName.AddString("Jeff Bing");
        m_listName.AddString("Brave Qu");
        m_listName.AddString("Ken Yao");
        m_listName.AddString("George Jeng");
        m_listName.AddString("");

        m_listName.AddString("Hardware Engineers:");
        m_listName.AddString("Xu Shuqing");
        m_listName.AddString("Jason Chen");
        m_listName.AddString("");

        m_listName.AddString("Software Engineers:");
        m_listName.AddString("Richard Guo");
        m_listName.AddString("Dragon Long");
        m_listName.AddString("Annie Yi");
        m_listName.AddString("Chris Fang");
        m_listName.AddString("Carl Hu");
        m_listName.AddString("John Zhou");
        m_listName.AddString("Gates Hua");
        m_listName.AddString("Jamoon Zhou");
        m_listName.AddString("Jerry Yan");
        m_listName.AddString("Daniel Lin");
        m_listName.AddString("Chen Jun");

        // Set timer.
        if ( 0 != m_uTimerID ) {
            // If outstanding timer, kill it.
            KillTimer(m_uTimerID);
        }
        // Set a timer for 200 milliseconds.
        m_uTimerID = SetTimer(tmEvent, tmElapse, NULL);
    }
    else {
        GetDlgItem(IDC_LIST_ABOUT_NAME)->ShowWindow(SW_HIDE);

        // Kill one-shot timer.
        if ( 0 != m_uTimerID ) {
            KillTimer(m_uTimerID);
            m_uTimerID = 0;
        }
    }
}

void CAboutDialog::OnTimer(UINT nIDEvent) 
{
    // TODO: Add your message handler code here and/or call default
    
    // Not our timer.
    if ( m_uTimerID != nIDEvent ) {
        CDialog::OnTimer(nIDEvent);
        return;
    }

    // Scroll the list box contents.
    m_listName.SendMessage(WM_VSCROLL, SB_LINEDOWN);
}
